/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1p1beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecurityMarksName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_ASSET_SECURITY_MARKS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/assets/{asset}/securityMarks");
    private static final PathTemplate ORGANIZATION_SOURCE_FINDING_SECURITY_MARKS_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/sources/{source}/findings/{finding}/securityMarks");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String organization;
    private String asset;
    private String source;
    private String finding;

    @Deprecated
    protected SecurityMarksName() {
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getAsset() {
        return this.asset;
    }

    public String getSource() {
        return this.source;
    }

    public String getFinding() {
        return this.finding;
    }

    private SecurityMarksName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
        this.pathTemplate = ORGANIZATION_ASSET_SECURITY_MARKS_PATH_TEMPLATE;
    }

    private SecurityMarksName(OrganizationSourceFindingSecurityMarksBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
        this.pathTemplate = ORGANIZATION_SOURCE_FINDING_SECURITY_MARKS_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationAssetSecurityMarksBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationSourceFindingSecurityMarksBuilder newOrganizationSourceFindingSecurityMarksBuilder() {
        return new OrganizationSourceFindingSecurityMarksBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SecurityMarksName of(String organization, String asset) {
        return SecurityMarksName.newOrganizationAssetSecurityMarksBuilder().setOrganization(organization).setAsset(asset).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityMarksName ofOrganizationAssetSecurityMarksName(String organization, String asset) {
        return SecurityMarksName.newOrganizationAssetSecurityMarksBuilder().setOrganization(organization).setAsset(asset).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityMarksName ofOrganizationSourceFindingSecurityMarksName(String organization, String source, String finding) {
        return SecurityMarksName.newOrganizationSourceFindingSecurityMarksBuilder().setOrganization(organization).setSource(source).setFinding(finding).build();
    }

    public static String format(String organization, String asset) {
        return SecurityMarksName.newBuilder().setOrganization(organization).setAsset(asset).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationAssetSecurityMarksName(String organization, String asset) {
        return SecurityMarksName.newBuilder().setOrganization(organization).setAsset(asset).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationSourceFindingSecurityMarksName(String organization, String source, String finding) {
        return SecurityMarksName.newOrganizationSourceFindingSecurityMarksBuilder().setOrganization(organization).setSource(source).setFinding(finding).build().toString();
    }

    public static SecurityMarksName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_ASSET_SECURITY_MARKS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_ASSET_SECURITY_MARKS_PATH_TEMPLATE.match(formattedString);
            return SecurityMarksName.ofOrganizationAssetSecurityMarksName((String)matchMap.get("organization"), (String)matchMap.get("asset"));
        }
        if (ORGANIZATION_SOURCE_FINDING_SECURITY_MARKS_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SOURCE_FINDING_SECURITY_MARKS_PATH_TEMPLATE.match(formattedString);
            return SecurityMarksName.ofOrganizationSourceFindingSecurityMarksName((String)matchMap.get("organization"), (String)matchMap.get("source"), (String)matchMap.get("finding"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SecurityMarksName> parseList(List<String> formattedStrings) {
        ArrayList<SecurityMarksName> list = new ArrayList<SecurityMarksName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecurityMarksName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecurityMarksName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecurityMarksName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_ASSET_SECURITY_MARKS_PATH_TEMPLATE.matches(formattedString) || ORGANIZATION_SOURCE_FINDING_SECURITY_MARKS_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecurityMarksName securityMarksName = this;
            synchronized (securityMarksName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.asset != null) {
                        fieldMapBuilder.put((Object)"asset", (Object)this.asset);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.finding != null) {
                        fieldMapBuilder.put((Object)"finding", (Object)this.finding);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SecurityMarksName that = (SecurityMarksName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.asset, that.asset) && Objects.equals(this.source, that.source) && Objects.equals(this.finding, that.finding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.asset);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        return h ^= Objects.hashCode(this.finding);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationSourceFindingSecurityMarksBuilder {
        private String organization;
        private String source;
        private String finding;

        private OrganizationSourceFindingSecurityMarksBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSource() {
            return this.source;
        }

        public String getFinding() {
            return this.finding;
        }

        public OrganizationSourceFindingSecurityMarksBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationSourceFindingSecurityMarksBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public OrganizationSourceFindingSecurityMarksBuilder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        public SecurityMarksName build() {
            return new SecurityMarksName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String asset;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getAsset() {
            return this.asset;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        private Builder(SecurityMarksName securityMarksName) {
            Preconditions.checkArgument((securityMarksName.pathTemplate == ORGANIZATION_ASSET_SECURITY_MARKS_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when SecurityMarksName has the pattern of organizations/{organization}/assets/{asset}/securityMarks.");
            this.organization = securityMarksName.organization;
            this.asset = securityMarksName.asset;
        }

        public SecurityMarksName build() {
            return new SecurityMarksName(this);
        }
    }
}

