/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EventThreatDetectionCustomModuleName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_MODULE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/eventThreatDetectionSettings/customModules/{module}");
    private static final PathTemplate FOLDER_MODULE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/eventThreatDetectionSettings/customModules/{module}");
    private static final PathTemplate PROJECT_MODULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/eventThreatDetectionSettings/customModules/{module}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String module;
    private final String folder;
    private final String project;

    @Deprecated
    protected EventThreatDetectionCustomModuleName() {
        this.organization = null;
        this.module = null;
        this.folder = null;
        this.project = null;
    }

    private EventThreatDetectionCustomModuleName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.module = (String)Preconditions.checkNotNull((Object)builder.getModule());
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_MODULE;
    }

    private EventThreatDetectionCustomModuleName(FolderModuleBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.module = (String)Preconditions.checkNotNull((Object)builder.getModule());
        this.organization = null;
        this.project = null;
        this.pathTemplate = FOLDER_MODULE;
    }

    private EventThreatDetectionCustomModuleName(ProjectModuleBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.module = (String)Preconditions.checkNotNull((Object)builder.getModule());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_MODULE;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getModule() {
        return this.module;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationModuleBuilder() {
        return new Builder();
    }

    public static FolderModuleBuilder newFolderModuleBuilder() {
        return new FolderModuleBuilder();
    }

    public static ProjectModuleBuilder newProjectModuleBuilder() {
        return new ProjectModuleBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EventThreatDetectionCustomModuleName of(String organization, String module) {
        return EventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setModule(module).build();
    }

    public static EventThreatDetectionCustomModuleName ofOrganizationModuleName(String organization, String module) {
        return EventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setModule(module).build();
    }

    public static EventThreatDetectionCustomModuleName ofFolderModuleName(String folder, String module) {
        return EventThreatDetectionCustomModuleName.newFolderModuleBuilder().setFolder(folder).setModule(module).build();
    }

    public static EventThreatDetectionCustomModuleName ofProjectModuleName(String project, String module) {
        return EventThreatDetectionCustomModuleName.newProjectModuleBuilder().setProject(project).setModule(module).build();
    }

    public static String format(String organization, String module) {
        return EventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setModule(module).build().toString();
    }

    public static String formatOrganizationModuleName(String organization, String module) {
        return EventThreatDetectionCustomModuleName.newBuilder().setOrganization(organization).setModule(module).build().toString();
    }

    public static String formatFolderModuleName(String folder, String module) {
        return EventThreatDetectionCustomModuleName.newFolderModuleBuilder().setFolder(folder).setModule(module).build().toString();
    }

    public static String formatProjectModuleName(String project, String module) {
        return EventThreatDetectionCustomModuleName.newProjectModuleBuilder().setProject(project).setModule(module).build().toString();
    }

    public static EventThreatDetectionCustomModuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_MODULE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_MODULE.match(formattedString);
            return EventThreatDetectionCustomModuleName.ofOrganizationModuleName((String)matchMap.get("organization"), (String)matchMap.get("module"));
        }
        if (FOLDER_MODULE.matches(formattedString)) {
            Map matchMap = FOLDER_MODULE.match(formattedString);
            return EventThreatDetectionCustomModuleName.ofFolderModuleName((String)matchMap.get("folder"), (String)matchMap.get("module"));
        }
        if (PROJECT_MODULE.matches(formattedString)) {
            Map matchMap = PROJECT_MODULE.match(formattedString);
            return EventThreatDetectionCustomModuleName.ofProjectModuleName((String)matchMap.get("project"), (String)matchMap.get("module"));
        }
        throw new ValidationException("EventThreatDetectionCustomModuleName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<EventThreatDetectionCustomModuleName> parseList(List<String> formattedStrings) {
        ArrayList<EventThreatDetectionCustomModuleName> list = new ArrayList<EventThreatDetectionCustomModuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EventThreatDetectionCustomModuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EventThreatDetectionCustomModuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EventThreatDetectionCustomModuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_MODULE.matches(formattedString) || FOLDER_MODULE.matches(formattedString) || PROJECT_MODULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EventThreatDetectionCustomModuleName eventThreatDetectionCustomModuleName = this;
            synchronized (eventThreatDetectionCustomModuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.module != null) {
                        fieldMapBuilder.put((Object)"module", (Object)this.module);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EventThreatDetectionCustomModuleName that = (EventThreatDetectionCustomModuleName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.module, that.module) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.module);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectModuleBuilder {
        private String project;
        private String module;

        protected ProjectModuleBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getModule() {
            return this.module;
        }

        public ProjectModuleBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectModuleBuilder setModule(String module) {
            this.module = module;
            return this;
        }

        public EventThreatDetectionCustomModuleName build() {
            return new EventThreatDetectionCustomModuleName(this);
        }
    }

    public static class FolderModuleBuilder {
        private String folder;
        private String module;

        protected FolderModuleBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getModule() {
            return this.module;
        }

        public FolderModuleBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderModuleBuilder setModule(String module) {
            this.module = module;
            return this;
        }

        public EventThreatDetectionCustomModuleName build() {
            return new EventThreatDetectionCustomModuleName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String module;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getModule() {
            return this.module;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setModule(String module) {
            this.module = module;
            return this;
        }

        private Builder(EventThreatDetectionCustomModuleName eventThreatDetectionCustomModuleName) {
            Preconditions.checkArgument((boolean)Objects.equals(eventThreatDetectionCustomModuleName.pathTemplate, ORGANIZATION_MODULE), (Object)"toBuilder is only supported when EventThreatDetectionCustomModuleName has the pattern of organizations/{organization}/eventThreatDetectionSettings/customModules/{module}");
            this.organization = eventThreatDetectionCustomModuleName.organization;
            this.module = eventThreatDetectionCustomModuleName.module;
        }

        public EventThreatDetectionCustomModuleName build() {
            return new EventThreatDetectionCustomModuleName(this);
        }
    }
}

