/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SecurityMarksName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_ASSET = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/assets/{asset}/securityMarks");
    private static final PathTemplate ORGANIZATION_SOURCE_FINDING = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/sources/{source}/findings/{finding}/securityMarks");
    private static final PathTemplate FOLDER_ASSET = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/assets/{asset}/securityMarks");
    private static final PathTemplate PROJECT_ASSET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/assets/{asset}/securityMarks");
    private static final PathTemplate FOLDER_SOURCE_FINDING = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/sources/{source}/findings/{finding}/securityMarks");
    private static final PathTemplate PROJECT_SOURCE_FINDING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/sources/{source}/findings/{finding}/securityMarks");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String asset;
    private final String source;
    private final String finding;
    private final String folder;
    private final String project;

    @Deprecated
    protected SecurityMarksName() {
        this.organization = null;
        this.asset = null;
        this.source = null;
        this.finding = null;
        this.folder = null;
        this.project = null;
    }

    private SecurityMarksName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
        this.source = null;
        this.finding = null;
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_ASSET;
    }

    private SecurityMarksName(OrganizationSourceFindingSecurityMarksBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
        this.asset = null;
        this.folder = null;
        this.project = null;
        this.pathTemplate = ORGANIZATION_SOURCE_FINDING;
    }

    private SecurityMarksName(FolderAssetBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
        this.organization = null;
        this.source = null;
        this.finding = null;
        this.project = null;
        this.pathTemplate = FOLDER_ASSET;
    }

    private SecurityMarksName(ProjectAssetBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
        this.organization = null;
        this.source = null;
        this.finding = null;
        this.folder = null;
        this.pathTemplate = PROJECT_ASSET;
    }

    private SecurityMarksName(FolderSourceFindingBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
        this.organization = null;
        this.asset = null;
        this.project = null;
        this.pathTemplate = FOLDER_SOURCE_FINDING;
    }

    private SecurityMarksName(ProjectSourceFindingBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
        this.organization = null;
        this.asset = null;
        this.folder = null;
        this.pathTemplate = PROJECT_SOURCE_FINDING;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getAsset() {
        return this.asset;
    }

    public String getSource() {
        return this.source;
    }

    public String getFinding() {
        return this.finding;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newOrganizationAssetSecurityMarksBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationSourceFindingSecurityMarksBuilder newOrganizationSourceFindingSecurityMarksBuilder() {
        return new OrganizationSourceFindingSecurityMarksBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderAssetBuilder newFolderAssetBuilder() {
        return new FolderAssetBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectAssetBuilder newProjectAssetBuilder() {
        return new ProjectAssetBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderSourceFindingBuilder newFolderSourceFindingBuilder() {
        return new FolderSourceFindingBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectSourceFindingBuilder newProjectSourceFindingBuilder() {
        return new ProjectSourceFindingBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SecurityMarksName of(String organization, String asset) {
        return SecurityMarksName.newBuilder().setOrganization(organization).setAsset(asset).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityMarksName ofOrganizationAssetSecurityMarksName(String organization, String asset) {
        return SecurityMarksName.newBuilder().setOrganization(organization).setAsset(asset).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityMarksName ofOrganizationSourceFindingSecurityMarksName(String organization, String source, String finding) {
        return SecurityMarksName.newOrganizationSourceFindingSecurityMarksBuilder().setOrganization(organization).setSource(source).setFinding(finding).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityMarksName ofFolderAssetName(String folder, String asset) {
        return SecurityMarksName.newFolderAssetBuilder().setFolder(folder).setAsset(asset).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityMarksName ofProjectAssetName(String project, String asset) {
        return SecurityMarksName.newProjectAssetBuilder().setProject(project).setAsset(asset).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityMarksName ofFolderSourceFindingName(String folder, String source, String finding) {
        return SecurityMarksName.newFolderSourceFindingBuilder().setFolder(folder).setSource(source).setFinding(finding).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static SecurityMarksName ofProjectSourceFindingName(String project, String source, String finding) {
        return SecurityMarksName.newProjectSourceFindingBuilder().setProject(project).setSource(source).setFinding(finding).build();
    }

    public static String format(String organization, String asset) {
        return SecurityMarksName.newBuilder().setOrganization(organization).setAsset(asset).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationAssetSecurityMarksName(String organization, String asset) {
        return SecurityMarksName.newBuilder().setOrganization(organization).setAsset(asset).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationSourceFindingSecurityMarksName(String organization, String source, String finding) {
        return SecurityMarksName.newOrganizationSourceFindingSecurityMarksBuilder().setOrganization(organization).setSource(source).setFinding(finding).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderAssetName(String folder, String asset) {
        return SecurityMarksName.newFolderAssetBuilder().setFolder(folder).setAsset(asset).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectAssetName(String project, String asset) {
        return SecurityMarksName.newProjectAssetBuilder().setProject(project).setAsset(asset).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderSourceFindingName(String folder, String source, String finding) {
        return SecurityMarksName.newFolderSourceFindingBuilder().setFolder(folder).setSource(source).setFinding(finding).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectSourceFindingName(String project, String source, String finding) {
        return SecurityMarksName.newProjectSourceFindingBuilder().setProject(project).setSource(source).setFinding(finding).build().toString();
    }

    public static SecurityMarksName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_ASSET.matches(formattedString)) {
            Map matchMap = ORGANIZATION_ASSET.match(formattedString);
            return SecurityMarksName.ofOrganizationAssetSecurityMarksName((String)matchMap.get("organization"), (String)matchMap.get("asset"));
        }
        if (ORGANIZATION_SOURCE_FINDING.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SOURCE_FINDING.match(formattedString);
            return SecurityMarksName.ofOrganizationSourceFindingSecurityMarksName((String)matchMap.get("organization"), (String)matchMap.get("source"), (String)matchMap.get("finding"));
        }
        if (FOLDER_ASSET.matches(formattedString)) {
            Map matchMap = FOLDER_ASSET.match(formattedString);
            return SecurityMarksName.ofFolderAssetName((String)matchMap.get("folder"), (String)matchMap.get("asset"));
        }
        if (PROJECT_ASSET.matches(formattedString)) {
            Map matchMap = PROJECT_ASSET.match(formattedString);
            return SecurityMarksName.ofProjectAssetName((String)matchMap.get("project"), (String)matchMap.get("asset"));
        }
        if (FOLDER_SOURCE_FINDING.matches(formattedString)) {
            Map matchMap = FOLDER_SOURCE_FINDING.match(formattedString);
            return SecurityMarksName.ofFolderSourceFindingName((String)matchMap.get("folder"), (String)matchMap.get("source"), (String)matchMap.get("finding"));
        }
        if (PROJECT_SOURCE_FINDING.matches(formattedString)) {
            Map matchMap = PROJECT_SOURCE_FINDING.match(formattedString);
            return SecurityMarksName.ofProjectSourceFindingName((String)matchMap.get("project"), (String)matchMap.get("source"), (String)matchMap.get("finding"));
        }
        throw new ValidationException("SecurityMarksName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SecurityMarksName> parseList(List<String> formattedStrings) {
        ArrayList<SecurityMarksName> list = new ArrayList<SecurityMarksName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SecurityMarksName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SecurityMarksName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SecurityMarksName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_ASSET.matches(formattedString) || ORGANIZATION_SOURCE_FINDING.matches(formattedString) || FOLDER_ASSET.matches(formattedString) || PROJECT_ASSET.matches(formattedString) || FOLDER_SOURCE_FINDING.matches(formattedString) || PROJECT_SOURCE_FINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SecurityMarksName securityMarksName = this;
            synchronized (securityMarksName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.asset != null) {
                        fieldMapBuilder.put((Object)"asset", (Object)this.asset);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.finding != null) {
                        fieldMapBuilder.put((Object)"finding", (Object)this.finding);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SecurityMarksName that = (SecurityMarksName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.asset, that.asset) && Objects.equals(this.source, that.source) && Objects.equals(this.finding, that.finding) && Objects.equals(this.folder, that.folder) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.asset);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        h ^= Objects.hashCode(this.finding);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectSourceFindingBuilder {
        private String project;
        private String source;
        private String finding;

        protected ProjectSourceFindingBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSource() {
            return this.source;
        }

        public String getFinding() {
            return this.finding;
        }

        public ProjectSourceFindingBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectSourceFindingBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public ProjectSourceFindingBuilder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        public SecurityMarksName build() {
            return new SecurityMarksName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderSourceFindingBuilder {
        private String folder;
        private String source;
        private String finding;

        protected FolderSourceFindingBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getSource() {
            return this.source;
        }

        public String getFinding() {
            return this.finding;
        }

        public FolderSourceFindingBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderSourceFindingBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public FolderSourceFindingBuilder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        public SecurityMarksName build() {
            return new SecurityMarksName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectAssetBuilder {
        private String project;
        private String asset;

        protected ProjectAssetBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getAsset() {
            return this.asset;
        }

        public ProjectAssetBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectAssetBuilder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        public SecurityMarksName build() {
            return new SecurityMarksName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderAssetBuilder {
        private String folder;
        private String asset;

        protected FolderAssetBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getAsset() {
            return this.asset;
        }

        public FolderAssetBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderAssetBuilder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        public SecurityMarksName build() {
            return new SecurityMarksName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationSourceFindingSecurityMarksBuilder {
        private String organization;
        private String source;
        private String finding;

        protected OrganizationSourceFindingSecurityMarksBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSource() {
            return this.source;
        }

        public String getFinding() {
            return this.finding;
        }

        public OrganizationSourceFindingSecurityMarksBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationSourceFindingSecurityMarksBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public OrganizationSourceFindingSecurityMarksBuilder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        public SecurityMarksName build() {
            return new SecurityMarksName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String asset;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getAsset() {
            return this.asset;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        private Builder(SecurityMarksName securityMarksName) {
            Preconditions.checkArgument((boolean)Objects.equals(securityMarksName.pathTemplate, ORGANIZATION_ASSET), (Object)"toBuilder is only supported when SecurityMarksName has the pattern of organizations/{organization}/assets/{asset}/securityMarks");
            this.organization = securityMarksName.organization;
            this.asset = securityMarksName.asset;
        }

        public SecurityMarksName build() {
            return new SecurityMarksName(this);
        }
    }
}

