/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SourceName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/sources/{source}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String source;

    public String getOrganization() {
        return this.organization;
    }

    public String getSource() {
        return this.source;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SourceName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
    }

    public static SourceName of(String organization, String source) {
        return SourceName.newBuilder().setOrganization(organization).setSource(source).build();
    }

    public static String format(String organization, String source) {
        return SourceName.newBuilder().setOrganization(organization).setSource(source).build().toString();
    }

    public static SourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SourceName.parse: formattedString not in valid format");
        return SourceName.of((String)matchMap.get("organization"), (String)matchMap.get("source"));
    }

    public static List<SourceName> parseList(List<String> formattedStrings) {
        ArrayList<SourceName> list = new ArrayList<SourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SourceName sourceName = this;
            synchronized (sourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    fieldMapBuilder.put((Object)"source", (Object)this.source);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"organization", this.organization, "source", this.source});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SourceName) {
            SourceName that = (SourceName)o;
            return this.organization.equals(that.organization) && this.source.equals(that.source);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.organization.hashCode();
        h *= 1000003;
        return h ^= this.source.hashCode();
    }

    public static class Builder {
        private String organization;
        private String source;

        public String getOrganization() {
            return this.organization;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        private Builder() {
        }

        private Builder(SourceName sourceName) {
            this.organization = sourceName.organization;
            this.source = sourceName.source;
        }

        public SourceName build() {
            return new SourceName(this);
        }
    }
}

