/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.settings.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceAccountName
implements ResourceName {
    private static final PathTemplate ORGANIZATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/serviceAccount");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;

    @Deprecated
    protected ServiceAccountName() {
        this.organization = null;
    }

    private ServiceAccountName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceAccountName of(String organization) {
        return ServiceAccountName.newBuilder().setOrganization(organization).build();
    }

    public static String format(String organization) {
        return ServiceAccountName.newBuilder().setOrganization(organization).build().toString();
    }

    public static ServiceAccountName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION.validatedMatch(formattedString, "ServiceAccountName.parse: formattedString not in valid format");
        return ServiceAccountName.of((String)matchMap.get("organization"));
    }

    public static List<ServiceAccountName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceAccountName> list = new ArrayList<ServiceAccountName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceAccountName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceAccountName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceAccountName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceAccountName serviceAccountName = this;
            synchronized (serviceAccountName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION.instantiate(new String[]{"organization", this.organization});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceAccountName that = (ServiceAccountName)o;
            return Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class Builder {
        private String organization;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        private Builder(ServiceAccountName serviceAccountName) {
            this.organization = serviceAccountName.organization;
        }

        public ServiceAccountName build() {
            return new ServiceAccountName(this);
        }
    }
}

