/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CertificateTemplateName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CERTIFICATE_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/certificateTemplates/{certificate_template}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String certificateTemplate;

    @Deprecated
    protected CertificateTemplateName() {
        this.project = null;
        this.location = null;
        this.certificateTemplate = null;
    }

    private CertificateTemplateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.certificateTemplate = (String)Preconditions.checkNotNull((Object)builder.getCertificateTemplate());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCertificateTemplate() {
        return this.certificateTemplate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CertificateTemplateName of(String project, String location, String certificateTemplate) {
        return CertificateTemplateName.newBuilder().setProject(project).setLocation(location).setCertificateTemplate(certificateTemplate).build();
    }

    public static String format(String project, String location, String certificateTemplate) {
        return CertificateTemplateName.newBuilder().setProject(project).setLocation(location).setCertificateTemplate(certificateTemplate).build().toString();
    }

    public static CertificateTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CERTIFICATE_TEMPLATE.validatedMatch(formattedString, "CertificateTemplateName.parse: formattedString not in valid format");
        return CertificateTemplateName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("certificate_template"));
    }

    public static List<CertificateTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateTemplateName> list = new ArrayList<CertificateTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CERTIFICATE_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateTemplateName certificateTemplateName = this;
            synchronized (certificateTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.certificateTemplate != null) {
                        fieldMapBuilder.put((Object)"certificate_template", (Object)this.certificateTemplate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CERTIFICATE_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "certificate_template", this.certificateTemplate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CertificateTemplateName that = (CertificateTemplateName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.certificateTemplate, that.certificateTemplate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.certificateTemplate);
    }

    public static class Builder {
        private String project;
        private String location;
        private String certificateTemplate;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCertificateTemplate() {
            return this.certificateTemplate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCertificateTemplate(String certificateTemplate) {
            this.certificateTemplate = certificateTemplate;
            return this;
        }

        private Builder(CertificateTemplateName certificateTemplateName) {
            this.project = certificateTemplateName.project;
            this.location = certificateTemplateName.location;
            this.certificateTemplate = certificateTemplateName.certificateTemplate;
        }

        public CertificateTemplateName build() {
            return new CertificateTemplateName(this);
        }
    }
}

