/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securesourcemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PullRequestCommentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_PULL_REQUEST_COMMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/pullRequests/{pull_request}/pullRequestComments/{comment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String pullRequest;
    private final String comment;

    @Deprecated
    protected PullRequestCommentName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.pullRequest = null;
        this.comment = null;
    }

    private PullRequestCommentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.pullRequest = (String)Preconditions.checkNotNull((Object)builder.getPullRequest());
        this.comment = (String)Preconditions.checkNotNull((Object)builder.getComment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getPullRequest() {
        return this.pullRequest;
    }

    public String getComment() {
        return this.comment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PullRequestCommentName of(String project, String location, String repository, String pullRequest, String comment) {
        return PullRequestCommentName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setPullRequest(pullRequest).setComment(comment).build();
    }

    public static String format(String project, String location, String repository, String pullRequest, String comment) {
        return PullRequestCommentName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setPullRequest(pullRequest).setComment(comment).build().toString();
    }

    public static PullRequestCommentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_PULL_REQUEST_COMMENT.validatedMatch(formattedString, "PullRequestCommentName.parse: formattedString not in valid format");
        return PullRequestCommentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("pull_request"), (String)matchMap.get("comment"));
    }

    public static List<PullRequestCommentName> parseList(List<String> formattedStrings) {
        ArrayList<PullRequestCommentName> list = new ArrayList<PullRequestCommentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PullRequestCommentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PullRequestCommentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PullRequestCommentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_PULL_REQUEST_COMMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PullRequestCommentName pullRequestCommentName = this;
            synchronized (pullRequestCommentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.pullRequest != null) {
                        fieldMapBuilder.put((Object)"pull_request", (Object)this.pullRequest);
                    }
                    if (this.comment != null) {
                        fieldMapBuilder.put((Object)"comment", (Object)this.comment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_PULL_REQUEST_COMMENT.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "pull_request", this.pullRequest, "comment", this.comment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PullRequestCommentName that = (PullRequestCommentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.pullRequest, that.pullRequest) && Objects.equals(this.comment, that.comment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        h ^= Objects.hashCode(this.pullRequest);
        h *= 1000003;
        return h ^= Objects.hashCode(this.comment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String pullRequest;
        private String comment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getPullRequest() {
            return this.pullRequest;
        }

        public String getComment() {
            return this.comment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setPullRequest(String pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        private Builder(PullRequestCommentName pullRequestCommentName) {
            this.project = pullRequestCommentName.project;
            this.location = pullRequestCommentName.location;
            this.repository = pullRequestCommentName.repository;
            this.pullRequest = pullRequestCommentName.pullRequest;
            this.comment = pullRequestCommentName.comment;
        }

        public PullRequestCommentName build() {
            return new PullRequestCommentName(this);
        }
    }
}

