/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securesourcemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IssueCommentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_ISSUE_COMMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/issues/{issue}/issueComments/{comment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String issue;
    private final String comment;

    @Deprecated
    protected IssueCommentName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.issue = null;
        this.comment = null;
    }

    private IssueCommentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.issue = (String)Preconditions.checkNotNull((Object)builder.getIssue());
        this.comment = (String)Preconditions.checkNotNull((Object)builder.getComment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getIssue() {
        return this.issue;
    }

    public String getComment() {
        return this.comment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IssueCommentName of(String project, String location, String repository, String issue, String comment) {
        return IssueCommentName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setIssue(issue).setComment(comment).build();
    }

    public static String format(String project, String location, String repository, String issue, String comment) {
        return IssueCommentName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setIssue(issue).setComment(comment).build().toString();
    }

    public static IssueCommentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_ISSUE_COMMENT.validatedMatch(formattedString, "IssueCommentName.parse: formattedString not in valid format");
        return IssueCommentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("issue"), (String)matchMap.get("comment"));
    }

    public static List<IssueCommentName> parseList(List<String> formattedStrings) {
        ArrayList<IssueCommentName> list = new ArrayList<IssueCommentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IssueCommentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IssueCommentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IssueCommentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_ISSUE_COMMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IssueCommentName issueCommentName = this;
            synchronized (issueCommentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.issue != null) {
                        fieldMapBuilder.put((Object)"issue", (Object)this.issue);
                    }
                    if (this.comment != null) {
                        fieldMapBuilder.put((Object)"comment", (Object)this.comment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_ISSUE_COMMENT.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "issue", this.issue, "comment", this.comment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            IssueCommentName that = (IssueCommentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.issue, that.issue) && Objects.equals(this.comment, that.comment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        h ^= Objects.hashCode(this.issue);
        h *= 1000003;
        return h ^= Objects.hashCode(this.comment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String issue;
        private String comment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getIssue() {
            return this.issue;
        }

        public String getComment() {
            return this.comment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setIssue(String issue) {
            this.issue = issue;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        private Builder(IssueCommentName issueCommentName) {
            this.project = issueCommentName.project;
            this.location = issueCommentName.location;
            this.repository = issueCommentName.repository;
            this.issue = issueCommentName.issue;
            this.comment = issueCommentName.comment;
        }

        public IssueCommentName build() {
            return new IssueCommentName(this);
        }
    }
}

