/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securesourcemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BranchRuleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_BRANCH_RULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String branchRule;

    @Deprecated
    protected BranchRuleName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.branchRule = null;
    }

    private BranchRuleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.branchRule = (String)Preconditions.checkNotNull((Object)builder.getBranchRule());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getBranchRule() {
        return this.branchRule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BranchRuleName of(String project, String location, String repository, String branchRule) {
        return BranchRuleName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setBranchRule(branchRule).build();
    }

    public static String format(String project, String location, String repository, String branchRule) {
        return BranchRuleName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setBranchRule(branchRule).build().toString();
    }

    public static BranchRuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_BRANCH_RULE.validatedMatch(formattedString, "BranchRuleName.parse: formattedString not in valid format");
        return BranchRuleName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("branch_rule"));
    }

    public static List<BranchRuleName> parseList(List<String> formattedStrings) {
        ArrayList<BranchRuleName> list = new ArrayList<BranchRuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BranchRuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BranchRuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BranchRuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_BRANCH_RULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BranchRuleName branchRuleName = this;
            synchronized (branchRuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.branchRule != null) {
                        fieldMapBuilder.put((Object)"branch_rule", (Object)this.branchRule);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_BRANCH_RULE.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "branch_rule", this.branchRule});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BranchRuleName that = (BranchRuleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.branchRule, that.branchRule);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        return h ^= Objects.hashCode(this.branchRule);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String branchRule;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getBranchRule() {
            return this.branchRule;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setBranchRule(String branchRule) {
            this.branchRule = branchRule;
            return this;
        }

        private Builder(BranchRuleName branchRuleName) {
            this.project = branchRuleName.project;
            this.location = branchRuleName.location;
            this.repository = branchRuleName.repository;
            this.branchRule = branchRuleName.branchRule;
        }

        public BranchRuleName build() {
            return new BranchRuleName(this);
        }
    }
}

