/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.saasplatform.saasservicemgmt.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UnitOperationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_UNITOPERATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/unitOperations/{unitOperation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String unitOperation;

    @Deprecated
    protected UnitOperationName() {
        this.project = null;
        this.location = null;
        this.unitOperation = null;
    }

    private UnitOperationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.unitOperation = (String)Preconditions.checkNotNull((Object)builder.getUnitOperation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getUnitOperation() {
        return this.unitOperation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UnitOperationName of(String project, String location, String unitOperation) {
        return UnitOperationName.newBuilder().setProject(project).setLocation(location).setUnitOperation(unitOperation).build();
    }

    public static String format(String project, String location, String unitOperation) {
        return UnitOperationName.newBuilder().setProject(project).setLocation(location).setUnitOperation(unitOperation).build().toString();
    }

    public static UnitOperationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_UNITOPERATION.validatedMatch(formattedString, "UnitOperationName.parse: formattedString not in valid format");
        return UnitOperationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("unitOperation"));
    }

    public static List<UnitOperationName> parseList(List<String> formattedStrings) {
        ArrayList<UnitOperationName> list = new ArrayList<UnitOperationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UnitOperationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UnitOperationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UnitOperationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_UNITOPERATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UnitOperationName unitOperationName = this;
            synchronized (unitOperationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.unitOperation != null) {
                        fieldMapBuilder.put((Object)"unitOperation", (Object)this.unitOperation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_UNITOPERATION.instantiate(new String[]{"project", this.project, "location", this.location, "unitOperation", this.unitOperation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UnitOperationName that = (UnitOperationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.unitOperation, that.unitOperation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.unitOperation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String unitOperation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getUnitOperation() {
            return this.unitOperation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setUnitOperation(String unitOperation) {
            this.unitOperation = unitOperation;
            return this;
        }

        private Builder(UnitOperationName unitOperationName) {
            this.project = unitOperationName.project;
            this.location = unitOperationName.location;
            this.unitOperation = unitOperationName.unitOperation;
        }

        public UnitOperationName build() {
            return new UnitOperationName(this);
        }
    }
}

