/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.saasplatform.saasservicemgmt.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UnitKindName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_UNITKIND = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/unitKinds/{unitKind}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String unitKind;

    @Deprecated
    protected UnitKindName() {
        this.project = null;
        this.location = null;
        this.unitKind = null;
    }

    private UnitKindName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.unitKind = (String)Preconditions.checkNotNull((Object)builder.getUnitKind());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getUnitKind() {
        return this.unitKind;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UnitKindName of(String project, String location, String unitKind) {
        return UnitKindName.newBuilder().setProject(project).setLocation(location).setUnitKind(unitKind).build();
    }

    public static String format(String project, String location, String unitKind) {
        return UnitKindName.newBuilder().setProject(project).setLocation(location).setUnitKind(unitKind).build().toString();
    }

    public static UnitKindName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_UNITKIND.validatedMatch(formattedString, "UnitKindName.parse: formattedString not in valid format");
        return UnitKindName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("unitKind"));
    }

    public static List<UnitKindName> parseList(List<String> formattedStrings) {
        ArrayList<UnitKindName> list = new ArrayList<UnitKindName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UnitKindName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UnitKindName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UnitKindName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_UNITKIND.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UnitKindName unitKindName = this;
            synchronized (unitKindName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.unitKind != null) {
                        fieldMapBuilder.put((Object)"unitKind", (Object)this.unitKind);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_UNITKIND.instantiate(new String[]{"project", this.project, "location", this.location, "unitKind", this.unitKind});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UnitKindName that = (UnitKindName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.unitKind, that.unitKind);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.unitKind);
    }

    public static class Builder {
        private String project;
        private String location;
        private String unitKind;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getUnitKind() {
            return this.unitKind;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setUnitKind(String unitKind) {
            this.unitKind = unitKind;
            return this;
        }

        private Builder(UnitKindName unitKindName) {
            this.project = unitKindName.project;
            this.location = unitKindName.location;
            this.unitKind = unitKindName.unitKind;
        }

        public UnitKindName build() {
            return new UnitKindName(this);
        }
    }
}

