/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.saasplatform.saasservicemgmt.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SaasName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SAAS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/saas/{saas}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String saas;

    @Deprecated
    protected SaasName() {
        this.project = null;
        this.location = null;
        this.saas = null;
    }

    private SaasName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.saas = (String)Preconditions.checkNotNull((Object)builder.getSaas());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSaas() {
        return this.saas;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SaasName of(String project, String location, String saas) {
        return SaasName.newBuilder().setProject(project).setLocation(location).setSaas(saas).build();
    }

    public static String format(String project, String location, String saas) {
        return SaasName.newBuilder().setProject(project).setLocation(location).setSaas(saas).build().toString();
    }

    public static SaasName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SAAS.validatedMatch(formattedString, "SaasName.parse: formattedString not in valid format");
        return SaasName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("saas"));
    }

    public static List<SaasName> parseList(List<String> formattedStrings) {
        ArrayList<SaasName> list = new ArrayList<SaasName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SaasName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SaasName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SaasName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SAAS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SaasName saasName = this;
            synchronized (saasName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.saas != null) {
                        fieldMapBuilder.put((Object)"saas", (Object)this.saas);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SAAS.instantiate(new String[]{"project", this.project, "location", this.location, "saas", this.saas});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SaasName that = (SaasName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.saas, that.saas);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.saas);
    }

    public static class Builder {
        private String project;
        private String location;
        private String saas;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSaas() {
            return this.saas;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSaas(String saas) {
            this.saas = saas;
            return this;
        }

        private Builder(SaasName saasName) {
            this.project = saasName.project;
            this.location = saasName.location;
            this.saas = saasName.saas;
        }

        public SaasName build() {
            return new SaasName(this);
        }
    }
}

