/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.saasplatform.saasservicemgmt.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UnitName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_UNIT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/units/{unit}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String unit;

    @Deprecated
    protected UnitName() {
        this.project = null;
        this.location = null;
        this.unit = null;
    }

    private UnitName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.unit = (String)Preconditions.checkNotNull((Object)builder.getUnit());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getUnit() {
        return this.unit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UnitName of(String project, String location, String unit) {
        return UnitName.newBuilder().setProject(project).setLocation(location).setUnit(unit).build();
    }

    public static String format(String project, String location, String unit) {
        return UnitName.newBuilder().setProject(project).setLocation(location).setUnit(unit).build().toString();
    }

    public static UnitName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_UNIT.validatedMatch(formattedString, "UnitName.parse: formattedString not in valid format");
        return UnitName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("unit"));
    }

    public static List<UnitName> parseList(List<String> formattedStrings) {
        ArrayList<UnitName> list = new ArrayList<UnitName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UnitName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UnitName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UnitName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_UNIT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UnitName unitName = this;
            synchronized (unitName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.unit != null) {
                        fieldMapBuilder.put((Object)"unit", (Object)this.unit);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_UNIT.instantiate(new String[]{"project", this.project, "location", this.location, "unit", this.unit});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UnitName that = (UnitName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.unit, that.unit);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.unit);
    }

    public static class Builder {
        private String project;
        private String location;
        private String unit;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getUnit() {
            return this.unit;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setUnit(String unit) {
            this.unit = unit;
            return this;
        }

        private Builder(UnitName unitName) {
            this.project = unitName.project;
            this.location = unitName.location;
            this.unit = unitName.unit;
        }

        public UnitName build() {
            return new UnitName(this);
        }
    }
}

