/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.saasplatform.saasservicemgmt.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RolloutName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ROLLOUT_ID = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/rollouts/{rollout_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String rolloutId;

    @Deprecated
    protected RolloutName() {
        this.project = null;
        this.location = null;
        this.rolloutId = null;
    }

    private RolloutName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.rolloutId = (String)Preconditions.checkNotNull((Object)builder.getRolloutId());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRolloutId() {
        return this.rolloutId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RolloutName of(String project, String location, String rolloutId) {
        return RolloutName.newBuilder().setProject(project).setLocation(location).setRolloutId(rolloutId).build();
    }

    public static String format(String project, String location, String rolloutId) {
        return RolloutName.newBuilder().setProject(project).setLocation(location).setRolloutId(rolloutId).build().toString();
    }

    public static RolloutName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ROLLOUT_ID.validatedMatch(formattedString, "RolloutName.parse: formattedString not in valid format");
        return RolloutName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("rollout_id"));
    }

    public static List<RolloutName> parseList(List<String> formattedStrings) {
        ArrayList<RolloutName> list = new ArrayList<RolloutName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RolloutName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RolloutName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RolloutName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ROLLOUT_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RolloutName rolloutName = this;
            synchronized (rolloutName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.rolloutId != null) {
                        fieldMapBuilder.put((Object)"rollout_id", (Object)this.rolloutId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ROLLOUT_ID.instantiate(new String[]{"project", this.project, "location", this.location, "rollout_id", this.rolloutId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RolloutName that = (RolloutName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.rolloutId, that.rolloutId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.rolloutId);
    }

    public static class Builder {
        private String project;
        private String location;
        private String rolloutId;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRolloutId() {
            return this.rolloutId;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRolloutId(String rolloutId) {
            this.rolloutId = rolloutId;
            return this;
        }

        private Builder(RolloutName rolloutName) {
            this.project = rolloutName.project;
            this.location = rolloutName.location;
            this.rolloutId = rolloutName.rolloutId;
        }

        public RolloutName build() {
            return new RolloutName(this);
        }
    }
}

