/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.saasplatform.saasservicemgmt.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RolloutKindName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ROLLOUT_KIND_ID = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/rolloutKinds/{rollout_kind_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String rolloutKindId;

    @Deprecated
    protected RolloutKindName() {
        this.project = null;
        this.location = null;
        this.rolloutKindId = null;
    }

    private RolloutKindName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.rolloutKindId = (String)Preconditions.checkNotNull((Object)builder.getRolloutKindId());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRolloutKindId() {
        return this.rolloutKindId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RolloutKindName of(String project, String location, String rolloutKindId) {
        return RolloutKindName.newBuilder().setProject(project).setLocation(location).setRolloutKindId(rolloutKindId).build();
    }

    public static String format(String project, String location, String rolloutKindId) {
        return RolloutKindName.newBuilder().setProject(project).setLocation(location).setRolloutKindId(rolloutKindId).build().toString();
    }

    public static RolloutKindName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ROLLOUT_KIND_ID.validatedMatch(formattedString, "RolloutKindName.parse: formattedString not in valid format");
        return RolloutKindName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("rollout_kind_id"));
    }

    public static List<RolloutKindName> parseList(List<String> formattedStrings) {
        ArrayList<RolloutKindName> list = new ArrayList<RolloutKindName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RolloutKindName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RolloutKindName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RolloutKindName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ROLLOUT_KIND_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RolloutKindName rolloutKindName = this;
            synchronized (rolloutKindName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.rolloutKindId != null) {
                        fieldMapBuilder.put((Object)"rollout_kind_id", (Object)this.rolloutKindId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ROLLOUT_KIND_ID.instantiate(new String[]{"project", this.project, "location", this.location, "rollout_kind_id", this.rolloutKindId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RolloutKindName that = (RolloutKindName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.rolloutKindId, that.rolloutKindId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.rolloutKindId);
    }

    public static class Builder {
        private String project;
        private String location;
        private String rolloutKindId;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRolloutKindId() {
            return this.rolloutKindId;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRolloutKindId(String rolloutKindId) {
            this.rolloutKindId = rolloutKindId;
            return this;
        }

        private Builder(RolloutKindName rolloutKindName) {
            this.project = rolloutKindName.project;
            this.location = rolloutKindName.location;
            this.rolloutKindId = rolloutKindName.rolloutKindId;
        }

        public RolloutKindName build() {
            return new RolloutKindName(this);
        }
    }
}

