/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2;

import com.google.cloud.run.v2.ContainerOrBuilder;
import com.google.cloud.run.v2.ContainerPort;
import com.google.cloud.run.v2.ContainerPortOrBuilder;
import com.google.cloud.run.v2.EnvVar;
import com.google.cloud.run.v2.EnvVarOrBuilder;
import com.google.cloud.run.v2.K8sMinProto;
import com.google.cloud.run.v2.Probe;
import com.google.cloud.run.v2.ProbeOrBuilder;
import com.google.cloud.run.v2.ResourceRequirements;
import com.google.cloud.run.v2.ResourceRequirementsOrBuilder;
import com.google.cloud.run.v2.VolumeMount;
import com.google.cloud.run.v2.VolumeMountOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Container
extends GeneratedMessageV3
implements ContainerOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_;
    public static final int IMAGE_FIELD_NUMBER = 2;
    private volatile Object image_;
    public static final int COMMAND_FIELD_NUMBER = 3;
    private LazyStringList command_;
    public static final int ARGS_FIELD_NUMBER = 4;
    private LazyStringList args_;
    public static final int ENV_FIELD_NUMBER = 5;
    private List<EnvVar> env_;
    public static final int RESOURCES_FIELD_NUMBER = 6;
    private ResourceRequirements resources_;
    public static final int PORTS_FIELD_NUMBER = 7;
    private List<ContainerPort> ports_;
    public static final int VOLUME_MOUNTS_FIELD_NUMBER = 8;
    private List<VolumeMount> volumeMounts_;
    public static final int WORKING_DIR_FIELD_NUMBER = 9;
    private volatile Object workingDir_;
    public static final int LIVENESS_PROBE_FIELD_NUMBER = 10;
    private Probe livenessProbe_;
    public static final int STARTUP_PROBE_FIELD_NUMBER = 11;
    private Probe startupProbe_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Container DEFAULT_INSTANCE = new Container();
    private static final Parser<Container> PARSER = new AbstractParser<Container>(){

        public Container parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Container.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Container(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Container() {
        this.name_ = "";
        this.image_ = "";
        this.command_ = LazyStringArrayList.EMPTY;
        this.args_ = LazyStringArrayList.EMPTY;
        this.env_ = Collections.emptyList();
        this.ports_ = Collections.emptyList();
        this.volumeMounts_ = Collections.emptyList();
        this.workingDir_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Container();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return K8sMinProto.internal_static_google_cloud_run_v2_Container_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return K8sMinProto.internal_static_google_cloud_run_v2_Container_fieldAccessorTable.ensureFieldAccessorsInitialized(Container.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getImage() {
        Object ref = this.image_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.image_ = s;
        return s;
    }

    @Override
    public ByteString getImageBytes() {
        Object ref = this.image_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.image_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getCommandList() {
        return this.command_;
    }

    @Override
    public int getCommandCount() {
        return this.command_.size();
    }

    @Override
    public String getCommand(int index) {
        return (String)this.command_.get(index);
    }

    @Override
    public ByteString getCommandBytes(int index) {
        return this.command_.getByteString(index);
    }

    public ProtocolStringList getArgsList() {
        return this.args_;
    }

    @Override
    public int getArgsCount() {
        return this.args_.size();
    }

    @Override
    public String getArgs(int index) {
        return (String)this.args_.get(index);
    }

    @Override
    public ByteString getArgsBytes(int index) {
        return this.args_.getByteString(index);
    }

    @Override
    public List<EnvVar> getEnvList() {
        return this.env_;
    }

    @Override
    public List<? extends EnvVarOrBuilder> getEnvOrBuilderList() {
        return this.env_;
    }

    @Override
    public int getEnvCount() {
        return this.env_.size();
    }

    @Override
    public EnvVar getEnv(int index) {
        return this.env_.get(index);
    }

    @Override
    public EnvVarOrBuilder getEnvOrBuilder(int index) {
        return this.env_.get(index);
    }

    @Override
    public boolean hasResources() {
        return this.resources_ != null;
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources_ == null ? ResourceRequirements.getDefaultInstance() : this.resources_;
    }

    @Override
    public ResourceRequirementsOrBuilder getResourcesOrBuilder() {
        return this.getResources();
    }

    @Override
    public List<ContainerPort> getPortsList() {
        return this.ports_;
    }

    @Override
    public List<? extends ContainerPortOrBuilder> getPortsOrBuilderList() {
        return this.ports_;
    }

    @Override
    public int getPortsCount() {
        return this.ports_.size();
    }

    @Override
    public ContainerPort getPorts(int index) {
        return this.ports_.get(index);
    }

    @Override
    public ContainerPortOrBuilder getPortsOrBuilder(int index) {
        return this.ports_.get(index);
    }

    @Override
    public List<VolumeMount> getVolumeMountsList() {
        return this.volumeMounts_;
    }

    @Override
    public List<? extends VolumeMountOrBuilder> getVolumeMountsOrBuilderList() {
        return this.volumeMounts_;
    }

    @Override
    public int getVolumeMountsCount() {
        return this.volumeMounts_.size();
    }

    @Override
    public VolumeMount getVolumeMounts(int index) {
        return this.volumeMounts_.get(index);
    }

    @Override
    public VolumeMountOrBuilder getVolumeMountsOrBuilder(int index) {
        return this.volumeMounts_.get(index);
    }

    @Override
    public String getWorkingDir() {
        Object ref = this.workingDir_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.workingDir_ = s;
        return s;
    }

    @Override
    public ByteString getWorkingDirBytes() {
        Object ref = this.workingDir_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.workingDir_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasLivenessProbe() {
        return this.livenessProbe_ != null;
    }

    @Override
    public Probe getLivenessProbe() {
        return this.livenessProbe_ == null ? Probe.getDefaultInstance() : this.livenessProbe_;
    }

    @Override
    public ProbeOrBuilder getLivenessProbeOrBuilder() {
        return this.getLivenessProbe();
    }

    @Override
    public boolean hasStartupProbe() {
        return this.startupProbe_ != null;
    }

    @Override
    public Probe getStartupProbe() {
        return this.startupProbe_ == null ? Probe.getDefaultInstance() : this.startupProbe_;
    }

    @Override
    public ProbeOrBuilder getStartupProbeOrBuilder() {
        return this.getStartupProbe();
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.image_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.image_);
        }
        for (i = 0; i < this.command_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.command_.getRaw(i));
        }
        for (i = 0; i < this.args_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.args_.getRaw(i));
        }
        for (i = 0; i < this.env_.size(); ++i) {
            output.writeMessage(5, (MessageLite)this.env_.get(i));
        }
        if (this.resources_ != null) {
            output.writeMessage(6, (MessageLite)this.getResources());
        }
        for (i = 0; i < this.ports_.size(); ++i) {
            output.writeMessage(7, (MessageLite)this.ports_.get(i));
        }
        for (i = 0; i < this.volumeMounts_.size(); ++i) {
            output.writeMessage(8, (MessageLite)this.volumeMounts_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.workingDir_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.workingDir_);
        }
        if (this.livenessProbe_ != null) {
            output.writeMessage(10, (MessageLite)this.getLivenessProbe());
        }
        if (this.startupProbe_ != null) {
            output.writeMessage(11, (MessageLite)this.getStartupProbe());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int i2;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.image_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.image_);
        }
        int dataSize = 0;
        for (i2 = 0; i2 < this.command_.size(); ++i2) {
            dataSize += Container.computeStringSizeNoTag((Object)this.command_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getCommandList().size();
        dataSize = 0;
        for (i2 = 0; i2 < this.args_.size(); ++i2) {
            dataSize += Container.computeStringSizeNoTag((Object)this.args_.getRaw(i2));
        }
        size += dataSize;
        size += 1 * this.getArgsList().size();
        for (i = 0; i < this.env_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((MessageLite)this.env_.get(i)));
        }
        if (this.resources_ != null) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getResources());
        }
        for (i = 0; i < this.ports_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((MessageLite)this.ports_.get(i)));
        }
        for (i = 0; i < this.volumeMounts_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((MessageLite)this.volumeMounts_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.workingDir_)) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.workingDir_);
        }
        if (this.livenessProbe_ != null) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getLivenessProbe());
        }
        if (this.startupProbe_ != null) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getStartupProbe());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Container)) {
            return super.equals(obj);
        }
        Container other = (Container)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getImage().equals(other.getImage())) {
            return false;
        }
        if (!this.getCommandList().equals(other.getCommandList())) {
            return false;
        }
        if (!this.getArgsList().equals(other.getArgsList())) {
            return false;
        }
        if (!this.getEnvList().equals(other.getEnvList())) {
            return false;
        }
        if (this.hasResources() != other.hasResources()) {
            return false;
        }
        if (this.hasResources() && !this.getResources().equals(other.getResources())) {
            return false;
        }
        if (!this.getPortsList().equals(other.getPortsList())) {
            return false;
        }
        if (!this.getVolumeMountsList().equals(other.getVolumeMountsList())) {
            return false;
        }
        if (!this.getWorkingDir().equals(other.getWorkingDir())) {
            return false;
        }
        if (this.hasLivenessProbe() != other.hasLivenessProbe()) {
            return false;
        }
        if (this.hasLivenessProbe() && !this.getLivenessProbe().equals(other.getLivenessProbe())) {
            return false;
        }
        if (this.hasStartupProbe() != other.hasStartupProbe()) {
            return false;
        }
        if (this.hasStartupProbe() && !this.getStartupProbe().equals(other.getStartupProbe())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Container.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getImage().hashCode();
        if (this.getCommandCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getCommandList().hashCode();
        }
        if (this.getArgsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getArgsList().hashCode();
        }
        if (this.getEnvCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getEnvList().hashCode();
        }
        if (this.hasResources()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getResources().hashCode();
        }
        if (this.getPortsCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getPortsList().hashCode();
        }
        if (this.getVolumeMountsCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getVolumeMountsList().hashCode();
        }
        hash = 37 * hash + 9;
        hash = 53 * hash + this.getWorkingDir().hashCode();
        if (this.hasLivenessProbe()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getLivenessProbe().hashCode();
        }
        if (this.hasStartupProbe()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getStartupProbe().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Container parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Container)PARSER.parseFrom(data);
    }

    public static Container parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Container)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Container parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Container)PARSER.parseFrom(data);
    }

    public static Container parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Container)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Container parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Container)PARSER.parseFrom(data);
    }

    public static Container parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Container)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Container parseFrom(InputStream input) throws IOException {
        return (Container)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Container parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Container)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Container parseDelimitedFrom(InputStream input) throws IOException {
        return (Container)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Container parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Container)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Container parseFrom(CodedInputStream input) throws IOException {
        return (Container)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Container parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Container)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Container.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Container prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Container getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Container> parser() {
        return PARSER;
    }

    public Parser<Container> getParserForType() {
        return PARSER;
    }

    public Container getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ContainerOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Object image_ = "";
        private LazyStringList command_ = LazyStringArrayList.EMPTY;
        private LazyStringList args_ = LazyStringArrayList.EMPTY;
        private List<EnvVar> env_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<EnvVar, EnvVar.Builder, EnvVarOrBuilder> envBuilder_;
        private ResourceRequirements resources_;
        private SingleFieldBuilderV3<ResourceRequirements, ResourceRequirements.Builder, ResourceRequirementsOrBuilder> resourcesBuilder_;
        private List<ContainerPort> ports_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ContainerPort, ContainerPort.Builder, ContainerPortOrBuilder> portsBuilder_;
        private List<VolumeMount> volumeMounts_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<VolumeMount, VolumeMount.Builder, VolumeMountOrBuilder> volumeMountsBuilder_;
        private Object workingDir_ = "";
        private Probe livenessProbe_;
        private SingleFieldBuilderV3<Probe, Probe.Builder, ProbeOrBuilder> livenessProbeBuilder_;
        private Probe startupProbe_;
        private SingleFieldBuilderV3<Probe, Probe.Builder, ProbeOrBuilder> startupProbeBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return K8sMinProto.internal_static_google_cloud_run_v2_Container_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return K8sMinProto.internal_static_google_cloud_run_v2_Container_fieldAccessorTable.ensureFieldAccessorsInitialized(Container.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.name_ = "";
            this.image_ = "";
            this.command_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.args_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFD;
            if (this.envBuilder_ == null) {
                this.env_ = Collections.emptyList();
            } else {
                this.env_ = null;
                this.envBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            if (this.resourcesBuilder_ == null) {
                this.resources_ = null;
            } else {
                this.resources_ = null;
                this.resourcesBuilder_ = null;
            }
            if (this.portsBuilder_ == null) {
                this.ports_ = Collections.emptyList();
            } else {
                this.ports_ = null;
                this.portsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            if (this.volumeMountsBuilder_ == null) {
                this.volumeMounts_ = Collections.emptyList();
            } else {
                this.volumeMounts_ = null;
                this.volumeMountsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFEF;
            this.workingDir_ = "";
            if (this.livenessProbeBuilder_ == null) {
                this.livenessProbe_ = null;
            } else {
                this.livenessProbe_ = null;
                this.livenessProbeBuilder_ = null;
            }
            if (this.startupProbeBuilder_ == null) {
                this.startupProbe_ = null;
            } else {
                this.startupProbe_ = null;
                this.startupProbeBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return K8sMinProto.internal_static_google_cloud_run_v2_Container_descriptor;
        }

        public Container getDefaultInstanceForType() {
            return Container.getDefaultInstance();
        }

        public Container build() {
            Container result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Container buildPartial() {
            Container result = new Container(this);
            int from_bitField0_ = this.bitField0_;
            result.name_ = this.name_;
            result.image_ = this.image_;
            if ((this.bitField0_ & 1) != 0) {
                this.command_ = this.command_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.command_ = this.command_;
            if ((this.bitField0_ & 2) != 0) {
                this.args_ = this.args_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.args_ = this.args_;
            if (this.envBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.env_ = Collections.unmodifiableList(this.env_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.env_ = this.env_;
            } else {
                result.env_ = this.envBuilder_.build();
            }
            if (this.resourcesBuilder_ == null) {
                result.resources_ = this.resources_;
            } else {
                result.resources_ = (ResourceRequirements)this.resourcesBuilder_.build();
            }
            if (this.portsBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.ports_ = Collections.unmodifiableList(this.ports_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.ports_ = this.ports_;
            } else {
                result.ports_ = this.portsBuilder_.build();
            }
            if (this.volumeMountsBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0) {
                    this.volumeMounts_ = Collections.unmodifiableList(this.volumeMounts_);
                    this.bitField0_ &= 0xFFFFFFEF;
                }
                result.volumeMounts_ = this.volumeMounts_;
            } else {
                result.volumeMounts_ = this.volumeMountsBuilder_.build();
            }
            result.workingDir_ = this.workingDir_;
            if (this.livenessProbeBuilder_ == null) {
                result.livenessProbe_ = this.livenessProbe_;
            } else {
                result.livenessProbe_ = (Probe)this.livenessProbeBuilder_.build();
            }
            if (this.startupProbeBuilder_ == null) {
                result.startupProbe_ = this.startupProbe_;
            } else {
                result.startupProbe_ = (Probe)this.startupProbeBuilder_.build();
            }
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Container) {
                return this.mergeFrom((Container)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Container other) {
            if (other == Container.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.onChanged();
            }
            if (!other.getImage().isEmpty()) {
                this.image_ = other.image_;
                this.onChanged();
            }
            if (!other.command_.isEmpty()) {
                if (this.command_.isEmpty()) {
                    this.command_ = other.command_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureCommandIsMutable();
                    this.command_.addAll((Collection)other.command_);
                }
                this.onChanged();
            }
            if (!other.args_.isEmpty()) {
                if (this.args_.isEmpty()) {
                    this.args_ = other.args_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureArgsIsMutable();
                    this.args_.addAll((Collection)other.args_);
                }
                this.onChanged();
            }
            if (this.envBuilder_ == null) {
                if (!other.env_.isEmpty()) {
                    if (this.env_.isEmpty()) {
                        this.env_ = other.env_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureEnvIsMutable();
                        this.env_.addAll(other.env_);
                    }
                    this.onChanged();
                }
            } else if (!other.env_.isEmpty()) {
                if (this.envBuilder_.isEmpty()) {
                    this.envBuilder_.dispose();
                    this.envBuilder_ = null;
                    this.env_ = other.env_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.envBuilder_ = alwaysUseFieldBuilders ? this.getEnvFieldBuilder() : null;
                } else {
                    this.envBuilder_.addAllMessages((Iterable)other.env_);
                }
            }
            if (other.hasResources()) {
                this.mergeResources(other.getResources());
            }
            if (this.portsBuilder_ == null) {
                if (!other.ports_.isEmpty()) {
                    if (this.ports_.isEmpty()) {
                        this.ports_ = other.ports_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensurePortsIsMutable();
                        this.ports_.addAll(other.ports_);
                    }
                    this.onChanged();
                }
            } else if (!other.ports_.isEmpty()) {
                if (this.portsBuilder_.isEmpty()) {
                    this.portsBuilder_.dispose();
                    this.portsBuilder_ = null;
                    this.ports_ = other.ports_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.portsBuilder_ = alwaysUseFieldBuilders ? this.getPortsFieldBuilder() : null;
                } else {
                    this.portsBuilder_.addAllMessages((Iterable)other.ports_);
                }
            }
            if (this.volumeMountsBuilder_ == null) {
                if (!other.volumeMounts_.isEmpty()) {
                    if (this.volumeMounts_.isEmpty()) {
                        this.volumeMounts_ = other.volumeMounts_;
                        this.bitField0_ &= 0xFFFFFFEF;
                    } else {
                        this.ensureVolumeMountsIsMutable();
                        this.volumeMounts_.addAll(other.volumeMounts_);
                    }
                    this.onChanged();
                }
            } else if (!other.volumeMounts_.isEmpty()) {
                if (this.volumeMountsBuilder_.isEmpty()) {
                    this.volumeMountsBuilder_.dispose();
                    this.volumeMountsBuilder_ = null;
                    this.volumeMounts_ = other.volumeMounts_;
                    this.bitField0_ &= 0xFFFFFFEF;
                    this.volumeMountsBuilder_ = alwaysUseFieldBuilders ? this.getVolumeMountsFieldBuilder() : null;
                } else {
                    this.volumeMountsBuilder_.addAllMessages((Iterable)other.volumeMounts_);
                }
            }
            if (!other.getWorkingDir().isEmpty()) {
                this.workingDir_ = other.workingDir_;
                this.onChanged();
            }
            if (other.hasLivenessProbe()) {
                this.mergeLivenessProbe(other.getLivenessProbe());
            }
            if (other.hasStartupProbe()) {
                this.mergeStartupProbe(other.getStartupProbe());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block19: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block19;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            continue block19;
                        }
                        case 18: {
                            this.image_ = input.readStringRequireUtf8();
                            continue block19;
                        }
                        case 26: {
                            String s = input.readStringRequireUtf8();
                            this.ensureCommandIsMutable();
                            this.command_.add((Object)s);
                            continue block19;
                        }
                        case 34: {
                            String s = input.readStringRequireUtf8();
                            this.ensureArgsIsMutable();
                            this.args_.add((Object)s);
                            continue block19;
                        }
                        case 42: {
                            GeneratedMessageV3 m = (EnvVar)input.readMessage(EnvVar.parser(), extensionRegistry);
                            if (this.envBuilder_ == null) {
                                this.ensureEnvIsMutable();
                                this.env_.add((EnvVar)m);
                                continue block19;
                            }
                            this.envBuilder_.addMessage((AbstractMessage)m);
                            continue block19;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getResourcesFieldBuilder().getBuilder(), extensionRegistry);
                            continue block19;
                        }
                        case 58: {
                            GeneratedMessageV3 m = (ContainerPort)input.readMessage(ContainerPort.parser(), extensionRegistry);
                            if (this.portsBuilder_ == null) {
                                this.ensurePortsIsMutable();
                                this.ports_.add((ContainerPort)m);
                                continue block19;
                            }
                            this.portsBuilder_.addMessage((AbstractMessage)m);
                            continue block19;
                        }
                        case 66: {
                            GeneratedMessageV3 m = (VolumeMount)input.readMessage(VolumeMount.parser(), extensionRegistry);
                            if (this.volumeMountsBuilder_ == null) {
                                this.ensureVolumeMountsIsMutable();
                                this.volumeMounts_.add((VolumeMount)m);
                                continue block19;
                            }
                            this.volumeMountsBuilder_.addMessage((AbstractMessage)m);
                            continue block19;
                        }
                        case 74: {
                            this.workingDir_ = input.readStringRequireUtf8();
                            continue block19;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getLivenessProbeFieldBuilder().getBuilder(), extensionRegistry);
                            continue block19;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getStartupProbeFieldBuilder().getBuilder(), extensionRegistry);
                            continue block19;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Container.getDefaultInstance().getName();
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Container.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getImage() {
            Object ref = this.image_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.image_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getImageBytes() {
            Object ref = this.image_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.image_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setImage(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.image_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearImage() {
            this.image_ = Container.getDefaultInstance().getImage();
            this.onChanged();
            return this;
        }

        public Builder setImageBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Container.checkByteStringIsUtf8((ByteString)value);
            this.image_ = value;
            this.onChanged();
            return this;
        }

        private void ensureCommandIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.command_ = new LazyStringArrayList(this.command_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getCommandList() {
            return this.command_.getUnmodifiableView();
        }

        @Override
        public int getCommandCount() {
            return this.command_.size();
        }

        @Override
        public String getCommand(int index) {
            return (String)this.command_.get(index);
        }

        @Override
        public ByteString getCommandBytes(int index) {
            return this.command_.getByteString(index);
        }

        public Builder setCommand(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCommandIsMutable();
            this.command_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addCommand(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCommandIsMutable();
            this.command_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllCommand(Iterable<String> values) {
            this.ensureCommandIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.command_);
            this.onChanged();
            return this;
        }

        public Builder clearCommand() {
            this.command_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addCommandBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Container.checkByteStringIsUtf8((ByteString)value);
            this.ensureCommandIsMutable();
            this.command_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureArgsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.args_ = new LazyStringArrayList(this.args_);
                this.bitField0_ |= 2;
            }
        }

        public ProtocolStringList getArgsList() {
            return this.args_.getUnmodifiableView();
        }

        @Override
        public int getArgsCount() {
            return this.args_.size();
        }

        @Override
        public String getArgs(int index) {
            return (String)this.args_.get(index);
        }

        @Override
        public ByteString getArgsBytes(int index) {
            return this.args_.getByteString(index);
        }

        public Builder setArgs(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureArgsIsMutable();
            this.args_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addArgs(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureArgsIsMutable();
            this.args_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllArgs(Iterable<String> values) {
            this.ensureArgsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.args_);
            this.onChanged();
            return this;
        }

        public Builder clearArgs() {
            this.args_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder addArgsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Container.checkByteStringIsUtf8((ByteString)value);
            this.ensureArgsIsMutable();
            this.args_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureEnvIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.env_ = new ArrayList<EnvVar>(this.env_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<EnvVar> getEnvList() {
            if (this.envBuilder_ == null) {
                return Collections.unmodifiableList(this.env_);
            }
            return this.envBuilder_.getMessageList();
        }

        @Override
        public int getEnvCount() {
            if (this.envBuilder_ == null) {
                return this.env_.size();
            }
            return this.envBuilder_.getCount();
        }

        @Override
        public EnvVar getEnv(int index) {
            if (this.envBuilder_ == null) {
                return this.env_.get(index);
            }
            return (EnvVar)this.envBuilder_.getMessage(index);
        }

        public Builder setEnv(int index, EnvVar value) {
            if (this.envBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEnvIsMutable();
                this.env_.set(index, value);
                this.onChanged();
            } else {
                this.envBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setEnv(int index, EnvVar.Builder builderForValue) {
            if (this.envBuilder_ == null) {
                this.ensureEnvIsMutable();
                this.env_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.envBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addEnv(EnvVar value) {
            if (this.envBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEnvIsMutable();
                this.env_.add(value);
                this.onChanged();
            } else {
                this.envBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addEnv(int index, EnvVar value) {
            if (this.envBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEnvIsMutable();
                this.env_.add(index, value);
                this.onChanged();
            } else {
                this.envBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addEnv(EnvVar.Builder builderForValue) {
            if (this.envBuilder_ == null) {
                this.ensureEnvIsMutable();
                this.env_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.envBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addEnv(int index, EnvVar.Builder builderForValue) {
            if (this.envBuilder_ == null) {
                this.ensureEnvIsMutable();
                this.env_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.envBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllEnv(Iterable<? extends EnvVar> values) {
            if (this.envBuilder_ == null) {
                this.ensureEnvIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.env_);
                this.onChanged();
            } else {
                this.envBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearEnv() {
            if (this.envBuilder_ == null) {
                this.env_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.envBuilder_.clear();
            }
            return this;
        }

        public Builder removeEnv(int index) {
            if (this.envBuilder_ == null) {
                this.ensureEnvIsMutable();
                this.env_.remove(index);
                this.onChanged();
            } else {
                this.envBuilder_.remove(index);
            }
            return this;
        }

        public EnvVar.Builder getEnvBuilder(int index) {
            return (EnvVar.Builder)this.getEnvFieldBuilder().getBuilder(index);
        }

        @Override
        public EnvVarOrBuilder getEnvOrBuilder(int index) {
            if (this.envBuilder_ == null) {
                return this.env_.get(index);
            }
            return (EnvVarOrBuilder)this.envBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends EnvVarOrBuilder> getEnvOrBuilderList() {
            if (this.envBuilder_ != null) {
                return this.envBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.env_);
        }

        public EnvVar.Builder addEnvBuilder() {
            return (EnvVar.Builder)this.getEnvFieldBuilder().addBuilder((AbstractMessage)EnvVar.getDefaultInstance());
        }

        public EnvVar.Builder addEnvBuilder(int index) {
            return (EnvVar.Builder)this.getEnvFieldBuilder().addBuilder(index, (AbstractMessage)EnvVar.getDefaultInstance());
        }

        public List<EnvVar.Builder> getEnvBuilderList() {
            return this.getEnvFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<EnvVar, EnvVar.Builder, EnvVarOrBuilder> getEnvFieldBuilder() {
            if (this.envBuilder_ == null) {
                this.envBuilder_ = new RepeatedFieldBuilderV3(this.env_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.env_ = null;
            }
            return this.envBuilder_;
        }

        @Override
        public boolean hasResources() {
            return this.resourcesBuilder_ != null || this.resources_ != null;
        }

        @Override
        public ResourceRequirements getResources() {
            if (this.resourcesBuilder_ == null) {
                return this.resources_ == null ? ResourceRequirements.getDefaultInstance() : this.resources_;
            }
            return (ResourceRequirements)this.resourcesBuilder_.getMessage();
        }

        public Builder setResources(ResourceRequirements value) {
            if (this.resourcesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.resources_ = value;
                this.onChanged();
            } else {
                this.resourcesBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setResources(ResourceRequirements.Builder builderForValue) {
            if (this.resourcesBuilder_ == null) {
                this.resources_ = builderForValue.build();
                this.onChanged();
            } else {
                this.resourcesBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeResources(ResourceRequirements value) {
            if (this.resourcesBuilder_ == null) {
                this.resources_ = this.resources_ != null ? ResourceRequirements.newBuilder(this.resources_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.resourcesBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearResources() {
            if (this.resourcesBuilder_ == null) {
                this.resources_ = null;
                this.onChanged();
            } else {
                this.resources_ = null;
                this.resourcesBuilder_ = null;
            }
            return this;
        }

        public ResourceRequirements.Builder getResourcesBuilder() {
            this.onChanged();
            return (ResourceRequirements.Builder)this.getResourcesFieldBuilder().getBuilder();
        }

        @Override
        public ResourceRequirementsOrBuilder getResourcesOrBuilder() {
            if (this.resourcesBuilder_ != null) {
                return (ResourceRequirementsOrBuilder)this.resourcesBuilder_.getMessageOrBuilder();
            }
            return this.resources_ == null ? ResourceRequirements.getDefaultInstance() : this.resources_;
        }

        private SingleFieldBuilderV3<ResourceRequirements, ResourceRequirements.Builder, ResourceRequirementsOrBuilder> getResourcesFieldBuilder() {
            if (this.resourcesBuilder_ == null) {
                this.resourcesBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getResources(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.resources_ = null;
            }
            return this.resourcesBuilder_;
        }

        private void ensurePortsIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.ports_ = new ArrayList<ContainerPort>(this.ports_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<ContainerPort> getPortsList() {
            if (this.portsBuilder_ == null) {
                return Collections.unmodifiableList(this.ports_);
            }
            return this.portsBuilder_.getMessageList();
        }

        @Override
        public int getPortsCount() {
            if (this.portsBuilder_ == null) {
                return this.ports_.size();
            }
            return this.portsBuilder_.getCount();
        }

        @Override
        public ContainerPort getPorts(int index) {
            if (this.portsBuilder_ == null) {
                return this.ports_.get(index);
            }
            return (ContainerPort)this.portsBuilder_.getMessage(index);
        }

        public Builder setPorts(int index, ContainerPort value) {
            if (this.portsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePortsIsMutable();
                this.ports_.set(index, value);
                this.onChanged();
            } else {
                this.portsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPorts(int index, ContainerPort.Builder builderForValue) {
            if (this.portsBuilder_ == null) {
                this.ensurePortsIsMutable();
                this.ports_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.portsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPorts(ContainerPort value) {
            if (this.portsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePortsIsMutable();
                this.ports_.add(value);
                this.onChanged();
            } else {
                this.portsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPorts(int index, ContainerPort value) {
            if (this.portsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePortsIsMutable();
                this.ports_.add(index, value);
                this.onChanged();
            } else {
                this.portsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPorts(ContainerPort.Builder builderForValue) {
            if (this.portsBuilder_ == null) {
                this.ensurePortsIsMutable();
                this.ports_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.portsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPorts(int index, ContainerPort.Builder builderForValue) {
            if (this.portsBuilder_ == null) {
                this.ensurePortsIsMutable();
                this.ports_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.portsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPorts(Iterable<? extends ContainerPort> values) {
            if (this.portsBuilder_ == null) {
                this.ensurePortsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.ports_);
                this.onChanged();
            } else {
                this.portsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPorts() {
            if (this.portsBuilder_ == null) {
                this.ports_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.portsBuilder_.clear();
            }
            return this;
        }

        public Builder removePorts(int index) {
            if (this.portsBuilder_ == null) {
                this.ensurePortsIsMutable();
                this.ports_.remove(index);
                this.onChanged();
            } else {
                this.portsBuilder_.remove(index);
            }
            return this;
        }

        public ContainerPort.Builder getPortsBuilder(int index) {
            return (ContainerPort.Builder)this.getPortsFieldBuilder().getBuilder(index);
        }

        @Override
        public ContainerPortOrBuilder getPortsOrBuilder(int index) {
            if (this.portsBuilder_ == null) {
                return this.ports_.get(index);
            }
            return (ContainerPortOrBuilder)this.portsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ContainerPortOrBuilder> getPortsOrBuilderList() {
            if (this.portsBuilder_ != null) {
                return this.portsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.ports_);
        }

        public ContainerPort.Builder addPortsBuilder() {
            return (ContainerPort.Builder)this.getPortsFieldBuilder().addBuilder((AbstractMessage)ContainerPort.getDefaultInstance());
        }

        public ContainerPort.Builder addPortsBuilder(int index) {
            return (ContainerPort.Builder)this.getPortsFieldBuilder().addBuilder(index, (AbstractMessage)ContainerPort.getDefaultInstance());
        }

        public List<ContainerPort.Builder> getPortsBuilderList() {
            return this.getPortsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ContainerPort, ContainerPort.Builder, ContainerPortOrBuilder> getPortsFieldBuilder() {
            if (this.portsBuilder_ == null) {
                this.portsBuilder_ = new RepeatedFieldBuilderV3(this.ports_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.ports_ = null;
            }
            return this.portsBuilder_;
        }

        private void ensureVolumeMountsIsMutable() {
            if ((this.bitField0_ & 0x10) == 0) {
                this.volumeMounts_ = new ArrayList<VolumeMount>(this.volumeMounts_);
                this.bitField0_ |= 0x10;
            }
        }

        @Override
        public List<VolumeMount> getVolumeMountsList() {
            if (this.volumeMountsBuilder_ == null) {
                return Collections.unmodifiableList(this.volumeMounts_);
            }
            return this.volumeMountsBuilder_.getMessageList();
        }

        @Override
        public int getVolumeMountsCount() {
            if (this.volumeMountsBuilder_ == null) {
                return this.volumeMounts_.size();
            }
            return this.volumeMountsBuilder_.getCount();
        }

        @Override
        public VolumeMount getVolumeMounts(int index) {
            if (this.volumeMountsBuilder_ == null) {
                return this.volumeMounts_.get(index);
            }
            return (VolumeMount)this.volumeMountsBuilder_.getMessage(index);
        }

        public Builder setVolumeMounts(int index, VolumeMount value) {
            if (this.volumeMountsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVolumeMountsIsMutable();
                this.volumeMounts_.set(index, value);
                this.onChanged();
            } else {
                this.volumeMountsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setVolumeMounts(int index, VolumeMount.Builder builderForValue) {
            if (this.volumeMountsBuilder_ == null) {
                this.ensureVolumeMountsIsMutable();
                this.volumeMounts_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.volumeMountsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addVolumeMounts(VolumeMount value) {
            if (this.volumeMountsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVolumeMountsIsMutable();
                this.volumeMounts_.add(value);
                this.onChanged();
            } else {
                this.volumeMountsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addVolumeMounts(int index, VolumeMount value) {
            if (this.volumeMountsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVolumeMountsIsMutable();
                this.volumeMounts_.add(index, value);
                this.onChanged();
            } else {
                this.volumeMountsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addVolumeMounts(VolumeMount.Builder builderForValue) {
            if (this.volumeMountsBuilder_ == null) {
                this.ensureVolumeMountsIsMutable();
                this.volumeMounts_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.volumeMountsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addVolumeMounts(int index, VolumeMount.Builder builderForValue) {
            if (this.volumeMountsBuilder_ == null) {
                this.ensureVolumeMountsIsMutable();
                this.volumeMounts_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.volumeMountsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllVolumeMounts(Iterable<? extends VolumeMount> values) {
            if (this.volumeMountsBuilder_ == null) {
                this.ensureVolumeMountsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.volumeMounts_);
                this.onChanged();
            } else {
                this.volumeMountsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearVolumeMounts() {
            if (this.volumeMountsBuilder_ == null) {
                this.volumeMounts_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
            } else {
                this.volumeMountsBuilder_.clear();
            }
            return this;
        }

        public Builder removeVolumeMounts(int index) {
            if (this.volumeMountsBuilder_ == null) {
                this.ensureVolumeMountsIsMutable();
                this.volumeMounts_.remove(index);
                this.onChanged();
            } else {
                this.volumeMountsBuilder_.remove(index);
            }
            return this;
        }

        public VolumeMount.Builder getVolumeMountsBuilder(int index) {
            return (VolumeMount.Builder)this.getVolumeMountsFieldBuilder().getBuilder(index);
        }

        @Override
        public VolumeMountOrBuilder getVolumeMountsOrBuilder(int index) {
            if (this.volumeMountsBuilder_ == null) {
                return this.volumeMounts_.get(index);
            }
            return (VolumeMountOrBuilder)this.volumeMountsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VolumeMountOrBuilder> getVolumeMountsOrBuilderList() {
            if (this.volumeMountsBuilder_ != null) {
                return this.volumeMountsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.volumeMounts_);
        }

        public VolumeMount.Builder addVolumeMountsBuilder() {
            return (VolumeMount.Builder)this.getVolumeMountsFieldBuilder().addBuilder((AbstractMessage)VolumeMount.getDefaultInstance());
        }

        public VolumeMount.Builder addVolumeMountsBuilder(int index) {
            return (VolumeMount.Builder)this.getVolumeMountsFieldBuilder().addBuilder(index, (AbstractMessage)VolumeMount.getDefaultInstance());
        }

        public List<VolumeMount.Builder> getVolumeMountsBuilderList() {
            return this.getVolumeMountsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<VolumeMount, VolumeMount.Builder, VolumeMountOrBuilder> getVolumeMountsFieldBuilder() {
            if (this.volumeMountsBuilder_ == null) {
                this.volumeMountsBuilder_ = new RepeatedFieldBuilderV3(this.volumeMounts_, (this.bitField0_ & 0x10) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.volumeMounts_ = null;
            }
            return this.volumeMountsBuilder_;
        }

        @Override
        public String getWorkingDir() {
            Object ref = this.workingDir_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.workingDir_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getWorkingDirBytes() {
            Object ref = this.workingDir_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.workingDir_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setWorkingDir(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.workingDir_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearWorkingDir() {
            this.workingDir_ = Container.getDefaultInstance().getWorkingDir();
            this.onChanged();
            return this;
        }

        public Builder setWorkingDirBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Container.checkByteStringIsUtf8((ByteString)value);
            this.workingDir_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLivenessProbe() {
            return this.livenessProbeBuilder_ != null || this.livenessProbe_ != null;
        }

        @Override
        public Probe getLivenessProbe() {
            if (this.livenessProbeBuilder_ == null) {
                return this.livenessProbe_ == null ? Probe.getDefaultInstance() : this.livenessProbe_;
            }
            return (Probe)this.livenessProbeBuilder_.getMessage();
        }

        public Builder setLivenessProbe(Probe value) {
            if (this.livenessProbeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.livenessProbe_ = value;
                this.onChanged();
            } else {
                this.livenessProbeBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setLivenessProbe(Probe.Builder builderForValue) {
            if (this.livenessProbeBuilder_ == null) {
                this.livenessProbe_ = builderForValue.build();
                this.onChanged();
            } else {
                this.livenessProbeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeLivenessProbe(Probe value) {
            if (this.livenessProbeBuilder_ == null) {
                this.livenessProbe_ = this.livenessProbe_ != null ? Probe.newBuilder(this.livenessProbe_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.livenessProbeBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearLivenessProbe() {
            if (this.livenessProbeBuilder_ == null) {
                this.livenessProbe_ = null;
                this.onChanged();
            } else {
                this.livenessProbe_ = null;
                this.livenessProbeBuilder_ = null;
            }
            return this;
        }

        public Probe.Builder getLivenessProbeBuilder() {
            this.onChanged();
            return (Probe.Builder)this.getLivenessProbeFieldBuilder().getBuilder();
        }

        @Override
        public ProbeOrBuilder getLivenessProbeOrBuilder() {
            if (this.livenessProbeBuilder_ != null) {
                return (ProbeOrBuilder)this.livenessProbeBuilder_.getMessageOrBuilder();
            }
            return this.livenessProbe_ == null ? Probe.getDefaultInstance() : this.livenessProbe_;
        }

        private SingleFieldBuilderV3<Probe, Probe.Builder, ProbeOrBuilder> getLivenessProbeFieldBuilder() {
            if (this.livenessProbeBuilder_ == null) {
                this.livenessProbeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLivenessProbe(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.livenessProbe_ = null;
            }
            return this.livenessProbeBuilder_;
        }

        @Override
        public boolean hasStartupProbe() {
            return this.startupProbeBuilder_ != null || this.startupProbe_ != null;
        }

        @Override
        public Probe getStartupProbe() {
            if (this.startupProbeBuilder_ == null) {
                return this.startupProbe_ == null ? Probe.getDefaultInstance() : this.startupProbe_;
            }
            return (Probe)this.startupProbeBuilder_.getMessage();
        }

        public Builder setStartupProbe(Probe value) {
            if (this.startupProbeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.startupProbe_ = value;
                this.onChanged();
            } else {
                this.startupProbeBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setStartupProbe(Probe.Builder builderForValue) {
            if (this.startupProbeBuilder_ == null) {
                this.startupProbe_ = builderForValue.build();
                this.onChanged();
            } else {
                this.startupProbeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeStartupProbe(Probe value) {
            if (this.startupProbeBuilder_ == null) {
                this.startupProbe_ = this.startupProbe_ != null ? Probe.newBuilder(this.startupProbe_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.startupProbeBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearStartupProbe() {
            if (this.startupProbeBuilder_ == null) {
                this.startupProbe_ = null;
                this.onChanged();
            } else {
                this.startupProbe_ = null;
                this.startupProbeBuilder_ = null;
            }
            return this;
        }

        public Probe.Builder getStartupProbeBuilder() {
            this.onChanged();
            return (Probe.Builder)this.getStartupProbeFieldBuilder().getBuilder();
        }

        @Override
        public ProbeOrBuilder getStartupProbeOrBuilder() {
            if (this.startupProbeBuilder_ != null) {
                return (ProbeOrBuilder)this.startupProbeBuilder_.getMessageOrBuilder();
            }
            return this.startupProbe_ == null ? Probe.getDefaultInstance() : this.startupProbe_;
        }

        private SingleFieldBuilderV3<Probe, Probe.Builder, ProbeOrBuilder> getStartupProbeFieldBuilder() {
            if (this.startupProbeBuilder_ == null) {
                this.startupProbeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStartupProbe(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.startupProbe_ = null;
            }
            return this.startupProbeBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

