/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RevisionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE_REVISION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/services/{service}/revisions/{revision}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String service;
    private final String revision;

    @Deprecated
    protected RevisionName() {
        this.project = null;
        this.location = null;
        this.service = null;
        this.revision = null;
    }

    private RevisionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.service = (String)Preconditions.checkNotNull((Object)builder.getService());
        this.revision = (String)Preconditions.checkNotNull((Object)builder.getRevision());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getService() {
        return this.service;
    }

    public String getRevision() {
        return this.revision;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RevisionName of(String project, String location, String service, String revision) {
        return RevisionName.newBuilder().setProject(project).setLocation(location).setService(service).setRevision(revision).build();
    }

    public static String format(String project, String location, String service, String revision) {
        return RevisionName.newBuilder().setProject(project).setLocation(location).setService(service).setRevision(revision).build().toString();
    }

    public static RevisionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SERVICE_REVISION.validatedMatch(formattedString, "RevisionName.parse: formattedString not in valid format");
        return RevisionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service"), (String)matchMap.get("revision"));
    }

    public static List<RevisionName> parseList(List<String> formattedStrings) {
        ArrayList<RevisionName> list = new ArrayList<RevisionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RevisionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RevisionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RevisionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE_REVISION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RevisionName revisionName = this;
            synchronized (revisionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.service != null) {
                        fieldMapBuilder.put((Object)"service", (Object)this.service);
                    }
                    if (this.revision != null) {
                        fieldMapBuilder.put((Object)"revision", (Object)this.revision);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SERVICE_REVISION.instantiate(new String[]{"project", this.project, "location", this.location, "service", this.service, "revision", this.revision});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RevisionName that = (RevisionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.service, that.service) && Objects.equals(this.revision, that.revision);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.service);
        h *= 1000003;
        return h ^= Objects.hashCode(this.revision);
    }

    public static class Builder {
        private String project;
        private String location;
        private String service;
        private String revision;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getService() {
            return this.service;
        }

        public String getRevision() {
            return this.revision;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setRevision(String revision) {
            this.revision = revision;
            return this;
        }

        private Builder(RevisionName revisionName) {
            this.project = revisionName.project;
            this.location = revisionName.location;
            this.service = revisionName.service;
            this.revision = revisionName.revision;
        }

        public RevisionName build() {
            return new RevisionName(this);
        }
    }
}

