/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2;

import com.google.cloud.run.v2.Container;
import com.google.cloud.run.v2.ContainerOrBuilder;
import com.google.cloud.run.v2.ExecutionEnvironment;
import com.google.cloud.run.v2.TaskTemplateOrBuilder;
import com.google.cloud.run.v2.TaskTemplateProto;
import com.google.cloud.run.v2.Volume;
import com.google.cloud.run.v2.VolumeOrBuilder;
import com.google.cloud.run.v2.VpcAccess;
import com.google.cloud.run.v2.VpcAccessOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TaskTemplate
extends GeneratedMessageV3
implements TaskTemplateOrBuilder {
    private static final long serialVersionUID = 0L;
    private int retriesCase_ = 0;
    private Object retries_;
    public static final int CONTAINERS_FIELD_NUMBER = 1;
    private List<Container> containers_;
    public static final int VOLUMES_FIELD_NUMBER = 2;
    private List<Volume> volumes_;
    public static final int MAX_RETRIES_FIELD_NUMBER = 3;
    public static final int TIMEOUT_FIELD_NUMBER = 4;
    private Duration timeout_;
    public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 5;
    private volatile Object serviceAccount_ = "";
    public static final int EXECUTION_ENVIRONMENT_FIELD_NUMBER = 6;
    private int executionEnvironment_ = 0;
    public static final int ENCRYPTION_KEY_FIELD_NUMBER = 7;
    private volatile Object encryptionKey_ = "";
    public static final int VPC_ACCESS_FIELD_NUMBER = 8;
    private VpcAccess vpcAccess_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final TaskTemplate DEFAULT_INSTANCE = new TaskTemplate();
    private static final Parser<TaskTemplate> PARSER = new AbstractParser<TaskTemplate>(){

        public TaskTemplate parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = TaskTemplate.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private TaskTemplate(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private TaskTemplate() {
        this.containers_ = Collections.emptyList();
        this.volumes_ = Collections.emptyList();
        this.serviceAccount_ = "";
        this.executionEnvironment_ = 0;
        this.encryptionKey_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new TaskTemplate();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return TaskTemplateProto.internal_static_google_cloud_run_v2_TaskTemplate_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return TaskTemplateProto.internal_static_google_cloud_run_v2_TaskTemplate_fieldAccessorTable.ensureFieldAccessorsInitialized(TaskTemplate.class, Builder.class);
    }

    @Override
    public RetriesCase getRetriesCase() {
        return RetriesCase.forNumber(this.retriesCase_);
    }

    @Override
    public List<Container> getContainersList() {
        return this.containers_;
    }

    @Override
    public List<? extends ContainerOrBuilder> getContainersOrBuilderList() {
        return this.containers_;
    }

    @Override
    public int getContainersCount() {
        return this.containers_.size();
    }

    @Override
    public Container getContainers(int index) {
        return this.containers_.get(index);
    }

    @Override
    public ContainerOrBuilder getContainersOrBuilder(int index) {
        return this.containers_.get(index);
    }

    @Override
    public List<Volume> getVolumesList() {
        return this.volumes_;
    }

    @Override
    public List<? extends VolumeOrBuilder> getVolumesOrBuilderList() {
        return this.volumes_;
    }

    @Override
    public int getVolumesCount() {
        return this.volumes_.size();
    }

    @Override
    public Volume getVolumes(int index) {
        return this.volumes_.get(index);
    }

    @Override
    public VolumeOrBuilder getVolumesOrBuilder(int index) {
        return this.volumes_.get(index);
    }

    @Override
    public boolean hasMaxRetries() {
        return this.retriesCase_ == 3;
    }

    @Override
    public int getMaxRetries() {
        if (this.retriesCase_ == 3) {
            return (Integer)this.retries_;
        }
        return 0;
    }

    @Override
    public boolean hasTimeout() {
        return this.timeout_ != null;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
    }

    @Override
    public DurationOrBuilder getTimeoutOrBuilder() {
        return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
    }

    @Override
    public String getServiceAccount() {
        Object ref = this.serviceAccount_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.serviceAccount_ = s;
        return s;
    }

    @Override
    public ByteString getServiceAccountBytes() {
        Object ref = this.serviceAccount_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.serviceAccount_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getExecutionEnvironmentValue() {
        return this.executionEnvironment_;
    }

    @Override
    public ExecutionEnvironment getExecutionEnvironment() {
        ExecutionEnvironment result = ExecutionEnvironment.forNumber(this.executionEnvironment_);
        return result == null ? ExecutionEnvironment.UNRECOGNIZED : result;
    }

    @Override
    public String getEncryptionKey() {
        Object ref = this.encryptionKey_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.encryptionKey_ = s;
        return s;
    }

    @Override
    public ByteString getEncryptionKeyBytes() {
        Object ref = this.encryptionKey_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.encryptionKey_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasVpcAccess() {
        return this.vpcAccess_ != null;
    }

    @Override
    public VpcAccess getVpcAccess() {
        return this.vpcAccess_ == null ? VpcAccess.getDefaultInstance() : this.vpcAccess_;
    }

    @Override
    public VpcAccessOrBuilder getVpcAccessOrBuilder() {
        return this.vpcAccess_ == null ? VpcAccess.getDefaultInstance() : this.vpcAccess_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        for (i = 0; i < this.containers_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.containers_.get(i));
        }
        for (i = 0; i < this.volumes_.size(); ++i) {
            output.writeMessage(2, (MessageLite)this.volumes_.get(i));
        }
        if (this.retriesCase_ == 3) {
            output.writeInt32(3, ((Integer)this.retries_).intValue());
        }
        if (this.timeout_ != null) {
            output.writeMessage(4, (MessageLite)this.getTimeout());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceAccount_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.serviceAccount_);
        }
        if (this.executionEnvironment_ != ExecutionEnvironment.EXECUTION_ENVIRONMENT_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.executionEnvironment_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.encryptionKey_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.encryptionKey_);
        }
        if (this.vpcAccess_ != null) {
            output.writeMessage(8, (MessageLite)this.getVpcAccess());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (i = 0; i < this.containers_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.containers_.get(i)));
        }
        for (i = 0; i < this.volumes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.volumes_.get(i)));
        }
        if (this.retriesCase_ == 3) {
            size += CodedOutputStream.computeInt32Size((int)3, (int)((Integer)this.retries_));
        }
        if (this.timeout_ != null) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getTimeout());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceAccount_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.serviceAccount_);
        }
        if (this.executionEnvironment_ != ExecutionEnvironment.EXECUTION_ENVIRONMENT_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.executionEnvironment_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.encryptionKey_)) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.encryptionKey_);
        }
        if (this.vpcAccess_ != null) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getVpcAccess());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaskTemplate)) {
            return super.equals(obj);
        }
        TaskTemplate other = (TaskTemplate)obj;
        if (!this.getContainersList().equals(other.getContainersList())) {
            return false;
        }
        if (!this.getVolumesList().equals(other.getVolumesList())) {
            return false;
        }
        if (this.hasTimeout() != other.hasTimeout()) {
            return false;
        }
        if (this.hasTimeout() && !this.getTimeout().equals((Object)other.getTimeout())) {
            return false;
        }
        if (!this.getServiceAccount().equals(other.getServiceAccount())) {
            return false;
        }
        if (this.executionEnvironment_ != other.executionEnvironment_) {
            return false;
        }
        if (!this.getEncryptionKey().equals(other.getEncryptionKey())) {
            return false;
        }
        if (this.hasVpcAccess() != other.hasVpcAccess()) {
            return false;
        }
        if (this.hasVpcAccess() && !this.getVpcAccess().equals(other.getVpcAccess())) {
            return false;
        }
        if (!this.getRetriesCase().equals((Object)other.getRetriesCase())) {
            return false;
        }
        switch (this.retriesCase_) {
            case 3: {
                if (this.getMaxRetries() == other.getMaxRetries()) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + TaskTemplate.getDescriptor().hashCode();
        if (this.getContainersCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getContainersList().hashCode();
        }
        if (this.getVolumesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getVolumesList().hashCode();
        }
        if (this.hasTimeout()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getTimeout().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getServiceAccount().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.executionEnvironment_;
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getEncryptionKey().hashCode();
        if (this.hasVpcAccess()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getVpcAccess().hashCode();
        }
        switch (this.retriesCase_) {
            case 3: {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getMaxRetries();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static TaskTemplate parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (TaskTemplate)PARSER.parseFrom(data);
    }

    public static TaskTemplate parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TaskTemplate)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TaskTemplate parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (TaskTemplate)PARSER.parseFrom(data);
    }

    public static TaskTemplate parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TaskTemplate)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TaskTemplate parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (TaskTemplate)PARSER.parseFrom(data);
    }

    public static TaskTemplate parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TaskTemplate)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TaskTemplate parseFrom(InputStream input) throws IOException {
        return (TaskTemplate)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static TaskTemplate parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TaskTemplate)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TaskTemplate parseDelimitedFrom(InputStream input) throws IOException {
        return (TaskTemplate)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static TaskTemplate parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TaskTemplate)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TaskTemplate parseFrom(CodedInputStream input) throws IOException {
        return (TaskTemplate)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static TaskTemplate parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TaskTemplate)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return TaskTemplate.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TaskTemplate prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static TaskTemplate getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<TaskTemplate> parser() {
        return PARSER;
    }

    public Parser<TaskTemplate> getParserForType() {
        return PARSER;
    }

    public TaskTemplate getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements TaskTemplateOrBuilder {
        private int retriesCase_ = 0;
        private Object retries_;
        private int bitField0_;
        private List<Container> containers_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Container, Container.Builder, ContainerOrBuilder> containersBuilder_;
        private List<Volume> volumes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Volume, Volume.Builder, VolumeOrBuilder> volumesBuilder_;
        private Duration timeout_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> timeoutBuilder_;
        private Object serviceAccount_ = "";
        private int executionEnvironment_ = 0;
        private Object encryptionKey_ = "";
        private VpcAccess vpcAccess_;
        private SingleFieldBuilderV3<VpcAccess, VpcAccess.Builder, VpcAccessOrBuilder> vpcAccessBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return TaskTemplateProto.internal_static_google_cloud_run_v2_TaskTemplate_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return TaskTemplateProto.internal_static_google_cloud_run_v2_TaskTemplate_fieldAccessorTable.ensureFieldAccessorsInitialized(TaskTemplate.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.containersBuilder_ == null) {
                this.containers_ = Collections.emptyList();
            } else {
                this.containers_ = null;
                this.containersBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.volumesBuilder_ == null) {
                this.volumes_ = Collections.emptyList();
            } else {
                this.volumes_ = null;
                this.volumesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.timeout_ = null;
            if (this.timeoutBuilder_ != null) {
                this.timeoutBuilder_.dispose();
                this.timeoutBuilder_ = null;
            }
            this.serviceAccount_ = "";
            this.executionEnvironment_ = 0;
            this.encryptionKey_ = "";
            this.vpcAccess_ = null;
            if (this.vpcAccessBuilder_ != null) {
                this.vpcAccessBuilder_.dispose();
                this.vpcAccessBuilder_ = null;
            }
            this.retriesCase_ = 0;
            this.retries_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return TaskTemplateProto.internal_static_google_cloud_run_v2_TaskTemplate_descriptor;
        }

        public TaskTemplate getDefaultInstanceForType() {
            return TaskTemplate.getDefaultInstance();
        }

        public TaskTemplate build() {
            TaskTemplate result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public TaskTemplate buildPartial() {
            TaskTemplate result = new TaskTemplate(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(TaskTemplate result) {
            if (this.containersBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.containers_ = Collections.unmodifiableList(this.containers_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.containers_ = this.containers_;
            } else {
                result.containers_ = this.containersBuilder_.build();
            }
            if (this.volumesBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.volumes_ = Collections.unmodifiableList(this.volumes_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.volumes_ = this.volumes_;
            } else {
                result.volumes_ = this.volumesBuilder_.build();
            }
        }

        private void buildPartial0(TaskTemplate result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 8) != 0) {
                result.timeout_ = this.timeoutBuilder_ == null ? this.timeout_ : (Duration)this.timeoutBuilder_.build();
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.serviceAccount_ = this.serviceAccount_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.executionEnvironment_ = this.executionEnvironment_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.encryptionKey_ = this.encryptionKey_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.vpcAccess_ = this.vpcAccessBuilder_ == null ? this.vpcAccess_ : (VpcAccess)this.vpcAccessBuilder_.build();
            }
        }

        private void buildPartialOneofs(TaskTemplate result) {
            result.retriesCase_ = this.retriesCase_;
            result.retries_ = this.retries_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof TaskTemplate) {
                return this.mergeFrom((TaskTemplate)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(TaskTemplate other) {
            if (other == TaskTemplate.getDefaultInstance()) {
                return this;
            }
            if (this.containersBuilder_ == null) {
                if (!other.containers_.isEmpty()) {
                    if (this.containers_.isEmpty()) {
                        this.containers_ = other.containers_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureContainersIsMutable();
                        this.containers_.addAll(other.containers_);
                    }
                    this.onChanged();
                }
            } else if (!other.containers_.isEmpty()) {
                if (this.containersBuilder_.isEmpty()) {
                    this.containersBuilder_.dispose();
                    this.containersBuilder_ = null;
                    this.containers_ = other.containers_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.containersBuilder_ = alwaysUseFieldBuilders ? this.getContainersFieldBuilder() : null;
                } else {
                    this.containersBuilder_.addAllMessages((Iterable)other.containers_);
                }
            }
            if (this.volumesBuilder_ == null) {
                if (!other.volumes_.isEmpty()) {
                    if (this.volumes_.isEmpty()) {
                        this.volumes_ = other.volumes_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureVolumesIsMutable();
                        this.volumes_.addAll(other.volumes_);
                    }
                    this.onChanged();
                }
            } else if (!other.volumes_.isEmpty()) {
                if (this.volumesBuilder_.isEmpty()) {
                    this.volumesBuilder_.dispose();
                    this.volumesBuilder_ = null;
                    this.volumes_ = other.volumes_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.volumesBuilder_ = alwaysUseFieldBuilders ? this.getVolumesFieldBuilder() : null;
                } else {
                    this.volumesBuilder_.addAllMessages((Iterable)other.volumes_);
                }
            }
            if (other.hasTimeout()) {
                this.mergeTimeout(other.getTimeout());
            }
            if (!other.getServiceAccount().isEmpty()) {
                this.serviceAccount_ = other.serviceAccount_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.executionEnvironment_ != 0) {
                this.setExecutionEnvironmentValue(other.getExecutionEnvironmentValue());
            }
            if (!other.getEncryptionKey().isEmpty()) {
                this.encryptionKey_ = other.encryptionKey_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (other.hasVpcAccess()) {
                this.mergeVpcAccess(other.getVpcAccess());
            }
            switch (other.getRetriesCase()) {
                case MAX_RETRIES: {
                    this.setMaxRetries(other.getMaxRetries());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block16: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block16;
                        }
                        case 10: {
                            GeneratedMessageV3 m = (Container)input.readMessage(Container.parser(), extensionRegistry);
                            if (this.containersBuilder_ == null) {
                                this.ensureContainersIsMutable();
                                this.containers_.add((Container)m);
                                continue block16;
                            }
                            this.containersBuilder_.addMessage((AbstractMessage)m);
                            continue block16;
                        }
                        case 18: {
                            GeneratedMessageV3 m = (Volume)input.readMessage(Volume.parser(), extensionRegistry);
                            if (this.volumesBuilder_ == null) {
                                this.ensureVolumesIsMutable();
                                this.volumes_.add((Volume)m);
                                continue block16;
                            }
                            this.volumesBuilder_.addMessage((AbstractMessage)m);
                            continue block16;
                        }
                        case 24: {
                            this.retries_ = input.readInt32();
                            this.retriesCase_ = 3;
                            continue block16;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block16;
                        }
                        case 42: {
                            this.serviceAccount_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block16;
                        }
                        case 48: {
                            this.executionEnvironment_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block16;
                        }
                        case 58: {
                            this.encryptionKey_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block16;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getVpcAccessFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block16;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public RetriesCase getRetriesCase() {
            return RetriesCase.forNumber(this.retriesCase_);
        }

        public Builder clearRetries() {
            this.retriesCase_ = 0;
            this.retries_ = null;
            this.onChanged();
            return this;
        }

        private void ensureContainersIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.containers_ = new ArrayList<Container>(this.containers_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<Container> getContainersList() {
            if (this.containersBuilder_ == null) {
                return Collections.unmodifiableList(this.containers_);
            }
            return this.containersBuilder_.getMessageList();
        }

        @Override
        public int getContainersCount() {
            if (this.containersBuilder_ == null) {
                return this.containers_.size();
            }
            return this.containersBuilder_.getCount();
        }

        @Override
        public Container getContainers(int index) {
            if (this.containersBuilder_ == null) {
                return this.containers_.get(index);
            }
            return (Container)this.containersBuilder_.getMessage(index);
        }

        public Builder setContainers(int index, Container value) {
            if (this.containersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureContainersIsMutable();
                this.containers_.set(index, value);
                this.onChanged();
            } else {
                this.containersBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setContainers(int index, Container.Builder builderForValue) {
            if (this.containersBuilder_ == null) {
                this.ensureContainersIsMutable();
                this.containers_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.containersBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addContainers(Container value) {
            if (this.containersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureContainersIsMutable();
                this.containers_.add(value);
                this.onChanged();
            } else {
                this.containersBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addContainers(int index, Container value) {
            if (this.containersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureContainersIsMutable();
                this.containers_.add(index, value);
                this.onChanged();
            } else {
                this.containersBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addContainers(Container.Builder builderForValue) {
            if (this.containersBuilder_ == null) {
                this.ensureContainersIsMutable();
                this.containers_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.containersBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addContainers(int index, Container.Builder builderForValue) {
            if (this.containersBuilder_ == null) {
                this.ensureContainersIsMutable();
                this.containers_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.containersBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllContainers(Iterable<? extends Container> values) {
            if (this.containersBuilder_ == null) {
                this.ensureContainersIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.containers_);
                this.onChanged();
            } else {
                this.containersBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearContainers() {
            if (this.containersBuilder_ == null) {
                this.containers_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.containersBuilder_.clear();
            }
            return this;
        }

        public Builder removeContainers(int index) {
            if (this.containersBuilder_ == null) {
                this.ensureContainersIsMutable();
                this.containers_.remove(index);
                this.onChanged();
            } else {
                this.containersBuilder_.remove(index);
            }
            return this;
        }

        public Container.Builder getContainersBuilder(int index) {
            return (Container.Builder)this.getContainersFieldBuilder().getBuilder(index);
        }

        @Override
        public ContainerOrBuilder getContainersOrBuilder(int index) {
            if (this.containersBuilder_ == null) {
                return this.containers_.get(index);
            }
            return (ContainerOrBuilder)this.containersBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ContainerOrBuilder> getContainersOrBuilderList() {
            if (this.containersBuilder_ != null) {
                return this.containersBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.containers_);
        }

        public Container.Builder addContainersBuilder() {
            return (Container.Builder)this.getContainersFieldBuilder().addBuilder((AbstractMessage)Container.getDefaultInstance());
        }

        public Container.Builder addContainersBuilder(int index) {
            return (Container.Builder)this.getContainersFieldBuilder().addBuilder(index, (AbstractMessage)Container.getDefaultInstance());
        }

        public List<Container.Builder> getContainersBuilderList() {
            return this.getContainersFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Container, Container.Builder, ContainerOrBuilder> getContainersFieldBuilder() {
            if (this.containersBuilder_ == null) {
                this.containersBuilder_ = new RepeatedFieldBuilderV3(this.containers_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.containers_ = null;
            }
            return this.containersBuilder_;
        }

        private void ensureVolumesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.volumes_ = new ArrayList<Volume>(this.volumes_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Volume> getVolumesList() {
            if (this.volumesBuilder_ == null) {
                return Collections.unmodifiableList(this.volumes_);
            }
            return this.volumesBuilder_.getMessageList();
        }

        @Override
        public int getVolumesCount() {
            if (this.volumesBuilder_ == null) {
                return this.volumes_.size();
            }
            return this.volumesBuilder_.getCount();
        }

        @Override
        public Volume getVolumes(int index) {
            if (this.volumesBuilder_ == null) {
                return this.volumes_.get(index);
            }
            return (Volume)this.volumesBuilder_.getMessage(index);
        }

        public Builder setVolumes(int index, Volume value) {
            if (this.volumesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVolumesIsMutable();
                this.volumes_.set(index, value);
                this.onChanged();
            } else {
                this.volumesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setVolumes(int index, Volume.Builder builderForValue) {
            if (this.volumesBuilder_ == null) {
                this.ensureVolumesIsMutable();
                this.volumes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.volumesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addVolumes(Volume value) {
            if (this.volumesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVolumesIsMutable();
                this.volumes_.add(value);
                this.onChanged();
            } else {
                this.volumesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addVolumes(int index, Volume value) {
            if (this.volumesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureVolumesIsMutable();
                this.volumes_.add(index, value);
                this.onChanged();
            } else {
                this.volumesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addVolumes(Volume.Builder builderForValue) {
            if (this.volumesBuilder_ == null) {
                this.ensureVolumesIsMutable();
                this.volumes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.volumesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addVolumes(int index, Volume.Builder builderForValue) {
            if (this.volumesBuilder_ == null) {
                this.ensureVolumesIsMutable();
                this.volumes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.volumesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllVolumes(Iterable<? extends Volume> values) {
            if (this.volumesBuilder_ == null) {
                this.ensureVolumesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.volumes_);
                this.onChanged();
            } else {
                this.volumesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearVolumes() {
            if (this.volumesBuilder_ == null) {
                this.volumes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.volumesBuilder_.clear();
            }
            return this;
        }

        public Builder removeVolumes(int index) {
            if (this.volumesBuilder_ == null) {
                this.ensureVolumesIsMutable();
                this.volumes_.remove(index);
                this.onChanged();
            } else {
                this.volumesBuilder_.remove(index);
            }
            return this;
        }

        public Volume.Builder getVolumesBuilder(int index) {
            return (Volume.Builder)this.getVolumesFieldBuilder().getBuilder(index);
        }

        @Override
        public VolumeOrBuilder getVolumesOrBuilder(int index) {
            if (this.volumesBuilder_ == null) {
                return this.volumes_.get(index);
            }
            return (VolumeOrBuilder)this.volumesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends VolumeOrBuilder> getVolumesOrBuilderList() {
            if (this.volumesBuilder_ != null) {
                return this.volumesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.volumes_);
        }

        public Volume.Builder addVolumesBuilder() {
            return (Volume.Builder)this.getVolumesFieldBuilder().addBuilder((AbstractMessage)Volume.getDefaultInstance());
        }

        public Volume.Builder addVolumesBuilder(int index) {
            return (Volume.Builder)this.getVolumesFieldBuilder().addBuilder(index, (AbstractMessage)Volume.getDefaultInstance());
        }

        public List<Volume.Builder> getVolumesBuilderList() {
            return this.getVolumesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Volume, Volume.Builder, VolumeOrBuilder> getVolumesFieldBuilder() {
            if (this.volumesBuilder_ == null) {
                this.volumesBuilder_ = new RepeatedFieldBuilderV3(this.volumes_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.volumes_ = null;
            }
            return this.volumesBuilder_;
        }

        @Override
        public boolean hasMaxRetries() {
            return this.retriesCase_ == 3;
        }

        @Override
        public int getMaxRetries() {
            if (this.retriesCase_ == 3) {
                return (Integer)this.retries_;
            }
            return 0;
        }

        public Builder setMaxRetries(int value) {
            this.retriesCase_ = 3;
            this.retries_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearMaxRetries() {
            if (this.retriesCase_ == 3) {
                this.retriesCase_ = 0;
                this.retries_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasTimeout() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Duration getTimeout() {
            if (this.timeoutBuilder_ == null) {
                return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
            }
            return (Duration)this.timeoutBuilder_.getMessage();
        }

        public Builder setTimeout(Duration value) {
            if (this.timeoutBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.timeout_ = value;
            } else {
                this.timeoutBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setTimeout(Duration.Builder builderForValue) {
            if (this.timeoutBuilder_ == null) {
                this.timeout_ = builderForValue.build();
            } else {
                this.timeoutBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeTimeout(Duration value) {
            if (this.timeoutBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.timeout_ != null && this.timeout_ != Duration.getDefaultInstance()) {
                    this.getTimeoutBuilder().mergeFrom(value);
                } else {
                    this.timeout_ = value;
                }
            } else {
                this.timeoutBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearTimeout() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.timeout_ = null;
            if (this.timeoutBuilder_ != null) {
                this.timeoutBuilder_.dispose();
                this.timeoutBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getTimeoutBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (Duration.Builder)this.getTimeoutFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getTimeoutOrBuilder() {
            if (this.timeoutBuilder_ != null) {
                return (DurationOrBuilder)this.timeoutBuilder_.getMessageOrBuilder();
            }
            return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getTimeoutFieldBuilder() {
            if (this.timeoutBuilder_ == null) {
                this.timeoutBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTimeout(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.timeout_ = null;
            }
            return this.timeoutBuilder_;
        }

        @Override
        public String getServiceAccount() {
            Object ref = this.serviceAccount_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.serviceAccount_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceAccountBytes() {
            Object ref = this.serviceAccount_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceAccount_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServiceAccount(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceAccount_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearServiceAccount() {
            this.serviceAccount_ = TaskTemplate.getDefaultInstance().getServiceAccount();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setServiceAccountBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TaskTemplate.checkByteStringIsUtf8((ByteString)value);
            this.serviceAccount_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public int getExecutionEnvironmentValue() {
            return this.executionEnvironment_;
        }

        public Builder setExecutionEnvironmentValue(int value) {
            this.executionEnvironment_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public ExecutionEnvironment getExecutionEnvironment() {
            ExecutionEnvironment result = ExecutionEnvironment.forNumber(this.executionEnvironment_);
            return result == null ? ExecutionEnvironment.UNRECOGNIZED : result;
        }

        public Builder setExecutionEnvironment(ExecutionEnvironment value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.executionEnvironment_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearExecutionEnvironment() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.executionEnvironment_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getEncryptionKey() {
            Object ref = this.encryptionKey_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.encryptionKey_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEncryptionKeyBytes() {
            Object ref = this.encryptionKey_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.encryptionKey_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEncryptionKey(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.encryptionKey_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearEncryptionKey() {
            this.encryptionKey_ = TaskTemplate.getDefaultInstance().getEncryptionKey();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setEncryptionKeyBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TaskTemplate.checkByteStringIsUtf8((ByteString)value);
            this.encryptionKey_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasVpcAccess() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public VpcAccess getVpcAccess() {
            if (this.vpcAccessBuilder_ == null) {
                return this.vpcAccess_ == null ? VpcAccess.getDefaultInstance() : this.vpcAccess_;
            }
            return (VpcAccess)this.vpcAccessBuilder_.getMessage();
        }

        public Builder setVpcAccess(VpcAccess value) {
            if (this.vpcAccessBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.vpcAccess_ = value;
            } else {
                this.vpcAccessBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setVpcAccess(VpcAccess.Builder builderForValue) {
            if (this.vpcAccessBuilder_ == null) {
                this.vpcAccess_ = builderForValue.build();
            } else {
                this.vpcAccessBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeVpcAccess(VpcAccess value) {
            if (this.vpcAccessBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.vpcAccess_ != null && this.vpcAccess_ != VpcAccess.getDefaultInstance()) {
                    this.getVpcAccessBuilder().mergeFrom(value);
                } else {
                    this.vpcAccess_ = value;
                }
            } else {
                this.vpcAccessBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearVpcAccess() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.vpcAccess_ = null;
            if (this.vpcAccessBuilder_ != null) {
                this.vpcAccessBuilder_.dispose();
                this.vpcAccessBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public VpcAccess.Builder getVpcAccessBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (VpcAccess.Builder)this.getVpcAccessFieldBuilder().getBuilder();
        }

        @Override
        public VpcAccessOrBuilder getVpcAccessOrBuilder() {
            if (this.vpcAccessBuilder_ != null) {
                return (VpcAccessOrBuilder)this.vpcAccessBuilder_.getMessageOrBuilder();
            }
            return this.vpcAccess_ == null ? VpcAccess.getDefaultInstance() : this.vpcAccess_;
        }

        private SingleFieldBuilderV3<VpcAccess, VpcAccess.Builder, VpcAccessOrBuilder> getVpcAccessFieldBuilder() {
            if (this.vpcAccessBuilder_ == null) {
                this.vpcAccessBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getVpcAccess(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.vpcAccess_ = null;
            }
            return this.vpcAccessBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum RetriesCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        MAX_RETRIES(3),
        RETRIES_NOT_SET(0);

        private final int value;

        private RetriesCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static RetriesCase valueOf(int value) {
            return RetriesCase.forNumber(value);
        }

        public static RetriesCase forNumber(int value) {
            switch (value) {
                case 3: {
                    return MAX_RETRIES;
                }
                case 0: {
                    return RETRIES_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }
}

