/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.cloud.retail.v2alpha.ProjectOrBuilder;
import com.google.cloud.retail.v2alpha.ProjectProto;
import com.google.cloud.retail.v2alpha.SolutionType;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Project
extends GeneratedMessageV3
implements ProjectOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int ENROLLED_SOLUTIONS_FIELD_NUMBER = 2;
    private List<Integer> enrolledSolutions_;
    private static final Internal.ListAdapter.Converter<Integer, SolutionType> enrolledSolutions_converter_ = new Internal.ListAdapter.Converter<Integer, SolutionType>(){

        public SolutionType convert(Integer from) {
            SolutionType result = SolutionType.forNumber(from);
            return result == null ? SolutionType.UNRECOGNIZED : result;
        }
    };
    private int enrolledSolutionsMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Project DEFAULT_INSTANCE = new Project();
    private static final Parser<Project> PARSER = new AbstractParser<Project>(){

        public Project parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Project.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Project(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Project() {
        this.name_ = "";
        this.enrolledSolutions_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Project();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ProjectProto.internal_static_google_cloud_retail_v2alpha_Project_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ProjectProto.internal_static_google_cloud_retail_v2alpha_Project_fieldAccessorTable.ensureFieldAccessorsInitialized(Project.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<SolutionType> getEnrolledSolutionsList() {
        return new Internal.ListAdapter(this.enrolledSolutions_, enrolledSolutions_converter_);
    }

    @Override
    public int getEnrolledSolutionsCount() {
        return this.enrolledSolutions_.size();
    }

    @Override
    public SolutionType getEnrolledSolutions(int index) {
        return (SolutionType)((Object)enrolledSolutions_converter_.convert((Object)this.enrolledSolutions_.get(index)));
    }

    @Override
    public List<Integer> getEnrolledSolutionsValueList() {
        return this.enrolledSolutions_;
    }

    @Override
    public int getEnrolledSolutionsValue(int index) {
        return this.enrolledSolutions_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (this.getEnrolledSolutionsList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.enrolledSolutionsMemoizedSerializedSize);
        }
        for (int i = 0; i < this.enrolledSolutions_.size(); ++i) {
            output.writeEnumNoTag(this.enrolledSolutions_.get(i).intValue());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.enrolledSolutions_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.enrolledSolutions_.get(i));
        }
        size += dataSize;
        if (!this.getEnrolledSolutionsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.enrolledSolutionsMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Project)) {
            return super.equals(obj);
        }
        Project other = (Project)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.enrolledSolutions_.equals(other.enrolledSolutions_)) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Project.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        if (this.getEnrolledSolutionsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.enrolledSolutions_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Project parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Project)PARSER.parseFrom(data);
    }

    public static Project parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Project)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Project parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Project)PARSER.parseFrom(data);
    }

    public static Project parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Project)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Project parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Project)PARSER.parseFrom(data);
    }

    public static Project parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Project)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Project parseFrom(InputStream input) throws IOException {
        return (Project)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Project parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Project)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Project parseDelimitedFrom(InputStream input) throws IOException {
        return (Project)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Project parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Project)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Project parseFrom(CodedInputStream input) throws IOException {
        return (Project)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Project parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Project)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Project.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Project prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Project getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Project> parser() {
        return PARSER;
    }

    public Parser<Project> getParserForType() {
        return PARSER;
    }

    public Project getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ProjectOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private List<Integer> enrolledSolutions_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return ProjectProto.internal_static_google_cloud_retail_v2alpha_Project_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ProjectProto.internal_static_google_cloud_retail_v2alpha_Project_fieldAccessorTable.ensureFieldAccessorsInitialized(Project.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.enrolledSolutions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ProjectProto.internal_static_google_cloud_retail_v2alpha_Project_descriptor;
        }

        public Project getDefaultInstanceForType() {
            return Project.getDefaultInstance();
        }

        public Project build() {
            Project result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Project buildPartial() {
            Project result = new Project(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Project result) {
            if ((this.bitField0_ & 2) != 0) {
                this.enrolledSolutions_ = Collections.unmodifiableList(this.enrolledSolutions_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.enrolledSolutions_ = this.enrolledSolutions_;
        }

        private void buildPartial0(Project result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Project) {
                return this.mergeFrom((Project)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Project other) {
            if (other == Project.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.enrolledSolutions_.isEmpty()) {
                if (this.enrolledSolutions_.isEmpty()) {
                    this.enrolledSolutions_ = other.enrolledSolutions_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureEnrolledSolutionsIsMutable();
                    this.enrolledSolutions_.addAll(other.enrolledSolutions_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block11;
                        }
                        case 16: {
                            int tmpRaw = input.readEnum();
                            this.ensureEnrolledSolutionsIsMutable();
                            this.enrolledSolutions_.add(tmpRaw);
                            continue block11;
                        }
                        case 18: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureEnrolledSolutionsIsMutable();
                                this.enrolledSolutions_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block11;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Project.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Project.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureEnrolledSolutionsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.enrolledSolutions_ = new ArrayList<Integer>(this.enrolledSolutions_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<SolutionType> getEnrolledSolutionsList() {
            return new Internal.ListAdapter(this.enrolledSolutions_, enrolledSolutions_converter_);
        }

        @Override
        public int getEnrolledSolutionsCount() {
            return this.enrolledSolutions_.size();
        }

        @Override
        public SolutionType getEnrolledSolutions(int index) {
            return (SolutionType)((Object)enrolledSolutions_converter_.convert((Object)this.enrolledSolutions_.get(index)));
        }

        public Builder setEnrolledSolutions(int index, SolutionType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureEnrolledSolutionsIsMutable();
            this.enrolledSolutions_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addEnrolledSolutions(SolutionType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureEnrolledSolutionsIsMutable();
            this.enrolledSolutions_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllEnrolledSolutions(Iterable<? extends SolutionType> values) {
            this.ensureEnrolledSolutionsIsMutable();
            for (SolutionType solutionType : values) {
                this.enrolledSolutions_.add(solutionType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearEnrolledSolutions() {
            this.enrolledSolutions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getEnrolledSolutionsValueList() {
            return Collections.unmodifiableList(this.enrolledSolutions_);
        }

        @Override
        public int getEnrolledSolutionsValue(int index) {
            return this.enrolledSolutions_.get(index);
        }

        public Builder setEnrolledSolutionsValue(int index, int value) {
            this.ensureEnrolledSolutionsIsMutable();
            this.enrolledSolutions_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addEnrolledSolutionsValue(int value) {
            this.ensureEnrolledSolutionsIsMutable();
            this.enrolledSolutions_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllEnrolledSolutionsValue(Iterable<Integer> values) {
            this.ensureEnrolledSolutionsIsMutable();
            for (int value : values) {
                this.enrolledSolutions_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

