/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BranchName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CATALOG_BRANCH = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/branches/{branch}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;
    private final String branch;

    @Deprecated
    protected BranchName() {
        this.project = null;
        this.location = null;
        this.catalog = null;
        this.branch = null;
    }

    private BranchName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.branch = (String)Preconditions.checkNotNull((Object)builder.getBranch());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getBranch() {
        return this.branch;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BranchName of(String project, String location, String catalog, String branch) {
        return BranchName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setBranch(branch).build();
    }

    public static String format(String project, String location, String catalog, String branch) {
        return BranchName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setBranch(branch).build().toString();
    }

    public static BranchName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CATALOG_BRANCH.validatedMatch(formattedString, "BranchName.parse: formattedString not in valid format");
        return BranchName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"), (String)matchMap.get("branch"));
    }

    public static List<BranchName> parseList(List<String> formattedStrings) {
        ArrayList<BranchName> list = new ArrayList<BranchName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BranchName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BranchName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BranchName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CATALOG_BRANCH.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BranchName branchName = this;
            synchronized (branchName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    if (this.branch != null) {
                        fieldMapBuilder.put((Object)"branch", (Object)this.branch);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CATALOG_BRANCH.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog, "branch", this.branch});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BranchName that = (BranchName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.branch, that.branch);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.catalog);
        h *= 1000003;
        return h ^= Objects.hashCode(this.branch);
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;
        private String branch;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getBranch() {
            return this.branch;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setBranch(String branch) {
            this.branch = branch;
            return this;
        }

        private Builder(BranchName branchName) {
            this.project = branchName.project;
            this.location = branchName.location;
            this.catalog = branchName.catalog;
            this.branch = branchName.branch;
        }

        public BranchName build() {
            return new BranchName(this);
        }
    }
}

