/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2;

import com.google.cloud.retail.v2.CustomAttribute;
import com.google.cloud.retail.v2.Image;
import com.google.cloud.retail.v2.ImageOrBuilder;
import com.google.cloud.retail.v2.PriceInfo;
import com.google.cloud.retail.v2.PriceInfoOrBuilder;
import com.google.cloud.retail.v2.ProductOrBuilder;
import com.google.cloud.retail.v2.ProductProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int32ValueOrBuilder;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Product
extends GeneratedMessageV3
implements ProductOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_;
    public static final int ID_FIELD_NUMBER = 2;
    private volatile Object id_;
    public static final int TYPE_FIELD_NUMBER = 3;
    private int type_;
    public static final int PRIMARY_PRODUCT_ID_FIELD_NUMBER = 4;
    private volatile Object primaryProductId_;
    public static final int CATEGORIES_FIELD_NUMBER = 7;
    private LazyStringList categories_;
    public static final int TITLE_FIELD_NUMBER = 8;
    private volatile Object title_;
    public static final int DESCRIPTION_FIELD_NUMBER = 10;
    private volatile Object description_;
    public static final int ATTRIBUTES_FIELD_NUMBER = 12;
    private MapField<String, CustomAttribute> attributes_;
    public static final int TAGS_FIELD_NUMBER = 13;
    private LazyStringList tags_;
    public static final int PRICE_INFO_FIELD_NUMBER = 14;
    private PriceInfo priceInfo_;
    public static final int AVAILABLE_TIME_FIELD_NUMBER = 18;
    private Timestamp availableTime_;
    public static final int AVAILABILITY_FIELD_NUMBER = 19;
    private int availability_;
    public static final int AVAILABLE_QUANTITY_FIELD_NUMBER = 20;
    private Int32Value availableQuantity_;
    public static final int URI_FIELD_NUMBER = 22;
    private volatile Object uri_;
    public static final int IMAGES_FIELD_NUMBER = 23;
    private List<Image> images_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Product DEFAULT_INSTANCE = new Product();
    private static final Parser<Product> PARSER = new AbstractParser<Product>(){

        public Product parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new Product(input, extensionRegistry);
        }
    };

    private Product(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Product() {
        this.name_ = "";
        this.id_ = "";
        this.type_ = 0;
        this.primaryProductId_ = "";
        this.categories_ = LazyStringArrayList.EMPTY;
        this.title_ = "";
        this.description_ = "";
        this.tags_ = LazyStringArrayList.EMPTY;
        this.availability_ = 0;
        this.uri_ = "";
        this.images_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Product();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private Product(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block24: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block24;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.name_ = s;
                        continue block24;
                    }
                    case 18: {
                        String s = input.readStringRequireUtf8();
                        this.id_ = s;
                        continue block24;
                    }
                    case 24: {
                        int rawValue;
                        this.type_ = rawValue = input.readEnum();
                        continue block24;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        this.primaryProductId_ = s;
                        continue block24;
                    }
                    case 58: {
                        String s = input.readStringRequireUtf8();
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.categories_ = new LazyStringArrayList();
                            mutable_bitField0_ |= 1;
                        }
                        this.categories_.add((Object)s);
                        continue block24;
                    }
                    case 66: {
                        String s = input.readStringRequireUtf8();
                        this.title_ = s;
                        continue block24;
                    }
                    case 82: {
                        String s = input.readStringRequireUtf8();
                        this.description_ = s;
                        continue block24;
                    }
                    case 98: {
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.attributes_ = MapField.newMapField(AttributesDefaultEntryHolder.defaultEntry);
                            mutable_bitField0_ |= 2;
                        }
                        MapEntry attributes__ = (MapEntry)input.readMessage(AttributesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                        this.attributes_.getMutableMap().put(attributes__.getKey(), attributes__.getValue());
                        continue block24;
                    }
                    case 106: {
                        String s = input.readStringRequireUtf8();
                        if ((mutable_bitField0_ & 4) == 0) {
                            this.tags_ = new LazyStringArrayList();
                            mutable_bitField0_ |= 4;
                        }
                        this.tags_.add((Object)s);
                        continue block24;
                    }
                    case 114: {
                        PriceInfo.Builder subBuilder = null;
                        if (this.priceInfo_ != null) {
                            subBuilder = this.priceInfo_.toBuilder();
                        }
                        this.priceInfo_ = (PriceInfo)input.readMessage(PriceInfo.parser(), extensionRegistry);
                        if (subBuilder == null) continue block24;
                        subBuilder.mergeFrom(this.priceInfo_);
                        this.priceInfo_ = subBuilder.buildPartial();
                        continue block24;
                    }
                    case 146: {
                        Timestamp.Builder subBuilder = null;
                        if (this.availableTime_ != null) {
                            subBuilder = this.availableTime_.toBuilder();
                        }
                        this.availableTime_ = (Timestamp)input.readMessage(Timestamp.parser(), extensionRegistry);
                        if (subBuilder == null) continue block24;
                        subBuilder.mergeFrom(this.availableTime_);
                        this.availableTime_ = subBuilder.buildPartial();
                        continue block24;
                    }
                    case 152: {
                        int rawValue;
                        this.availability_ = rawValue = input.readEnum();
                        continue block24;
                    }
                    case 162: {
                        Int32Value.Builder subBuilder = null;
                        if (this.availableQuantity_ != null) {
                            subBuilder = this.availableQuantity_.toBuilder();
                        }
                        this.availableQuantity_ = (Int32Value)input.readMessage(Int32Value.parser(), extensionRegistry);
                        if (subBuilder == null) continue block24;
                        subBuilder.mergeFrom(this.availableQuantity_);
                        this.availableQuantity_ = subBuilder.buildPartial();
                        continue block24;
                    }
                    case 178: {
                        String s = input.readStringRequireUtf8();
                        this.uri_ = s;
                        continue block24;
                    }
                    case 186: {
                        if ((mutable_bitField0_ & 8) == 0) {
                            this.images_ = new ArrayList<Image>();
                            mutable_bitField0_ |= 8;
                        }
                        this.images_.add((Image)input.readMessage(Image.parser(), extensionRegistry));
                        continue block24;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.categories_ = this.categories_.getUnmodifiableView();
            }
            if ((mutable_bitField0_ & 4) != 0) {
                this.tags_ = this.tags_.getUnmodifiableView();
            }
            if ((mutable_bitField0_ & 8) != 0) {
                this.images_ = Collections.unmodifiableList(this.images_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ProductProto.internal_static_google_cloud_retail_v2_Product_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 12: {
                return this.internalGetAttributes();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ProductProto.internal_static_google_cloud_retail_v2_Product_fieldAccessorTable.ensureFieldAccessorsInitialized(Product.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getId() {
        Object ref = this.id_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.id_ = s;
        return s;
    }

    @Override
    public ByteString getIdBytes() {
        Object ref = this.id_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.id_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public Type getType() {
        Type result = Type.valueOf(this.type_);
        return result == null ? Type.UNRECOGNIZED : result;
    }

    @Override
    public String getPrimaryProductId() {
        Object ref = this.primaryProductId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.primaryProductId_ = s;
        return s;
    }

    @Override
    public ByteString getPrimaryProductIdBytes() {
        Object ref = this.primaryProductId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.primaryProductId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getCategoriesList() {
        return this.categories_;
    }

    @Override
    public int getCategoriesCount() {
        return this.categories_.size();
    }

    @Override
    public String getCategories(int index) {
        return (String)this.categories_.get(index);
    }

    @Override
    public ByteString getCategoriesBytes(int index) {
        return this.categories_.getByteString(index);
    }

    @Override
    public String getTitle() {
        Object ref = this.title_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.title_ = s;
        return s;
    }

    @Override
    public ByteString getTitleBytes() {
        Object ref = this.title_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.title_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, CustomAttribute> internalGetAttributes() {
        if (this.attributes_ == null) {
            return MapField.emptyMapField(AttributesDefaultEntryHolder.defaultEntry);
        }
        return this.attributes_;
    }

    @Override
    public int getAttributesCount() {
        return this.internalGetAttributes().getMap().size();
    }

    @Override
    public boolean containsAttributes(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.internalGetAttributes().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, CustomAttribute> getAttributes() {
        return this.getAttributesMap();
    }

    @Override
    public Map<String, CustomAttribute> getAttributesMap() {
        return this.internalGetAttributes().getMap();
    }

    @Override
    public CustomAttribute getAttributesOrDefault(String key, CustomAttribute defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetAttributes().getMap();
        return map.containsKey(key) ? (CustomAttribute)map.get(key) : defaultValue;
    }

    @Override
    public CustomAttribute getAttributesOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetAttributes().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (CustomAttribute)map.get(key);
    }

    public ProtocolStringList getTagsList() {
        return this.tags_;
    }

    @Override
    public int getTagsCount() {
        return this.tags_.size();
    }

    @Override
    public String getTags(int index) {
        return (String)this.tags_.get(index);
    }

    @Override
    public ByteString getTagsBytes(int index) {
        return this.tags_.getByteString(index);
    }

    @Override
    public boolean hasPriceInfo() {
        return this.priceInfo_ != null;
    }

    @Override
    public PriceInfo getPriceInfo() {
        return this.priceInfo_ == null ? PriceInfo.getDefaultInstance() : this.priceInfo_;
    }

    @Override
    public PriceInfoOrBuilder getPriceInfoOrBuilder() {
        return this.getPriceInfo();
    }

    @Override
    public boolean hasAvailableTime() {
        return this.availableTime_ != null;
    }

    @Override
    public Timestamp getAvailableTime() {
        return this.availableTime_ == null ? Timestamp.getDefaultInstance() : this.availableTime_;
    }

    @Override
    public TimestampOrBuilder getAvailableTimeOrBuilder() {
        return this.getAvailableTime();
    }

    @Override
    public int getAvailabilityValue() {
        return this.availability_;
    }

    @Override
    public Availability getAvailability() {
        Availability result = Availability.valueOf(this.availability_);
        return result == null ? Availability.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasAvailableQuantity() {
        return this.availableQuantity_ != null;
    }

    @Override
    public Int32Value getAvailableQuantity() {
        return this.availableQuantity_ == null ? Int32Value.getDefaultInstance() : this.availableQuantity_;
    }

    @Override
    public Int32ValueOrBuilder getAvailableQuantityOrBuilder() {
        return this.getAvailableQuantity();
    }

    @Override
    public String getUri() {
        Object ref = this.uri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.uri_ = s;
        return s;
    }

    @Override
    public ByteString getUriBytes() {
        Object ref = this.uri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.uri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<Image> getImagesList() {
        return this.images_;
    }

    @Override
    public List<? extends ImageOrBuilder> getImagesOrBuilderList() {
        return this.images_;
    }

    @Override
    public int getImagesCount() {
        return this.images_.size();
    }

    @Override
    public Image getImages(int index) {
        return this.images_.get(index);
    }

    @Override
    public ImageOrBuilder getImagesOrBuilder(int index) {
        return this.images_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!this.getNameBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!this.getIdBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.id_);
        }
        if (this.type_ != Type.TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.type_);
        }
        if (!this.getPrimaryProductIdBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.primaryProductId_);
        }
        for (i = 0; i < this.categories_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.categories_.getRaw(i));
        }
        if (!this.getTitleBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.title_);
        }
        if (!this.getDescriptionBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.description_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, (int)12);
        for (i = 0; i < this.tags_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.tags_.getRaw(i));
        }
        if (this.priceInfo_ != null) {
            output.writeMessage(14, (MessageLite)this.getPriceInfo());
        }
        if (this.availableTime_ != null) {
            output.writeMessage(18, (MessageLite)this.getAvailableTime());
        }
        if (this.availability_ != Availability.AVAILABILITY_UNSPECIFIED.getNumber()) {
            output.writeEnum(19, this.availability_);
        }
        if (this.availableQuantity_ != null) {
            output.writeMessage(20, (MessageLite)this.getAvailableQuantity());
        }
        if (!this.getUriBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)22, (Object)this.uri_);
        }
        for (i = 0; i < this.images_.size(); ++i) {
            output.writeMessage(23, (MessageLite)this.images_.get(i));
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.getNameBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!this.getIdBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.id_);
        }
        if (this.type_ != Type.TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.type_);
        }
        if (!this.getPrimaryProductIdBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.primaryProductId_);
        }
        int dataSize = 0;
        for (i = 0; i < this.categories_.size(); ++i) {
            dataSize += Product.computeStringSizeNoTag((Object)this.categories_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getCategoriesList().size();
        if (!this.getTitleBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.title_);
        }
        if (!this.getDescriptionBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.description_);
        }
        for (Map.Entry entry : this.internalGetAttributes().getMap().entrySet()) {
            MapEntry attributes__ = AttributesDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)attributes__);
        }
        dataSize = 0;
        for (i = 0; i < this.tags_.size(); ++i) {
            dataSize += Product.computeStringSizeNoTag((Object)this.tags_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getTagsList().size();
        if (this.priceInfo_ != null) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)this.getPriceInfo());
        }
        if (this.availableTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)18, (MessageLite)this.getAvailableTime());
        }
        if (this.availability_ != Availability.AVAILABILITY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)19, (int)this.availability_);
        }
        if (this.availableQuantity_ != null) {
            size += CodedOutputStream.computeMessageSize((int)20, (MessageLite)this.getAvailableQuantity());
        }
        if (!this.getUriBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)22, (Object)this.uri_);
        }
        for (int i2 = 0; i2 < this.images_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)23, (MessageLite)((MessageLite)this.images_.get(i2)));
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Product)) {
            return super.equals(obj);
        }
        Product other = (Product)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getId().equals(other.getId())) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (!this.getPrimaryProductId().equals(other.getPrimaryProductId())) {
            return false;
        }
        if (!this.getCategoriesList().equals(other.getCategoriesList())) {
            return false;
        }
        if (!this.getTitle().equals(other.getTitle())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.internalGetAttributes().equals(other.internalGetAttributes())) {
            return false;
        }
        if (!this.getTagsList().equals(other.getTagsList())) {
            return false;
        }
        if (this.hasPriceInfo() != other.hasPriceInfo()) {
            return false;
        }
        if (this.hasPriceInfo() && !this.getPriceInfo().equals(other.getPriceInfo())) {
            return false;
        }
        if (this.hasAvailableTime() != other.hasAvailableTime()) {
            return false;
        }
        if (this.hasAvailableTime() && !this.getAvailableTime().equals((Object)other.getAvailableTime())) {
            return false;
        }
        if (this.availability_ != other.availability_) {
            return false;
        }
        if (this.hasAvailableQuantity() != other.hasAvailableQuantity()) {
            return false;
        }
        if (this.hasAvailableQuantity() && !this.getAvailableQuantity().equals((Object)other.getAvailableQuantity())) {
            return false;
        }
        if (!this.getUri().equals(other.getUri())) {
            return false;
        }
        if (!this.getImagesList().equals(other.getImagesList())) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Product.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.type_;
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getPrimaryProductId().hashCode();
        if (this.getCategoriesCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getCategoriesList().hashCode();
        }
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getTitle().hashCode();
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getDescription().hashCode();
        if (!this.internalGetAttributes().getMap().isEmpty()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.internalGetAttributes().hashCode();
        }
        if (this.getTagsCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getTagsList().hashCode();
        }
        if (this.hasPriceInfo()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getPriceInfo().hashCode();
        }
        if (this.hasAvailableTime()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getAvailableTime().hashCode();
        }
        hash = 37 * hash + 19;
        hash = 53 * hash + this.availability_;
        if (this.hasAvailableQuantity()) {
            hash = 37 * hash + 20;
            hash = 53 * hash + this.getAvailableQuantity().hashCode();
        }
        hash = 37 * hash + 22;
        hash = 53 * hash + this.getUri().hashCode();
        if (this.getImagesCount() > 0) {
            hash = 37 * hash + 23;
            hash = 53 * hash + this.getImagesList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static Product parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Product)PARSER.parseFrom(data);
    }

    public static Product parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Product)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Product parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Product)PARSER.parseFrom(data);
    }

    public static Product parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Product)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Product parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Product)PARSER.parseFrom(data);
    }

    public static Product parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Product)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Product parseFrom(InputStream input) throws IOException {
        return (Product)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Product parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Product)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Product parseDelimitedFrom(InputStream input) throws IOException {
        return (Product)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Product parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Product)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Product parseFrom(CodedInputStream input) throws IOException {
        return (Product)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Product parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Product)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Product.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Product prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Product getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Product> parser() {
        return PARSER;
    }

    public Parser<Product> getParserForType() {
        return PARSER;
    }

    public Product getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ProductOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Object id_ = "";
        private int type_ = 0;
        private Object primaryProductId_ = "";
        private LazyStringList categories_ = LazyStringArrayList.EMPTY;
        private Object title_ = "";
        private Object description_ = "";
        private MapField<String, CustomAttribute> attributes_;
        private LazyStringList tags_ = LazyStringArrayList.EMPTY;
        private PriceInfo priceInfo_;
        private SingleFieldBuilderV3<PriceInfo, PriceInfo.Builder, PriceInfoOrBuilder> priceInfoBuilder_;
        private Timestamp availableTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> availableTimeBuilder_;
        private int availability_ = 0;
        private Int32Value availableQuantity_;
        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> availableQuantityBuilder_;
        private Object uri_ = "";
        private List<Image> images_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Image, Image.Builder, ImageOrBuilder> imagesBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ProductProto.internal_static_google_cloud_retail_v2_Product_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 12: {
                    return this.internalGetAttributes();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 12: {
                    return this.internalGetMutableAttributes();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ProductProto.internal_static_google_cloud_retail_v2_Product_fieldAccessorTable.ensureFieldAccessorsInitialized(Product.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getImagesFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.name_ = "";
            this.id_ = "";
            this.type_ = 0;
            this.primaryProductId_ = "";
            this.categories_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.title_ = "";
            this.description_ = "";
            this.internalGetMutableAttributes().clear();
            this.tags_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFB;
            if (this.priceInfoBuilder_ == null) {
                this.priceInfo_ = null;
            } else {
                this.priceInfo_ = null;
                this.priceInfoBuilder_ = null;
            }
            if (this.availableTimeBuilder_ == null) {
                this.availableTime_ = null;
            } else {
                this.availableTime_ = null;
                this.availableTimeBuilder_ = null;
            }
            this.availability_ = 0;
            if (this.availableQuantityBuilder_ == null) {
                this.availableQuantity_ = null;
            } else {
                this.availableQuantity_ = null;
                this.availableQuantityBuilder_ = null;
            }
            this.uri_ = "";
            if (this.imagesBuilder_ == null) {
                this.images_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
            } else {
                this.imagesBuilder_.clear();
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ProductProto.internal_static_google_cloud_retail_v2_Product_descriptor;
        }

        public Product getDefaultInstanceForType() {
            return Product.getDefaultInstance();
        }

        public Product build() {
            Product result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Product buildPartial() {
            Product result = new Product(this);
            int from_bitField0_ = this.bitField0_;
            result.name_ = this.name_;
            result.id_ = this.id_;
            result.type_ = this.type_;
            result.primaryProductId_ = this.primaryProductId_;
            if ((this.bitField0_ & 1) != 0) {
                this.categories_ = this.categories_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.categories_ = this.categories_;
            result.title_ = this.title_;
            result.description_ = this.description_;
            result.attributes_ = this.internalGetAttributes();
            result.attributes_.makeImmutable();
            if ((this.bitField0_ & 4) != 0) {
                this.tags_ = this.tags_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFB;
            }
            result.tags_ = this.tags_;
            if (this.priceInfoBuilder_ == null) {
                result.priceInfo_ = this.priceInfo_;
            } else {
                result.priceInfo_ = (PriceInfo)this.priceInfoBuilder_.build();
            }
            if (this.availableTimeBuilder_ == null) {
                result.availableTime_ = this.availableTime_;
            } else {
                result.availableTime_ = (Timestamp)this.availableTimeBuilder_.build();
            }
            result.availability_ = this.availability_;
            if (this.availableQuantityBuilder_ == null) {
                result.availableQuantity_ = this.availableQuantity_;
            } else {
                result.availableQuantity_ = (Int32Value)this.availableQuantityBuilder_.build();
            }
            result.uri_ = this.uri_;
            if (this.imagesBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.images_ = Collections.unmodifiableList(this.images_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.images_ = this.images_;
            } else {
                result.images_ = this.imagesBuilder_.build();
            }
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Product) {
                return this.mergeFrom((Product)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Product other) {
            if (other == Product.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.onChanged();
            }
            if (!other.getId().isEmpty()) {
                this.id_ = other.id_;
                this.onChanged();
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            if (!other.getPrimaryProductId().isEmpty()) {
                this.primaryProductId_ = other.primaryProductId_;
                this.onChanged();
            }
            if (!other.categories_.isEmpty()) {
                if (this.categories_.isEmpty()) {
                    this.categories_ = other.categories_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureCategoriesIsMutable();
                    this.categories_.addAll((Collection)other.categories_);
                }
                this.onChanged();
            }
            if (!other.getTitle().isEmpty()) {
                this.title_ = other.title_;
                this.onChanged();
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.onChanged();
            }
            this.internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
            if (!other.tags_.isEmpty()) {
                if (this.tags_.isEmpty()) {
                    this.tags_ = other.tags_;
                    this.bitField0_ &= 0xFFFFFFFB;
                } else {
                    this.ensureTagsIsMutable();
                    this.tags_.addAll((Collection)other.tags_);
                }
                this.onChanged();
            }
            if (other.hasPriceInfo()) {
                this.mergePriceInfo(other.getPriceInfo());
            }
            if (other.hasAvailableTime()) {
                this.mergeAvailableTime(other.getAvailableTime());
            }
            if (other.availability_ != 0) {
                this.setAvailabilityValue(other.getAvailabilityValue());
            }
            if (other.hasAvailableQuantity()) {
                this.mergeAvailableQuantity(other.getAvailableQuantity());
            }
            if (!other.getUri().isEmpty()) {
                this.uri_ = other.uri_;
                this.onChanged();
            }
            if (this.imagesBuilder_ == null) {
                if (!other.images_.isEmpty()) {
                    if (this.images_.isEmpty()) {
                        this.images_ = other.images_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureImagesIsMutable();
                        this.images_.addAll(other.images_);
                    }
                    this.onChanged();
                }
            } else if (!other.images_.isEmpty()) {
                if (this.imagesBuilder_.isEmpty()) {
                    this.imagesBuilder_.dispose();
                    this.imagesBuilder_ = null;
                    this.images_ = other.images_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.imagesBuilder_ = alwaysUseFieldBuilders ? this.getImagesFieldBuilder() : null;
                } else {
                    this.imagesBuilder_.addAllMessages((Iterable)other.images_);
                }
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            Product parsedMessage = null;
            try {
                parsedMessage = (Product)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (Product)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Product.getDefaultInstance().getName();
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Product.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getId() {
            Object ref = this.id_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.id_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getIdBytes() {
            Object ref = this.id_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.id_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.id_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.id_ = Product.getDefaultInstance().getId();
            this.onChanged();
            return this;
        }

        public Builder setIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Product.checkByteStringIsUtf8((ByteString)value);
            this.id_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public Type getType() {
            Type result = Type.valueOf(this.type_);
            return result == null ? Type.UNRECOGNIZED : result;
        }

        public Builder setType(Type value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getPrimaryProductId() {
            Object ref = this.primaryProductId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.primaryProductId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPrimaryProductIdBytes() {
            Object ref = this.primaryProductId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.primaryProductId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPrimaryProductId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.primaryProductId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryProductId() {
            this.primaryProductId_ = Product.getDefaultInstance().getPrimaryProductId();
            this.onChanged();
            return this;
        }

        public Builder setPrimaryProductIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Product.checkByteStringIsUtf8((ByteString)value);
            this.primaryProductId_ = value;
            this.onChanged();
            return this;
        }

        private void ensureCategoriesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.categories_ = new LazyStringArrayList(this.categories_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getCategoriesList() {
            return this.categories_.getUnmodifiableView();
        }

        @Override
        public int getCategoriesCount() {
            return this.categories_.size();
        }

        @Override
        public String getCategories(int index) {
            return (String)this.categories_.get(index);
        }

        @Override
        public ByteString getCategoriesBytes(int index) {
            return this.categories_.getByteString(index);
        }

        public Builder setCategories(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCategoriesIsMutable();
            this.categories_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addCategories(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCategoriesIsMutable();
            this.categories_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllCategories(Iterable<String> values) {
            this.ensureCategoriesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.categories_);
            this.onChanged();
            return this;
        }

        public Builder clearCategories() {
            this.categories_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addCategoriesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Product.checkByteStringIsUtf8((ByteString)value);
            this.ensureCategoriesIsMutable();
            this.categories_.add(value);
            this.onChanged();
            return this;
        }

        @Override
        public String getTitle() {
            Object ref = this.title_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.title_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTitleBytes() {
            Object ref = this.title_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.title_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTitle(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.title_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearTitle() {
            this.title_ = Product.getDefaultInstance().getTitle();
            this.onChanged();
            return this;
        }

        public Builder setTitleBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Product.checkByteStringIsUtf8((ByteString)value);
            this.title_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = Product.getDefaultInstance().getDescription();
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Product.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.onChanged();
            return this;
        }

        private MapField<String, CustomAttribute> internalGetAttributes() {
            if (this.attributes_ == null) {
                return MapField.emptyMapField(AttributesDefaultEntryHolder.defaultEntry);
            }
            return this.attributes_;
        }

        private MapField<String, CustomAttribute> internalGetMutableAttributes() {
            this.onChanged();
            if (this.attributes_ == null) {
                this.attributes_ = MapField.newMapField(AttributesDefaultEntryHolder.defaultEntry);
            }
            if (!this.attributes_.isMutable()) {
                this.attributes_ = this.attributes_.copy();
            }
            return this.attributes_;
        }

        @Override
        public int getAttributesCount() {
            return this.internalGetAttributes().getMap().size();
        }

        @Override
        public boolean containsAttributes(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return this.internalGetAttributes().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, CustomAttribute> getAttributes() {
            return this.getAttributesMap();
        }

        @Override
        public Map<String, CustomAttribute> getAttributesMap() {
            return this.internalGetAttributes().getMap();
        }

        @Override
        public CustomAttribute getAttributesOrDefault(String key, CustomAttribute defaultValue) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetAttributes().getMap();
            return map.containsKey(key) ? (CustomAttribute)map.get(key) : defaultValue;
        }

        @Override
        public CustomAttribute getAttributesOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetAttributes().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (CustomAttribute)map.get(key);
        }

        public Builder clearAttributes() {
            this.internalGetMutableAttributes().getMutableMap().clear();
            return this;
        }

        public Builder removeAttributes(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableAttributes().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, CustomAttribute> getMutableAttributes() {
            return this.internalGetMutableAttributes().getMutableMap();
        }

        public Builder putAttributes(String key, CustomAttribute value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableAttributes().getMutableMap().put(key, value);
            return this;
        }

        public Builder putAllAttributes(Map<String, CustomAttribute> values) {
            this.internalGetMutableAttributes().getMutableMap().putAll(values);
            return this;
        }

        private void ensureTagsIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.tags_ = new LazyStringArrayList(this.tags_);
                this.bitField0_ |= 4;
            }
        }

        public ProtocolStringList getTagsList() {
            return this.tags_.getUnmodifiableView();
        }

        @Override
        public int getTagsCount() {
            return this.tags_.size();
        }

        @Override
        public String getTags(int index) {
            return (String)this.tags_.get(index);
        }

        @Override
        public ByteString getTagsBytes(int index) {
            return this.tags_.getByteString(index);
        }

        public Builder setTags(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTagsIsMutable();
            this.tags_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addTags(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureTagsIsMutable();
            this.tags_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllTags(Iterable<String> values) {
            this.ensureTagsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.tags_);
            this.onChanged();
            return this;
        }

        public Builder clearTags() {
            this.tags_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder addTagsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Product.checkByteStringIsUtf8((ByteString)value);
            this.ensureTagsIsMutable();
            this.tags_.add(value);
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPriceInfo() {
            return this.priceInfoBuilder_ != null || this.priceInfo_ != null;
        }

        @Override
        public PriceInfo getPriceInfo() {
            if (this.priceInfoBuilder_ == null) {
                return this.priceInfo_ == null ? PriceInfo.getDefaultInstance() : this.priceInfo_;
            }
            return (PriceInfo)this.priceInfoBuilder_.getMessage();
        }

        public Builder setPriceInfo(PriceInfo value) {
            if (this.priceInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.priceInfo_ = value;
                this.onChanged();
            } else {
                this.priceInfoBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setPriceInfo(PriceInfo.Builder builderForValue) {
            if (this.priceInfoBuilder_ == null) {
                this.priceInfo_ = builderForValue.build();
                this.onChanged();
            } else {
                this.priceInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergePriceInfo(PriceInfo value) {
            if (this.priceInfoBuilder_ == null) {
                this.priceInfo_ = this.priceInfo_ != null ? PriceInfo.newBuilder(this.priceInfo_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.priceInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearPriceInfo() {
            if (this.priceInfoBuilder_ == null) {
                this.priceInfo_ = null;
                this.onChanged();
            } else {
                this.priceInfo_ = null;
                this.priceInfoBuilder_ = null;
            }
            return this;
        }

        public PriceInfo.Builder getPriceInfoBuilder() {
            this.onChanged();
            return (PriceInfo.Builder)this.getPriceInfoFieldBuilder().getBuilder();
        }

        @Override
        public PriceInfoOrBuilder getPriceInfoOrBuilder() {
            if (this.priceInfoBuilder_ != null) {
                return (PriceInfoOrBuilder)this.priceInfoBuilder_.getMessageOrBuilder();
            }
            return this.priceInfo_ == null ? PriceInfo.getDefaultInstance() : this.priceInfo_;
        }

        private SingleFieldBuilderV3<PriceInfo, PriceInfo.Builder, PriceInfoOrBuilder> getPriceInfoFieldBuilder() {
            if (this.priceInfoBuilder_ == null) {
                this.priceInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPriceInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.priceInfo_ = null;
            }
            return this.priceInfoBuilder_;
        }

        @Override
        public boolean hasAvailableTime() {
            return this.availableTimeBuilder_ != null || this.availableTime_ != null;
        }

        @Override
        public Timestamp getAvailableTime() {
            if (this.availableTimeBuilder_ == null) {
                return this.availableTime_ == null ? Timestamp.getDefaultInstance() : this.availableTime_;
            }
            return (Timestamp)this.availableTimeBuilder_.getMessage();
        }

        public Builder setAvailableTime(Timestamp value) {
            if (this.availableTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.availableTime_ = value;
                this.onChanged();
            } else {
                this.availableTimeBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setAvailableTime(Timestamp.Builder builderForValue) {
            if (this.availableTimeBuilder_ == null) {
                this.availableTime_ = builderForValue.build();
                this.onChanged();
            } else {
                this.availableTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeAvailableTime(Timestamp value) {
            if (this.availableTimeBuilder_ == null) {
                this.availableTime_ = this.availableTime_ != null ? Timestamp.newBuilder((Timestamp)this.availableTime_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.availableTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearAvailableTime() {
            if (this.availableTimeBuilder_ == null) {
                this.availableTime_ = null;
                this.onChanged();
            } else {
                this.availableTime_ = null;
                this.availableTimeBuilder_ = null;
            }
            return this;
        }

        public Timestamp.Builder getAvailableTimeBuilder() {
            this.onChanged();
            return (Timestamp.Builder)this.getAvailableTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getAvailableTimeOrBuilder() {
            if (this.availableTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.availableTimeBuilder_.getMessageOrBuilder();
            }
            return this.availableTime_ == null ? Timestamp.getDefaultInstance() : this.availableTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getAvailableTimeFieldBuilder() {
            if (this.availableTimeBuilder_ == null) {
                this.availableTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAvailableTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.availableTime_ = null;
            }
            return this.availableTimeBuilder_;
        }

        @Override
        public int getAvailabilityValue() {
            return this.availability_;
        }

        public Builder setAvailabilityValue(int value) {
            this.availability_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public Availability getAvailability() {
            Availability result = Availability.valueOf(this.availability_);
            return result == null ? Availability.UNRECOGNIZED : result;
        }

        public Builder setAvailability(Availability value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.availability_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAvailability() {
            this.availability_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAvailableQuantity() {
            return this.availableQuantityBuilder_ != null || this.availableQuantity_ != null;
        }

        @Override
        public Int32Value getAvailableQuantity() {
            if (this.availableQuantityBuilder_ == null) {
                return this.availableQuantity_ == null ? Int32Value.getDefaultInstance() : this.availableQuantity_;
            }
            return (Int32Value)this.availableQuantityBuilder_.getMessage();
        }

        public Builder setAvailableQuantity(Int32Value value) {
            if (this.availableQuantityBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.availableQuantity_ = value;
                this.onChanged();
            } else {
                this.availableQuantityBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setAvailableQuantity(Int32Value.Builder builderForValue) {
            if (this.availableQuantityBuilder_ == null) {
                this.availableQuantity_ = builderForValue.build();
                this.onChanged();
            } else {
                this.availableQuantityBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeAvailableQuantity(Int32Value value) {
            if (this.availableQuantityBuilder_ == null) {
                this.availableQuantity_ = this.availableQuantity_ != null ? Int32Value.newBuilder((Int32Value)this.availableQuantity_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.availableQuantityBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearAvailableQuantity() {
            if (this.availableQuantityBuilder_ == null) {
                this.availableQuantity_ = null;
                this.onChanged();
            } else {
                this.availableQuantity_ = null;
                this.availableQuantityBuilder_ = null;
            }
            return this;
        }

        public Int32Value.Builder getAvailableQuantityBuilder() {
            this.onChanged();
            return (Int32Value.Builder)this.getAvailableQuantityFieldBuilder().getBuilder();
        }

        @Override
        public Int32ValueOrBuilder getAvailableQuantityOrBuilder() {
            if (this.availableQuantityBuilder_ != null) {
                return (Int32ValueOrBuilder)this.availableQuantityBuilder_.getMessageOrBuilder();
            }
            return this.availableQuantity_ == null ? Int32Value.getDefaultInstance() : this.availableQuantity_;
        }

        private SingleFieldBuilderV3<Int32Value, Int32Value.Builder, Int32ValueOrBuilder> getAvailableQuantityFieldBuilder() {
            if (this.availableQuantityBuilder_ == null) {
                this.availableQuantityBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAvailableQuantity(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.availableQuantity_ = null;
            }
            return this.availableQuantityBuilder_;
        }

        @Override
        public String getUri() {
            Object ref = this.uri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.uri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getUriBytes() {
            Object ref = this.uri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.uri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.uri_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearUri() {
            this.uri_ = Product.getDefaultInstance().getUri();
            this.onChanged();
            return this;
        }

        public Builder setUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Product.checkByteStringIsUtf8((ByteString)value);
            this.uri_ = value;
            this.onChanged();
            return this;
        }

        private void ensureImagesIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.images_ = new ArrayList<Image>(this.images_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<Image> getImagesList() {
            if (this.imagesBuilder_ == null) {
                return Collections.unmodifiableList(this.images_);
            }
            return this.imagesBuilder_.getMessageList();
        }

        @Override
        public int getImagesCount() {
            if (this.imagesBuilder_ == null) {
                return this.images_.size();
            }
            return this.imagesBuilder_.getCount();
        }

        @Override
        public Image getImages(int index) {
            if (this.imagesBuilder_ == null) {
                return this.images_.get(index);
            }
            return (Image)this.imagesBuilder_.getMessage(index);
        }

        public Builder setImages(int index, Image value) {
            if (this.imagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureImagesIsMutable();
                this.images_.set(index, value);
                this.onChanged();
            } else {
                this.imagesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setImages(int index, Image.Builder builderForValue) {
            if (this.imagesBuilder_ == null) {
                this.ensureImagesIsMutable();
                this.images_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.imagesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addImages(Image value) {
            if (this.imagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureImagesIsMutable();
                this.images_.add(value);
                this.onChanged();
            } else {
                this.imagesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addImages(int index, Image value) {
            if (this.imagesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureImagesIsMutable();
                this.images_.add(index, value);
                this.onChanged();
            } else {
                this.imagesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addImages(Image.Builder builderForValue) {
            if (this.imagesBuilder_ == null) {
                this.ensureImagesIsMutable();
                this.images_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.imagesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addImages(int index, Image.Builder builderForValue) {
            if (this.imagesBuilder_ == null) {
                this.ensureImagesIsMutable();
                this.images_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.imagesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllImages(Iterable<? extends Image> values) {
            if (this.imagesBuilder_ == null) {
                this.ensureImagesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.images_);
                this.onChanged();
            } else {
                this.imagesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearImages() {
            if (this.imagesBuilder_ == null) {
                this.images_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.imagesBuilder_.clear();
            }
            return this;
        }

        public Builder removeImages(int index) {
            if (this.imagesBuilder_ == null) {
                this.ensureImagesIsMutable();
                this.images_.remove(index);
                this.onChanged();
            } else {
                this.imagesBuilder_.remove(index);
            }
            return this;
        }

        public Image.Builder getImagesBuilder(int index) {
            return (Image.Builder)this.getImagesFieldBuilder().getBuilder(index);
        }

        @Override
        public ImageOrBuilder getImagesOrBuilder(int index) {
            if (this.imagesBuilder_ == null) {
                return this.images_.get(index);
            }
            return (ImageOrBuilder)this.imagesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ImageOrBuilder> getImagesOrBuilderList() {
            if (this.imagesBuilder_ != null) {
                return this.imagesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.images_);
        }

        public Image.Builder addImagesBuilder() {
            return (Image.Builder)this.getImagesFieldBuilder().addBuilder((AbstractMessage)Image.getDefaultInstance());
        }

        public Image.Builder addImagesBuilder(int index) {
            return (Image.Builder)this.getImagesFieldBuilder().addBuilder(index, (AbstractMessage)Image.getDefaultInstance());
        }

        public List<Image.Builder> getImagesBuilderList() {
            return this.getImagesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Image, Image.Builder, ImageOrBuilder> getImagesFieldBuilder() {
            if (this.imagesBuilder_ == null) {
                this.imagesBuilder_ = new RepeatedFieldBuilderV3(this.images_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.images_ = null;
            }
            return this.imagesBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class AttributesDefaultEntryHolder {
        static final MapEntry<String, CustomAttribute> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)ProductProto.internal_static_google_cloud_retail_v2_Product_AttributesEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.MESSAGE, (Object)CustomAttribute.getDefaultInstance());

        private AttributesDefaultEntryHolder() {
        }
    }

    public static enum Availability implements ProtocolMessageEnum
    {
        AVAILABILITY_UNSPECIFIED(0),
        IN_STOCK(1),
        OUT_OF_STOCK(2),
        PREORDER(3),
        BACKORDER(4),
        UNRECOGNIZED(-1);

        public static final int AVAILABILITY_UNSPECIFIED_VALUE = 0;
        public static final int IN_STOCK_VALUE = 1;
        public static final int OUT_OF_STOCK_VALUE = 2;
        public static final int PREORDER_VALUE = 3;
        public static final int BACKORDER_VALUE = 4;
        private static final Internal.EnumLiteMap<Availability> internalValueMap;
        private static final Availability[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Availability valueOf(int value) {
            return Availability.forNumber(value);
        }

        public static Availability forNumber(int value) {
            switch (value) {
                case 0: {
                    return AVAILABILITY_UNSPECIFIED;
                }
                case 1: {
                    return IN_STOCK;
                }
                case 2: {
                    return OUT_OF_STOCK;
                }
                case 3: {
                    return PREORDER;
                }
                case 4: {
                    return BACKORDER;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Availability> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Availability.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Availability.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Product.getDescriptor().getEnumTypes().get(1);
        }

        public static Availability valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Availability.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Availability(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Availability>(){

                public Availability findValueByNumber(int number) {
                    return Availability.forNumber(number);
                }
            };
            VALUES = Availability.values();
        }
    }

    public static enum Type implements ProtocolMessageEnum
    {
        TYPE_UNSPECIFIED(0),
        PRIMARY(1),
        VARIANT(2),
        COLLECTION(3),
        UNRECOGNIZED(-1);

        public static final int TYPE_UNSPECIFIED_VALUE = 0;
        public static final int PRIMARY_VALUE = 1;
        public static final int VARIANT_VALUE = 2;
        public static final int COLLECTION_VALUE = 3;
        private static final Internal.EnumLiteMap<Type> internalValueMap;
        private static final Type[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Type valueOf(int value) {
            return Type.forNumber(value);
        }

        public static Type forNumber(int value) {
            switch (value) {
                case 0: {
                    return TYPE_UNSPECIFIED;
                }
                case 1: {
                    return PRIMARY;
                }
                case 2: {
                    return VARIANT;
                }
                case 3: {
                    return COLLECTION;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Type> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Type.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Type.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Product.getDescriptor().getEnumTypes().get(0);
        }

        public static Type valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Type.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Type(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Type>(){

                public Type findValueByNumber(int number) {
                    return Type.forNumber(number);
                }
            };
            VALUES = Type.values();
        }
    }
}

