/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.redis.cluster.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BackupCollectionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BACKUP_COLLECTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/backupCollections/{backup_collection}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String backupCollection;

    @Deprecated
    protected BackupCollectionName() {
        this.project = null;
        this.location = null;
        this.backupCollection = null;
    }

    private BackupCollectionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.backupCollection = (String)Preconditions.checkNotNull((Object)builder.getBackupCollection());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBackupCollection() {
        return this.backupCollection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BackupCollectionName of(String project, String location, String backupCollection) {
        return BackupCollectionName.newBuilder().setProject(project).setLocation(location).setBackupCollection(backupCollection).build();
    }

    public static String format(String project, String location, String backupCollection) {
        return BackupCollectionName.newBuilder().setProject(project).setLocation(location).setBackupCollection(backupCollection).build().toString();
    }

    public static BackupCollectionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BACKUP_COLLECTION.validatedMatch(formattedString, "BackupCollectionName.parse: formattedString not in valid format");
        return BackupCollectionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("backup_collection"));
    }

    public static List<BackupCollectionName> parseList(List<String> formattedStrings) {
        ArrayList<BackupCollectionName> list = new ArrayList<BackupCollectionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BackupCollectionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BackupCollectionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BackupCollectionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BACKUP_COLLECTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BackupCollectionName backupCollectionName = this;
            synchronized (backupCollectionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.backupCollection != null) {
                        fieldMapBuilder.put((Object)"backup_collection", (Object)this.backupCollection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BACKUP_COLLECTION.instantiate(new String[]{"project", this.project, "location", this.location, "backup_collection", this.backupCollection});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BackupCollectionName that = (BackupCollectionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.backupCollection, that.backupCollection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.backupCollection);
    }

    public static class Builder {
        private String project;
        private String location;
        private String backupCollection;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBackupCollection() {
            return this.backupCollection;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBackupCollection(String backupCollection) {
            this.backupCollection = backupCollection;
            return this;
        }

        private Builder(BackupCollectionName backupCollectionName) {
            this.project = backupCollectionName.project;
            this.location = backupCollectionName.location;
            this.backupCollection = backupCollectionName.backupCollection;
        }

        public BackupCollectionName build() {
            return new BackupCollectionName(this);
        }
    }
}

