/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.redis.cluster.v1beta1;

import com.google.cloud.redis.cluster.v1beta1.AuthorizationMode;
import com.google.cloud.redis.cluster.v1beta1.CloudRedisClusterProto;
import com.google.cloud.redis.cluster.v1beta1.ClusterOrBuilder;
import com.google.cloud.redis.cluster.v1beta1.ClusterPersistenceConfig;
import com.google.cloud.redis.cluster.v1beta1.ClusterPersistenceConfigOrBuilder;
import com.google.cloud.redis.cluster.v1beta1.DiscoveryEndpoint;
import com.google.cloud.redis.cluster.v1beta1.DiscoveryEndpointOrBuilder;
import com.google.cloud.redis.cluster.v1beta1.NodeType;
import com.google.cloud.redis.cluster.v1beta1.PscConfig;
import com.google.cloud.redis.cluster.v1beta1.PscConfigOrBuilder;
import com.google.cloud.redis.cluster.v1beta1.PscConnection;
import com.google.cloud.redis.cluster.v1beta1.PscConnectionOrBuilder;
import com.google.cloud.redis.cluster.v1beta1.TransitEncryptionMode;
import com.google.cloud.redis.cluster.v1beta1.ZoneDistributionConfig;
import com.google.cloud.redis.cluster.v1beta1.ZoneDistributionConfigOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Cluster
extends GeneratedMessageV3
implements ClusterOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int CREATE_TIME_FIELD_NUMBER = 3;
    private Timestamp createTime_;
    public static final int STATE_FIELD_NUMBER = 4;
    private int state_ = 0;
    public static final int UID_FIELD_NUMBER = 5;
    private volatile Object uid_ = "";
    public static final int REPLICA_COUNT_FIELD_NUMBER = 8;
    private int replicaCount_ = 0;
    public static final int AUTHORIZATION_MODE_FIELD_NUMBER = 11;
    private int authorizationMode_ = 0;
    public static final int TRANSIT_ENCRYPTION_MODE_FIELD_NUMBER = 12;
    private int transitEncryptionMode_ = 0;
    public static final int SIZE_GB_FIELD_NUMBER = 13;
    private int sizeGb_ = 0;
    public static final int SHARD_COUNT_FIELD_NUMBER = 14;
    private int shardCount_ = 0;
    public static final int PSC_CONFIGS_FIELD_NUMBER = 15;
    private List<PscConfig> pscConfigs_;
    public static final int DISCOVERY_ENDPOINTS_FIELD_NUMBER = 16;
    private List<DiscoveryEndpoint> discoveryEndpoints_;
    public static final int PSC_CONNECTIONS_FIELD_NUMBER = 17;
    private List<PscConnection> pscConnections_;
    public static final int STATE_INFO_FIELD_NUMBER = 18;
    private StateInfo stateInfo_;
    public static final int NODE_TYPE_FIELD_NUMBER = 19;
    private int nodeType_ = 0;
    public static final int PERSISTENCE_CONFIG_FIELD_NUMBER = 20;
    private ClusterPersistenceConfig persistenceConfig_;
    public static final int REDIS_CONFIGS_FIELD_NUMBER = 21;
    private MapField<String, String> redisConfigs_;
    public static final int PRECISE_SIZE_GB_FIELD_NUMBER = 22;
    private double preciseSizeGb_ = 0.0;
    public static final int ZONE_DISTRIBUTION_CONFIG_FIELD_NUMBER = 23;
    private ZoneDistributionConfig zoneDistributionConfig_;
    public static final int DELETION_PROTECTION_ENABLED_FIELD_NUMBER = 25;
    private boolean deletionProtectionEnabled_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Cluster DEFAULT_INSTANCE = new Cluster();
    private static final Parser<Cluster> PARSER = new AbstractParser<Cluster>(){

        public Cluster parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Cluster.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Cluster(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Cluster() {
        this.name_ = "";
        this.state_ = 0;
        this.uid_ = "";
        this.authorizationMode_ = 0;
        this.transitEncryptionMode_ = 0;
        this.pscConfigs_ = Collections.emptyList();
        this.discoveryEndpoints_ = Collections.emptyList();
        this.pscConnections_ = Collections.emptyList();
        this.nodeType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Cluster();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 21: {
                return this.internalGetRedisConfigs();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_fieldAccessorTable.ensureFieldAccessorsInitialized(Cluster.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCreateTime() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getCreateTime() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public TimestampOrBuilder getCreateTimeOrBuilder() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public int getStateValue() {
        return this.state_;
    }

    @Override
    public State getState() {
        State result = State.forNumber(this.state_);
        return result == null ? State.UNRECOGNIZED : result;
    }

    @Override
    public String getUid() {
        Object ref = this.uid_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.uid_ = s;
        return s;
    }

    @Override
    public ByteString getUidBytes() {
        Object ref = this.uid_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.uid_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasReplicaCount() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public int getReplicaCount() {
        return this.replicaCount_;
    }

    @Override
    public int getAuthorizationModeValue() {
        return this.authorizationMode_;
    }

    @Override
    public AuthorizationMode getAuthorizationMode() {
        AuthorizationMode result = AuthorizationMode.forNumber(this.authorizationMode_);
        return result == null ? AuthorizationMode.UNRECOGNIZED : result;
    }

    @Override
    public int getTransitEncryptionModeValue() {
        return this.transitEncryptionMode_;
    }

    @Override
    public TransitEncryptionMode getTransitEncryptionMode() {
        TransitEncryptionMode result = TransitEncryptionMode.forNumber(this.transitEncryptionMode_);
        return result == null ? TransitEncryptionMode.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasSizeGb() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public int getSizeGb() {
        return this.sizeGb_;
    }

    @Override
    public boolean hasShardCount() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public int getShardCount() {
        return this.shardCount_;
    }

    @Override
    public List<PscConfig> getPscConfigsList() {
        return this.pscConfigs_;
    }

    @Override
    public List<? extends PscConfigOrBuilder> getPscConfigsOrBuilderList() {
        return this.pscConfigs_;
    }

    @Override
    public int getPscConfigsCount() {
        return this.pscConfigs_.size();
    }

    @Override
    public PscConfig getPscConfigs(int index) {
        return this.pscConfigs_.get(index);
    }

    @Override
    public PscConfigOrBuilder getPscConfigsOrBuilder(int index) {
        return this.pscConfigs_.get(index);
    }

    @Override
    public List<DiscoveryEndpoint> getDiscoveryEndpointsList() {
        return this.discoveryEndpoints_;
    }

    @Override
    public List<? extends DiscoveryEndpointOrBuilder> getDiscoveryEndpointsOrBuilderList() {
        return this.discoveryEndpoints_;
    }

    @Override
    public int getDiscoveryEndpointsCount() {
        return this.discoveryEndpoints_.size();
    }

    @Override
    public DiscoveryEndpoint getDiscoveryEndpoints(int index) {
        return this.discoveryEndpoints_.get(index);
    }

    @Override
    public DiscoveryEndpointOrBuilder getDiscoveryEndpointsOrBuilder(int index) {
        return this.discoveryEndpoints_.get(index);
    }

    @Override
    public List<PscConnection> getPscConnectionsList() {
        return this.pscConnections_;
    }

    @Override
    public List<? extends PscConnectionOrBuilder> getPscConnectionsOrBuilderList() {
        return this.pscConnections_;
    }

    @Override
    public int getPscConnectionsCount() {
        return this.pscConnections_.size();
    }

    @Override
    public PscConnection getPscConnections(int index) {
        return this.pscConnections_.get(index);
    }

    @Override
    public PscConnectionOrBuilder getPscConnectionsOrBuilder(int index) {
        return this.pscConnections_.get(index);
    }

    @Override
    public boolean hasStateInfo() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public StateInfo getStateInfo() {
        return this.stateInfo_ == null ? StateInfo.getDefaultInstance() : this.stateInfo_;
    }

    @Override
    public StateInfoOrBuilder getStateInfoOrBuilder() {
        return this.stateInfo_ == null ? StateInfo.getDefaultInstance() : this.stateInfo_;
    }

    @Override
    public int getNodeTypeValue() {
        return this.nodeType_;
    }

    @Override
    public NodeType getNodeType() {
        NodeType result = NodeType.forNumber(this.nodeType_);
        return result == null ? NodeType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasPersistenceConfig() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public ClusterPersistenceConfig getPersistenceConfig() {
        return this.persistenceConfig_ == null ? ClusterPersistenceConfig.getDefaultInstance() : this.persistenceConfig_;
    }

    @Override
    public ClusterPersistenceConfigOrBuilder getPersistenceConfigOrBuilder() {
        return this.persistenceConfig_ == null ? ClusterPersistenceConfig.getDefaultInstance() : this.persistenceConfig_;
    }

    private MapField<String, String> internalGetRedisConfigs() {
        if (this.redisConfigs_ == null) {
            return MapField.emptyMapField(RedisConfigsDefaultEntryHolder.defaultEntry);
        }
        return this.redisConfigs_;
    }

    @Override
    public int getRedisConfigsCount() {
        return this.internalGetRedisConfigs().getMap().size();
    }

    @Override
    public boolean containsRedisConfigs(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetRedisConfigs().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getRedisConfigs() {
        return this.getRedisConfigsMap();
    }

    @Override
    public Map<String, String> getRedisConfigsMap() {
        return this.internalGetRedisConfigs().getMap();
    }

    @Override
    public String getRedisConfigsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetRedisConfigs().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getRedisConfigsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetRedisConfigs().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public boolean hasPreciseSizeGb() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public double getPreciseSizeGb() {
        return this.preciseSizeGb_;
    }

    @Override
    public boolean hasZoneDistributionConfig() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public ZoneDistributionConfig getZoneDistributionConfig() {
        return this.zoneDistributionConfig_ == null ? ZoneDistributionConfig.getDefaultInstance() : this.zoneDistributionConfig_;
    }

    @Override
    public ZoneDistributionConfigOrBuilder getZoneDistributionConfigOrBuilder() {
        return this.zoneDistributionConfig_ == null ? ZoneDistributionConfig.getDefaultInstance() : this.zoneDistributionConfig_;
    }

    @Override
    public boolean hasDeletionProtectionEnabled() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public boolean getDeletionProtectionEnabled() {
        return this.deletionProtectionEnabled_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(3, (MessageLite)this.getCreateTime());
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.state_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.uid_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.uid_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeInt32(8, this.replicaCount_);
        }
        if (this.authorizationMode_ != AuthorizationMode.AUTH_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(11, this.authorizationMode_);
        }
        if (this.transitEncryptionMode_ != TransitEncryptionMode.TRANSIT_ENCRYPTION_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(12, this.transitEncryptionMode_);
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeInt32(13, this.sizeGb_);
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeInt32(14, this.shardCount_);
        }
        for (i = 0; i < this.pscConfigs_.size(); ++i) {
            output.writeMessage(15, (MessageLite)this.pscConfigs_.get(i));
        }
        for (i = 0; i < this.discoveryEndpoints_.size(); ++i) {
            output.writeMessage(16, (MessageLite)this.discoveryEndpoints_.get(i));
        }
        for (i = 0; i < this.pscConnections_.size(); ++i) {
            output.writeMessage(17, (MessageLite)this.pscConnections_.get(i));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(18, (MessageLite)this.getStateInfo());
        }
        if (this.nodeType_ != NodeType.NODE_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(19, this.nodeType_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(20, (MessageLite)this.getPersistenceConfig());
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetRedisConfigs(), RedisConfigsDefaultEntryHolder.defaultEntry, (int)21);
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeDouble(22, this.preciseSizeGb_);
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeMessage(23, (MessageLite)this.getZoneDistributionConfig());
        }
        if ((this.bitField0_ & 0x100) != 0) {
            output.writeBool(25, this.deletionProtectionEnabled_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getCreateTime());
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.state_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.uid_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.uid_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeInt32Size((int)8, (int)this.replicaCount_);
        }
        if (this.authorizationMode_ != AuthorizationMode.AUTH_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)11, (int)this.authorizationMode_);
        }
        if (this.transitEncryptionMode_ != TransitEncryptionMode.TRANSIT_ENCRYPTION_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)12, (int)this.transitEncryptionMode_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeInt32Size((int)13, (int)this.sizeGb_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeInt32Size((int)14, (int)this.shardCount_);
        }
        for (i = 0; i < this.pscConfigs_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)((MessageLite)this.pscConfigs_.get(i)));
        }
        for (i = 0; i < this.discoveryEndpoints_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)16, (MessageLite)((MessageLite)this.discoveryEndpoints_.get(i)));
        }
        for (i = 0; i < this.pscConnections_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)((MessageLite)this.pscConnections_.get(i)));
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)18, (MessageLite)this.getStateInfo());
        }
        if (this.nodeType_ != NodeType.NODE_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)19, (int)this.nodeType_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)20, (MessageLite)this.getPersistenceConfig());
        }
        for (Map.Entry entry : this.internalGetRedisConfigs().getMap().entrySet()) {
            MapEntry redisConfigs__ = RedisConfigsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)21, (MessageLite)redisConfigs__);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeDoubleSize((int)22, (double)this.preciseSizeGb_);
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeMessageSize((int)23, (MessageLite)this.getZoneDistributionConfig());
        }
        if ((this.bitField0_ & 0x100) != 0) {
            size += CodedOutputStream.computeBoolSize((int)25, (boolean)this.deletionProtectionEnabled_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Cluster)) {
            return super.equals(obj);
        }
        Cluster other = (Cluster)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.hasCreateTime() != other.hasCreateTime()) {
            return false;
        }
        if (this.hasCreateTime() && !this.getCreateTime().equals((Object)other.getCreateTime())) {
            return false;
        }
        if (this.state_ != other.state_) {
            return false;
        }
        if (!this.getUid().equals(other.getUid())) {
            return false;
        }
        if (this.hasReplicaCount() != other.hasReplicaCount()) {
            return false;
        }
        if (this.hasReplicaCount() && this.getReplicaCount() != other.getReplicaCount()) {
            return false;
        }
        if (this.authorizationMode_ != other.authorizationMode_) {
            return false;
        }
        if (this.transitEncryptionMode_ != other.transitEncryptionMode_) {
            return false;
        }
        if (this.hasSizeGb() != other.hasSizeGb()) {
            return false;
        }
        if (this.hasSizeGb() && this.getSizeGb() != other.getSizeGb()) {
            return false;
        }
        if (this.hasShardCount() != other.hasShardCount()) {
            return false;
        }
        if (this.hasShardCount() && this.getShardCount() != other.getShardCount()) {
            return false;
        }
        if (!this.getPscConfigsList().equals(other.getPscConfigsList())) {
            return false;
        }
        if (!this.getDiscoveryEndpointsList().equals(other.getDiscoveryEndpointsList())) {
            return false;
        }
        if (!this.getPscConnectionsList().equals(other.getPscConnectionsList())) {
            return false;
        }
        if (this.hasStateInfo() != other.hasStateInfo()) {
            return false;
        }
        if (this.hasStateInfo() && !this.getStateInfo().equals(other.getStateInfo())) {
            return false;
        }
        if (this.nodeType_ != other.nodeType_) {
            return false;
        }
        if (this.hasPersistenceConfig() != other.hasPersistenceConfig()) {
            return false;
        }
        if (this.hasPersistenceConfig() && !this.getPersistenceConfig().equals(other.getPersistenceConfig())) {
            return false;
        }
        if (!this.internalGetRedisConfigs().equals(other.internalGetRedisConfigs())) {
            return false;
        }
        if (this.hasPreciseSizeGb() != other.hasPreciseSizeGb()) {
            return false;
        }
        if (this.hasPreciseSizeGb() && Double.doubleToLongBits(this.getPreciseSizeGb()) != Double.doubleToLongBits(other.getPreciseSizeGb())) {
            return false;
        }
        if (this.hasZoneDistributionConfig() != other.hasZoneDistributionConfig()) {
            return false;
        }
        if (this.hasZoneDistributionConfig() && !this.getZoneDistributionConfig().equals(other.getZoneDistributionConfig())) {
            return false;
        }
        if (this.hasDeletionProtectionEnabled() != other.hasDeletionProtectionEnabled()) {
            return false;
        }
        if (this.hasDeletionProtectionEnabled() && this.getDeletionProtectionEnabled() != other.getDeletionProtectionEnabled()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Cluster.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        if (this.hasCreateTime()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getCreateTime().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.state_;
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getUid().hashCode();
        if (this.hasReplicaCount()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getReplicaCount();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.authorizationMode_;
        hash = 37 * hash + 12;
        hash = 53 * hash + this.transitEncryptionMode_;
        if (this.hasSizeGb()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getSizeGb();
        }
        if (this.hasShardCount()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getShardCount();
        }
        if (this.getPscConfigsCount() > 0) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getPscConfigsList().hashCode();
        }
        if (this.getDiscoveryEndpointsCount() > 0) {
            hash = 37 * hash + 16;
            hash = 53 * hash + this.getDiscoveryEndpointsList().hashCode();
        }
        if (this.getPscConnectionsCount() > 0) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getPscConnectionsList().hashCode();
        }
        if (this.hasStateInfo()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getStateInfo().hashCode();
        }
        hash = 37 * hash + 19;
        hash = 53 * hash + this.nodeType_;
        if (this.hasPersistenceConfig()) {
            hash = 37 * hash + 20;
            hash = 53 * hash + this.getPersistenceConfig().hashCode();
        }
        if (!this.internalGetRedisConfigs().getMap().isEmpty()) {
            hash = 37 * hash + 21;
            hash = 53 * hash + this.internalGetRedisConfigs().hashCode();
        }
        if (this.hasPreciseSizeGb()) {
            hash = 37 * hash + 22;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getPreciseSizeGb()));
        }
        if (this.hasZoneDistributionConfig()) {
            hash = 37 * hash + 23;
            hash = 53 * hash + this.getZoneDistributionConfig().hashCode();
        }
        if (this.hasDeletionProtectionEnabled()) {
            hash = 37 * hash + 25;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getDeletionProtectionEnabled());
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Cluster parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Cluster)PARSER.parseFrom(data);
    }

    public static Cluster parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Cluster)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Cluster parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Cluster)PARSER.parseFrom(data);
    }

    public static Cluster parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Cluster)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Cluster parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Cluster)PARSER.parseFrom(data);
    }

    public static Cluster parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Cluster)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Cluster parseFrom(InputStream input) throws IOException {
        return (Cluster)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Cluster parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Cluster)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Cluster parseDelimitedFrom(InputStream input) throws IOException {
        return (Cluster)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Cluster parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Cluster)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Cluster parseFrom(CodedInputStream input) throws IOException {
        return (Cluster)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Cluster parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Cluster)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Cluster.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Cluster prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Cluster getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Cluster> parser() {
        return PARSER;
    }

    public Parser<Cluster> getParserForType() {
        return PARSER;
    }

    public Cluster getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ClusterOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Timestamp createTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createTimeBuilder_;
        private int state_ = 0;
        private Object uid_ = "";
        private int replicaCount_;
        private int authorizationMode_ = 0;
        private int transitEncryptionMode_ = 0;
        private int sizeGb_;
        private int shardCount_;
        private List<PscConfig> pscConfigs_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<PscConfig, PscConfig.Builder, PscConfigOrBuilder> pscConfigsBuilder_;
        private List<DiscoveryEndpoint> discoveryEndpoints_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<DiscoveryEndpoint, DiscoveryEndpoint.Builder, DiscoveryEndpointOrBuilder> discoveryEndpointsBuilder_;
        private List<PscConnection> pscConnections_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<PscConnection, PscConnection.Builder, PscConnectionOrBuilder> pscConnectionsBuilder_;
        private StateInfo stateInfo_;
        private SingleFieldBuilderV3<StateInfo, StateInfo.Builder, StateInfoOrBuilder> stateInfoBuilder_;
        private int nodeType_ = 0;
        private ClusterPersistenceConfig persistenceConfig_;
        private SingleFieldBuilderV3<ClusterPersistenceConfig, ClusterPersistenceConfig.Builder, ClusterPersistenceConfigOrBuilder> persistenceConfigBuilder_;
        private MapField<String, String> redisConfigs_;
        private double preciseSizeGb_;
        private ZoneDistributionConfig zoneDistributionConfig_;
        private SingleFieldBuilderV3<ZoneDistributionConfig, ZoneDistributionConfig.Builder, ZoneDistributionConfigOrBuilder> zoneDistributionConfigBuilder_;
        private boolean deletionProtectionEnabled_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 21: {
                    return this.internalGetRedisConfigs();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 21: {
                    return this.internalGetMutableRedisConfigs();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_fieldAccessorTable.ensureFieldAccessorsInitialized(Cluster.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getCreateTimeFieldBuilder();
                this.getPscConfigsFieldBuilder();
                this.getDiscoveryEndpointsFieldBuilder();
                this.getPscConnectionsFieldBuilder();
                this.getStateInfoFieldBuilder();
                this.getPersistenceConfigFieldBuilder();
                this.getZoneDistributionConfigFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.state_ = 0;
            this.uid_ = "";
            this.replicaCount_ = 0;
            this.authorizationMode_ = 0;
            this.transitEncryptionMode_ = 0;
            this.sizeGb_ = 0;
            this.shardCount_ = 0;
            if (this.pscConfigsBuilder_ == null) {
                this.pscConfigs_ = Collections.emptyList();
            } else {
                this.pscConfigs_ = null;
                this.pscConfigsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            if (this.discoveryEndpointsBuilder_ == null) {
                this.discoveryEndpoints_ = Collections.emptyList();
            } else {
                this.discoveryEndpoints_ = null;
                this.discoveryEndpointsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFBFF;
            if (this.pscConnectionsBuilder_ == null) {
                this.pscConnections_ = Collections.emptyList();
            } else {
                this.pscConnections_ = null;
                this.pscConnectionsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFF7FF;
            this.stateInfo_ = null;
            if (this.stateInfoBuilder_ != null) {
                this.stateInfoBuilder_.dispose();
                this.stateInfoBuilder_ = null;
            }
            this.nodeType_ = 0;
            this.persistenceConfig_ = null;
            if (this.persistenceConfigBuilder_ != null) {
                this.persistenceConfigBuilder_.dispose();
                this.persistenceConfigBuilder_ = null;
            }
            this.internalGetMutableRedisConfigs().clear();
            this.preciseSizeGb_ = 0.0;
            this.zoneDistributionConfig_ = null;
            if (this.zoneDistributionConfigBuilder_ != null) {
                this.zoneDistributionConfigBuilder_.dispose();
                this.zoneDistributionConfigBuilder_ = null;
            }
            this.deletionProtectionEnabled_ = false;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_descriptor;
        }

        public Cluster getDefaultInstanceForType() {
            return Cluster.getDefaultInstance();
        }

        public Cluster build() {
            Cluster result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Cluster buildPartial() {
            Cluster result = new Cluster(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Cluster result) {
            if (this.pscConfigsBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.pscConfigs_ = Collections.unmodifiableList(this.pscConfigs_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.pscConfigs_ = this.pscConfigs_;
            } else {
                result.pscConfigs_ = this.pscConfigsBuilder_.build();
            }
            if (this.discoveryEndpointsBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0) {
                    this.discoveryEndpoints_ = Collections.unmodifiableList(this.discoveryEndpoints_);
                    this.bitField0_ &= 0xFFFFFBFF;
                }
                result.discoveryEndpoints_ = this.discoveryEndpoints_;
            } else {
                result.discoveryEndpoints_ = this.discoveryEndpointsBuilder_.build();
            }
            if (this.pscConnectionsBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0) {
                    this.pscConnections_ = Collections.unmodifiableList(this.pscConnections_);
                    this.bitField0_ &= 0xFFFFF7FF;
                }
                result.pscConnections_ = this.pscConnections_;
            } else {
                result.pscConnections_ = this.pscConnectionsBuilder_.build();
            }
        }

        private void buildPartial0(Cluster result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.createTime_ = this.createTimeBuilder_ == null ? this.createTime_ : (Timestamp)this.createTimeBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.state_ = this.state_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.uid_ = this.uid_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.replicaCount_ = this.replicaCount_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.authorizationMode_ = this.authorizationMode_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.transitEncryptionMode_ = this.transitEncryptionMode_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.sizeGb_ = this.sizeGb_;
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.shardCount_ = this.shardCount_;
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.stateInfo_ = this.stateInfoBuilder_ == null ? this.stateInfo_ : (StateInfo)this.stateInfoBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.nodeType_ = this.nodeType_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.persistenceConfig_ = this.persistenceConfigBuilder_ == null ? this.persistenceConfig_ : (ClusterPersistenceConfig)this.persistenceConfigBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.redisConfigs_ = this.internalGetRedisConfigs();
                result.redisConfigs_.makeImmutable();
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.preciseSizeGb_ = this.preciseSizeGb_;
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.zoneDistributionConfig_ = this.zoneDistributionConfigBuilder_ == null ? this.zoneDistributionConfig_ : (ZoneDistributionConfig)this.zoneDistributionConfigBuilder_.build();
                to_bitField0_ |= 0x80;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.deletionProtectionEnabled_ = this.deletionProtectionEnabled_;
                to_bitField0_ |= 0x100;
            }
            Cluster cluster = result;
            cluster.bitField0_ = cluster.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Cluster) {
                return this.mergeFrom((Cluster)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Cluster other) {
            if (other == Cluster.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasCreateTime()) {
                this.mergeCreateTime(other.getCreateTime());
            }
            if (other.state_ != 0) {
                this.setStateValue(other.getStateValue());
            }
            if (!other.getUid().isEmpty()) {
                this.uid_ = other.uid_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.hasReplicaCount()) {
                this.setReplicaCount(other.getReplicaCount());
            }
            if (other.authorizationMode_ != 0) {
                this.setAuthorizationModeValue(other.getAuthorizationModeValue());
            }
            if (other.transitEncryptionMode_ != 0) {
                this.setTransitEncryptionModeValue(other.getTransitEncryptionModeValue());
            }
            if (other.hasSizeGb()) {
                this.setSizeGb(other.getSizeGb());
            }
            if (other.hasShardCount()) {
                this.setShardCount(other.getShardCount());
            }
            if (this.pscConfigsBuilder_ == null) {
                if (!other.pscConfigs_.isEmpty()) {
                    if (this.pscConfigs_.isEmpty()) {
                        this.pscConfigs_ = other.pscConfigs_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensurePscConfigsIsMutable();
                        this.pscConfigs_.addAll(other.pscConfigs_);
                    }
                    this.onChanged();
                }
            } else if (!other.pscConfigs_.isEmpty()) {
                if (this.pscConfigsBuilder_.isEmpty()) {
                    this.pscConfigsBuilder_.dispose();
                    this.pscConfigsBuilder_ = null;
                    this.pscConfigs_ = other.pscConfigs_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.pscConfigsBuilder_ = alwaysUseFieldBuilders ? this.getPscConfigsFieldBuilder() : null;
                } else {
                    this.pscConfigsBuilder_.addAllMessages((Iterable)other.pscConfigs_);
                }
            }
            if (this.discoveryEndpointsBuilder_ == null) {
                if (!other.discoveryEndpoints_.isEmpty()) {
                    if (this.discoveryEndpoints_.isEmpty()) {
                        this.discoveryEndpoints_ = other.discoveryEndpoints_;
                        this.bitField0_ &= 0xFFFFFBFF;
                    } else {
                        this.ensureDiscoveryEndpointsIsMutable();
                        this.discoveryEndpoints_.addAll(other.discoveryEndpoints_);
                    }
                    this.onChanged();
                }
            } else if (!other.discoveryEndpoints_.isEmpty()) {
                if (this.discoveryEndpointsBuilder_.isEmpty()) {
                    this.discoveryEndpointsBuilder_.dispose();
                    this.discoveryEndpointsBuilder_ = null;
                    this.discoveryEndpoints_ = other.discoveryEndpoints_;
                    this.bitField0_ &= 0xFFFFFBFF;
                    this.discoveryEndpointsBuilder_ = alwaysUseFieldBuilders ? this.getDiscoveryEndpointsFieldBuilder() : null;
                } else {
                    this.discoveryEndpointsBuilder_.addAllMessages((Iterable)other.discoveryEndpoints_);
                }
            }
            if (this.pscConnectionsBuilder_ == null) {
                if (!other.pscConnections_.isEmpty()) {
                    if (this.pscConnections_.isEmpty()) {
                        this.pscConnections_ = other.pscConnections_;
                        this.bitField0_ &= 0xFFFFF7FF;
                    } else {
                        this.ensurePscConnectionsIsMutable();
                        this.pscConnections_.addAll(other.pscConnections_);
                    }
                    this.onChanged();
                }
            } else if (!other.pscConnections_.isEmpty()) {
                if (this.pscConnectionsBuilder_.isEmpty()) {
                    this.pscConnectionsBuilder_.dispose();
                    this.pscConnectionsBuilder_ = null;
                    this.pscConnections_ = other.pscConnections_;
                    this.bitField0_ &= 0xFFFFF7FF;
                    this.pscConnectionsBuilder_ = alwaysUseFieldBuilders ? this.getPscConnectionsFieldBuilder() : null;
                } else {
                    this.pscConnectionsBuilder_.addAllMessages((Iterable)other.pscConnections_);
                }
            }
            if (other.hasStateInfo()) {
                this.mergeStateInfo(other.getStateInfo());
            }
            if (other.nodeType_ != 0) {
                this.setNodeTypeValue(other.getNodeTypeValue());
            }
            if (other.hasPersistenceConfig()) {
                this.mergePersistenceConfig(other.getPersistenceConfig());
            }
            this.internalGetMutableRedisConfigs().mergeFrom(other.internalGetRedisConfigs());
            this.bitField0_ |= 0x8000;
            if (other.hasPreciseSizeGb()) {
                this.setPreciseSizeGb(other.getPreciseSizeGb());
            }
            if (other.hasZoneDistributionConfig()) {
                this.mergeZoneDistributionConfig(other.getZoneDistributionConfig());
            }
            if (other.hasDeletionProtectionEnabled()) {
                this.setDeletionProtectionEnabled(other.getDeletionProtectionEnabled());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block27: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block27;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block27;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block27;
                        }
                        case 32: {
                            this.state_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block27;
                        }
                        case 42: {
                            this.uid_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block27;
                        }
                        case 64: {
                            this.replicaCount_ = input.readInt32();
                            this.bitField0_ |= 0x10;
                            continue block27;
                        }
                        case 88: {
                            this.authorizationMode_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block27;
                        }
                        case 96: {
                            this.transitEncryptionMode_ = input.readEnum();
                            this.bitField0_ |= 0x40;
                            continue block27;
                        }
                        case 104: {
                            this.sizeGb_ = input.readInt32();
                            this.bitField0_ |= 0x80;
                            continue block27;
                        }
                        case 112: {
                            this.shardCount_ = input.readInt32();
                            this.bitField0_ |= 0x100;
                            continue block27;
                        }
                        case 122: {
                            GeneratedMessageV3 m = (PscConfig)input.readMessage(PscConfig.parser(), extensionRegistry);
                            if (this.pscConfigsBuilder_ == null) {
                                this.ensurePscConfigsIsMutable();
                                this.pscConfigs_.add((PscConfig)m);
                                continue block27;
                            }
                            this.pscConfigsBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 130: {
                            GeneratedMessageV3 m = (DiscoveryEndpoint)input.readMessage(DiscoveryEndpoint.parser(), extensionRegistry);
                            if (this.discoveryEndpointsBuilder_ == null) {
                                this.ensureDiscoveryEndpointsIsMutable();
                                this.discoveryEndpoints_.add((DiscoveryEndpoint)m);
                                continue block27;
                            }
                            this.discoveryEndpointsBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 138: {
                            GeneratedMessageV3 m = (PscConnection)input.readMessage(PscConnection.parser(), extensionRegistry);
                            if (this.pscConnectionsBuilder_ == null) {
                                this.ensurePscConnectionsIsMutable();
                                this.pscConnections_.add((PscConnection)m);
                                continue block27;
                            }
                            this.pscConnectionsBuilder_.addMessage((AbstractMessage)m);
                            continue block27;
                        }
                        case 146: {
                            input.readMessage((MessageLite.Builder)this.getStateInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block27;
                        }
                        case 152: {
                            this.nodeType_ = input.readEnum();
                            this.bitField0_ |= 0x2000;
                            continue block27;
                        }
                        case 162: {
                            input.readMessage((MessageLite.Builder)this.getPersistenceConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x4000;
                            continue block27;
                        }
                        case 170: {
                            MapEntry redisConfigs__ = (MapEntry)input.readMessage(RedisConfigsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableRedisConfigs().getMutableMap().put(redisConfigs__.getKey(), redisConfigs__.getValue());
                            this.bitField0_ |= 0x8000;
                            continue block27;
                        }
                        case 177: {
                            this.preciseSizeGb_ = input.readDouble();
                            this.bitField0_ |= 0x10000;
                            continue block27;
                        }
                        case 186: {
                            input.readMessage((MessageLite.Builder)this.getZoneDistributionConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20000;
                            continue block27;
                        }
                        case 200: {
                            this.deletionProtectionEnabled_ = input.readBool();
                            this.bitField0_ |= 0x40000;
                            continue block27;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Cluster.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Cluster.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreateTime() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Timestamp getCreateTime() {
            if (this.createTimeBuilder_ == null) {
                return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
            }
            return (Timestamp)this.createTimeBuilder_.getMessage();
        }

        public Builder setCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createTime_ = value;
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setCreateTime(Timestamp.Builder builderForValue) {
            if (this.createTimeBuilder_ == null) {
                this.createTime_ = builderForValue.build();
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.createTime_ != null && this.createTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.createTime_ = value;
                }
            } else {
                this.createTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.createTime_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCreateTime() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreateTimeBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (Timestamp.Builder)this.getCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreateTimeOrBuilder() {
            if (this.createTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.createTimeBuilder_.getMessageOrBuilder();
            }
            return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreateTimeFieldBuilder() {
            if (this.createTimeBuilder_ == null) {
                this.createTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createTime_ = null;
            }
            return this.createTimeBuilder_;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        public Builder setStateValue(int value) {
            this.state_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        public Builder setState(State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.state_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.state_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getUid() {
            Object ref = this.uid_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.uid_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getUidBytes() {
            Object ref = this.uid_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.uid_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setUid(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.uid_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearUid() {
            this.uid_ = Cluster.getDefaultInstance().getUid();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setUidBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Cluster.checkByteStringIsUtf8((ByteString)value);
            this.uid_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasReplicaCount() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public int getReplicaCount() {
            return this.replicaCount_;
        }

        public Builder setReplicaCount(int value) {
            this.replicaCount_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearReplicaCount() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.replicaCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getAuthorizationModeValue() {
            return this.authorizationMode_;
        }

        public Builder setAuthorizationModeValue(int value) {
            this.authorizationMode_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public AuthorizationMode getAuthorizationMode() {
            AuthorizationMode result = AuthorizationMode.forNumber(this.authorizationMode_);
            return result == null ? AuthorizationMode.UNRECOGNIZED : result;
        }

        public Builder setAuthorizationMode(AuthorizationMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.authorizationMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAuthorizationMode() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.authorizationMode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getTransitEncryptionModeValue() {
            return this.transitEncryptionMode_;
        }

        public Builder setTransitEncryptionModeValue(int value) {
            this.transitEncryptionMode_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public TransitEncryptionMode getTransitEncryptionMode() {
            TransitEncryptionMode result = TransitEncryptionMode.forNumber(this.transitEncryptionMode_);
            return result == null ? TransitEncryptionMode.UNRECOGNIZED : result;
        }

        public Builder setTransitEncryptionMode(TransitEncryptionMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40;
            this.transitEncryptionMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearTransitEncryptionMode() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.transitEncryptionMode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSizeGb() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public int getSizeGb() {
            return this.sizeGb_;
        }

        public Builder setSizeGb(int value) {
            this.sizeGb_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearSizeGb() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.sizeGb_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasShardCount() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public int getShardCount() {
            return this.shardCount_;
        }

        public Builder setShardCount(int value) {
            this.shardCount_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearShardCount() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.shardCount_ = 0;
            this.onChanged();
            return this;
        }

        private void ensurePscConfigsIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.pscConfigs_ = new ArrayList<PscConfig>(this.pscConfigs_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<PscConfig> getPscConfigsList() {
            if (this.pscConfigsBuilder_ == null) {
                return Collections.unmodifiableList(this.pscConfigs_);
            }
            return this.pscConfigsBuilder_.getMessageList();
        }

        @Override
        public int getPscConfigsCount() {
            if (this.pscConfigsBuilder_ == null) {
                return this.pscConfigs_.size();
            }
            return this.pscConfigsBuilder_.getCount();
        }

        @Override
        public PscConfig getPscConfigs(int index) {
            if (this.pscConfigsBuilder_ == null) {
                return this.pscConfigs_.get(index);
            }
            return (PscConfig)this.pscConfigsBuilder_.getMessage(index);
        }

        public Builder setPscConfigs(int index, PscConfig value) {
            if (this.pscConfigsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePscConfigsIsMutable();
                this.pscConfigs_.set(index, value);
                this.onChanged();
            } else {
                this.pscConfigsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPscConfigs(int index, PscConfig.Builder builderForValue) {
            if (this.pscConfigsBuilder_ == null) {
                this.ensurePscConfigsIsMutable();
                this.pscConfigs_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.pscConfigsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPscConfigs(PscConfig value) {
            if (this.pscConfigsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePscConfigsIsMutable();
                this.pscConfigs_.add(value);
                this.onChanged();
            } else {
                this.pscConfigsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPscConfigs(int index, PscConfig value) {
            if (this.pscConfigsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePscConfigsIsMutable();
                this.pscConfigs_.add(index, value);
                this.onChanged();
            } else {
                this.pscConfigsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPscConfigs(PscConfig.Builder builderForValue) {
            if (this.pscConfigsBuilder_ == null) {
                this.ensurePscConfigsIsMutable();
                this.pscConfigs_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.pscConfigsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPscConfigs(int index, PscConfig.Builder builderForValue) {
            if (this.pscConfigsBuilder_ == null) {
                this.ensurePscConfigsIsMutable();
                this.pscConfigs_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.pscConfigsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPscConfigs(Iterable<? extends PscConfig> values) {
            if (this.pscConfigsBuilder_ == null) {
                this.ensurePscConfigsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.pscConfigs_);
                this.onChanged();
            } else {
                this.pscConfigsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPscConfigs() {
            if (this.pscConfigsBuilder_ == null) {
                this.pscConfigs_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.pscConfigsBuilder_.clear();
            }
            return this;
        }

        public Builder removePscConfigs(int index) {
            if (this.pscConfigsBuilder_ == null) {
                this.ensurePscConfigsIsMutable();
                this.pscConfigs_.remove(index);
                this.onChanged();
            } else {
                this.pscConfigsBuilder_.remove(index);
            }
            return this;
        }

        public PscConfig.Builder getPscConfigsBuilder(int index) {
            return (PscConfig.Builder)this.getPscConfigsFieldBuilder().getBuilder(index);
        }

        @Override
        public PscConfigOrBuilder getPscConfigsOrBuilder(int index) {
            if (this.pscConfigsBuilder_ == null) {
                return this.pscConfigs_.get(index);
            }
            return (PscConfigOrBuilder)this.pscConfigsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends PscConfigOrBuilder> getPscConfigsOrBuilderList() {
            if (this.pscConfigsBuilder_ != null) {
                return this.pscConfigsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.pscConfigs_);
        }

        public PscConfig.Builder addPscConfigsBuilder() {
            return (PscConfig.Builder)this.getPscConfigsFieldBuilder().addBuilder((AbstractMessage)PscConfig.getDefaultInstance());
        }

        public PscConfig.Builder addPscConfigsBuilder(int index) {
            return (PscConfig.Builder)this.getPscConfigsFieldBuilder().addBuilder(index, (AbstractMessage)PscConfig.getDefaultInstance());
        }

        public List<PscConfig.Builder> getPscConfigsBuilderList() {
            return this.getPscConfigsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<PscConfig, PscConfig.Builder, PscConfigOrBuilder> getPscConfigsFieldBuilder() {
            if (this.pscConfigsBuilder_ == null) {
                this.pscConfigsBuilder_ = new RepeatedFieldBuilderV3(this.pscConfigs_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.pscConfigs_ = null;
            }
            return this.pscConfigsBuilder_;
        }

        private void ensureDiscoveryEndpointsIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.discoveryEndpoints_ = new ArrayList<DiscoveryEndpoint>(this.discoveryEndpoints_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<DiscoveryEndpoint> getDiscoveryEndpointsList() {
            if (this.discoveryEndpointsBuilder_ == null) {
                return Collections.unmodifiableList(this.discoveryEndpoints_);
            }
            return this.discoveryEndpointsBuilder_.getMessageList();
        }

        @Override
        public int getDiscoveryEndpointsCount() {
            if (this.discoveryEndpointsBuilder_ == null) {
                return this.discoveryEndpoints_.size();
            }
            return this.discoveryEndpointsBuilder_.getCount();
        }

        @Override
        public DiscoveryEndpoint getDiscoveryEndpoints(int index) {
            if (this.discoveryEndpointsBuilder_ == null) {
                return this.discoveryEndpoints_.get(index);
            }
            return (DiscoveryEndpoint)this.discoveryEndpointsBuilder_.getMessage(index);
        }

        public Builder setDiscoveryEndpoints(int index, DiscoveryEndpoint value) {
            if (this.discoveryEndpointsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDiscoveryEndpointsIsMutable();
                this.discoveryEndpoints_.set(index, value);
                this.onChanged();
            } else {
                this.discoveryEndpointsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setDiscoveryEndpoints(int index, DiscoveryEndpoint.Builder builderForValue) {
            if (this.discoveryEndpointsBuilder_ == null) {
                this.ensureDiscoveryEndpointsIsMutable();
                this.discoveryEndpoints_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.discoveryEndpointsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDiscoveryEndpoints(DiscoveryEndpoint value) {
            if (this.discoveryEndpointsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDiscoveryEndpointsIsMutable();
                this.discoveryEndpoints_.add(value);
                this.onChanged();
            } else {
                this.discoveryEndpointsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addDiscoveryEndpoints(int index, DiscoveryEndpoint value) {
            if (this.discoveryEndpointsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDiscoveryEndpointsIsMutable();
                this.discoveryEndpoints_.add(index, value);
                this.onChanged();
            } else {
                this.discoveryEndpointsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addDiscoveryEndpoints(DiscoveryEndpoint.Builder builderForValue) {
            if (this.discoveryEndpointsBuilder_ == null) {
                this.ensureDiscoveryEndpointsIsMutable();
                this.discoveryEndpoints_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.discoveryEndpointsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDiscoveryEndpoints(int index, DiscoveryEndpoint.Builder builderForValue) {
            if (this.discoveryEndpointsBuilder_ == null) {
                this.ensureDiscoveryEndpointsIsMutable();
                this.discoveryEndpoints_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.discoveryEndpointsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllDiscoveryEndpoints(Iterable<? extends DiscoveryEndpoint> values) {
            if (this.discoveryEndpointsBuilder_ == null) {
                this.ensureDiscoveryEndpointsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.discoveryEndpoints_);
                this.onChanged();
            } else {
                this.discoveryEndpointsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearDiscoveryEndpoints() {
            if (this.discoveryEndpointsBuilder_ == null) {
                this.discoveryEndpoints_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFBFF;
                this.onChanged();
            } else {
                this.discoveryEndpointsBuilder_.clear();
            }
            return this;
        }

        public Builder removeDiscoveryEndpoints(int index) {
            if (this.discoveryEndpointsBuilder_ == null) {
                this.ensureDiscoveryEndpointsIsMutable();
                this.discoveryEndpoints_.remove(index);
                this.onChanged();
            } else {
                this.discoveryEndpointsBuilder_.remove(index);
            }
            return this;
        }

        public DiscoveryEndpoint.Builder getDiscoveryEndpointsBuilder(int index) {
            return (DiscoveryEndpoint.Builder)this.getDiscoveryEndpointsFieldBuilder().getBuilder(index);
        }

        @Override
        public DiscoveryEndpointOrBuilder getDiscoveryEndpointsOrBuilder(int index) {
            if (this.discoveryEndpointsBuilder_ == null) {
                return this.discoveryEndpoints_.get(index);
            }
            return (DiscoveryEndpointOrBuilder)this.discoveryEndpointsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends DiscoveryEndpointOrBuilder> getDiscoveryEndpointsOrBuilderList() {
            if (this.discoveryEndpointsBuilder_ != null) {
                return this.discoveryEndpointsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.discoveryEndpoints_);
        }

        public DiscoveryEndpoint.Builder addDiscoveryEndpointsBuilder() {
            return (DiscoveryEndpoint.Builder)this.getDiscoveryEndpointsFieldBuilder().addBuilder((AbstractMessage)DiscoveryEndpoint.getDefaultInstance());
        }

        public DiscoveryEndpoint.Builder addDiscoveryEndpointsBuilder(int index) {
            return (DiscoveryEndpoint.Builder)this.getDiscoveryEndpointsFieldBuilder().addBuilder(index, (AbstractMessage)DiscoveryEndpoint.getDefaultInstance());
        }

        public List<DiscoveryEndpoint.Builder> getDiscoveryEndpointsBuilderList() {
            return this.getDiscoveryEndpointsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<DiscoveryEndpoint, DiscoveryEndpoint.Builder, DiscoveryEndpointOrBuilder> getDiscoveryEndpointsFieldBuilder() {
            if (this.discoveryEndpointsBuilder_ == null) {
                this.discoveryEndpointsBuilder_ = new RepeatedFieldBuilderV3(this.discoveryEndpoints_, (this.bitField0_ & 0x400) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.discoveryEndpoints_ = null;
            }
            return this.discoveryEndpointsBuilder_;
        }

        private void ensurePscConnectionsIsMutable() {
            if ((this.bitField0_ & 0x800) == 0) {
                this.pscConnections_ = new ArrayList<PscConnection>(this.pscConnections_);
                this.bitField0_ |= 0x800;
            }
        }

        @Override
        public List<PscConnection> getPscConnectionsList() {
            if (this.pscConnectionsBuilder_ == null) {
                return Collections.unmodifiableList(this.pscConnections_);
            }
            return this.pscConnectionsBuilder_.getMessageList();
        }

        @Override
        public int getPscConnectionsCount() {
            if (this.pscConnectionsBuilder_ == null) {
                return this.pscConnections_.size();
            }
            return this.pscConnectionsBuilder_.getCount();
        }

        @Override
        public PscConnection getPscConnections(int index) {
            if (this.pscConnectionsBuilder_ == null) {
                return this.pscConnections_.get(index);
            }
            return (PscConnection)this.pscConnectionsBuilder_.getMessage(index);
        }

        public Builder setPscConnections(int index, PscConnection value) {
            if (this.pscConnectionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePscConnectionsIsMutable();
                this.pscConnections_.set(index, value);
                this.onChanged();
            } else {
                this.pscConnectionsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setPscConnections(int index, PscConnection.Builder builderForValue) {
            if (this.pscConnectionsBuilder_ == null) {
                this.ensurePscConnectionsIsMutable();
                this.pscConnections_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.pscConnectionsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPscConnections(PscConnection value) {
            if (this.pscConnectionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePscConnectionsIsMutable();
                this.pscConnections_.add(value);
                this.onChanged();
            } else {
                this.pscConnectionsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addPscConnections(int index, PscConnection value) {
            if (this.pscConnectionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePscConnectionsIsMutable();
                this.pscConnections_.add(index, value);
                this.onChanged();
            } else {
                this.pscConnectionsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addPscConnections(PscConnection.Builder builderForValue) {
            if (this.pscConnectionsBuilder_ == null) {
                this.ensurePscConnectionsIsMutable();
                this.pscConnections_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.pscConnectionsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addPscConnections(int index, PscConnection.Builder builderForValue) {
            if (this.pscConnectionsBuilder_ == null) {
                this.ensurePscConnectionsIsMutable();
                this.pscConnections_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.pscConnectionsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllPscConnections(Iterable<? extends PscConnection> values) {
            if (this.pscConnectionsBuilder_ == null) {
                this.ensurePscConnectionsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.pscConnections_);
                this.onChanged();
            } else {
                this.pscConnectionsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearPscConnections() {
            if (this.pscConnectionsBuilder_ == null) {
                this.pscConnections_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFF7FF;
                this.onChanged();
            } else {
                this.pscConnectionsBuilder_.clear();
            }
            return this;
        }

        public Builder removePscConnections(int index) {
            if (this.pscConnectionsBuilder_ == null) {
                this.ensurePscConnectionsIsMutable();
                this.pscConnections_.remove(index);
                this.onChanged();
            } else {
                this.pscConnectionsBuilder_.remove(index);
            }
            return this;
        }

        public PscConnection.Builder getPscConnectionsBuilder(int index) {
            return (PscConnection.Builder)this.getPscConnectionsFieldBuilder().getBuilder(index);
        }

        @Override
        public PscConnectionOrBuilder getPscConnectionsOrBuilder(int index) {
            if (this.pscConnectionsBuilder_ == null) {
                return this.pscConnections_.get(index);
            }
            return (PscConnectionOrBuilder)this.pscConnectionsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends PscConnectionOrBuilder> getPscConnectionsOrBuilderList() {
            if (this.pscConnectionsBuilder_ != null) {
                return this.pscConnectionsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.pscConnections_);
        }

        public PscConnection.Builder addPscConnectionsBuilder() {
            return (PscConnection.Builder)this.getPscConnectionsFieldBuilder().addBuilder((AbstractMessage)PscConnection.getDefaultInstance());
        }

        public PscConnection.Builder addPscConnectionsBuilder(int index) {
            return (PscConnection.Builder)this.getPscConnectionsFieldBuilder().addBuilder(index, (AbstractMessage)PscConnection.getDefaultInstance());
        }

        public List<PscConnection.Builder> getPscConnectionsBuilderList() {
            return this.getPscConnectionsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<PscConnection, PscConnection.Builder, PscConnectionOrBuilder> getPscConnectionsFieldBuilder() {
            if (this.pscConnectionsBuilder_ == null) {
                this.pscConnectionsBuilder_ = new RepeatedFieldBuilderV3(this.pscConnections_, (this.bitField0_ & 0x800) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.pscConnections_ = null;
            }
            return this.pscConnectionsBuilder_;
        }

        @Override
        public boolean hasStateInfo() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public StateInfo getStateInfo() {
            if (this.stateInfoBuilder_ == null) {
                return this.stateInfo_ == null ? StateInfo.getDefaultInstance() : this.stateInfo_;
            }
            return (StateInfo)this.stateInfoBuilder_.getMessage();
        }

        public Builder setStateInfo(StateInfo value) {
            if (this.stateInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.stateInfo_ = value;
            } else {
                this.stateInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setStateInfo(StateInfo.Builder builderForValue) {
            if (this.stateInfoBuilder_ == null) {
                this.stateInfo_ = builderForValue.build();
            } else {
                this.stateInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeStateInfo(StateInfo value) {
            if (this.stateInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.stateInfo_ != null && this.stateInfo_ != StateInfo.getDefaultInstance()) {
                    this.getStateInfoBuilder().mergeFrom(value);
                } else {
                    this.stateInfo_ = value;
                }
            } else {
                this.stateInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.stateInfo_ != null) {
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearStateInfo() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.stateInfo_ = null;
            if (this.stateInfoBuilder_ != null) {
                this.stateInfoBuilder_.dispose();
                this.stateInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public StateInfo.Builder getStateInfoBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (StateInfo.Builder)this.getStateInfoFieldBuilder().getBuilder();
        }

        @Override
        public StateInfoOrBuilder getStateInfoOrBuilder() {
            if (this.stateInfoBuilder_ != null) {
                return (StateInfoOrBuilder)this.stateInfoBuilder_.getMessageOrBuilder();
            }
            return this.stateInfo_ == null ? StateInfo.getDefaultInstance() : this.stateInfo_;
        }

        private SingleFieldBuilderV3<StateInfo, StateInfo.Builder, StateInfoOrBuilder> getStateInfoFieldBuilder() {
            if (this.stateInfoBuilder_ == null) {
                this.stateInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStateInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.stateInfo_ = null;
            }
            return this.stateInfoBuilder_;
        }

        @Override
        public int getNodeTypeValue() {
            return this.nodeType_;
        }

        public Builder setNodeTypeValue(int value) {
            this.nodeType_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        @Override
        public NodeType getNodeType() {
            NodeType result = NodeType.forNumber(this.nodeType_);
            return result == null ? NodeType.UNRECOGNIZED : result;
        }

        public Builder setNodeType(NodeType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x2000;
            this.nodeType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearNodeType() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.nodeType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPersistenceConfig() {
            return (this.bitField0_ & 0x4000) != 0;
        }

        @Override
        public ClusterPersistenceConfig getPersistenceConfig() {
            if (this.persistenceConfigBuilder_ == null) {
                return this.persistenceConfig_ == null ? ClusterPersistenceConfig.getDefaultInstance() : this.persistenceConfig_;
            }
            return (ClusterPersistenceConfig)this.persistenceConfigBuilder_.getMessage();
        }

        public Builder setPersistenceConfig(ClusterPersistenceConfig value) {
            if (this.persistenceConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.persistenceConfig_ = value;
            } else {
                this.persistenceConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder setPersistenceConfig(ClusterPersistenceConfig.Builder builderForValue) {
            if (this.persistenceConfigBuilder_ == null) {
                this.persistenceConfig_ = builderForValue.build();
            } else {
                this.persistenceConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder mergePersistenceConfig(ClusterPersistenceConfig value) {
            if (this.persistenceConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x4000) != 0 && this.persistenceConfig_ != null && this.persistenceConfig_ != ClusterPersistenceConfig.getDefaultInstance()) {
                    this.getPersistenceConfigBuilder().mergeFrom(value);
                } else {
                    this.persistenceConfig_ = value;
                }
            } else {
                this.persistenceConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.persistenceConfig_ != null) {
                this.bitField0_ |= 0x4000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPersistenceConfig() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.persistenceConfig_ = null;
            if (this.persistenceConfigBuilder_ != null) {
                this.persistenceConfigBuilder_.dispose();
                this.persistenceConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ClusterPersistenceConfig.Builder getPersistenceConfigBuilder() {
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return (ClusterPersistenceConfig.Builder)this.getPersistenceConfigFieldBuilder().getBuilder();
        }

        @Override
        public ClusterPersistenceConfigOrBuilder getPersistenceConfigOrBuilder() {
            if (this.persistenceConfigBuilder_ != null) {
                return (ClusterPersistenceConfigOrBuilder)this.persistenceConfigBuilder_.getMessageOrBuilder();
            }
            return this.persistenceConfig_ == null ? ClusterPersistenceConfig.getDefaultInstance() : this.persistenceConfig_;
        }

        private SingleFieldBuilderV3<ClusterPersistenceConfig, ClusterPersistenceConfig.Builder, ClusterPersistenceConfigOrBuilder> getPersistenceConfigFieldBuilder() {
            if (this.persistenceConfigBuilder_ == null) {
                this.persistenceConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPersistenceConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.persistenceConfig_ = null;
            }
            return this.persistenceConfigBuilder_;
        }

        private MapField<String, String> internalGetRedisConfigs() {
            if (this.redisConfigs_ == null) {
                return MapField.emptyMapField(RedisConfigsDefaultEntryHolder.defaultEntry);
            }
            return this.redisConfigs_;
        }

        private MapField<String, String> internalGetMutableRedisConfigs() {
            if (this.redisConfigs_ == null) {
                this.redisConfigs_ = MapField.newMapField(RedisConfigsDefaultEntryHolder.defaultEntry);
            }
            if (!this.redisConfigs_.isMutable()) {
                this.redisConfigs_ = this.redisConfigs_.copy();
            }
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this.redisConfigs_;
        }

        @Override
        public int getRedisConfigsCount() {
            return this.internalGetRedisConfigs().getMap().size();
        }

        @Override
        public boolean containsRedisConfigs(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetRedisConfigs().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getRedisConfigs() {
            return this.getRedisConfigsMap();
        }

        @Override
        public Map<String, String> getRedisConfigsMap() {
            return this.internalGetRedisConfigs().getMap();
        }

        @Override
        public String getRedisConfigsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetRedisConfigs().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getRedisConfigsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetRedisConfigs().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearRedisConfigs() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.internalGetMutableRedisConfigs().getMutableMap().clear();
            return this;
        }

        public Builder removeRedisConfigs(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableRedisConfigs().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableRedisConfigs() {
            this.bitField0_ |= 0x8000;
            return this.internalGetMutableRedisConfigs().getMutableMap();
        }

        public Builder putRedisConfigs(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableRedisConfigs().getMutableMap().put(key, value);
            this.bitField0_ |= 0x8000;
            return this;
        }

        public Builder putAllRedisConfigs(Map<String, String> values) {
            this.internalGetMutableRedisConfigs().getMutableMap().putAll(values);
            this.bitField0_ |= 0x8000;
            return this;
        }

        @Override
        public boolean hasPreciseSizeGb() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public double getPreciseSizeGb() {
            return this.preciseSizeGb_;
        }

        public Builder setPreciseSizeGb(double value) {
            this.preciseSizeGb_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearPreciseSizeGb() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.preciseSizeGb_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasZoneDistributionConfig() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public ZoneDistributionConfig getZoneDistributionConfig() {
            if (this.zoneDistributionConfigBuilder_ == null) {
                return this.zoneDistributionConfig_ == null ? ZoneDistributionConfig.getDefaultInstance() : this.zoneDistributionConfig_;
            }
            return (ZoneDistributionConfig)this.zoneDistributionConfigBuilder_.getMessage();
        }

        public Builder setZoneDistributionConfig(ZoneDistributionConfig value) {
            if (this.zoneDistributionConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.zoneDistributionConfig_ = value;
            } else {
                this.zoneDistributionConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder setZoneDistributionConfig(ZoneDistributionConfig.Builder builderForValue) {
            if (this.zoneDistributionConfigBuilder_ == null) {
                this.zoneDistributionConfig_ = builderForValue.build();
            } else {
                this.zoneDistributionConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder mergeZoneDistributionConfig(ZoneDistributionConfig value) {
            if (this.zoneDistributionConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x20000) != 0 && this.zoneDistributionConfig_ != null && this.zoneDistributionConfig_ != ZoneDistributionConfig.getDefaultInstance()) {
                    this.getZoneDistributionConfigBuilder().mergeFrom(value);
                } else {
                    this.zoneDistributionConfig_ = value;
                }
            } else {
                this.zoneDistributionConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.zoneDistributionConfig_ != null) {
                this.bitField0_ |= 0x20000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearZoneDistributionConfig() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.zoneDistributionConfig_ = null;
            if (this.zoneDistributionConfigBuilder_ != null) {
                this.zoneDistributionConfigBuilder_.dispose();
                this.zoneDistributionConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ZoneDistributionConfig.Builder getZoneDistributionConfigBuilder() {
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return (ZoneDistributionConfig.Builder)this.getZoneDistributionConfigFieldBuilder().getBuilder();
        }

        @Override
        public ZoneDistributionConfigOrBuilder getZoneDistributionConfigOrBuilder() {
            if (this.zoneDistributionConfigBuilder_ != null) {
                return (ZoneDistributionConfigOrBuilder)this.zoneDistributionConfigBuilder_.getMessageOrBuilder();
            }
            return this.zoneDistributionConfig_ == null ? ZoneDistributionConfig.getDefaultInstance() : this.zoneDistributionConfig_;
        }

        private SingleFieldBuilderV3<ZoneDistributionConfig, ZoneDistributionConfig.Builder, ZoneDistributionConfigOrBuilder> getZoneDistributionConfigFieldBuilder() {
            if (this.zoneDistributionConfigBuilder_ == null) {
                this.zoneDistributionConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getZoneDistributionConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.zoneDistributionConfig_ = null;
            }
            return this.zoneDistributionConfigBuilder_;
        }

        @Override
        public boolean hasDeletionProtectionEnabled() {
            return (this.bitField0_ & 0x40000) != 0;
        }

        @Override
        public boolean getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled_;
        }

        public Builder setDeletionProtectionEnabled(boolean value) {
            this.deletionProtectionEnabled_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder clearDeletionProtectionEnabled() {
            this.bitField0_ &= 0xFFFBFFFF;
            this.deletionProtectionEnabled_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class RedisConfigsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_RedisConfigsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private RedisConfigsDefaultEntryHolder() {
        }
    }

    public static final class StateInfo
    extends GeneratedMessageV3
    implements StateInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        private int infoCase_ = 0;
        private Object info_;
        public static final int UPDATE_INFO_FIELD_NUMBER = 1;
        private byte memoizedIsInitialized = (byte)-1;
        private static final StateInfo DEFAULT_INSTANCE = new StateInfo();
        private static final Parser<StateInfo> PARSER = new AbstractParser<StateInfo>(){

            public StateInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = StateInfo.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private StateInfo(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private StateInfo() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new StateInfo();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_StateInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_StateInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(StateInfo.class, Builder.class);
        }

        @Override
        public InfoCase getInfoCase() {
            return InfoCase.forNumber(this.infoCase_);
        }

        @Override
        public boolean hasUpdateInfo() {
            return this.infoCase_ == 1;
        }

        @Override
        public UpdateInfo getUpdateInfo() {
            if (this.infoCase_ == 1) {
                return (UpdateInfo)this.info_;
            }
            return UpdateInfo.getDefaultInstance();
        }

        @Override
        public UpdateInfoOrBuilder getUpdateInfoOrBuilder() {
            if (this.infoCase_ == 1) {
                return (UpdateInfo)this.info_;
            }
            return UpdateInfo.getDefaultInstance();
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.infoCase_ == 1) {
                output.writeMessage(1, (MessageLite)((UpdateInfo)this.info_));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.infoCase_ == 1) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((UpdateInfo)this.info_));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StateInfo)) {
                return super.equals(obj);
            }
            StateInfo other = (StateInfo)obj;
            if (!this.getInfoCase().equals((Object)other.getInfoCase())) {
                return false;
            }
            switch (this.infoCase_) {
                case 1: {
                    if (this.getUpdateInfo().equals(other.getUpdateInfo())) break;
                    return false;
                }
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + StateInfo.getDescriptor().hashCode();
            switch (this.infoCase_) {
                case 1: {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getUpdateInfo().hashCode();
                    break;
                }
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static StateInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (StateInfo)PARSER.parseFrom(data);
        }

        public static StateInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (StateInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static StateInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (StateInfo)PARSER.parseFrom(data);
        }

        public static StateInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (StateInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static StateInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (StateInfo)PARSER.parseFrom(data);
        }

        public static StateInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (StateInfo)PARSER.parseFrom(data, extensionRegistry);
        }

        public static StateInfo parseFrom(InputStream input) throws IOException {
            return (StateInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static StateInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (StateInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static StateInfo parseDelimitedFrom(InputStream input) throws IOException {
            return (StateInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static StateInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (StateInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static StateInfo parseFrom(CodedInputStream input) throws IOException {
            return (StateInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static StateInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (StateInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return StateInfo.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(StateInfo prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static StateInfo getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<StateInfo> parser() {
            return PARSER;
        }

        public Parser<StateInfo> getParserForType() {
            return PARSER;
        }

        public StateInfo getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements StateInfoOrBuilder {
            private int infoCase_ = 0;
            private Object info_;
            private int bitField0_;
            private SingleFieldBuilderV3<UpdateInfo, UpdateInfo.Builder, UpdateInfoOrBuilder> updateInfoBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_StateInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_StateInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(StateInfo.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                if (this.updateInfoBuilder_ != null) {
                    this.updateInfoBuilder_.clear();
                }
                this.infoCase_ = 0;
                this.info_ = null;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_StateInfo_descriptor;
            }

            public StateInfo getDefaultInstanceForType() {
                return StateInfo.getDefaultInstance();
            }

            public StateInfo build() {
                StateInfo result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public StateInfo buildPartial() {
                StateInfo result = new StateInfo(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.buildPartialOneofs(result);
                this.onBuilt();
                return result;
            }

            private void buildPartial0(StateInfo result) {
                int from_bitField0_ = this.bitField0_;
            }

            private void buildPartialOneofs(StateInfo result) {
                result.infoCase_ = this.infoCase_;
                result.info_ = this.info_;
                if (this.infoCase_ == 1 && this.updateInfoBuilder_ != null) {
                    result.info_ = this.updateInfoBuilder_.build();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof StateInfo) {
                    return this.mergeFrom((StateInfo)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(StateInfo other) {
                if (other == StateInfo.getDefaultInstance()) {
                    return this;
                }
                switch (other.getInfoCase()) {
                    case UPDATE_INFO: {
                        this.mergeUpdateInfo(other.getUpdateInfo());
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getUpdateInfoFieldBuilder().getBuilder(), extensionRegistry);
                                this.infoCase_ = 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public InfoCase getInfoCase() {
                return InfoCase.forNumber(this.infoCase_);
            }

            public Builder clearInfo() {
                this.infoCase_ = 0;
                this.info_ = null;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasUpdateInfo() {
                return this.infoCase_ == 1;
            }

            @Override
            public UpdateInfo getUpdateInfo() {
                if (this.updateInfoBuilder_ == null) {
                    if (this.infoCase_ == 1) {
                        return (UpdateInfo)this.info_;
                    }
                    return UpdateInfo.getDefaultInstance();
                }
                if (this.infoCase_ == 1) {
                    return (UpdateInfo)this.updateInfoBuilder_.getMessage();
                }
                return UpdateInfo.getDefaultInstance();
            }

            public Builder setUpdateInfo(UpdateInfo value) {
                if (this.updateInfoBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.info_ = value;
                    this.onChanged();
                } else {
                    this.updateInfoBuilder_.setMessage((AbstractMessage)value);
                }
                this.infoCase_ = 1;
                return this;
            }

            public Builder setUpdateInfo(UpdateInfo.Builder builderForValue) {
                if (this.updateInfoBuilder_ == null) {
                    this.info_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.updateInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.infoCase_ = 1;
                return this;
            }

            public Builder mergeUpdateInfo(UpdateInfo value) {
                if (this.updateInfoBuilder_ == null) {
                    this.info_ = this.infoCase_ == 1 && this.info_ != UpdateInfo.getDefaultInstance() ? UpdateInfo.newBuilder((UpdateInfo)this.info_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.infoCase_ == 1) {
                    this.updateInfoBuilder_.mergeFrom((AbstractMessage)value);
                } else {
                    this.updateInfoBuilder_.setMessage((AbstractMessage)value);
                }
                this.infoCase_ = 1;
                return this;
            }

            public Builder clearUpdateInfo() {
                if (this.updateInfoBuilder_ == null) {
                    if (this.infoCase_ == 1) {
                        this.infoCase_ = 0;
                        this.info_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.infoCase_ == 1) {
                        this.infoCase_ = 0;
                        this.info_ = null;
                    }
                    this.updateInfoBuilder_.clear();
                }
                return this;
            }

            public UpdateInfo.Builder getUpdateInfoBuilder() {
                return (UpdateInfo.Builder)this.getUpdateInfoFieldBuilder().getBuilder();
            }

            @Override
            public UpdateInfoOrBuilder getUpdateInfoOrBuilder() {
                if (this.infoCase_ == 1 && this.updateInfoBuilder_ != null) {
                    return (UpdateInfoOrBuilder)this.updateInfoBuilder_.getMessageOrBuilder();
                }
                if (this.infoCase_ == 1) {
                    return (UpdateInfo)this.info_;
                }
                return UpdateInfo.getDefaultInstance();
            }

            private SingleFieldBuilderV3<UpdateInfo, UpdateInfo.Builder, UpdateInfoOrBuilder> getUpdateInfoFieldBuilder() {
                if (this.updateInfoBuilder_ == null) {
                    if (this.infoCase_ != 1) {
                        this.info_ = UpdateInfo.getDefaultInstance();
                    }
                    this.updateInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((UpdateInfo)this.info_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.info_ = null;
                }
                this.infoCase_ = 1;
                this.onChanged();
                return this.updateInfoBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum InfoCase implements Internal.EnumLite,
        AbstractMessageLite.InternalOneOfEnum
        {
            UPDATE_INFO(1),
            INFO_NOT_SET(0);

            private final int value;

            private InfoCase(int value) {
                this.value = value;
            }

            @Deprecated
            public static InfoCase valueOf(int value) {
                return InfoCase.forNumber(value);
            }

            public static InfoCase forNumber(int value) {
                switch (value) {
                    case 1: {
                        return UPDATE_INFO;
                    }
                    case 0: {
                        return INFO_NOT_SET;
                    }
                }
                return null;
            }

            public int getNumber() {
                return this.value;
            }
        }

        public static final class UpdateInfo
        extends GeneratedMessageV3
        implements UpdateInfoOrBuilder {
            private static final long serialVersionUID = 0L;
            private int bitField0_;
            public static final int TARGET_SHARD_COUNT_FIELD_NUMBER = 1;
            private int targetShardCount_ = 0;
            public static final int TARGET_REPLICA_COUNT_FIELD_NUMBER = 2;
            private int targetReplicaCount_ = 0;
            private byte memoizedIsInitialized = (byte)-1;
            private static final UpdateInfo DEFAULT_INSTANCE = new UpdateInfo();
            private static final Parser<UpdateInfo> PARSER = new AbstractParser<UpdateInfo>(){

                public UpdateInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = UpdateInfo.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private UpdateInfo(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private UpdateInfo() {
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new UpdateInfo();
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_StateInfo_UpdateInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_StateInfo_UpdateInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(UpdateInfo.class, Builder.class);
            }

            @Override
            public boolean hasTargetShardCount() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getTargetShardCount() {
                return this.targetShardCount_;
            }

            @Override
            public boolean hasTargetReplicaCount() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public int getTargetReplicaCount() {
                return this.targetReplicaCount_;
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                if ((this.bitField0_ & 1) != 0) {
                    output.writeInt32(1, this.targetShardCount_);
                }
                if ((this.bitField0_ & 2) != 0) {
                    output.writeInt32(2, this.targetReplicaCount_);
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if ((this.bitField0_ & 1) != 0) {
                    size += CodedOutputStream.computeInt32Size((int)1, (int)this.targetShardCount_);
                }
                if ((this.bitField0_ & 2) != 0) {
                    size += CodedOutputStream.computeInt32Size((int)2, (int)this.targetReplicaCount_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof UpdateInfo)) {
                    return super.equals(obj);
                }
                UpdateInfo other = (UpdateInfo)obj;
                if (this.hasTargetShardCount() != other.hasTargetShardCount()) {
                    return false;
                }
                if (this.hasTargetShardCount() && this.getTargetShardCount() != other.getTargetShardCount()) {
                    return false;
                }
                if (this.hasTargetReplicaCount() != other.hasTargetReplicaCount()) {
                    return false;
                }
                if (this.hasTargetReplicaCount() && this.getTargetReplicaCount() != other.getTargetReplicaCount()) {
                    return false;
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + UpdateInfo.getDescriptor().hashCode();
                if (this.hasTargetShardCount()) {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getTargetShardCount();
                }
                if (this.hasTargetReplicaCount()) {
                    hash = 37 * hash + 2;
                    hash = 53 * hash + this.getTargetReplicaCount();
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static UpdateInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (UpdateInfo)PARSER.parseFrom(data);
            }

            public static UpdateInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (UpdateInfo)PARSER.parseFrom(data, extensionRegistry);
            }

            public static UpdateInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (UpdateInfo)PARSER.parseFrom(data);
            }

            public static UpdateInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (UpdateInfo)PARSER.parseFrom(data, extensionRegistry);
            }

            public static UpdateInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (UpdateInfo)PARSER.parseFrom(data);
            }

            public static UpdateInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (UpdateInfo)PARSER.parseFrom(data, extensionRegistry);
            }

            public static UpdateInfo parseFrom(InputStream input) throws IOException {
                return (UpdateInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static UpdateInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (UpdateInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static UpdateInfo parseDelimitedFrom(InputStream input) throws IOException {
                return (UpdateInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static UpdateInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (UpdateInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static UpdateInfo parseFrom(CodedInputStream input) throws IOException {
                return (UpdateInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static UpdateInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (UpdateInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return UpdateInfo.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(UpdateInfo prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static UpdateInfo getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<UpdateInfo> parser() {
                return PARSER;
            }

            public Parser<UpdateInfo> getParserForType() {
                return PARSER;
            }

            public UpdateInfo getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements UpdateInfoOrBuilder {
                private int bitField0_;
                private int targetShardCount_;
                private int targetReplicaCount_;

                public static final Descriptors.Descriptor getDescriptor() {
                    return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_StateInfo_UpdateInfo_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_StateInfo_UpdateInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(UpdateInfo.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.targetShardCount_ = 0;
                    this.targetReplicaCount_ = 0;
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return CloudRedisClusterProto.internal_static_google_cloud_redis_cluster_v1beta1_Cluster_StateInfo_UpdateInfo_descriptor;
                }

                public UpdateInfo getDefaultInstanceForType() {
                    return UpdateInfo.getDefaultInstance();
                }

                public UpdateInfo build() {
                    UpdateInfo result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public UpdateInfo buildPartial() {
                    UpdateInfo result = new UpdateInfo(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(UpdateInfo result) {
                    int from_bitField0_ = this.bitField0_;
                    int to_bitField0_ = 0;
                    if ((from_bitField0_ & 1) != 0) {
                        result.targetShardCount_ = this.targetShardCount_;
                        to_bitField0_ |= 1;
                    }
                    if ((from_bitField0_ & 2) != 0) {
                        result.targetReplicaCount_ = this.targetReplicaCount_;
                        to_bitField0_ |= 2;
                    }
                    UpdateInfo updateInfo = result;
                    updateInfo.bitField0_ = updateInfo.bitField0_ | to_bitField0_;
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof UpdateInfo) {
                        return this.mergeFrom((UpdateInfo)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(UpdateInfo other) {
                    if (other == UpdateInfo.getDefaultInstance()) {
                        return this;
                    }
                    if (other.hasTargetShardCount()) {
                        this.setTargetShardCount(other.getTargetShardCount());
                    }
                    if (other.hasTargetReplicaCount()) {
                        this.setTargetReplicaCount(other.getTargetReplicaCount());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block10: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block10;
                                }
                                case 8: {
                                    this.targetShardCount_ = input.readInt32();
                                    this.bitField0_ |= 1;
                                    continue block10;
                                }
                                case 16: {
                                    this.targetReplicaCount_ = input.readInt32();
                                    this.bitField0_ |= 2;
                                    continue block10;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public boolean hasTargetShardCount() {
                    return (this.bitField0_ & 1) != 0;
                }

                @Override
                public int getTargetShardCount() {
                    return this.targetShardCount_;
                }

                public Builder setTargetShardCount(int value) {
                    this.targetShardCount_ = value;
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder clearTargetShardCount() {
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.targetShardCount_ = 0;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasTargetReplicaCount() {
                    return (this.bitField0_ & 2) != 0;
                }

                @Override
                public int getTargetReplicaCount() {
                    return this.targetReplicaCount_;
                }

                public Builder setTargetReplicaCount(int value) {
                    this.targetReplicaCount_ = value;
                    this.bitField0_ |= 2;
                    this.onChanged();
                    return this;
                }

                public Builder clearTargetReplicaCount() {
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.targetReplicaCount_ = 0;
                    this.onChanged();
                    return this;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }
        }

        public static interface UpdateInfoOrBuilder
        extends MessageOrBuilder {
            public boolean hasTargetShardCount();

            public int getTargetShardCount();

            public boolean hasTargetReplicaCount();

            public int getTargetReplicaCount();
        }
    }

    public static interface StateInfoOrBuilder
    extends MessageOrBuilder {
        public boolean hasUpdateInfo();

        public StateInfo.UpdateInfo getUpdateInfo();

        public StateInfo.UpdateInfoOrBuilder getUpdateInfoOrBuilder();

        public StateInfo.InfoCase getInfoCase();
    }

    public static enum State implements ProtocolMessageEnum
    {
        STATE_UNSPECIFIED(0),
        CREATING(1),
        ACTIVE(2),
        UPDATING(3),
        DELETING(4),
        UNRECOGNIZED(-1);

        public static final int STATE_UNSPECIFIED_VALUE = 0;
        public static final int CREATING_VALUE = 1;
        public static final int ACTIVE_VALUE = 2;
        public static final int UPDATING_VALUE = 3;
        public static final int DELETING_VALUE = 4;
        private static final Internal.EnumLiteMap<State> internalValueMap;
        private static final State[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static State valueOf(int value) {
            return State.forNumber(value);
        }

        public static State forNumber(int value) {
            switch (value) {
                case 0: {
                    return STATE_UNSPECIFIED;
                }
                case 1: {
                    return CREATING;
                }
                case 2: {
                    return ACTIVE;
                }
                case 3: {
                    return UPDATING;
                }
                case 4: {
                    return DELETING;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<State> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return State.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Cluster.getDescriptor().getEnumTypes().get(0);
        }

        public static State valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != State.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private State(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<State>(){

                public State findValueByNumber(int number) {
                    return State.forNumber(number);
                }
            };
            VALUES = State.values();
        }
    }
}

