/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.redis.cluster.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CertificateAuthorityName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/certificateAuthority");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cluster;

    @Deprecated
    protected CertificateAuthorityName() {
        this.project = null;
        this.location = null;
        this.cluster = null;
    }

    private CertificateAuthorityName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CertificateAuthorityName of(String project, String location, String cluster) {
        return CertificateAuthorityName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).build();
    }

    public static String format(String project, String location, String cluster) {
        return CertificateAuthorityName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).build().toString();
    }

    public static CertificateAuthorityName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLUSTER.validatedMatch(formattedString, "CertificateAuthorityName.parse: formattedString not in valid format");
        return CertificateAuthorityName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"));
    }

    public static List<CertificateAuthorityName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateAuthorityName> list = new ArrayList<CertificateAuthorityName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateAuthorityName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateAuthorityName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateAuthorityName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateAuthorityName certificateAuthorityName = this;
            synchronized (certificateAuthorityName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLUSTER.instantiate(new String[]{"project", this.project, "location", this.location, "cluster", this.cluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CertificateAuthorityName that = (CertificateAuthorityName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cluster);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        private Builder(CertificateAuthorityName certificateAuthorityName) {
            this.project = certificateAuthorityName.project;
            this.location = certificateAuthorityName.location;
            this.cluster = certificateAuthorityName.cluster;
        }

        public CertificateAuthorityName build() {
            return new CertificateAuthorityName(this);
        }
    }
}

