/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecommenderName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RECOMMENDER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/recommenders/{recommender}");
    private static final PathTemplate BILLING_ACCOUNT_LOCATION_RECOMMENDER = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/locations/{location}/recommenders/{recommender}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String recommender;
    private final String billingAccount;

    @Deprecated
    protected RecommenderName() {
        this.project = null;
        this.location = null;
        this.recommender = null;
        this.billingAccount = null;
    }

    private RecommenderName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.recommender = (String)Preconditions.checkNotNull((Object)builder.getRecommender());
        this.billingAccount = null;
        this.pathTemplate = PROJECT_LOCATION_RECOMMENDER;
    }

    private RecommenderName(BillingAccountLocationRecommenderBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.recommender = (String)Preconditions.checkNotNull((Object)builder.getRecommender());
        this.project = null;
        this.pathTemplate = BILLING_ACCOUNT_LOCATION_RECOMMENDER;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRecommender() {
        return this.recommender;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationRecommenderBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static BillingAccountLocationRecommenderBuilder newBillingAccountLocationRecommenderBuilder() {
        return new BillingAccountLocationRecommenderBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RecommenderName of(String project, String location, String recommender) {
        return RecommenderName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static RecommenderName ofProjectLocationRecommenderName(String project, String location, String recommender) {
        return RecommenderName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static RecommenderName ofBillingAccountLocationRecommenderName(String billingAccount, String location, String recommender) {
        return RecommenderName.newBillingAccountLocationRecommenderBuilder().setBillingAccount(billingAccount).setLocation(location).setRecommender(recommender).build();
    }

    public static String format(String project, String location, String recommender) {
        return RecommenderName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationRecommenderName(String project, String location, String recommender) {
        return RecommenderName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatBillingAccountLocationRecommenderName(String billingAccount, String location, String recommender) {
        return RecommenderName.newBillingAccountLocationRecommenderBuilder().setBillingAccount(billingAccount).setLocation(location).setRecommender(recommender).build().toString();
    }

    public static RecommenderName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_RECOMMENDER.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_RECOMMENDER.match(formattedString);
            return RecommenderName.ofProjectLocationRecommenderName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("recommender"));
        }
        if (BILLING_ACCOUNT_LOCATION_RECOMMENDER.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT_LOCATION_RECOMMENDER.match(formattedString);
            return RecommenderName.ofBillingAccountLocationRecommenderName((String)matchMap.get("billing_account"), (String)matchMap.get("location"), (String)matchMap.get("recommender"));
        }
        throw new ValidationException("RecommenderName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<RecommenderName> parseList(List<String> formattedStrings) {
        ArrayList<RecommenderName> list = new ArrayList<RecommenderName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RecommenderName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RecommenderName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RecommenderName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RECOMMENDER.matches(formattedString) || BILLING_ACCOUNT_LOCATION_RECOMMENDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RecommenderName recommenderName = this;
            synchronized (recommenderName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.recommender != null) {
                        fieldMapBuilder.put((Object)"recommender", (Object)this.recommender);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RecommenderName that = (RecommenderName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.recommender, that.recommender) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.recommender);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class BillingAccountLocationRecommenderBuilder {
        private String billingAccount;
        private String location;
        private String recommender;

        protected BillingAccountLocationRecommenderBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRecommender() {
            return this.recommender;
        }

        public BillingAccountLocationRecommenderBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountLocationRecommenderBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public BillingAccountLocationRecommenderBuilder setRecommender(String recommender) {
            this.recommender = recommender;
            return this;
        }

        public RecommenderName build() {
            return new RecommenderName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String recommender;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRecommender() {
            return this.recommender;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRecommender(String recommender) {
            this.recommender = recommender;
            return this;
        }

        private Builder(RecommenderName recommenderName) {
            Preconditions.checkArgument((boolean)Objects.equals(recommenderName.pathTemplate, PROJECT_LOCATION_RECOMMENDER), (Object)"toBuilder is only supported when RecommenderName has the pattern of projects/{project}/locations/{location}/recommenders/{recommender}");
            this.project = recommenderName.project;
            this.location = recommenderName.location;
            this.recommender = recommenderName.recommender;
        }

        public RecommenderName build() {
            return new RecommenderName(this);
        }
    }
}

