/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecommendationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RECOMMENDER_RECOMMENDATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/recommenders/{recommender}/recommendations/{recommendation}");
    private static final PathTemplate BILLING_ACCOUNT_LOCATION_RECOMMENDER_RECOMMENDATION = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/locations/{location}/recommenders/{recommender}/recommendations/{recommendation}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String recommender;
    private final String recommendation;
    private final String billingAccount;

    @Deprecated
    protected RecommendationName() {
        this.project = null;
        this.location = null;
        this.recommender = null;
        this.recommendation = null;
        this.billingAccount = null;
    }

    private RecommendationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.recommender = (String)Preconditions.checkNotNull((Object)builder.getRecommender());
        this.recommendation = (String)Preconditions.checkNotNull((Object)builder.getRecommendation());
        this.billingAccount = null;
        this.pathTemplate = PROJECT_LOCATION_RECOMMENDER_RECOMMENDATION;
    }

    private RecommendationName(BillingAccountLocationRecommenderRecommendationBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.recommender = (String)Preconditions.checkNotNull((Object)builder.getRecommender());
        this.recommendation = (String)Preconditions.checkNotNull((Object)builder.getRecommendation());
        this.project = null;
        this.pathTemplate = BILLING_ACCOUNT_LOCATION_RECOMMENDER_RECOMMENDATION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRecommender() {
        return this.recommender;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationRecommenderRecommendationBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static BillingAccountLocationRecommenderRecommendationBuilder newBillingAccountLocationRecommenderRecommendationBuilder() {
        return new BillingAccountLocationRecommenderRecommendationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RecommendationName of(String project, String location, String recommender, String recommendation) {
        return RecommendationName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).setRecommendation(recommendation).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static RecommendationName ofProjectLocationRecommenderRecommendationName(String project, String location, String recommender, String recommendation) {
        return RecommendationName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).setRecommendation(recommendation).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static RecommendationName ofBillingAccountLocationRecommenderRecommendationName(String billingAccount, String location, String recommender, String recommendation) {
        return RecommendationName.newBillingAccountLocationRecommenderRecommendationBuilder().setBillingAccount(billingAccount).setLocation(location).setRecommender(recommender).setRecommendation(recommendation).build();
    }

    public static String format(String project, String location, String recommender, String recommendation) {
        return RecommendationName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).setRecommendation(recommendation).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationRecommenderRecommendationName(String project, String location, String recommender, String recommendation) {
        return RecommendationName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).setRecommendation(recommendation).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatBillingAccountLocationRecommenderRecommendationName(String billingAccount, String location, String recommender, String recommendation) {
        return RecommendationName.newBillingAccountLocationRecommenderRecommendationBuilder().setBillingAccount(billingAccount).setLocation(location).setRecommender(recommender).setRecommendation(recommendation).build().toString();
    }

    public static RecommendationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_RECOMMENDER_RECOMMENDATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_RECOMMENDER_RECOMMENDATION.match(formattedString);
            return RecommendationName.ofProjectLocationRecommenderRecommendationName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("recommender"), (String)matchMap.get("recommendation"));
        }
        if (BILLING_ACCOUNT_LOCATION_RECOMMENDER_RECOMMENDATION.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT_LOCATION_RECOMMENDER_RECOMMENDATION.match(formattedString);
            return RecommendationName.ofBillingAccountLocationRecommenderRecommendationName((String)matchMap.get("billing_account"), (String)matchMap.get("location"), (String)matchMap.get("recommender"), (String)matchMap.get("recommendation"));
        }
        throw new ValidationException("RecommendationName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<RecommendationName> parseList(List<String> formattedStrings) {
        ArrayList<RecommendationName> list = new ArrayList<RecommendationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RecommendationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RecommendationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RecommendationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RECOMMENDER_RECOMMENDATION.matches(formattedString) || BILLING_ACCOUNT_LOCATION_RECOMMENDER_RECOMMENDATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RecommendationName recommendationName = this;
            synchronized (recommendationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.recommender != null) {
                        fieldMapBuilder.put((Object)"recommender", (Object)this.recommender);
                    }
                    if (this.recommendation != null) {
                        fieldMapBuilder.put((Object)"recommendation", (Object)this.recommendation);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RecommendationName that = (RecommendationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.recommender, that.recommender) && Objects.equals(this.recommendation, that.recommendation) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.recommender);
        h *= 1000003;
        h ^= Objects.hashCode(this.recommendation);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class BillingAccountLocationRecommenderRecommendationBuilder {
        private String billingAccount;
        private String location;
        private String recommender;
        private String recommendation;

        protected BillingAccountLocationRecommenderRecommendationBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRecommender() {
            return this.recommender;
        }

        public String getRecommendation() {
            return this.recommendation;
        }

        public BillingAccountLocationRecommenderRecommendationBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountLocationRecommenderRecommendationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public BillingAccountLocationRecommenderRecommendationBuilder setRecommender(String recommender) {
            this.recommender = recommender;
            return this;
        }

        public BillingAccountLocationRecommenderRecommendationBuilder setRecommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public RecommendationName build() {
            return new RecommendationName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String recommender;
        private String recommendation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRecommender() {
            return this.recommender;
        }

        public String getRecommendation() {
            return this.recommendation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRecommender(String recommender) {
            this.recommender = recommender;
            return this;
        }

        public Builder setRecommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        private Builder(RecommendationName recommendationName) {
            Preconditions.checkArgument((boolean)Objects.equals(recommendationName.pathTemplate, PROJECT_LOCATION_RECOMMENDER_RECOMMENDATION), (Object)"toBuilder is only supported when RecommendationName has the pattern of projects/{project}/locations/{location}/recommenders/{recommender}/recommendations/{recommendation}");
            this.project = recommendationName.project;
            this.location = recommendationName.location;
            this.recommender = recommendationName.recommender;
            this.recommendation = recommendationName.recommendation;
        }

        public RecommendationName build() {
            return new RecommendationName(this);
        }
    }
}

