/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InsightName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSIGHT_TYPE_INSIGHT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/insightTypes/{insight_type}/insights/{insight}");
    private static final PathTemplate BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE_INSIGHT = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/locations/{location}/insightTypes/{insight_type}/insights/{insight}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String insightType;
    private final String insight;
    private final String billingAccount;

    @Deprecated
    protected InsightName() {
        this.project = null;
        this.location = null;
        this.insightType = null;
        this.insight = null;
        this.billingAccount = null;
    }

    private InsightName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.insight = (String)Preconditions.checkNotNull((Object)builder.getInsight());
        this.billingAccount = null;
        this.pathTemplate = PROJECT_LOCATION_INSIGHT_TYPE_INSIGHT;
    }

    private InsightName(BillingAccountLocationInsightTypeInsightBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.insight = (String)Preconditions.checkNotNull((Object)builder.getInsight());
        this.project = null;
        this.pathTemplate = BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE_INSIGHT;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInsightType() {
        return this.insightType;
    }

    public String getInsight() {
        return this.insight;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationInsightTypeInsightBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static BillingAccountLocationInsightTypeInsightBuilder newBillingAccountLocationInsightTypeInsightBuilder() {
        return new BillingAccountLocationInsightTypeInsightBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InsightName of(String project, String location, String insightType, String insight) {
        return InsightName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).setInsight(insight).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static InsightName ofProjectLocationInsightTypeInsightName(String project, String location, String insightType, String insight) {
        return InsightName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).setInsight(insight).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static InsightName ofBillingAccountLocationInsightTypeInsightName(String billingAccount, String location, String insightType, String insight) {
        return InsightName.newBillingAccountLocationInsightTypeInsightBuilder().setBillingAccount(billingAccount).setLocation(location).setInsightType(insightType).setInsight(insight).build();
    }

    public static String format(String project, String location, String insightType, String insight) {
        return InsightName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).setInsight(insight).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationInsightTypeInsightName(String project, String location, String insightType, String insight) {
        return InsightName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).setInsight(insight).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatBillingAccountLocationInsightTypeInsightName(String billingAccount, String location, String insightType, String insight) {
        return InsightName.newBillingAccountLocationInsightTypeInsightBuilder().setBillingAccount(billingAccount).setLocation(location).setInsightType(insightType).setInsight(insight).build().toString();
    }

    public static InsightName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_INSIGHT_TYPE_INSIGHT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_INSIGHT_TYPE_INSIGHT.match(formattedString);
            return InsightName.ofProjectLocationInsightTypeInsightName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"), (String)matchMap.get("insight"));
        }
        if (BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE_INSIGHT.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE_INSIGHT.match(formattedString);
            return InsightName.ofBillingAccountLocationInsightTypeInsightName((String)matchMap.get("billing_account"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"), (String)matchMap.get("insight"));
        }
        throw new ValidationException("InsightName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<InsightName> parseList(List<String> formattedStrings) {
        ArrayList<InsightName> list = new ArrayList<InsightName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InsightName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InsightName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InsightName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSIGHT_TYPE_INSIGHT.matches(formattedString) || BILLING_ACCOUNT_LOCATION_INSIGHT_TYPE_INSIGHT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InsightName insightName = this;
            synchronized (insightName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.insightType != null) {
                        fieldMapBuilder.put((Object)"insight_type", (Object)this.insightType);
                    }
                    if (this.insight != null) {
                        fieldMapBuilder.put((Object)"insight", (Object)this.insight);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            InsightName that = (InsightName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.insightType, that.insightType) && Objects.equals(this.insight, that.insight) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.insightType);
        h *= 1000003;
        h ^= Objects.hashCode(this.insight);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class BillingAccountLocationInsightTypeInsightBuilder {
        private String billingAccount;
        private String location;
        private String insightType;
        private String insight;

        protected BillingAccountLocationInsightTypeInsightBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public String getInsight() {
            return this.insight;
        }

        public BillingAccountLocationInsightTypeInsightBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountLocationInsightTypeInsightBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public BillingAccountLocationInsightTypeInsightBuilder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        public BillingAccountLocationInsightTypeInsightBuilder setInsight(String insight) {
            this.insight = insight;
            return this;
        }

        public InsightName build() {
            return new InsightName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String insightType;
        private String insight;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public String getInsight() {
            return this.insight;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        public Builder setInsight(String insight) {
            this.insight = insight;
            return this;
        }

        private Builder(InsightName insightName) {
            Preconditions.checkArgument((boolean)Objects.equals(insightName.pathTemplate, PROJECT_LOCATION_INSIGHT_TYPE_INSIGHT), (Object)"toBuilder is only supported when InsightName has the pattern of projects/{project}/locations/{location}/insightTypes/{insight_type}/insights/{insight}");
            this.project = insightName.project;
            this.location = insightName.location;
            this.insightType = insightName.insightType;
            this.insight = insightName.insight;
        }

        public InsightName build() {
            return new InsightName(this);
        }
    }
}

