/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecommenderConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RECOMMENDER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/recommenders/{recommender}/config");
    private static final PathTemplate ORGANIZATION_LOCATION_RECOMMENDER = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/recommenders/{recommender}/config");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String recommender;
    private final String organization;

    @Deprecated
    protected RecommenderConfigName() {
        this.project = null;
        this.location = null;
        this.recommender = null;
        this.organization = null;
    }

    private RecommenderConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.recommender = (String)Preconditions.checkNotNull((Object)builder.getRecommender());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_RECOMMENDER;
    }

    private RecommenderConfigName(OrganizationLocationRecommenderBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.recommender = (String)Preconditions.checkNotNull((Object)builder.getRecommender());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION_RECOMMENDER;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRecommender() {
        return this.recommender;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationRecommenderBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationLocationRecommenderBuilder newOrganizationLocationRecommenderBuilder() {
        return new OrganizationLocationRecommenderBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RecommenderConfigName of(String project, String location, String recommender) {
        return RecommenderConfigName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static RecommenderConfigName ofProjectLocationRecommenderName(String project, String location, String recommender) {
        return RecommenderConfigName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static RecommenderConfigName ofOrganizationLocationRecommenderName(String organization, String location, String recommender) {
        return RecommenderConfigName.newOrganizationLocationRecommenderBuilder().setOrganization(organization).setLocation(location).setRecommender(recommender).build();
    }

    public static String format(String project, String location, String recommender) {
        return RecommenderConfigName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationRecommenderName(String project, String location, String recommender) {
        return RecommenderConfigName.newBuilder().setProject(project).setLocation(location).setRecommender(recommender).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationLocationRecommenderName(String organization, String location, String recommender) {
        return RecommenderConfigName.newOrganizationLocationRecommenderBuilder().setOrganization(organization).setLocation(location).setRecommender(recommender).build().toString();
    }

    public static RecommenderConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_RECOMMENDER.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_RECOMMENDER.match(formattedString);
            return RecommenderConfigName.ofProjectLocationRecommenderName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("recommender"));
        }
        if (ORGANIZATION_LOCATION_RECOMMENDER.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_RECOMMENDER.match(formattedString);
            return RecommenderConfigName.ofOrganizationLocationRecommenderName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("recommender"));
        }
        throw new ValidationException("RecommenderConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<RecommenderConfigName> parseList(List<String> formattedStrings) {
        ArrayList<RecommenderConfigName> list = new ArrayList<RecommenderConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RecommenderConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RecommenderConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RecommenderConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RECOMMENDER.matches(formattedString) || ORGANIZATION_LOCATION_RECOMMENDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RecommenderConfigName recommenderConfigName = this;
            synchronized (recommenderConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.recommender != null) {
                        fieldMapBuilder.put((Object)"recommender", (Object)this.recommender);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RecommenderConfigName that = (RecommenderConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.recommender, that.recommender) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.recommender);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationLocationRecommenderBuilder {
        private String organization;
        private String location;
        private String recommender;

        protected OrganizationLocationRecommenderBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRecommender() {
            return this.recommender;
        }

        public OrganizationLocationRecommenderBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationRecommenderBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationRecommenderBuilder setRecommender(String recommender) {
            this.recommender = recommender;
            return this;
        }

        public RecommenderConfigName build() {
            return new RecommenderConfigName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String recommender;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRecommender() {
            return this.recommender;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRecommender(String recommender) {
            this.recommender = recommender;
            return this;
        }

        private Builder(RecommenderConfigName recommenderConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(recommenderConfigName.pathTemplate, PROJECT_LOCATION_RECOMMENDER), (Object)"toBuilder is only supported when RecommenderConfigName has the pattern of projects/{project}/locations/{location}/recommenders/{recommender}/config");
            this.project = recommenderConfigName.project;
            this.location = recommenderConfigName.location;
            this.recommender = recommenderConfigName.recommender;
        }

        public RecommenderConfigName build() {
            return new RecommenderConfigName(this);
        }
    }
}

