/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1;

import com.google.cloud.recommender.v1.Impact;
import com.google.cloud.recommender.v1.ImpactOrBuilder;
import com.google.cloud.recommender.v1.RecommendationContent;
import com.google.cloud.recommender.v1.RecommendationContentOrBuilder;
import com.google.cloud.recommender.v1.RecommendationOrBuilder;
import com.google.cloud.recommender.v1.RecommendationOuterClass;
import com.google.cloud.recommender.v1.RecommendationStateInfo;
import com.google.cloud.recommender.v1.RecommendationStateInfoOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Recommendation
extends GeneratedMessageV3
implements RecommendationOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int DESCRIPTION_FIELD_NUMBER = 2;
    private volatile Object description_ = "";
    public static final int RECOMMENDER_SUBTYPE_FIELD_NUMBER = 12;
    private volatile Object recommenderSubtype_ = "";
    public static final int LAST_REFRESH_TIME_FIELD_NUMBER = 4;
    private Timestamp lastRefreshTime_;
    public static final int PRIMARY_IMPACT_FIELD_NUMBER = 5;
    private Impact primaryImpact_;
    public static final int ADDITIONAL_IMPACT_FIELD_NUMBER = 6;
    private List<Impact> additionalImpact_;
    public static final int PRIORITY_FIELD_NUMBER = 17;
    private int priority_ = 0;
    public static final int CONTENT_FIELD_NUMBER = 7;
    private RecommendationContent content_;
    public static final int STATE_INFO_FIELD_NUMBER = 10;
    private RecommendationStateInfo stateInfo_;
    public static final int ETAG_FIELD_NUMBER = 11;
    private volatile Object etag_ = "";
    public static final int ASSOCIATED_INSIGHTS_FIELD_NUMBER = 14;
    private List<InsightReference> associatedInsights_;
    public static final int XOR_GROUP_ID_FIELD_NUMBER = 18;
    private volatile Object xorGroupId_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final Recommendation DEFAULT_INSTANCE = new Recommendation();
    private static final Parser<Recommendation> PARSER = new AbstractParser<Recommendation>(){

        public Recommendation parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Recommendation.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Recommendation(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Recommendation() {
        this.name_ = "";
        this.description_ = "";
        this.recommenderSubtype_ = "";
        this.additionalImpact_ = Collections.emptyList();
        this.priority_ = 0;
        this.etag_ = "";
        this.associatedInsights_ = Collections.emptyList();
        this.xorGroupId_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Recommendation();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return RecommendationOuterClass.internal_static_google_cloud_recommender_v1_Recommendation_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return RecommendationOuterClass.internal_static_google_cloud_recommender_v1_Recommendation_fieldAccessorTable.ensureFieldAccessorsInitialized(Recommendation.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRecommenderSubtype() {
        Object ref = this.recommenderSubtype_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.recommenderSubtype_ = s;
        return s;
    }

    @Override
    public ByteString getRecommenderSubtypeBytes() {
        Object ref = this.recommenderSubtype_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.recommenderSubtype_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasLastRefreshTime() {
        return this.lastRefreshTime_ != null;
    }

    @Override
    public Timestamp getLastRefreshTime() {
        return this.lastRefreshTime_ == null ? Timestamp.getDefaultInstance() : this.lastRefreshTime_;
    }

    @Override
    public TimestampOrBuilder getLastRefreshTimeOrBuilder() {
        return this.lastRefreshTime_ == null ? Timestamp.getDefaultInstance() : this.lastRefreshTime_;
    }

    @Override
    public boolean hasPrimaryImpact() {
        return this.primaryImpact_ != null;
    }

    @Override
    public Impact getPrimaryImpact() {
        return this.primaryImpact_ == null ? Impact.getDefaultInstance() : this.primaryImpact_;
    }

    @Override
    public ImpactOrBuilder getPrimaryImpactOrBuilder() {
        return this.primaryImpact_ == null ? Impact.getDefaultInstance() : this.primaryImpact_;
    }

    @Override
    public List<Impact> getAdditionalImpactList() {
        return this.additionalImpact_;
    }

    @Override
    public List<? extends ImpactOrBuilder> getAdditionalImpactOrBuilderList() {
        return this.additionalImpact_;
    }

    @Override
    public int getAdditionalImpactCount() {
        return this.additionalImpact_.size();
    }

    @Override
    public Impact getAdditionalImpact(int index) {
        return this.additionalImpact_.get(index);
    }

    @Override
    public ImpactOrBuilder getAdditionalImpactOrBuilder(int index) {
        return this.additionalImpact_.get(index);
    }

    @Override
    public int getPriorityValue() {
        return this.priority_;
    }

    @Override
    public Priority getPriority() {
        Priority result = Priority.forNumber(this.priority_);
        return result == null ? Priority.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasContent() {
        return this.content_ != null;
    }

    @Override
    public RecommendationContent getContent() {
        return this.content_ == null ? RecommendationContent.getDefaultInstance() : this.content_;
    }

    @Override
    public RecommendationContentOrBuilder getContentOrBuilder() {
        return this.content_ == null ? RecommendationContent.getDefaultInstance() : this.content_;
    }

    @Override
    public boolean hasStateInfo() {
        return this.stateInfo_ != null;
    }

    @Override
    public RecommendationStateInfo getStateInfo() {
        return this.stateInfo_ == null ? RecommendationStateInfo.getDefaultInstance() : this.stateInfo_;
    }

    @Override
    public RecommendationStateInfoOrBuilder getStateInfoOrBuilder() {
        return this.stateInfo_ == null ? RecommendationStateInfo.getDefaultInstance() : this.stateInfo_;
    }

    @Override
    public String getEtag() {
        Object ref = this.etag_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.etag_ = s;
        return s;
    }

    @Override
    public ByteString getEtagBytes() {
        Object ref = this.etag_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.etag_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<InsightReference> getAssociatedInsightsList() {
        return this.associatedInsights_;
    }

    @Override
    public List<? extends InsightReferenceOrBuilder> getAssociatedInsightsOrBuilderList() {
        return this.associatedInsights_;
    }

    @Override
    public int getAssociatedInsightsCount() {
        return this.associatedInsights_.size();
    }

    @Override
    public InsightReference getAssociatedInsights(int index) {
        return this.associatedInsights_.get(index);
    }

    @Override
    public InsightReferenceOrBuilder getAssociatedInsightsOrBuilder(int index) {
        return this.associatedInsights_.get(index);
    }

    @Override
    public String getXorGroupId() {
        Object ref = this.xorGroupId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.xorGroupId_ = s;
        return s;
    }

    @Override
    public ByteString getXorGroupIdBytes() {
        Object ref = this.xorGroupId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.xorGroupId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.description_);
        }
        if (this.lastRefreshTime_ != null) {
            output.writeMessage(4, (MessageLite)this.getLastRefreshTime());
        }
        if (this.primaryImpact_ != null) {
            output.writeMessage(5, (MessageLite)this.getPrimaryImpact());
        }
        for (i = 0; i < this.additionalImpact_.size(); ++i) {
            output.writeMessage(6, (MessageLite)this.additionalImpact_.get(i));
        }
        if (this.content_ != null) {
            output.writeMessage(7, (MessageLite)this.getContent());
        }
        if (this.stateInfo_ != null) {
            output.writeMessage(10, (MessageLite)this.getStateInfo());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.etag_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.etag_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.recommenderSubtype_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.recommenderSubtype_);
        }
        for (i = 0; i < this.associatedInsights_.size(); ++i) {
            output.writeMessage(14, (MessageLite)this.associatedInsights_.get(i));
        }
        if (this.priority_ != Priority.PRIORITY_UNSPECIFIED.getNumber()) {
            output.writeEnum(17, this.priority_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.xorGroupId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)18, (Object)this.xorGroupId_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.description_);
        }
        if (this.lastRefreshTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getLastRefreshTime());
        }
        if (this.primaryImpact_ != null) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getPrimaryImpact());
        }
        for (i = 0; i < this.additionalImpact_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.additionalImpact_.get(i)));
        }
        if (this.content_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getContent());
        }
        if (this.stateInfo_ != null) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getStateInfo());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.etag_)) {
            size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.etag_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.recommenderSubtype_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.recommenderSubtype_);
        }
        for (i = 0; i < this.associatedInsights_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)((MessageLite)this.associatedInsights_.get(i)));
        }
        if (this.priority_ != Priority.PRIORITY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)17, (int)this.priority_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.xorGroupId_)) {
            size += GeneratedMessageV3.computeStringSize((int)18, (Object)this.xorGroupId_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Recommendation)) {
            return super.equals(obj);
        }
        Recommendation other = (Recommendation)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.getRecommenderSubtype().equals(other.getRecommenderSubtype())) {
            return false;
        }
        if (this.hasLastRefreshTime() != other.hasLastRefreshTime()) {
            return false;
        }
        if (this.hasLastRefreshTime() && !this.getLastRefreshTime().equals((Object)other.getLastRefreshTime())) {
            return false;
        }
        if (this.hasPrimaryImpact() != other.hasPrimaryImpact()) {
            return false;
        }
        if (this.hasPrimaryImpact() && !this.getPrimaryImpact().equals(other.getPrimaryImpact())) {
            return false;
        }
        if (!this.getAdditionalImpactList().equals(other.getAdditionalImpactList())) {
            return false;
        }
        if (this.priority_ != other.priority_) {
            return false;
        }
        if (this.hasContent() != other.hasContent()) {
            return false;
        }
        if (this.hasContent() && !this.getContent().equals(other.getContent())) {
            return false;
        }
        if (this.hasStateInfo() != other.hasStateInfo()) {
            return false;
        }
        if (this.hasStateInfo() && !this.getStateInfo().equals(other.getStateInfo())) {
            return false;
        }
        if (!this.getEtag().equals(other.getEtag())) {
            return false;
        }
        if (!this.getAssociatedInsightsList().equals(other.getAssociatedInsightsList())) {
            return false;
        }
        if (!this.getXorGroupId().equals(other.getXorGroupId())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Recommendation.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getDescription().hashCode();
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getRecommenderSubtype().hashCode();
        if (this.hasLastRefreshTime()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getLastRefreshTime().hashCode();
        }
        if (this.hasPrimaryImpact()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getPrimaryImpact().hashCode();
        }
        if (this.getAdditionalImpactCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getAdditionalImpactList().hashCode();
        }
        hash = 37 * hash + 17;
        hash = 53 * hash + this.priority_;
        if (this.hasContent()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getContent().hashCode();
        }
        if (this.hasStateInfo()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getStateInfo().hashCode();
        }
        hash = 37 * hash + 11;
        hash = 53 * hash + this.getEtag().hashCode();
        if (this.getAssociatedInsightsCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getAssociatedInsightsList().hashCode();
        }
        hash = 37 * hash + 18;
        hash = 53 * hash + this.getXorGroupId().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Recommendation parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Recommendation)PARSER.parseFrom(data);
    }

    public static Recommendation parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Recommendation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Recommendation parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Recommendation)PARSER.parseFrom(data);
    }

    public static Recommendation parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Recommendation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Recommendation parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Recommendation)PARSER.parseFrom(data);
    }

    public static Recommendation parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Recommendation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Recommendation parseFrom(InputStream input) throws IOException {
        return (Recommendation)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Recommendation parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Recommendation)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Recommendation parseDelimitedFrom(InputStream input) throws IOException {
        return (Recommendation)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Recommendation parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Recommendation)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Recommendation parseFrom(CodedInputStream input) throws IOException {
        return (Recommendation)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Recommendation parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Recommendation)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Recommendation.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Recommendation prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Recommendation getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Recommendation> parser() {
        return PARSER;
    }

    public Parser<Recommendation> getParserForType() {
        return PARSER;
    }

    public Recommendation getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements RecommendationOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Object description_ = "";
        private Object recommenderSubtype_ = "";
        private Timestamp lastRefreshTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastRefreshTimeBuilder_;
        private Impact primaryImpact_;
        private SingleFieldBuilderV3<Impact, Impact.Builder, ImpactOrBuilder> primaryImpactBuilder_;
        private List<Impact> additionalImpact_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Impact, Impact.Builder, ImpactOrBuilder> additionalImpactBuilder_;
        private int priority_ = 0;
        private RecommendationContent content_;
        private SingleFieldBuilderV3<RecommendationContent, RecommendationContent.Builder, RecommendationContentOrBuilder> contentBuilder_;
        private RecommendationStateInfo stateInfo_;
        private SingleFieldBuilderV3<RecommendationStateInfo, RecommendationStateInfo.Builder, RecommendationStateInfoOrBuilder> stateInfoBuilder_;
        private Object etag_ = "";
        private List<InsightReference> associatedInsights_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<InsightReference, InsightReference.Builder, InsightReferenceOrBuilder> associatedInsightsBuilder_;
        private Object xorGroupId_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationOuterClass.internal_static_google_cloud_recommender_v1_Recommendation_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationOuterClass.internal_static_google_cloud_recommender_v1_Recommendation_fieldAccessorTable.ensureFieldAccessorsInitialized(Recommendation.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.description_ = "";
            this.recommenderSubtype_ = "";
            this.lastRefreshTime_ = null;
            if (this.lastRefreshTimeBuilder_ != null) {
                this.lastRefreshTimeBuilder_.dispose();
                this.lastRefreshTimeBuilder_ = null;
            }
            this.primaryImpact_ = null;
            if (this.primaryImpactBuilder_ != null) {
                this.primaryImpactBuilder_.dispose();
                this.primaryImpactBuilder_ = null;
            }
            if (this.additionalImpactBuilder_ == null) {
                this.additionalImpact_ = Collections.emptyList();
            } else {
                this.additionalImpact_ = null;
                this.additionalImpactBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFDF;
            this.priority_ = 0;
            this.content_ = null;
            if (this.contentBuilder_ != null) {
                this.contentBuilder_.dispose();
                this.contentBuilder_ = null;
            }
            this.stateInfo_ = null;
            if (this.stateInfoBuilder_ != null) {
                this.stateInfoBuilder_.dispose();
                this.stateInfoBuilder_ = null;
            }
            this.etag_ = "";
            if (this.associatedInsightsBuilder_ == null) {
                this.associatedInsights_ = Collections.emptyList();
            } else {
                this.associatedInsights_ = null;
                this.associatedInsightsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFBFF;
            this.xorGroupId_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return RecommendationOuterClass.internal_static_google_cloud_recommender_v1_Recommendation_descriptor;
        }

        public Recommendation getDefaultInstanceForType() {
            return Recommendation.getDefaultInstance();
        }

        public Recommendation build() {
            Recommendation result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Recommendation buildPartial() {
            Recommendation result = new Recommendation(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Recommendation result) {
            if (this.additionalImpactBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0) {
                    this.additionalImpact_ = Collections.unmodifiableList(this.additionalImpact_);
                    this.bitField0_ &= 0xFFFFFFDF;
                }
                result.additionalImpact_ = this.additionalImpact_;
            } else {
                result.additionalImpact_ = this.additionalImpactBuilder_.build();
            }
            if (this.associatedInsightsBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0) {
                    this.associatedInsights_ = Collections.unmodifiableList(this.associatedInsights_);
                    this.bitField0_ &= 0xFFFFFBFF;
                }
                result.associatedInsights_ = this.associatedInsights_;
            } else {
                result.associatedInsights_ = this.associatedInsightsBuilder_.build();
            }
        }

        private void buildPartial0(Recommendation result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.description_ = this.description_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.recommenderSubtype_ = this.recommenderSubtype_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.lastRefreshTime_ = this.lastRefreshTimeBuilder_ == null ? this.lastRefreshTime_ : (Timestamp)this.lastRefreshTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.primaryImpact_ = this.primaryImpactBuilder_ == null ? this.primaryImpact_ : (Impact)this.primaryImpactBuilder_.build();
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.priority_ = this.priority_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.content_ = this.contentBuilder_ == null ? this.content_ : (RecommendationContent)this.contentBuilder_.build();
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.stateInfo_ = this.stateInfoBuilder_ == null ? this.stateInfo_ : (RecommendationStateInfo)this.stateInfoBuilder_.build();
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.etag_ = this.etag_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.xorGroupId_ = this.xorGroupId_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Recommendation) {
                return this.mergeFrom((Recommendation)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Recommendation other) {
            if (other == Recommendation.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getRecommenderSubtype().isEmpty()) {
                this.recommenderSubtype_ = other.recommenderSubtype_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.hasLastRefreshTime()) {
                this.mergeLastRefreshTime(other.getLastRefreshTime());
            }
            if (other.hasPrimaryImpact()) {
                this.mergePrimaryImpact(other.getPrimaryImpact());
            }
            if (this.additionalImpactBuilder_ == null) {
                if (!other.additionalImpact_.isEmpty()) {
                    if (this.additionalImpact_.isEmpty()) {
                        this.additionalImpact_ = other.additionalImpact_;
                        this.bitField0_ &= 0xFFFFFFDF;
                    } else {
                        this.ensureAdditionalImpactIsMutable();
                        this.additionalImpact_.addAll(other.additionalImpact_);
                    }
                    this.onChanged();
                }
            } else if (!other.additionalImpact_.isEmpty()) {
                if (this.additionalImpactBuilder_.isEmpty()) {
                    this.additionalImpactBuilder_.dispose();
                    this.additionalImpactBuilder_ = null;
                    this.additionalImpact_ = other.additionalImpact_;
                    this.bitField0_ &= 0xFFFFFFDF;
                    this.additionalImpactBuilder_ = alwaysUseFieldBuilders ? this.getAdditionalImpactFieldBuilder() : null;
                } else {
                    this.additionalImpactBuilder_.addAllMessages((Iterable)other.additionalImpact_);
                }
            }
            if (other.priority_ != 0) {
                this.setPriorityValue(other.getPriorityValue());
            }
            if (other.hasContent()) {
                this.mergeContent(other.getContent());
            }
            if (other.hasStateInfo()) {
                this.mergeStateInfo(other.getStateInfo());
            }
            if (!other.getEtag().isEmpty()) {
                this.etag_ = other.etag_;
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            if (this.associatedInsightsBuilder_ == null) {
                if (!other.associatedInsights_.isEmpty()) {
                    if (this.associatedInsights_.isEmpty()) {
                        this.associatedInsights_ = other.associatedInsights_;
                        this.bitField0_ &= 0xFFFFFBFF;
                    } else {
                        this.ensureAssociatedInsightsIsMutable();
                        this.associatedInsights_.addAll(other.associatedInsights_);
                    }
                    this.onChanged();
                }
            } else if (!other.associatedInsights_.isEmpty()) {
                if (this.associatedInsightsBuilder_.isEmpty()) {
                    this.associatedInsightsBuilder_.dispose();
                    this.associatedInsightsBuilder_ = null;
                    this.associatedInsights_ = other.associatedInsights_;
                    this.bitField0_ &= 0xFFFFFBFF;
                    this.associatedInsightsBuilder_ = alwaysUseFieldBuilders ? this.getAssociatedInsightsFieldBuilder() : null;
                } else {
                    this.associatedInsightsBuilder_.addAllMessages((Iterable)other.associatedInsights_);
                }
            }
            if (!other.getXorGroupId().isEmpty()) {
                this.xorGroupId_ = other.xorGroupId_;
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block20: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block20;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block20;
                        }
                        case 18: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block20;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getLastRefreshTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block20;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getPrimaryImpactFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block20;
                        }
                        case 50: {
                            GeneratedMessageV3 m = (Impact)input.readMessage(Impact.parser(), extensionRegistry);
                            if (this.additionalImpactBuilder_ == null) {
                                this.ensureAdditionalImpactIsMutable();
                                this.additionalImpact_.add((Impact)m);
                                continue block20;
                            }
                            this.additionalImpactBuilder_.addMessage((AbstractMessage)m);
                            continue block20;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getContentFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block20;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getStateInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block20;
                        }
                        case 90: {
                            this.etag_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x200;
                            continue block20;
                        }
                        case 98: {
                            this.recommenderSubtype_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block20;
                        }
                        case 114: {
                            GeneratedMessageV3 m = (InsightReference)input.readMessage(InsightReference.parser(), extensionRegistry);
                            if (this.associatedInsightsBuilder_ == null) {
                                this.ensureAssociatedInsightsIsMutable();
                                this.associatedInsights_.add((InsightReference)m);
                                continue block20;
                            }
                            this.associatedInsightsBuilder_.addMessage((AbstractMessage)m);
                            continue block20;
                        }
                        case 136: {
                            this.priority_ = input.readEnum();
                            this.bitField0_ |= 0x40;
                            continue block20;
                        }
                        case 146: {
                            this.xorGroupId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x800;
                            continue block20;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Recommendation.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Recommendation.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = Recommendation.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Recommendation.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getRecommenderSubtype() {
            Object ref = this.recommenderSubtype_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.recommenderSubtype_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRecommenderSubtypeBytes() {
            Object ref = this.recommenderSubtype_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.recommenderSubtype_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRecommenderSubtype(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.recommenderSubtype_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearRecommenderSubtype() {
            this.recommenderSubtype_ = Recommendation.getDefaultInstance().getRecommenderSubtype();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setRecommenderSubtypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Recommendation.checkByteStringIsUtf8((ByteString)value);
            this.recommenderSubtype_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLastRefreshTime() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Timestamp getLastRefreshTime() {
            if (this.lastRefreshTimeBuilder_ == null) {
                return this.lastRefreshTime_ == null ? Timestamp.getDefaultInstance() : this.lastRefreshTime_;
            }
            return (Timestamp)this.lastRefreshTimeBuilder_.getMessage();
        }

        public Builder setLastRefreshTime(Timestamp value) {
            if (this.lastRefreshTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastRefreshTime_ = value;
            } else {
                this.lastRefreshTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setLastRefreshTime(Timestamp.Builder builderForValue) {
            if (this.lastRefreshTimeBuilder_ == null) {
                this.lastRefreshTime_ = builderForValue.build();
            } else {
                this.lastRefreshTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeLastRefreshTime(Timestamp value) {
            if (this.lastRefreshTimeBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.lastRefreshTime_ != null && this.lastRefreshTime_ != Timestamp.getDefaultInstance()) {
                    this.getLastRefreshTimeBuilder().mergeFrom(value);
                } else {
                    this.lastRefreshTime_ = value;
                }
            } else {
                this.lastRefreshTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearLastRefreshTime() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.lastRefreshTime_ = null;
            if (this.lastRefreshTimeBuilder_ != null) {
                this.lastRefreshTimeBuilder_.dispose();
                this.lastRefreshTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getLastRefreshTimeBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (Timestamp.Builder)this.getLastRefreshTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getLastRefreshTimeOrBuilder() {
            if (this.lastRefreshTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.lastRefreshTimeBuilder_.getMessageOrBuilder();
            }
            return this.lastRefreshTime_ == null ? Timestamp.getDefaultInstance() : this.lastRefreshTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastRefreshTimeFieldBuilder() {
            if (this.lastRefreshTimeBuilder_ == null) {
                this.lastRefreshTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastRefreshTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastRefreshTime_ = null;
            }
            return this.lastRefreshTimeBuilder_;
        }

        @Override
        public boolean hasPrimaryImpact() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Impact getPrimaryImpact() {
            if (this.primaryImpactBuilder_ == null) {
                return this.primaryImpact_ == null ? Impact.getDefaultInstance() : this.primaryImpact_;
            }
            return (Impact)this.primaryImpactBuilder_.getMessage();
        }

        public Builder setPrimaryImpact(Impact value) {
            if (this.primaryImpactBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.primaryImpact_ = value;
            } else {
                this.primaryImpactBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setPrimaryImpact(Impact.Builder builderForValue) {
            if (this.primaryImpactBuilder_ == null) {
                this.primaryImpact_ = builderForValue.build();
            } else {
                this.primaryImpactBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergePrimaryImpact(Impact value) {
            if (this.primaryImpactBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.primaryImpact_ != null && this.primaryImpact_ != Impact.getDefaultInstance()) {
                    this.getPrimaryImpactBuilder().mergeFrom(value);
                } else {
                    this.primaryImpact_ = value;
                }
            } else {
                this.primaryImpactBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearPrimaryImpact() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.primaryImpact_ = null;
            if (this.primaryImpactBuilder_ != null) {
                this.primaryImpactBuilder_.dispose();
                this.primaryImpactBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Impact.Builder getPrimaryImpactBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (Impact.Builder)this.getPrimaryImpactFieldBuilder().getBuilder();
        }

        @Override
        public ImpactOrBuilder getPrimaryImpactOrBuilder() {
            if (this.primaryImpactBuilder_ != null) {
                return (ImpactOrBuilder)this.primaryImpactBuilder_.getMessageOrBuilder();
            }
            return this.primaryImpact_ == null ? Impact.getDefaultInstance() : this.primaryImpact_;
        }

        private SingleFieldBuilderV3<Impact, Impact.Builder, ImpactOrBuilder> getPrimaryImpactFieldBuilder() {
            if (this.primaryImpactBuilder_ == null) {
                this.primaryImpactBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPrimaryImpact(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.primaryImpact_ = null;
            }
            return this.primaryImpactBuilder_;
        }

        private void ensureAdditionalImpactIsMutable() {
            if ((this.bitField0_ & 0x20) == 0) {
                this.additionalImpact_ = new ArrayList<Impact>(this.additionalImpact_);
                this.bitField0_ |= 0x20;
            }
        }

        @Override
        public List<Impact> getAdditionalImpactList() {
            if (this.additionalImpactBuilder_ == null) {
                return Collections.unmodifiableList(this.additionalImpact_);
            }
            return this.additionalImpactBuilder_.getMessageList();
        }

        @Override
        public int getAdditionalImpactCount() {
            if (this.additionalImpactBuilder_ == null) {
                return this.additionalImpact_.size();
            }
            return this.additionalImpactBuilder_.getCount();
        }

        @Override
        public Impact getAdditionalImpact(int index) {
            if (this.additionalImpactBuilder_ == null) {
                return this.additionalImpact_.get(index);
            }
            return (Impact)this.additionalImpactBuilder_.getMessage(index);
        }

        public Builder setAdditionalImpact(int index, Impact value) {
            if (this.additionalImpactBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalImpactIsMutable();
                this.additionalImpact_.set(index, value);
                this.onChanged();
            } else {
                this.additionalImpactBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAdditionalImpact(int index, Impact.Builder builderForValue) {
            if (this.additionalImpactBuilder_ == null) {
                this.ensureAdditionalImpactIsMutable();
                this.additionalImpact_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.additionalImpactBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdditionalImpact(Impact value) {
            if (this.additionalImpactBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalImpactIsMutable();
                this.additionalImpact_.add(value);
                this.onChanged();
            } else {
                this.additionalImpactBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdditionalImpact(int index, Impact value) {
            if (this.additionalImpactBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdditionalImpactIsMutable();
                this.additionalImpact_.add(index, value);
                this.onChanged();
            } else {
                this.additionalImpactBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdditionalImpact(Impact.Builder builderForValue) {
            if (this.additionalImpactBuilder_ == null) {
                this.ensureAdditionalImpactIsMutable();
                this.additionalImpact_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.additionalImpactBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdditionalImpact(int index, Impact.Builder builderForValue) {
            if (this.additionalImpactBuilder_ == null) {
                this.ensureAdditionalImpactIsMutable();
                this.additionalImpact_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.additionalImpactBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAdditionalImpact(Iterable<? extends Impact> values) {
            if (this.additionalImpactBuilder_ == null) {
                this.ensureAdditionalImpactIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.additionalImpact_);
                this.onChanged();
            } else {
                this.additionalImpactBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAdditionalImpact() {
            if (this.additionalImpactBuilder_ == null) {
                this.additionalImpact_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
            } else {
                this.additionalImpactBuilder_.clear();
            }
            return this;
        }

        public Builder removeAdditionalImpact(int index) {
            if (this.additionalImpactBuilder_ == null) {
                this.ensureAdditionalImpactIsMutable();
                this.additionalImpact_.remove(index);
                this.onChanged();
            } else {
                this.additionalImpactBuilder_.remove(index);
            }
            return this;
        }

        public Impact.Builder getAdditionalImpactBuilder(int index) {
            return (Impact.Builder)this.getAdditionalImpactFieldBuilder().getBuilder(index);
        }

        @Override
        public ImpactOrBuilder getAdditionalImpactOrBuilder(int index) {
            if (this.additionalImpactBuilder_ == null) {
                return this.additionalImpact_.get(index);
            }
            return (ImpactOrBuilder)this.additionalImpactBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ImpactOrBuilder> getAdditionalImpactOrBuilderList() {
            if (this.additionalImpactBuilder_ != null) {
                return this.additionalImpactBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.additionalImpact_);
        }

        public Impact.Builder addAdditionalImpactBuilder() {
            return (Impact.Builder)this.getAdditionalImpactFieldBuilder().addBuilder((AbstractMessage)Impact.getDefaultInstance());
        }

        public Impact.Builder addAdditionalImpactBuilder(int index) {
            return (Impact.Builder)this.getAdditionalImpactFieldBuilder().addBuilder(index, (AbstractMessage)Impact.getDefaultInstance());
        }

        public List<Impact.Builder> getAdditionalImpactBuilderList() {
            return this.getAdditionalImpactFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Impact, Impact.Builder, ImpactOrBuilder> getAdditionalImpactFieldBuilder() {
            if (this.additionalImpactBuilder_ == null) {
                this.additionalImpactBuilder_ = new RepeatedFieldBuilderV3(this.additionalImpact_, (this.bitField0_ & 0x20) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.additionalImpact_ = null;
            }
            return this.additionalImpactBuilder_;
        }

        @Override
        public int getPriorityValue() {
            return this.priority_;
        }

        public Builder setPriorityValue(int value) {
            this.priority_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public Priority getPriority() {
            Priority result = Priority.forNumber(this.priority_);
            return result == null ? Priority.UNRECOGNIZED : result;
        }

        public Builder setPriority(Priority value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40;
            this.priority_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPriority() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.priority_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasContent() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public RecommendationContent getContent() {
            if (this.contentBuilder_ == null) {
                return this.content_ == null ? RecommendationContent.getDefaultInstance() : this.content_;
            }
            return (RecommendationContent)this.contentBuilder_.getMessage();
        }

        public Builder setContent(RecommendationContent value) {
            if (this.contentBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.content_ = value;
            } else {
                this.contentBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setContent(RecommendationContent.Builder builderForValue) {
            if (this.contentBuilder_ == null) {
                this.content_ = builderForValue.build();
            } else {
                this.contentBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeContent(RecommendationContent value) {
            if (this.contentBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.content_ != null && this.content_ != RecommendationContent.getDefaultInstance()) {
                    this.getContentBuilder().mergeFrom(value);
                } else {
                    this.content_ = value;
                }
            } else {
                this.contentBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearContent() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.content_ = null;
            if (this.contentBuilder_ != null) {
                this.contentBuilder_.dispose();
                this.contentBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public RecommendationContent.Builder getContentBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (RecommendationContent.Builder)this.getContentFieldBuilder().getBuilder();
        }

        @Override
        public RecommendationContentOrBuilder getContentOrBuilder() {
            if (this.contentBuilder_ != null) {
                return (RecommendationContentOrBuilder)this.contentBuilder_.getMessageOrBuilder();
            }
            return this.content_ == null ? RecommendationContent.getDefaultInstance() : this.content_;
        }

        private SingleFieldBuilderV3<RecommendationContent, RecommendationContent.Builder, RecommendationContentOrBuilder> getContentFieldBuilder() {
            if (this.contentBuilder_ == null) {
                this.contentBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getContent(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.content_ = null;
            }
            return this.contentBuilder_;
        }

        @Override
        public boolean hasStateInfo() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public RecommendationStateInfo getStateInfo() {
            if (this.stateInfoBuilder_ == null) {
                return this.stateInfo_ == null ? RecommendationStateInfo.getDefaultInstance() : this.stateInfo_;
            }
            return (RecommendationStateInfo)this.stateInfoBuilder_.getMessage();
        }

        public Builder setStateInfo(RecommendationStateInfo value) {
            if (this.stateInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.stateInfo_ = value;
            } else {
                this.stateInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setStateInfo(RecommendationStateInfo.Builder builderForValue) {
            if (this.stateInfoBuilder_ == null) {
                this.stateInfo_ = builderForValue.build();
            } else {
                this.stateInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeStateInfo(RecommendationStateInfo value) {
            if (this.stateInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.stateInfo_ != null && this.stateInfo_ != RecommendationStateInfo.getDefaultInstance()) {
                    this.getStateInfoBuilder().mergeFrom(value);
                } else {
                    this.stateInfo_ = value;
                }
            } else {
                this.stateInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearStateInfo() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.stateInfo_ = null;
            if (this.stateInfoBuilder_ != null) {
                this.stateInfoBuilder_.dispose();
                this.stateInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public RecommendationStateInfo.Builder getStateInfoBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (RecommendationStateInfo.Builder)this.getStateInfoFieldBuilder().getBuilder();
        }

        @Override
        public RecommendationStateInfoOrBuilder getStateInfoOrBuilder() {
            if (this.stateInfoBuilder_ != null) {
                return (RecommendationStateInfoOrBuilder)this.stateInfoBuilder_.getMessageOrBuilder();
            }
            return this.stateInfo_ == null ? RecommendationStateInfo.getDefaultInstance() : this.stateInfo_;
        }

        private SingleFieldBuilderV3<RecommendationStateInfo, RecommendationStateInfo.Builder, RecommendationStateInfoOrBuilder> getStateInfoFieldBuilder() {
            if (this.stateInfoBuilder_ == null) {
                this.stateInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStateInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.stateInfo_ = null;
            }
            return this.stateInfoBuilder_;
        }

        @Override
        public String getEtag() {
            Object ref = this.etag_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.etag_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEtagBytes() {
            Object ref = this.etag_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.etag_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEtag(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.etag_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearEtag() {
            this.etag_ = Recommendation.getDefaultInstance().getEtag();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder setEtagBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Recommendation.checkByteStringIsUtf8((ByteString)value);
            this.etag_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        private void ensureAssociatedInsightsIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.associatedInsights_ = new ArrayList<InsightReference>(this.associatedInsights_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<InsightReference> getAssociatedInsightsList() {
            if (this.associatedInsightsBuilder_ == null) {
                return Collections.unmodifiableList(this.associatedInsights_);
            }
            return this.associatedInsightsBuilder_.getMessageList();
        }

        @Override
        public int getAssociatedInsightsCount() {
            if (this.associatedInsightsBuilder_ == null) {
                return this.associatedInsights_.size();
            }
            return this.associatedInsightsBuilder_.getCount();
        }

        @Override
        public InsightReference getAssociatedInsights(int index) {
            if (this.associatedInsightsBuilder_ == null) {
                return this.associatedInsights_.get(index);
            }
            return (InsightReference)this.associatedInsightsBuilder_.getMessage(index);
        }

        public Builder setAssociatedInsights(int index, InsightReference value) {
            if (this.associatedInsightsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAssociatedInsightsIsMutable();
                this.associatedInsights_.set(index, value);
                this.onChanged();
            } else {
                this.associatedInsightsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAssociatedInsights(int index, InsightReference.Builder builderForValue) {
            if (this.associatedInsightsBuilder_ == null) {
                this.ensureAssociatedInsightsIsMutable();
                this.associatedInsights_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.associatedInsightsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAssociatedInsights(InsightReference value) {
            if (this.associatedInsightsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAssociatedInsightsIsMutable();
                this.associatedInsights_.add(value);
                this.onChanged();
            } else {
                this.associatedInsightsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAssociatedInsights(int index, InsightReference value) {
            if (this.associatedInsightsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAssociatedInsightsIsMutable();
                this.associatedInsights_.add(index, value);
                this.onChanged();
            } else {
                this.associatedInsightsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAssociatedInsights(InsightReference.Builder builderForValue) {
            if (this.associatedInsightsBuilder_ == null) {
                this.ensureAssociatedInsightsIsMutable();
                this.associatedInsights_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.associatedInsightsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAssociatedInsights(int index, InsightReference.Builder builderForValue) {
            if (this.associatedInsightsBuilder_ == null) {
                this.ensureAssociatedInsightsIsMutable();
                this.associatedInsights_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.associatedInsightsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAssociatedInsights(Iterable<? extends InsightReference> values) {
            if (this.associatedInsightsBuilder_ == null) {
                this.ensureAssociatedInsightsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.associatedInsights_);
                this.onChanged();
            } else {
                this.associatedInsightsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAssociatedInsights() {
            if (this.associatedInsightsBuilder_ == null) {
                this.associatedInsights_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFBFF;
                this.onChanged();
            } else {
                this.associatedInsightsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAssociatedInsights(int index) {
            if (this.associatedInsightsBuilder_ == null) {
                this.ensureAssociatedInsightsIsMutable();
                this.associatedInsights_.remove(index);
                this.onChanged();
            } else {
                this.associatedInsightsBuilder_.remove(index);
            }
            return this;
        }

        public InsightReference.Builder getAssociatedInsightsBuilder(int index) {
            return (InsightReference.Builder)this.getAssociatedInsightsFieldBuilder().getBuilder(index);
        }

        @Override
        public InsightReferenceOrBuilder getAssociatedInsightsOrBuilder(int index) {
            if (this.associatedInsightsBuilder_ == null) {
                return this.associatedInsights_.get(index);
            }
            return (InsightReferenceOrBuilder)this.associatedInsightsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends InsightReferenceOrBuilder> getAssociatedInsightsOrBuilderList() {
            if (this.associatedInsightsBuilder_ != null) {
                return this.associatedInsightsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.associatedInsights_);
        }

        public InsightReference.Builder addAssociatedInsightsBuilder() {
            return (InsightReference.Builder)this.getAssociatedInsightsFieldBuilder().addBuilder((AbstractMessage)InsightReference.getDefaultInstance());
        }

        public InsightReference.Builder addAssociatedInsightsBuilder(int index) {
            return (InsightReference.Builder)this.getAssociatedInsightsFieldBuilder().addBuilder(index, (AbstractMessage)InsightReference.getDefaultInstance());
        }

        public List<InsightReference.Builder> getAssociatedInsightsBuilderList() {
            return this.getAssociatedInsightsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<InsightReference, InsightReference.Builder, InsightReferenceOrBuilder> getAssociatedInsightsFieldBuilder() {
            if (this.associatedInsightsBuilder_ == null) {
                this.associatedInsightsBuilder_ = new RepeatedFieldBuilderV3(this.associatedInsights_, (this.bitField0_ & 0x400) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.associatedInsights_ = null;
            }
            return this.associatedInsightsBuilder_;
        }

        @Override
        public String getXorGroupId() {
            Object ref = this.xorGroupId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.xorGroupId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getXorGroupIdBytes() {
            Object ref = this.xorGroupId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.xorGroupId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setXorGroupId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.xorGroupId_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearXorGroupId() {
            this.xorGroupId_ = Recommendation.getDefaultInstance().getXorGroupId();
            this.bitField0_ &= 0xFFFFF7FF;
            this.onChanged();
            return this;
        }

        public Builder setXorGroupIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Recommendation.checkByteStringIsUtf8((ByteString)value);
            this.xorGroupId_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class InsightReference
    extends GeneratedMessageV3
    implements InsightReferenceOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int INSIGHT_FIELD_NUMBER = 1;
        private volatile Object insight_ = "";
        private byte memoizedIsInitialized = (byte)-1;
        private static final InsightReference DEFAULT_INSTANCE = new InsightReference();
        private static final Parser<InsightReference> PARSER = new AbstractParser<InsightReference>(){

            public InsightReference parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = InsightReference.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private InsightReference(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private InsightReference() {
            this.insight_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new InsightReference();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return RecommendationOuterClass.internal_static_google_cloud_recommender_v1_Recommendation_InsightReference_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return RecommendationOuterClass.internal_static_google_cloud_recommender_v1_Recommendation_InsightReference_fieldAccessorTable.ensureFieldAccessorsInitialized(InsightReference.class, Builder.class);
        }

        @Override
        public String getInsight() {
            Object ref = this.insight_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.insight_ = s;
            return s;
        }

        @Override
        public ByteString getInsightBytes() {
            Object ref = this.insight_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.insight_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.insight_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.insight_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.insight_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.insight_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof InsightReference)) {
                return super.equals(obj);
            }
            InsightReference other = (InsightReference)obj;
            if (!this.getInsight().equals(other.getInsight())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + InsightReference.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getInsight().hashCode();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static InsightReference parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (InsightReference)PARSER.parseFrom(data);
        }

        public static InsightReference parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (InsightReference)PARSER.parseFrom(data, extensionRegistry);
        }

        public static InsightReference parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (InsightReference)PARSER.parseFrom(data);
        }

        public static InsightReference parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (InsightReference)PARSER.parseFrom(data, extensionRegistry);
        }

        public static InsightReference parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (InsightReference)PARSER.parseFrom(data);
        }

        public static InsightReference parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (InsightReference)PARSER.parseFrom(data, extensionRegistry);
        }

        public static InsightReference parseFrom(InputStream input) throws IOException {
            return (InsightReference)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static InsightReference parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (InsightReference)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static InsightReference parseDelimitedFrom(InputStream input) throws IOException {
            return (InsightReference)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static InsightReference parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (InsightReference)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static InsightReference parseFrom(CodedInputStream input) throws IOException {
            return (InsightReference)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static InsightReference parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (InsightReference)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return InsightReference.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(InsightReference prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static InsightReference getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<InsightReference> parser() {
            return PARSER;
        }

        public Parser<InsightReference> getParserForType() {
            return PARSER;
        }

        public InsightReference getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements InsightReferenceOrBuilder {
            private int bitField0_;
            private Object insight_ = "";

            public static final Descriptors.Descriptor getDescriptor() {
                return RecommendationOuterClass.internal_static_google_cloud_recommender_v1_Recommendation_InsightReference_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return RecommendationOuterClass.internal_static_google_cloud_recommender_v1_Recommendation_InsightReference_fieldAccessorTable.ensureFieldAccessorsInitialized(InsightReference.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.insight_ = "";
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return RecommendationOuterClass.internal_static_google_cloud_recommender_v1_Recommendation_InsightReference_descriptor;
            }

            public InsightReference getDefaultInstanceForType() {
                return InsightReference.getDefaultInstance();
            }

            public InsightReference build() {
                InsightReference result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public InsightReference buildPartial() {
                InsightReference result = new InsightReference(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(InsightReference result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.insight_ = this.insight_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof InsightReference) {
                    return this.mergeFrom((InsightReference)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(InsightReference other) {
                if (other == InsightReference.getDefaultInstance()) {
                    return this;
                }
                if (!other.getInsight().isEmpty()) {
                    this.insight_ = other.insight_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                this.insight_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getInsight() {
                Object ref = this.insight_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.insight_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getInsightBytes() {
                Object ref = this.insight_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.insight_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setInsight(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.insight_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearInsight() {
                this.insight_ = InsightReference.getDefaultInstance().getInsight();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setInsightBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                InsightReference.checkByteStringIsUtf8((ByteString)value);
                this.insight_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface InsightReferenceOrBuilder
    extends MessageOrBuilder {
        public String getInsight();

        public ByteString getInsightBytes();
    }

    public static enum Priority implements ProtocolMessageEnum
    {
        PRIORITY_UNSPECIFIED(0),
        P4(1),
        P3(2),
        P2(3),
        P1(4),
        UNRECOGNIZED(-1);

        public static final int PRIORITY_UNSPECIFIED_VALUE = 0;
        public static final int P4_VALUE = 1;
        public static final int P3_VALUE = 2;
        public static final int P2_VALUE = 3;
        public static final int P1_VALUE = 4;
        private static final Internal.EnumLiteMap<Priority> internalValueMap;
        private static final Priority[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Priority valueOf(int value) {
            return Priority.forNumber(value);
        }

        public static Priority forNumber(int value) {
            switch (value) {
                case 0: {
                    return PRIORITY_UNSPECIFIED;
                }
                case 1: {
                    return P4;
                }
                case 2: {
                    return P3;
                }
                case 3: {
                    return P2;
                }
                case 4: {
                    return P1;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Priority> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Priority.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Priority.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Recommendation.getDescriptor().getEnumTypes().get(0);
        }

        public static Priority valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Priority.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Priority(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Priority>(){

                public Priority findValueByNumber(int number) {
                    return Priority.forNumber(number);
                }
            };
            VALUES = Priority.values();
        }
    }
}

