/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommender.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InsightName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSIGHT_TYPE_INSIGHT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/insightTypes/{insight_type}/insights/{insight}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String insightType;
    private final String insight;

    @Deprecated
    protected InsightName() {
        this.project = null;
        this.location = null;
        this.insightType = null;
        this.insight = null;
    }

    private InsightName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.insightType = (String)Preconditions.checkNotNull((Object)builder.getInsightType());
        this.insight = (String)Preconditions.checkNotNull((Object)builder.getInsight());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInsightType() {
        return this.insightType;
    }

    public String getInsight() {
        return this.insight;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InsightName of(String project, String location, String insightType, String insight) {
        return InsightName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).setInsight(insight).build();
    }

    public static String format(String project, String location, String insightType, String insight) {
        return InsightName.newBuilder().setProject(project).setLocation(location).setInsightType(insightType).setInsight(insight).build().toString();
    }

    public static InsightName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSIGHT_TYPE_INSIGHT.validatedMatch(formattedString, "InsightName.parse: formattedString not in valid format");
        return InsightName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("insight_type"), (String)matchMap.get("insight"));
    }

    public static List<InsightName> parseList(List<String> formattedStrings) {
        ArrayList<InsightName> list = new ArrayList<InsightName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InsightName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InsightName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InsightName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSIGHT_TYPE_INSIGHT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InsightName insightName = this;
            synchronized (insightName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.insightType != null) {
                        fieldMapBuilder.put((Object)"insight_type", (Object)this.insightType);
                    }
                    if (this.insight != null) {
                        fieldMapBuilder.put((Object)"insight", (Object)this.insight);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSIGHT_TYPE_INSIGHT.instantiate(new String[]{"project", this.project, "location", this.location, "insight_type", this.insightType, "insight", this.insight});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            InsightName that = (InsightName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.insightType, that.insightType) && Objects.equals(this.insight, that.insight);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.insightType);
        h *= 1000003;
        return h ^= Objects.hashCode(this.insight);
    }

    public static class Builder {
        private String project;
        private String location;
        private String insightType;
        private String insight;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInsightType() {
            return this.insightType;
        }

        public String getInsight() {
            return this.insight;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInsightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        public Builder setInsight(String insight) {
            this.insight = insight;
            return this;
        }

        private Builder(InsightName insightName) {
            this.project = insightName.project;
            this.location = insightName.location;
            this.insightType = insightName.insightType;
            this.insight = insightName.insight;
        }

        public InsightName build() {
            return new InsightName(this);
        }
    }
}

