/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommendationengine.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PlacementName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CATALOG_EVENT_STORE_PLACEMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/eventStores/{event_store}/placements/{placement}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;
    private final String eventStore;
    private final String placement;

    @Deprecated
    protected PlacementName() {
        this.project = null;
        this.location = null;
        this.catalog = null;
        this.eventStore = null;
        this.placement = null;
    }

    private PlacementName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.eventStore = (String)Preconditions.checkNotNull((Object)builder.getEventStore());
        this.placement = (String)Preconditions.checkNotNull((Object)builder.getPlacement());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getEventStore() {
        return this.eventStore;
    }

    public String getPlacement() {
        return this.placement;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PlacementName of(String project, String location, String catalog, String eventStore, String placement) {
        return PlacementName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setEventStore(eventStore).setPlacement(placement).build();
    }

    public static String format(String project, String location, String catalog, String eventStore, String placement) {
        return PlacementName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setEventStore(eventStore).setPlacement(placement).build().toString();
    }

    public static PlacementName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CATALOG_EVENT_STORE_PLACEMENT.validatedMatch(formattedString, "PlacementName.parse: formattedString not in valid format");
        return PlacementName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"), (String)matchMap.get("event_store"), (String)matchMap.get("placement"));
    }

    public static List<PlacementName> parseList(List<String> formattedStrings) {
        ArrayList<PlacementName> list = new ArrayList<PlacementName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PlacementName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PlacementName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PlacementName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CATALOG_EVENT_STORE_PLACEMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PlacementName placementName = this;
            synchronized (placementName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    if (this.eventStore != null) {
                        fieldMapBuilder.put((Object)"event_store", (Object)this.eventStore);
                    }
                    if (this.placement != null) {
                        fieldMapBuilder.put((Object)"placement", (Object)this.placement);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CATALOG_EVENT_STORE_PLACEMENT.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog, "event_store", this.eventStore, "placement", this.placement});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PlacementName that = (PlacementName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.eventStore, that.eventStore) && Objects.equals(this.placement, that.placement);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.catalog);
        h *= 1000003;
        h ^= Objects.hashCode(this.eventStore);
        h *= 1000003;
        return h ^= Objects.hashCode(this.placement);
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;
        private String eventStore;
        private String placement;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getEventStore() {
            return this.eventStore;
        }

        public String getPlacement() {
            return this.placement;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setEventStore(String eventStore) {
            this.eventStore = eventStore;
            return this;
        }

        public Builder setPlacement(String placement) {
            this.placement = placement;
            return this;
        }

        private Builder(PlacementName placementName) {
            this.project = placementName.project;
            this.location = placementName.location;
            this.catalog = placementName.catalog;
            this.eventStore = placementName.eventStore;
            this.placement = placementName.placement;
        }

        public PlacementName build() {
            return new PlacementName(this);
        }
    }
}

