/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommendationengine.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CatalogItemPathName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CATALOG_CATALOG_ITEM_PATH = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/catalogItems/{catalog_item_path=**}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;
    private final String catalogItemPath;

    @Deprecated
    protected CatalogItemPathName() {
        this.project = null;
        this.location = null;
        this.catalog = null;
        this.catalogItemPath = null;
    }

    private CatalogItemPathName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.catalogItemPath = (String)Preconditions.checkNotNull((Object)builder.getCatalogItemPath());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getCatalogItemPath() {
        return this.catalogItemPath;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CatalogItemPathName of(String project, String location, String catalog, String catalogItemPath) {
        return CatalogItemPathName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setCatalogItemPath(catalogItemPath).build();
    }

    public static String format(String project, String location, String catalog, String catalogItemPath) {
        return CatalogItemPathName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setCatalogItemPath(catalogItemPath).build().toString();
    }

    public static CatalogItemPathName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CATALOG_CATALOG_ITEM_PATH.validatedMatch(formattedString, "CatalogItemPathName.parse: formattedString not in valid format");
        return CatalogItemPathName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"), (String)matchMap.get("catalog_item_path"));
    }

    public static List<CatalogItemPathName> parseList(List<String> formattedStrings) {
        ArrayList<CatalogItemPathName> list = new ArrayList<CatalogItemPathName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CatalogItemPathName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CatalogItemPathName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CatalogItemPathName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CATALOG_CATALOG_ITEM_PATH.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CatalogItemPathName catalogItemPathName = this;
            synchronized (catalogItemPathName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    if (this.catalogItemPath != null) {
                        fieldMapBuilder.put((Object)"catalog_item_path", (Object)this.catalogItemPath);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CATALOG_CATALOG_ITEM_PATH.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog, "catalog_item_path", this.catalogItemPath});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CatalogItemPathName that = (CatalogItemPathName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.catalogItemPath, that.catalogItemPath);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.catalog);
        h *= 1000003;
        return h ^= Objects.hashCode(this.catalogItemPath);
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;
        private String catalogItemPath;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getCatalogItemPath() {
            return this.catalogItemPath;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setCatalogItemPath(String catalogItemPath) {
            this.catalogItemPath = catalogItemPath;
            return this;
        }

        private Builder(CatalogItemPathName catalogItemPathName) {
            this.project = catalogItemPathName.project;
            this.location = catalogItemPathName.location;
            this.catalog = catalogItemPathName.catalog;
            this.catalogItemPath = catalogItemPathName.catalogItemPath;
        }

        public CatalogItemPathName build() {
            return new CatalogItemPathName(this);
        }
    }
}

