/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommendationengine.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EventStoreName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/eventStores/{event_store}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;
    private final String eventStore;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getEventStore() {
        return this.eventStore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private EventStoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.eventStore = (String)Preconditions.checkNotNull((Object)builder.getEventStore());
    }

    public static EventStoreName of(String project, String location, String catalog, String eventStore) {
        return EventStoreName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setEventStore(eventStore).build();
    }

    public static String format(String project, String location, String catalog, String eventStore) {
        return EventStoreName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setEventStore(eventStore).build().toString();
    }

    public static EventStoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "EventStoreName.parse: formattedString not in valid format");
        return EventStoreName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"), (String)matchMap.get("event_store"));
    }

    public static List<EventStoreName> parseList(List<String> formattedStrings) {
        ArrayList<EventStoreName> list = new ArrayList<EventStoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EventStoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EventStoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EventStoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EventStoreName eventStoreName = this;
            synchronized (eventStoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    fieldMapBuilder.put((Object)"eventStore", (Object)this.eventStore);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog, "event_store", this.eventStore});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EventStoreName) {
            EventStoreName that = (EventStoreName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.catalog.equals(that.catalog) && this.eventStore.equals(that.eventStore);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.catalog.hashCode();
        h *= 1000003;
        return h ^= this.eventStore.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;
        private String eventStore;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getEventStore() {
            return this.eventStore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setEventStore(String eventStore) {
            this.eventStore = eventStore;
            return this;
        }

        private Builder() {
        }

        private Builder(EventStoreName eventStoreName) {
            this.project = eventStoreName.project;
            this.location = eventStoreName.location;
            this.catalog = eventStoreName.catalog;
            this.eventStore = eventStoreName.eventStore;
        }

        public EventStoreName build() {
            return new EventStoreName(this);
        }
    }
}

