/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto

// Protobuf Java Version: 3.25.8
package com.google.recaptchaenterprise.v1beta1;

/**
 *
 *
 * <pre>
 * Describes an event in the lifecycle of a payment transaction.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionEvent}
 */
public final class TransactionEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionEvent)
    TransactionEventOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TransactionEvent.newBuilder() to construct.
  private TransactionEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransactionEvent() {
    eventType_ = 0;
    reason_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransactionEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1beta1.TransactionEvent.class,
            com.google.recaptchaenterprise.v1beta1.TransactionEvent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enum that represents an event in the payment transaction lifecycle.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType}
   */
  public enum TransactionEventType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default, unspecified event type.
     * </pre>
     *
     * <code>TRANSACTION_EVENT_TYPE_UNSPECIFIED = 0;</code>
     */
    TRANSACTION_EVENT_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction is approved by the merchant. The
     * accompanying reasons can include terms such as 'INHOUSE', 'ACCERTIFY',
     * 'CYBERSOURCE', or 'MANUAL_REVIEW'.
     * </pre>
     *
     * <code>MERCHANT_APPROVE = 1;</code>
     */
    MERCHANT_APPROVE(1),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction is denied and concluded due to risks
     * detected by the merchant. The accompanying reasons can include terms such
     * as 'INHOUSE',  'ACCERTIFY',  'CYBERSOURCE', or 'MANUAL_REVIEW'.
     * </pre>
     *
     * <code>MERCHANT_DENY = 2;</code>
     */
    MERCHANT_DENY(2),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction is being evaluated by a human, due to
     * suspicion or risk.
     * </pre>
     *
     * <code>MANUAL_REVIEW = 3;</code>
     */
    MANUAL_REVIEW(3),
    /**
     *
     *
     * <pre>
     * Indicates that the authorization attempt with the card issuer succeeded.
     * </pre>
     *
     * <code>AUTHORIZATION = 4;</code>
     */
    AUTHORIZATION(4),
    /**
     *
     *
     * <pre>
     * Indicates that the authorization attempt with the card issuer failed.
     * The accompanying reasons can include Visa's '54' indicating that the card
     * is expired, or '82' indicating that the CVV is incorrect.
     * </pre>
     *
     * <code>AUTHORIZATION_DECLINE = 5;</code>
     */
    AUTHORIZATION_DECLINE(5),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction is completed because the funds were
     * settled.
     * </pre>
     *
     * <code>PAYMENT_CAPTURE = 6;</code>
     */
    PAYMENT_CAPTURE(6),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction could not be completed because the funds
     * were not settled.
     * </pre>
     *
     * <code>PAYMENT_CAPTURE_DECLINE = 7;</code>
     */
    PAYMENT_CAPTURE_DECLINE(7),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction has been canceled. Specify the reason
     * for the cancellation. For example, 'INSUFFICIENT_INVENTORY'.
     * </pre>
     *
     * <code>CANCEL = 8;</code>
     */
    CANCEL(8),
    /**
     *
     *
     * <pre>
     * Indicates that the merchant has received a chargeback inquiry due to
     * fraud for the transaction, requesting additional information before a
     * fraud chargeback is officially issued and a formal chargeback
     * notification is sent.
     * </pre>
     *
     * <code>CHARGEBACK_INQUIRY = 9;</code>
     */
    CHARGEBACK_INQUIRY(9),
    /**
     *
     *
     * <pre>
     * Indicates that the merchant has received a chargeback alert due to fraud
     * for the transaction. The process of resolving the dispute without
     * involving the payment network is started.
     * </pre>
     *
     * <code>CHARGEBACK_ALERT = 10;</code>
     */
    CHARGEBACK_ALERT(10),
    /**
     *
     *
     * <pre>
     * Indicates that a fraud notification is issued for the transaction, sent
     * by the payment instrument's issuing bank because the transaction appears
     * to be fraudulent. We recommend including TC40 or SAFE data in the
     * `reason` field for this event type. For partial chargebacks, we recommend
     * that you include an amount in the `value` field.
     * </pre>
     *
     * <code>FRAUD_NOTIFICATION = 11;</code>
     */
    FRAUD_NOTIFICATION(11),
    /**
     *
     *
     * <pre>
     * Indicates that the merchant is informed by the payment network that the
     * transaction has entered the chargeback process due to fraud. Reason code
     * examples include Discover's '6005' and '6041'. For partial chargebacks,
     * we recommend that you include an amount in the `value` field.
     * </pre>
     *
     * <code>CHARGEBACK = 12;</code>
     */
    CHARGEBACK(12),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction has entered the chargeback process due to
     * fraud, and that the merchant has chosen to enter representment. Reason
     * examples include Discover's '6005' and '6041'. For partial chargebacks,
     * we recommend that you include an amount in the `value` field.
     * </pre>
     *
     * <code>CHARGEBACK_REPRESENTMENT = 13;</code>
     */
    CHARGEBACK_REPRESENTMENT(13),
    /**
     *
     *
     * <pre>
     * Indicates that the transaction has had a fraud chargeback which was
     * illegitimate and was reversed as a result. For partial chargebacks, we
     * recommend that you include an amount in the `value` field.
     * </pre>
     *
     * <code>CHARGEBACK_REVERSE = 14;</code>
     */
    CHARGEBACK_REVERSE(14),
    /**
     *
     *
     * <pre>
     * Indicates that the merchant has received a refund for a completed
     * transaction. For partial refunds, we recommend that you include an amount
     * in the `value` field. Reason example: 'TAX_EXEMPT' (partial refund of
     * exempt tax)
     * </pre>
     *
     * <code>REFUND_REQUEST = 15;</code>
     */
    REFUND_REQUEST(15),
    /**
     *
     *
     * <pre>
     * Indicates that the merchant has received a refund request for this
     * transaction, but that they have declined it. For partial refunds, we
     * recommend that you include an amount in the `value` field. Reason
     * example: 'TAX_EXEMPT' (partial refund of exempt tax)
     * </pre>
     *
     * <code>REFUND_DECLINE = 16;</code>
     */
    REFUND_DECLINE(16),
    /**
     *
     *
     * <pre>
     * Indicates that the completed transaction was refunded by the merchant.
     * For partial refunds, we recommend that you include an amount in the
     * `value` field. Reason example: 'TAX_EXEMPT' (partial refund of exempt
     * tax)
     * </pre>
     *
     * <code>REFUND = 17;</code>
     */
    REFUND(17),
    /**
     *
     *
     * <pre>
     * Indicates that the completed transaction was refunded by the merchant,
     * and that this refund was reversed. For partial refunds, we recommend that
     * you include an amount in the `value` field.
     * </pre>
     *
     * <code>REFUND_REVERSE = 18;</code>
     */
    REFUND_REVERSE(18),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default, unspecified event type.
     * </pre>
     *
     * <code>TRANSACTION_EVENT_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TRANSACTION_EVENT_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Indicates that the transaction is approved by the merchant. The
     * accompanying reasons can include terms such as 'INHOUSE', 'ACCERTIFY',
     * 'CYBERSOURCE', or 'MANUAL_REVIEW'.
     * </pre>
     *
     * <code>MERCHANT_APPROVE = 1;</code>
     */
    public static final int MERCHANT_APPROVE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Indicates that the transaction is denied and concluded due to risks
     * detected by the merchant. The accompanying reasons can include terms such
     * as 'INHOUSE',  'ACCERTIFY',  'CYBERSOURCE', or 'MANUAL_REVIEW'.
     * </pre>
     *
     * <code>MERCHANT_DENY = 2;</code>
     */
    public static final int MERCHANT_DENY_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Indicates that the transaction is being evaluated by a human, due to
     * suspicion or risk.
     * </pre>
     *
     * <code>MANUAL_REVIEW = 3;</code>
     */
    public static final int MANUAL_REVIEW_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Indicates that the authorization attempt with the card issuer succeeded.
     * </pre>
     *
     * <code>AUTHORIZATION = 4;</code>
     */
    public static final int AUTHORIZATION_VALUE = 4;

    /**
     *
     *
     * <pre>
     * Indicates that the authorization attempt with the card issuer failed.
     * The accompanying reasons can include Visa's '54' indicating that the card
     * is expired, or '82' indicating that the CVV is incorrect.
     * </pre>
     *
     * <code>AUTHORIZATION_DECLINE = 5;</code>
     */
    public static final int AUTHORIZATION_DECLINE_VALUE = 5;

    /**
     *
     *
     * <pre>
     * Indicates that the transaction is completed because the funds were
     * settled.
     * </pre>
     *
     * <code>PAYMENT_CAPTURE = 6;</code>
     */
    public static final int PAYMENT_CAPTURE_VALUE = 6;

    /**
     *
     *
     * <pre>
     * Indicates that the transaction could not be completed because the funds
     * were not settled.
     * </pre>
     *
     * <code>PAYMENT_CAPTURE_DECLINE = 7;</code>
     */
    public static final int PAYMENT_CAPTURE_DECLINE_VALUE = 7;

    /**
     *
     *
     * <pre>
     * Indicates that the transaction has been canceled. Specify the reason
     * for the cancellation. For example, 'INSUFFICIENT_INVENTORY'.
     * </pre>
     *
     * <code>CANCEL = 8;</code>
     */
    public static final int CANCEL_VALUE = 8;

    /**
     *
     *
     * <pre>
     * Indicates that the merchant has received a chargeback inquiry due to
     * fraud for the transaction, requesting additional information before a
     * fraud chargeback is officially issued and a formal chargeback
     * notification is sent.
     * </pre>
     *
     * <code>CHARGEBACK_INQUIRY = 9;</code>
     */
    public static final int CHARGEBACK_INQUIRY_VALUE = 9;

    /**
     *
     *
     * <pre>
     * Indicates that the merchant has received a chargeback alert due to fraud
     * for the transaction. The process of resolving the dispute without
     * involving the payment network is started.
     * </pre>
     *
     * <code>CHARGEBACK_ALERT = 10;</code>
     */
    public static final int CHARGEBACK_ALERT_VALUE = 10;

    /**
     *
     *
     * <pre>
     * Indicates that a fraud notification is issued for the transaction, sent
     * by the payment instrument's issuing bank because the transaction appears
     * to be fraudulent. We recommend including TC40 or SAFE data in the
     * `reason` field for this event type. For partial chargebacks, we recommend
     * that you include an amount in the `value` field.
     * </pre>
     *
     * <code>FRAUD_NOTIFICATION = 11;</code>
     */
    public static final int FRAUD_NOTIFICATION_VALUE = 11;

    /**
     *
     *
     * <pre>
     * Indicates that the merchant is informed by the payment network that the
     * transaction has entered the chargeback process due to fraud. Reason code
     * examples include Discover's '6005' and '6041'. For partial chargebacks,
     * we recommend that you include an amount in the `value` field.
     * </pre>
     *
     * <code>CHARGEBACK = 12;</code>
     */
    public static final int CHARGEBACK_VALUE = 12;

    /**
     *
     *
     * <pre>
     * Indicates that the transaction has entered the chargeback process due to
     * fraud, and that the merchant has chosen to enter representment. Reason
     * examples include Discover's '6005' and '6041'. For partial chargebacks,
     * we recommend that you include an amount in the `value` field.
     * </pre>
     *
     * <code>CHARGEBACK_REPRESENTMENT = 13;</code>
     */
    public static final int CHARGEBACK_REPRESENTMENT_VALUE = 13;

    /**
     *
     *
     * <pre>
     * Indicates that the transaction has had a fraud chargeback which was
     * illegitimate and was reversed as a result. For partial chargebacks, we
     * recommend that you include an amount in the `value` field.
     * </pre>
     *
     * <code>CHARGEBACK_REVERSE = 14;</code>
     */
    public static final int CHARGEBACK_REVERSE_VALUE = 14;

    /**
     *
     *
     * <pre>
     * Indicates that the merchant has received a refund for a completed
     * transaction. For partial refunds, we recommend that you include an amount
     * in the `value` field. Reason example: 'TAX_EXEMPT' (partial refund of
     * exempt tax)
     * </pre>
     *
     * <code>REFUND_REQUEST = 15;</code>
     */
    public static final int REFUND_REQUEST_VALUE = 15;

    /**
     *
     *
     * <pre>
     * Indicates that the merchant has received a refund request for this
     * transaction, but that they have declined it. For partial refunds, we
     * recommend that you include an amount in the `value` field. Reason
     * example: 'TAX_EXEMPT' (partial refund of exempt tax)
     * </pre>
     *
     * <code>REFUND_DECLINE = 16;</code>
     */
    public static final int REFUND_DECLINE_VALUE = 16;

    /**
     *
     *
     * <pre>
     * Indicates that the completed transaction was refunded by the merchant.
     * For partial refunds, we recommend that you include an amount in the
     * `value` field. Reason example: 'TAX_EXEMPT' (partial refund of exempt
     * tax)
     * </pre>
     *
     * <code>REFUND = 17;</code>
     */
    public static final int REFUND_VALUE = 17;

    /**
     *
     *
     * <pre>
     * Indicates that the completed transaction was refunded by the merchant,
     * and that this refund was reversed. For partial refunds, we recommend that
     * you include an amount in the `value` field.
     * </pre>
     *
     * <code>REFUND_REVERSE = 18;</code>
     */
    public static final int REFUND_REVERSE_VALUE = 18;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransactionEventType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TransactionEventType forNumber(int value) {
      switch (value) {
        case 0:
          return TRANSACTION_EVENT_TYPE_UNSPECIFIED;
        case 1:
          return MERCHANT_APPROVE;
        case 2:
          return MERCHANT_DENY;
        case 3:
          return MANUAL_REVIEW;
        case 4:
          return AUTHORIZATION;
        case 5:
          return AUTHORIZATION_DECLINE;
        case 6:
          return PAYMENT_CAPTURE;
        case 7:
          return PAYMENT_CAPTURE_DECLINE;
        case 8:
          return CANCEL;
        case 9:
          return CHARGEBACK_INQUIRY;
        case 10:
          return CHARGEBACK_ALERT;
        case 11:
          return FRAUD_NOTIFICATION;
        case 12:
          return CHARGEBACK;
        case 13:
          return CHARGEBACK_REPRESENTMENT;
        case 14:
          return CHARGEBACK_REVERSE;
        case 15:
          return REFUND_REQUEST;
        case 16:
          return REFUND_DECLINE;
        case 17:
          return REFUND;
        case 18:
          return REFUND_REVERSE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TransactionEventType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TransactionEventType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TransactionEventType>() {
              public TransactionEventType findValueByNumber(int number) {
                return TransactionEventType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.TransactionEvent.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final TransactionEventType[] VALUES = values();

    public static TransactionEventType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TransactionEventType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType)
  }

  private int bitField0_;
  public static final int EVENT_TYPE_FIELD_NUMBER = 1;
  private int eventType_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The type of this transaction event.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType event_type = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for eventType.
   */
  @java.lang.Override
  public int getEventTypeValue() {
    return eventType_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The type of this transaction event.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType event_type = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The eventType.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType
      getEventType() {
    com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType result =
        com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType.forNumber(
            eventType_);
    return result == null
        ? com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType.UNRECOGNIZED
        : result;
  }

  public static final int REASON_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reason_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The reason or standardized code that corresponds with this
   * transaction event, if one exists. For example, a CHARGEBACK event with code
   * 6005.
   * </pre>
   *
   * <code>string reason = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The reason.
   */
  @java.lang.Override
  public java.lang.String getReason() {
    java.lang.Object ref = reason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reason_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The reason or standardized code that corresponds with this
   * transaction event, if one exists. For example, a CHARGEBACK event with code
   * 6005.
   * </pre>
   *
   * <code>string reason = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for reason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReasonBytes() {
    java.lang.Object ref = reason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_FIELD_NUMBER = 3;
  private double value_ = 0D;

  /**
   *
   *
   * <pre>
   * Optional. The value that corresponds with this transaction event, if one
   * exists. For example, a refund event where $5.00 was refunded. Currency is
   * obtained from the original transaction data.
   * </pre>
   *
   * <code>double value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The value.
   */
  @java.lang.Override
  public double getValue() {
    return value_;
  }

  public static final int EVENT_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp eventTime_;

  /**
   *
   *
   * <pre>
   * Optional. Timestamp when this transaction event occurred; otherwise assumed
   * to be the time of the API call.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the eventTime field is set.
   */
  @java.lang.Override
  public boolean hasEventTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Timestamp when this transaction event occurred; otherwise assumed
   * to be the time of the API call.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The eventTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEventTime() {
    return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Timestamp when this transaction event occurred; otherwise assumed
   * to be the time of the API call.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
    return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (eventType_
        != com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType
            .TRANSACTION_EVENT_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, eventType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, reason_);
    }
    if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
      output.writeDouble(3, value_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getEventTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (eventType_
        != com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType
            .TRANSACTION_EVENT_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, eventType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, reason_);
    }
    if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, value_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEventTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1beta1.TransactionEvent)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1beta1.TransactionEvent other =
        (com.google.recaptchaenterprise.v1beta1.TransactionEvent) obj;

    if (eventType_ != other.eventType_) return false;
    if (!getReason().equals(other.getReason())) return false;
    if (java.lang.Double.doubleToLongBits(getValue())
        != java.lang.Double.doubleToLongBits(other.getValue())) return false;
    if (hasEventTime() != other.hasEventTime()) return false;
    if (hasEventTime()) {
      if (!getEventTime().equals(other.getEventTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EVENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + eventType_;
    hash = (37 * hash) + REASON_FIELD_NUMBER;
    hash = (53 * hash) + getReason().hashCode();
    hash = (37 * hash) + VALUE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getValue()));
    if (hasEventTime()) {
      hash = (37 * hash) + EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEventTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.recaptchaenterprise.v1beta1.TransactionEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Describes an event in the lifecycle of a payment transaction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1beta1.TransactionEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1beta1.TransactionEvent)
      com.google.recaptchaenterprise.v1beta1.TransactionEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1beta1.TransactionEvent.class,
              com.google.recaptchaenterprise.v1beta1.TransactionEvent.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1beta1.TransactionEvent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEventTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      eventType_ = 0;
      reason_ = "";
      value_ = 0D;
      eventTime_ = null;
      if (eventTimeBuilder_ != null) {
        eventTimeBuilder_.dispose();
        eventTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1beta1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1beta1_TransactionEvent_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionEvent getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1beta1.TransactionEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionEvent build() {
      com.google.recaptchaenterprise.v1beta1.TransactionEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionEvent buildPartial() {
      com.google.recaptchaenterprise.v1beta1.TransactionEvent result =
          new com.google.recaptchaenterprise.v1beta1.TransactionEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1beta1.TransactionEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.eventType_ = eventType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.reason_ = reason_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.value_ = value_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.eventTime_ = eventTimeBuilder_ == null ? eventTime_ : eventTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1beta1.TransactionEvent) {
        return mergeFrom((com.google.recaptchaenterprise.v1beta1.TransactionEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1beta1.TransactionEvent other) {
      if (other == com.google.recaptchaenterprise.v1beta1.TransactionEvent.getDefaultInstance())
        return this;
      if (other.eventType_ != 0) {
        setEventTypeValue(other.getEventTypeValue());
      }
      if (!other.getReason().isEmpty()) {
        reason_ = other.reason_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getValue() != 0D) {
        setValue(other.getValue());
      }
      if (other.hasEventTime()) {
        mergeEventTime(other.getEventTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                eventType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                reason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 25:
              {
                value_ = input.readDouble();
                bitField0_ |= 0x00000004;
                break;
              } // case 25
            case 34:
              {
                input.readMessage(getEventTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int eventType_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The type of this transaction event.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType event_type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for eventType.
     */
    @java.lang.Override
    public int getEventTypeValue() {
      return eventType_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The type of this transaction event.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType event_type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventTypeValue(int value) {
      eventType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The type of this transaction event.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType event_type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The eventType.
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType
        getEventType() {
      com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType result =
          com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType.forNumber(
              eventType_);
      return result == null
          ? com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType
              .UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. The type of this transaction event.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType event_type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The eventType to set.
     * @return This builder for chaining.
     */
    public Builder setEventType(
        com.google.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      eventType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The type of this transaction event.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1beta1.TransactionEvent.TransactionEventType event_type = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      eventType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object reason_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The reason or standardized code that corresponds with this
     * transaction event, if one exists. For example, a CHARGEBACK event with code
     * 6005.
     * </pre>
     *
     * <code>string reason = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The reason.
     */
    public java.lang.String getReason() {
      java.lang.Object ref = reason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The reason or standardized code that corresponds with this
     * transaction event, if one exists. For example, a CHARGEBACK event with code
     * 6005.
     * </pre>
     *
     * <code>string reason = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for reason.
     */
    public com.google.protobuf.ByteString getReasonBytes() {
      java.lang.Object ref = reason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The reason or standardized code that corresponds with this
     * transaction event, if one exists. For example, a CHARGEBACK event with code
     * 6005.
     * </pre>
     *
     * <code>string reason = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The reason to set.
     * @return This builder for chaining.
     */
    public Builder setReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reason_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The reason or standardized code that corresponds with this
     * transaction event, if one exists. For example, a CHARGEBACK event with code
     * 6005.
     * </pre>
     *
     * <code>string reason = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReason() {
      reason_ = getDefaultInstance().getReason();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The reason or standardized code that corresponds with this
     * transaction event, if one exists. For example, a CHARGEBACK event with code
     * 6005.
     * </pre>
     *
     * <code>string reason = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for reason to set.
     * @return This builder for chaining.
     */
    public Builder setReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reason_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private double value_;

    /**
     *
     *
     * <pre>
     * Optional. The value that corresponds with this transaction event, if one
     * exists. For example, a refund event where $5.00 was refunded. Currency is
     * obtained from the original transaction data.
     * </pre>
     *
     * <code>double value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public double getValue() {
      return value_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The value that corresponds with this transaction event, if one
     * exists. For example, a refund event where $5.00 was refunded. Currency is
     * obtained from the original transaction data.
     * </pre>
     *
     * <code>double value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The value to set.
     * @return This builder for chaining.
     */
    public Builder setValue(double value) {

      value_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The value that corresponds with this transaction event, if one
     * exists. For example, a refund event where $5.00 was refunded. Currency is
     * obtained from the original transaction data.
     * </pre>
     *
     * <code>double value = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValue() {
      bitField0_ = (bitField0_ & ~0x00000004);
      value_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp eventTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        eventTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Timestamp when this transaction event occurred; otherwise assumed
     * to be the time of the API call.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the eventTime field is set.
     */
    public boolean hasEventTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp when this transaction event occurred; otherwise assumed
     * to be the time of the API call.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The eventTime.
     */
    public com.google.protobuf.Timestamp getEventTime() {
      if (eventTimeBuilder_ == null) {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      } else {
        return eventTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp when this transaction event occurred; otherwise assumed
     * to be the time of the API call.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventTime_ = value;
      } else {
        eventTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp when this transaction event occurred; otherwise assumed
     * to be the time of the API call.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEventTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (eventTimeBuilder_ == null) {
        eventTime_ = builderForValue.build();
      } else {
        eventTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp when this transaction event occurred; otherwise assumed
     * to be the time of the API call.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEventTime(com.google.protobuf.Timestamp value) {
      if (eventTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && eventTime_ != null
            && eventTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEventTimeBuilder().mergeFrom(value);
        } else {
          eventTime_ = value;
        }
      } else {
        eventTimeBuilder_.mergeFrom(value);
      }
      if (eventTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp when this transaction event occurred; otherwise assumed
     * to be the time of the API call.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEventTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      eventTime_ = null;
      if (eventTimeBuilder_ != null) {
        eventTimeBuilder_.dispose();
        eventTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp when this transaction event occurred; otherwise assumed
     * to be the time of the API call.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEventTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getEventTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp when this transaction event occurred; otherwise assumed
     * to be the time of the API call.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEventTimeOrBuilder() {
      if (eventTimeBuilder_ != null) {
        return eventTimeBuilder_.getMessageOrBuilder();
      } else {
        return eventTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : eventTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Timestamp when this transaction event occurred; otherwise assumed
     * to be the time of the API call.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp event_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEventTimeFieldBuilder() {
      if (eventTimeBuilder_ == null) {
        eventTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEventTime(), getParentForChildren(), isClean());
        eventTime_ = null;
      }
      return eventTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1beta1.TransactionEvent)
  private static final com.google.recaptchaenterprise.v1beta1.TransactionEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1beta1.TransactionEvent();
  }

  public static com.google.recaptchaenterprise.v1beta1.TransactionEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransactionEvent> PARSER =
      new com.google.protobuf.AbstractParser<TransactionEvent>() {
        @java.lang.Override
        public TransactionEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransactionEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransactionEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1beta1.TransactionEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
