/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

// Protobuf Java Version: 3.25.8
package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * Settings specific to keys that can be used by iOS apps.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.IOSKeySettings}
 */
public final class IOSKeySettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.IOSKeySettings)
    IOSKeySettingsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use IOSKeySettings.newBuilder() to construct.
  private IOSKeySettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IOSKeySettings() {
    allowedBundleIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IOSKeySettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_IOSKeySettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_IOSKeySettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.IOSKeySettings.class,
            com.google.recaptchaenterprise.v1.IOSKeySettings.Builder.class);
  }

  private int bitField0_;
  public static final int ALLOW_ALL_BUNDLE_IDS_FIELD_NUMBER = 2;
  private boolean allowAllBundleIds_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If set to true, allowed_bundle_ids are not enforced.
   * </pre>
   *
   * <code>bool allow_all_bundle_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The allowAllBundleIds.
   */
  @java.lang.Override
  public boolean getAllowAllBundleIds() {
    return allowAllBundleIds_;
  }

  public static final int ALLOWED_BUNDLE_IDS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList allowedBundleIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. iOS bundle ids of apps allowed to use the key.
   * Example: 'com.companyname.productname.appname'
   * </pre>
   *
   * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the allowedBundleIds.
   */
  public com.google.protobuf.ProtocolStringList getAllowedBundleIdsList() {
    return allowedBundleIds_;
  }

  /**
   *
   *
   * <pre>
   * Optional. iOS bundle ids of apps allowed to use the key.
   * Example: 'com.companyname.productname.appname'
   * </pre>
   *
   * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of allowedBundleIds.
   */
  public int getAllowedBundleIdsCount() {
    return allowedBundleIds_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. iOS bundle ids of apps allowed to use the key.
   * Example: 'com.companyname.productname.appname'
   * </pre>
   *
   * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The allowedBundleIds at the given index.
   */
  public java.lang.String getAllowedBundleIds(int index) {
    return allowedBundleIds_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. iOS bundle ids of apps allowed to use the key.
   * Example: 'com.companyname.productname.appname'
   * </pre>
   *
   * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowedBundleIds at the given index.
   */
  public com.google.protobuf.ByteString getAllowedBundleIdsBytes(int index) {
    return allowedBundleIds_.getByteString(index);
  }

  public static final int APPLE_DEVELOPER_ID_FIELD_NUMBER = 3;
  private com.google.recaptchaenterprise.v1.AppleDeveloperId appleDeveloperId_;

  /**
   *
   *
   * <pre>
   * Optional. Apple Developer account details for the app that is protected by
   * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
   * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
   * these fields allows reCAPTCHA to get a better assessment of the integrity
   * of your app.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the appleDeveloperId field is set.
   */
  @java.lang.Override
  public boolean hasAppleDeveloperId() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Apple Developer account details for the app that is protected by
   * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
   * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
   * these fields allows reCAPTCHA to get a better assessment of the integrity
   * of your app.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The appleDeveloperId.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AppleDeveloperId getAppleDeveloperId() {
    return appleDeveloperId_ == null
        ? com.google.recaptchaenterprise.v1.AppleDeveloperId.getDefaultInstance()
        : appleDeveloperId_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Apple Developer account details for the app that is protected by
   * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
   * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
   * these fields allows reCAPTCHA to get a better assessment of the integrity
   * of your app.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AppleDeveloperIdOrBuilder
      getAppleDeveloperIdOrBuilder() {
    return appleDeveloperId_ == null
        ? com.google.recaptchaenterprise.v1.AppleDeveloperId.getDefaultInstance()
        : appleDeveloperId_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < allowedBundleIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allowedBundleIds_.getRaw(i));
    }
    if (allowAllBundleIds_ != false) {
      output.writeBool(2, allowAllBundleIds_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getAppleDeveloperId());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < allowedBundleIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowedBundleIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAllowedBundleIdsList().size();
    }
    if (allowAllBundleIds_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, allowAllBundleIds_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAppleDeveloperId());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.IOSKeySettings)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.IOSKeySettings other =
        (com.google.recaptchaenterprise.v1.IOSKeySettings) obj;

    if (getAllowAllBundleIds() != other.getAllowAllBundleIds()) return false;
    if (!getAllowedBundleIdsList().equals(other.getAllowedBundleIdsList())) return false;
    if (hasAppleDeveloperId() != other.hasAppleDeveloperId()) return false;
    if (hasAppleDeveloperId()) {
      if (!getAppleDeveloperId().equals(other.getAppleDeveloperId())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ALLOW_ALL_BUNDLE_IDS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowAllBundleIds());
    if (getAllowedBundleIdsCount() > 0) {
      hash = (37 * hash) + ALLOWED_BUNDLE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedBundleIdsList().hashCode();
    }
    if (hasAppleDeveloperId()) {
      hash = (37 * hash) + APPLE_DEVELOPER_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAppleDeveloperId().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1.IOSKeySettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Settings specific to keys that can be used by iOS apps.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.IOSKeySettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.IOSKeySettings)
      com.google.recaptchaenterprise.v1.IOSKeySettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_IOSKeySettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_IOSKeySettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.IOSKeySettings.class,
              com.google.recaptchaenterprise.v1.IOSKeySettings.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.IOSKeySettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAppleDeveloperIdFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      allowAllBundleIds_ = false;
      allowedBundleIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      appleDeveloperId_ = null;
      if (appleDeveloperIdBuilder_ != null) {
        appleDeveloperIdBuilder_.dispose();
        appleDeveloperIdBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_IOSKeySettings_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.IOSKeySettings getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.IOSKeySettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.IOSKeySettings build() {
      com.google.recaptchaenterprise.v1.IOSKeySettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.IOSKeySettings buildPartial() {
      com.google.recaptchaenterprise.v1.IOSKeySettings result =
          new com.google.recaptchaenterprise.v1.IOSKeySettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1.IOSKeySettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.allowAllBundleIds_ = allowAllBundleIds_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        allowedBundleIds_.makeImmutable();
        result.allowedBundleIds_ = allowedBundleIds_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.appleDeveloperId_ =
            appleDeveloperIdBuilder_ == null ? appleDeveloperId_ : appleDeveloperIdBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.IOSKeySettings) {
        return mergeFrom((com.google.recaptchaenterprise.v1.IOSKeySettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.IOSKeySettings other) {
      if (other == com.google.recaptchaenterprise.v1.IOSKeySettings.getDefaultInstance())
        return this;
      if (other.getAllowAllBundleIds() != false) {
        setAllowAllBundleIds(other.getAllowAllBundleIds());
      }
      if (!other.allowedBundleIds_.isEmpty()) {
        if (allowedBundleIds_.isEmpty()) {
          allowedBundleIds_ = other.allowedBundleIds_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAllowedBundleIdsIsMutable();
          allowedBundleIds_.addAll(other.allowedBundleIds_);
        }
        onChanged();
      }
      if (other.hasAppleDeveloperId()) {
        mergeAppleDeveloperId(other.getAppleDeveloperId());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAllowedBundleIdsIsMutable();
                allowedBundleIds_.add(s);
                break;
              } // case 10
            case 16:
              {
                allowAllBundleIds_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(
                    getAppleDeveloperIdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean allowAllBundleIds_;

    /**
     *
     *
     * <pre>
     * Optional. If set to true, allowed_bundle_ids are not enforced.
     * </pre>
     *
     * <code>bool allow_all_bundle_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowAllBundleIds.
     */
    @java.lang.Override
    public boolean getAllowAllBundleIds() {
      return allowAllBundleIds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set to true, allowed_bundle_ids are not enforced.
     * </pre>
     *
     * <code>bool allow_all_bundle_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The allowAllBundleIds to set.
     * @return This builder for chaining.
     */
    public Builder setAllowAllBundleIds(boolean value) {

      allowAllBundleIds_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set to true, allowed_bundle_ids are not enforced.
     * </pre>
     *
     * <code>bool allow_all_bundle_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowAllBundleIds() {
      bitField0_ = (bitField0_ & ~0x00000001);
      allowAllBundleIds_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList allowedBundleIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAllowedBundleIdsIsMutable() {
      if (!allowedBundleIds_.isModifiable()) {
        allowedBundleIds_ = new com.google.protobuf.LazyStringArrayList(allowedBundleIds_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * Optional. iOS bundle ids of apps allowed to use the key.
     * Example: 'com.companyname.productname.appname'
     * </pre>
     *
     * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the allowedBundleIds.
     */
    public com.google.protobuf.ProtocolStringList getAllowedBundleIdsList() {
      allowedBundleIds_.makeImmutable();
      return allowedBundleIds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. iOS bundle ids of apps allowed to use the key.
     * Example: 'com.companyname.productname.appname'
     * </pre>
     *
     * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of allowedBundleIds.
     */
    public int getAllowedBundleIdsCount() {
      return allowedBundleIds_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. iOS bundle ids of apps allowed to use the key.
     * Example: 'com.companyname.productname.appname'
     * </pre>
     *
     * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The allowedBundleIds at the given index.
     */
    public java.lang.String getAllowedBundleIds(int index) {
      return allowedBundleIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. iOS bundle ids of apps allowed to use the key.
     * Example: 'com.companyname.productname.appname'
     * </pre>
     *
     * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedBundleIds at the given index.
     */
    public com.google.protobuf.ByteString getAllowedBundleIdsBytes(int index) {
      return allowedBundleIds_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. iOS bundle ids of apps allowed to use the key.
     * Example: 'com.companyname.productname.appname'
     * </pre>
     *
     * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The allowedBundleIds to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedBundleIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedBundleIdsIsMutable();
      allowedBundleIds_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. iOS bundle ids of apps allowed to use the key.
     * Example: 'com.companyname.productname.appname'
     * </pre>
     *
     * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The allowedBundleIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedBundleIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedBundleIdsIsMutable();
      allowedBundleIds_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. iOS bundle ids of apps allowed to use the key.
     * Example: 'com.companyname.productname.appname'
     * </pre>
     *
     * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The allowedBundleIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedBundleIds(java.lang.Iterable<java.lang.String> values) {
      ensureAllowedBundleIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedBundleIds_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. iOS bundle ids of apps allowed to use the key.
     * Example: 'com.companyname.productname.appname'
     * </pre>
     *
     * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedBundleIds() {
      allowedBundleIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. iOS bundle ids of apps allowed to use the key.
     * Example: 'com.companyname.productname.appname'
     * </pre>
     *
     * <code>repeated string allowed_bundle_ids = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the allowedBundleIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedBundleIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowedBundleIdsIsMutable();
      allowedBundleIds_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1.AppleDeveloperId appleDeveloperId_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AppleDeveloperId,
            com.google.recaptchaenterprise.v1.AppleDeveloperId.Builder,
            com.google.recaptchaenterprise.v1.AppleDeveloperIdOrBuilder>
        appleDeveloperIdBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Apple Developer account details for the app that is protected by
     * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
     * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
     * these fields allows reCAPTCHA to get a better assessment of the integrity
     * of your app.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the appleDeveloperId field is set.
     */
    public boolean hasAppleDeveloperId() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Apple Developer account details for the app that is protected by
     * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
     * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
     * these fields allows reCAPTCHA to get a better assessment of the integrity
     * of your app.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The appleDeveloperId.
     */
    public com.google.recaptchaenterprise.v1.AppleDeveloperId getAppleDeveloperId() {
      if (appleDeveloperIdBuilder_ == null) {
        return appleDeveloperId_ == null
            ? com.google.recaptchaenterprise.v1.AppleDeveloperId.getDefaultInstance()
            : appleDeveloperId_;
      } else {
        return appleDeveloperIdBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Apple Developer account details for the app that is protected by
     * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
     * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
     * these fields allows reCAPTCHA to get a better assessment of the integrity
     * of your app.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAppleDeveloperId(com.google.recaptchaenterprise.v1.AppleDeveloperId value) {
      if (appleDeveloperIdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        appleDeveloperId_ = value;
      } else {
        appleDeveloperIdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Apple Developer account details for the app that is protected by
     * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
     * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
     * these fields allows reCAPTCHA to get a better assessment of the integrity
     * of your app.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAppleDeveloperId(
        com.google.recaptchaenterprise.v1.AppleDeveloperId.Builder builderForValue) {
      if (appleDeveloperIdBuilder_ == null) {
        appleDeveloperId_ = builderForValue.build();
      } else {
        appleDeveloperIdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Apple Developer account details for the app that is protected by
     * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
     * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
     * these fields allows reCAPTCHA to get a better assessment of the integrity
     * of your app.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAppleDeveloperId(com.google.recaptchaenterprise.v1.AppleDeveloperId value) {
      if (appleDeveloperIdBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && appleDeveloperId_ != null
            && appleDeveloperId_
                != com.google.recaptchaenterprise.v1.AppleDeveloperId.getDefaultInstance()) {
          getAppleDeveloperIdBuilder().mergeFrom(value);
        } else {
          appleDeveloperId_ = value;
        }
      } else {
        appleDeveloperIdBuilder_.mergeFrom(value);
      }
      if (appleDeveloperId_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Apple Developer account details for the app that is protected by
     * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
     * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
     * these fields allows reCAPTCHA to get a better assessment of the integrity
     * of your app.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAppleDeveloperId() {
      bitField0_ = (bitField0_ & ~0x00000004);
      appleDeveloperId_ = null;
      if (appleDeveloperIdBuilder_ != null) {
        appleDeveloperIdBuilder_.dispose();
        appleDeveloperIdBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Apple Developer account details for the app that is protected by
     * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
     * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
     * these fields allows reCAPTCHA to get a better assessment of the integrity
     * of your app.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.AppleDeveloperId.Builder getAppleDeveloperIdBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAppleDeveloperIdFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Apple Developer account details for the app that is protected by
     * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
     * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
     * these fields allows reCAPTCHA to get a better assessment of the integrity
     * of your app.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.AppleDeveloperIdOrBuilder
        getAppleDeveloperIdOrBuilder() {
      if (appleDeveloperIdBuilder_ != null) {
        return appleDeveloperIdBuilder_.getMessageOrBuilder();
      } else {
        return appleDeveloperId_ == null
            ? com.google.recaptchaenterprise.v1.AppleDeveloperId.getDefaultInstance()
            : appleDeveloperId_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Apple Developer account details for the app that is protected by
     * the reCAPTCHA Key. reCAPTCHA leverages platform-specific checks like Apple
     * App Attest and Apple DeviceCheck to protect your app from abuse. Providing
     * these fields allows reCAPTCHA to get a better assessment of the integrity
     * of your app.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AppleDeveloperId apple_developer_id = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AppleDeveloperId,
            com.google.recaptchaenterprise.v1.AppleDeveloperId.Builder,
            com.google.recaptchaenterprise.v1.AppleDeveloperIdOrBuilder>
        getAppleDeveloperIdFieldBuilder() {
      if (appleDeveloperIdBuilder_ == null) {
        appleDeveloperIdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.AppleDeveloperId,
                com.google.recaptchaenterprise.v1.AppleDeveloperId.Builder,
                com.google.recaptchaenterprise.v1.AppleDeveloperIdOrBuilder>(
                getAppleDeveloperId(), getParentForChildren(), isClean());
        appleDeveloperId_ = null;
      }
      return appleDeveloperIdBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.IOSKeySettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.IOSKeySettings)
  private static final com.google.recaptchaenterprise.v1.IOSKeySettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.IOSKeySettings();
  }

  public static com.google.recaptchaenterprise.v1.IOSKeySettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IOSKeySettings> PARSER =
      new com.google.protobuf.AbstractParser<IOSKeySettings>() {
        @java.lang.Override
        public IOSKeySettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IOSKeySettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IOSKeySettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.IOSKeySettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
