/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

// Protobuf Java Version: 3.25.8
package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * Information about a verification endpoint that can be used for 2FA.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo}
 */
public final class EndpointVerificationInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo)
    EndpointVerificationInfoOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use EndpointVerificationInfo.newBuilder() to construct.
  private EndpointVerificationInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EndpointVerificationInfo() {
    requestToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EndpointVerificationInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_EndpointVerificationInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_EndpointVerificationInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.EndpointVerificationInfo.class,
            com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder.class);
  }

  private int bitField0_;
  private int endpointCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object endpoint_;

  public enum EndpointCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EMAIL_ADDRESS(1),
    PHONE_NUMBER(2),
    ENDPOINT_NOT_SET(0);
    private final int value;

    private EndpointCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EndpointCase valueOf(int value) {
      return forNumber(value);
    }

    public static EndpointCase forNumber(int value) {
      switch (value) {
        case 1:
          return EMAIL_ADDRESS;
        case 2:
          return PHONE_NUMBER;
        case 0:
          return ENDPOINT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EndpointCase getEndpointCase() {
    return EndpointCase.forNumber(endpointCase_);
  }

  public static final int EMAIL_ADDRESS_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Email address for which to trigger a verification request.
   * </pre>
   *
   * <code>string email_address = 1;</code>
   *
   * @return Whether the emailAddress field is set.
   */
  public boolean hasEmailAddress() {
    return endpointCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Email address for which to trigger a verification request.
   * </pre>
   *
   * <code>string email_address = 1;</code>
   *
   * @return The emailAddress.
   */
  public java.lang.String getEmailAddress() {
    java.lang.Object ref = "";
    if (endpointCase_ == 1) {
      ref = endpoint_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (endpointCase_ == 1) {
        endpoint_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Email address for which to trigger a verification request.
   * </pre>
   *
   * <code>string email_address = 1;</code>
   *
   * @return The bytes for emailAddress.
   */
  public com.google.protobuf.ByteString getEmailAddressBytes() {
    java.lang.Object ref = "";
    if (endpointCase_ == 1) {
      ref = endpoint_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (endpointCase_ == 1) {
        endpoint_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PHONE_NUMBER_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Phone number for which to trigger a verification request. Should be given
   * in E.164 format.
   * </pre>
   *
   * <code>string phone_number = 2;</code>
   *
   * @return Whether the phoneNumber field is set.
   */
  public boolean hasPhoneNumber() {
    return endpointCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Phone number for which to trigger a verification request. Should be given
   * in E.164 format.
   * </pre>
   *
   * <code>string phone_number = 2;</code>
   *
   * @return The phoneNumber.
   */
  public java.lang.String getPhoneNumber() {
    java.lang.Object ref = "";
    if (endpointCase_ == 2) {
      ref = endpoint_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (endpointCase_ == 2) {
        endpoint_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Phone number for which to trigger a verification request. Should be given
   * in E.164 format.
   * </pre>
   *
   * <code>string phone_number = 2;</code>
   *
   * @return The bytes for phoneNumber.
   */
  public com.google.protobuf.ByteString getPhoneNumberBytes() {
    java.lang.Object ref = "";
    if (endpointCase_ == 2) {
      ref = endpoint_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (endpointCase_ == 2) {
        endpoint_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestToken_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Token to provide to the client to trigger endpoint
   * verification. It must be used within 15 minutes.
   * </pre>
   *
   * <code>string request_token = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The requestToken.
   */
  @java.lang.Override
  public java.lang.String getRequestToken() {
    java.lang.Object ref = requestToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Token to provide to the client to trigger endpoint
   * verification. It must be used within 15 minutes.
   * </pre>
   *
   * <code>string request_token = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for requestToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestTokenBytes() {
    java.lang.Object ref = requestToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_VERIFICATION_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp lastVerificationTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last successful verification for the
   * endpoint, if any.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastVerificationTime field is set.
   */
  @java.lang.Override
  public boolean hasLastVerificationTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last successful verification for the
   * endpoint, if any.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastVerificationTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastVerificationTime() {
    return lastVerificationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastVerificationTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp of the last successful verification for the
   * endpoint, if any.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastVerificationTimeOrBuilder() {
    return lastVerificationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastVerificationTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (endpointCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoint_);
    }
    if (endpointCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, endpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, requestToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getLastVerificationTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (endpointCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpoint_);
    }
    if (endpointCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, endpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, requestToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getLastVerificationTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.EndpointVerificationInfo)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.EndpointVerificationInfo other =
        (com.google.recaptchaenterprise.v1.EndpointVerificationInfo) obj;

    if (!getRequestToken().equals(other.getRequestToken())) return false;
    if (hasLastVerificationTime() != other.hasLastVerificationTime()) return false;
    if (hasLastVerificationTime()) {
      if (!getLastVerificationTime().equals(other.getLastVerificationTime())) return false;
    }
    if (!getEndpointCase().equals(other.getEndpointCase())) return false;
    switch (endpointCase_) {
      case 1:
        if (!getEmailAddress().equals(other.getEmailAddress())) return false;
        break;
      case 2:
        if (!getPhoneNumber().equals(other.getPhoneNumber())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REQUEST_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getRequestToken().hashCode();
    if (hasLastVerificationTime()) {
      hash = (37 * hash) + LAST_VERIFICATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastVerificationTime().hashCode();
    }
    switch (endpointCase_) {
      case 1:
        hash = (37 * hash) + EMAIL_ADDRESS_FIELD_NUMBER;
        hash = (53 * hash) + getEmailAddress().hashCode();
        break;
      case 2:
        hash = (37 * hash) + PHONE_NUMBER_FIELD_NUMBER;
        hash = (53 * hash) + getPhoneNumber().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.recaptchaenterprise.v1.EndpointVerificationInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Information about a verification endpoint that can be used for 2FA.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo)
      com.google.recaptchaenterprise.v1.EndpointVerificationInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_EndpointVerificationInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_EndpointVerificationInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.EndpointVerificationInfo.class,
              com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.EndpointVerificationInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLastVerificationTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      requestToken_ = "";
      lastVerificationTime_ = null;
      if (lastVerificationTimeBuilder_ != null) {
        lastVerificationTimeBuilder_.dispose();
        lastVerificationTimeBuilder_ = null;
      }
      endpointCase_ = 0;
      endpoint_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_EndpointVerificationInfo_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.EndpointVerificationInfo getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.EndpointVerificationInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.EndpointVerificationInfo build() {
      com.google.recaptchaenterprise.v1.EndpointVerificationInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.EndpointVerificationInfo buildPartial() {
      com.google.recaptchaenterprise.v1.EndpointVerificationInfo result =
          new com.google.recaptchaenterprise.v1.EndpointVerificationInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1.EndpointVerificationInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requestToken_ = requestToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lastVerificationTime_ =
            lastVerificationTimeBuilder_ == null
                ? lastVerificationTime_
                : lastVerificationTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.recaptchaenterprise.v1.EndpointVerificationInfo result) {
      result.endpointCase_ = endpointCase_;
      result.endpoint_ = this.endpoint_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.EndpointVerificationInfo) {
        return mergeFrom((com.google.recaptchaenterprise.v1.EndpointVerificationInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.EndpointVerificationInfo other) {
      if (other == com.google.recaptchaenterprise.v1.EndpointVerificationInfo.getDefaultInstance())
        return this;
      if (!other.getRequestToken().isEmpty()) {
        requestToken_ = other.requestToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasLastVerificationTime()) {
        mergeLastVerificationTime(other.getLastVerificationTime());
      }
      switch (other.getEndpointCase()) {
        case EMAIL_ADDRESS:
          {
            endpointCase_ = 1;
            endpoint_ = other.endpoint_;
            onChanged();
            break;
          }
        case PHONE_NUMBER:
          {
            endpointCase_ = 2;
            endpoint_ = other.endpoint_;
            onChanged();
            break;
          }
        case ENDPOINT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                endpointCase_ = 1;
                endpoint_ = s;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                endpointCase_ = 2;
                endpoint_ = s;
                break;
              } // case 18
            case 26:
              {
                requestToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getLastVerificationTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int endpointCase_ = 0;
    private java.lang.Object endpoint_;

    public EndpointCase getEndpointCase() {
      return EndpointCase.forNumber(endpointCase_);
    }

    public Builder clearEndpoint() {
      endpointCase_ = 0;
      endpoint_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Email address for which to trigger a verification request.
     * </pre>
     *
     * <code>string email_address = 1;</code>
     *
     * @return Whether the emailAddress field is set.
     */
    @java.lang.Override
    public boolean hasEmailAddress() {
      return endpointCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Email address for which to trigger a verification request.
     * </pre>
     *
     * <code>string email_address = 1;</code>
     *
     * @return The emailAddress.
     */
    @java.lang.Override
    public java.lang.String getEmailAddress() {
      java.lang.Object ref = "";
      if (endpointCase_ == 1) {
        ref = endpoint_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (endpointCase_ == 1) {
          endpoint_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Email address for which to trigger a verification request.
     * </pre>
     *
     * <code>string email_address = 1;</code>
     *
     * @return The bytes for emailAddress.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEmailAddressBytes() {
      java.lang.Object ref = "";
      if (endpointCase_ == 1) {
        ref = endpoint_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (endpointCase_ == 1) {
          endpoint_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Email address for which to trigger a verification request.
     * </pre>
     *
     * <code>string email_address = 1;</code>
     *
     * @param value The emailAddress to set.
     * @return This builder for chaining.
     */
    public Builder setEmailAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endpointCase_ = 1;
      endpoint_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Email address for which to trigger a verification request.
     * </pre>
     *
     * <code>string email_address = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEmailAddress() {
      if (endpointCase_ == 1) {
        endpointCase_ = 0;
        endpoint_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Email address for which to trigger a verification request.
     * </pre>
     *
     * <code>string email_address = 1;</code>
     *
     * @param value The bytes for emailAddress to set.
     * @return This builder for chaining.
     */
    public Builder setEmailAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endpointCase_ = 1;
      endpoint_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Phone number for which to trigger a verification request. Should be given
     * in E.164 format.
     * </pre>
     *
     * <code>string phone_number = 2;</code>
     *
     * @return Whether the phoneNumber field is set.
     */
    @java.lang.Override
    public boolean hasPhoneNumber() {
      return endpointCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Phone number for which to trigger a verification request. Should be given
     * in E.164 format.
     * </pre>
     *
     * <code>string phone_number = 2;</code>
     *
     * @return The phoneNumber.
     */
    @java.lang.Override
    public java.lang.String getPhoneNumber() {
      java.lang.Object ref = "";
      if (endpointCase_ == 2) {
        ref = endpoint_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (endpointCase_ == 2) {
          endpoint_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Phone number for which to trigger a verification request. Should be given
     * in E.164 format.
     * </pre>
     *
     * <code>string phone_number = 2;</code>
     *
     * @return The bytes for phoneNumber.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPhoneNumberBytes() {
      java.lang.Object ref = "";
      if (endpointCase_ == 2) {
        ref = endpoint_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (endpointCase_ == 2) {
          endpoint_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Phone number for which to trigger a verification request. Should be given
     * in E.164 format.
     * </pre>
     *
     * <code>string phone_number = 2;</code>
     *
     * @param value The phoneNumber to set.
     * @return This builder for chaining.
     */
    public Builder setPhoneNumber(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endpointCase_ = 2;
      endpoint_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Phone number for which to trigger a verification request. Should be given
     * in E.164 format.
     * </pre>
     *
     * <code>string phone_number = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhoneNumber() {
      if (endpointCase_ == 2) {
        endpointCase_ = 0;
        endpoint_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Phone number for which to trigger a verification request. Should be given
     * in E.164 format.
     * </pre>
     *
     * <code>string phone_number = 2;</code>
     *
     * @param value The bytes for phoneNumber to set.
     * @return This builder for chaining.
     */
    public Builder setPhoneNumberBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endpointCase_ = 2;
      endpoint_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object requestToken_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Token to provide to the client to trigger endpoint
     * verification. It must be used within 15 minutes.
     * </pre>
     *
     * <code>string request_token = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The requestToken.
     */
    public java.lang.String getRequestToken() {
      java.lang.Object ref = requestToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Token to provide to the client to trigger endpoint
     * verification. It must be used within 15 minutes.
     * </pre>
     *
     * <code>string request_token = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for requestToken.
     */
    public com.google.protobuf.ByteString getRequestTokenBytes() {
      java.lang.Object ref = requestToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Token to provide to the client to trigger endpoint
     * verification. It must be used within 15 minutes.
     * </pre>
     *
     * <code>string request_token = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The requestToken to set.
     * @return This builder for chaining.
     */
    public Builder setRequestToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Token to provide to the client to trigger endpoint
     * verification. It must be used within 15 minutes.
     * </pre>
     *
     * <code>string request_token = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestToken() {
      requestToken_ = getDefaultInstance().getRequestToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Token to provide to the client to trigger endpoint
     * verification. It must be used within 15 minutes.
     * </pre>
     *
     * <code>string request_token = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for requestToken to set.
     * @return This builder for chaining.
     */
    public Builder setRequestTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp lastVerificationTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastVerificationTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last successful verification for the
     * endpoint, if any.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastVerificationTime field is set.
     */
    public boolean hasLastVerificationTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last successful verification for the
     * endpoint, if any.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastVerificationTime.
     */
    public com.google.protobuf.Timestamp getLastVerificationTime() {
      if (lastVerificationTimeBuilder_ == null) {
        return lastVerificationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastVerificationTime_;
      } else {
        return lastVerificationTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last successful verification for the
     * endpoint, if any.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastVerificationTime(com.google.protobuf.Timestamp value) {
      if (lastVerificationTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastVerificationTime_ = value;
      } else {
        lastVerificationTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last successful verification for the
     * endpoint, if any.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastVerificationTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastVerificationTimeBuilder_ == null) {
        lastVerificationTime_ = builderForValue.build();
      } else {
        lastVerificationTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last successful verification for the
     * endpoint, if any.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastVerificationTime(com.google.protobuf.Timestamp value) {
      if (lastVerificationTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && lastVerificationTime_ != null
            && lastVerificationTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastVerificationTimeBuilder().mergeFrom(value);
        } else {
          lastVerificationTime_ = value;
        }
      } else {
        lastVerificationTimeBuilder_.mergeFrom(value);
      }
      if (lastVerificationTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last successful verification for the
     * endpoint, if any.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastVerificationTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      lastVerificationTime_ = null;
      if (lastVerificationTimeBuilder_ != null) {
        lastVerificationTimeBuilder_.dispose();
        lastVerificationTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last successful verification for the
     * endpoint, if any.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastVerificationTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLastVerificationTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last successful verification for the
     * endpoint, if any.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastVerificationTimeOrBuilder() {
      if (lastVerificationTimeBuilder_ != null) {
        return lastVerificationTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastVerificationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastVerificationTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp of the last successful verification for the
     * endpoint, if any.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_verification_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastVerificationTimeFieldBuilder() {
      if (lastVerificationTimeBuilder_ == null) {
        lastVerificationTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastVerificationTime(), getParentForChildren(), isClean());
        lastVerificationTime_ = null;
      }
      return lastVerificationTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo)
  private static final com.google.recaptchaenterprise.v1.EndpointVerificationInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.EndpointVerificationInfo();
  }

  public static com.google.recaptchaenterprise.v1.EndpointVerificationInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EndpointVerificationInfo> PARSER =
      new com.google.protobuf.AbstractParser<EndpointVerificationInfo>() {
        @java.lang.Override
        public EndpointVerificationInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EndpointVerificationInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EndpointVerificationInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.EndpointVerificationInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
