/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

// Protobuf Java Version: 3.25.8
package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * A reCAPTCHA Enterprise assessment resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.Assessment}
 */
public final class Assessment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.Assessment)
    AssessmentOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Assessment.newBuilder() to construct.
  private Assessment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Assessment() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Assessment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_Assessment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_Assessment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.Assessment.class,
            com.google.recaptchaenterprise.v1.Assessment.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Identifier. The resource name for the Assessment in the format
   * `projects/{project}/assessments/{assessment}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Identifier. The resource name for the Assessment in the format
   * `projects/{project}/assessments/{assessment}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_FIELD_NUMBER = 2;
  private com.google.recaptchaenterprise.v1.Event event_;

  /**
   *
   *
   * <pre>
   * Optional. The event being assessed.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the event field is set.
   */
  @java.lang.Override
  public boolean hasEvent() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The event being assessed.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The event.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.Event getEvent() {
    return event_ == null ? com.google.recaptchaenterprise.v1.Event.getDefaultInstance() : event_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The event being assessed.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.EventOrBuilder getEventOrBuilder() {
    return event_ == null ? com.google.recaptchaenterprise.v1.Event.getDefaultInstance() : event_;
  }

  public static final int RISK_ANALYSIS_FIELD_NUMBER = 3;
  private com.google.recaptchaenterprise.v1.RiskAnalysis riskAnalysis_;

  /**
   *
   *
   * <pre>
   * Output only. The risk analysis result for the event being assessed.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the riskAnalysis field is set.
   */
  @java.lang.Override
  public boolean hasRiskAnalysis() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The risk analysis result for the event being assessed.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The riskAnalysis.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.RiskAnalysis getRiskAnalysis() {
    return riskAnalysis_ == null
        ? com.google.recaptchaenterprise.v1.RiskAnalysis.getDefaultInstance()
        : riskAnalysis_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The risk analysis result for the event being assessed.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.RiskAnalysisOrBuilder getRiskAnalysisOrBuilder() {
    return riskAnalysis_ == null
        ? com.google.recaptchaenterprise.v1.RiskAnalysis.getDefaultInstance()
        : riskAnalysis_;
  }

  public static final int TOKEN_PROPERTIES_FIELD_NUMBER = 4;
  private com.google.recaptchaenterprise.v1.TokenProperties tokenProperties_;

  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the tokenProperties field is set.
   */
  @java.lang.Override
  public boolean hasTokenProperties() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The tokenProperties.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.TokenProperties getTokenProperties() {
    return tokenProperties_ == null
        ? com.google.recaptchaenterprise.v1.TokenProperties.getDefaultInstance()
        : tokenProperties_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Properties of the provided event token.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.TokenPropertiesOrBuilder getTokenPropertiesOrBuilder() {
    return tokenProperties_ == null
        ? com.google.recaptchaenterprise.v1.TokenProperties.getDefaultInstance()
        : tokenProperties_;
  }

  public static final int ACCOUNT_VERIFICATION_FIELD_NUMBER = 5;
  private com.google.recaptchaenterprise.v1.AccountVerificationInfo accountVerification_;

  /**
   *
   *
   * <pre>
   * Optional. Account verification information for identity verification. The
   * assessment event must include a token and site key to use this feature.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the accountVerification field is set.
   */
  @java.lang.Override
  public boolean hasAccountVerification() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Account verification information for identity verification. The
   * assessment event must include a token and site key to use this feature.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The accountVerification.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AccountVerificationInfo getAccountVerification() {
    return accountVerification_ == null
        ? com.google.recaptchaenterprise.v1.AccountVerificationInfo.getDefaultInstance()
        : accountVerification_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Account verification information for identity verification. The
   * assessment event must include a token and site key to use this feature.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AccountVerificationInfoOrBuilder
      getAccountVerificationOrBuilder() {
    return accountVerification_ == null
        ? com.google.recaptchaenterprise.v1.AccountVerificationInfo.getDefaultInstance()
        : accountVerification_;
  }

  public static final int ACCOUNT_DEFENDER_ASSESSMENT_FIELD_NUMBER = 6;
  private com.google.recaptchaenterprise.v1.AccountDefenderAssessment accountDefenderAssessment_;

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned by account defender when an account
   * identifier is provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the accountDefenderAssessment field is set.
   */
  @java.lang.Override
  public boolean hasAccountDefenderAssessment() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned by account defender when an account
   * identifier is provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The accountDefenderAssessment.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AccountDefenderAssessment
      getAccountDefenderAssessment() {
    return accountDefenderAssessment_ == null
        ? com.google.recaptchaenterprise.v1.AccountDefenderAssessment.getDefaultInstance()
        : accountDefenderAssessment_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned by account defender when an account
   * identifier is provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AccountDefenderAssessmentOrBuilder
      getAccountDefenderAssessmentOrBuilder() {
    return accountDefenderAssessment_ == null
        ? com.google.recaptchaenterprise.v1.AccountDefenderAssessment.getDefaultInstance()
        : accountDefenderAssessment_;
  }

  public static final int PRIVATE_PASSWORD_LEAK_VERIFICATION_FIELD_NUMBER = 8;
  private com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification
      privatePasswordLeakVerification_;

  /**
   *
   *
   * <pre>
   * Optional. The private password leak verification field contains the
   * parameters that are used to to check for leaks privately without sharing
   * user credentials.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the privatePasswordLeakVerification field is set.
   */
  @java.lang.Override
  public boolean hasPrivatePasswordLeakVerification() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The private password leak verification field contains the
   * parameters that are used to to check for leaks privately without sharing
   * user credentials.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The privatePasswordLeakVerification.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification
      getPrivatePasswordLeakVerification() {
    return privatePasswordLeakVerification_ == null
        ? com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification.getDefaultInstance()
        : privatePasswordLeakVerification_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The private password leak verification field contains the
   * parameters that are used to to check for leaks privately without sharing
   * user credentials.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerificationOrBuilder
      getPrivatePasswordLeakVerificationOrBuilder() {
    return privatePasswordLeakVerification_ == null
        ? com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification.getDefaultInstance()
        : privatePasswordLeakVerification_;
  }

  public static final int FIREWALL_POLICY_ASSESSMENT_FIELD_NUMBER = 10;
  private com.google.recaptchaenterprise.v1.FirewallPolicyAssessment firewallPolicyAssessment_;

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned when firewall policies belonging to the
   * project are evaluated using the field firewall_policy_evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the firewallPolicyAssessment field is set.
   */
  @java.lang.Override
  public boolean hasFirewallPolicyAssessment() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned when firewall policies belonging to the
   * project are evaluated using the field firewall_policy_evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The firewallPolicyAssessment.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FirewallPolicyAssessment getFirewallPolicyAssessment() {
    return firewallPolicyAssessment_ == null
        ? com.google.recaptchaenterprise.v1.FirewallPolicyAssessment.getDefaultInstance()
        : firewallPolicyAssessment_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned when firewall policies belonging to the
   * project are evaluated using the field firewall_policy_evaluation.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FirewallPolicyAssessmentOrBuilder
      getFirewallPolicyAssessmentOrBuilder() {
    return firewallPolicyAssessment_ == null
        ? com.google.recaptchaenterprise.v1.FirewallPolicyAssessment.getDefaultInstance()
        : firewallPolicyAssessment_;
  }

  public static final int FRAUD_PREVENTION_ASSESSMENT_FIELD_NUMBER = 11;
  private com.google.recaptchaenterprise.v1.FraudPreventionAssessment fraudPreventionAssessment_;

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned by Fraud Prevention when TransactionData
   * is provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the fraudPreventionAssessment field is set.
   */
  @java.lang.Override
  public boolean hasFraudPreventionAssessment() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned by Fraud Prevention when TransactionData
   * is provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The fraudPreventionAssessment.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FraudPreventionAssessment
      getFraudPreventionAssessment() {
    return fraudPreventionAssessment_ == null
        ? com.google.recaptchaenterprise.v1.FraudPreventionAssessment.getDefaultInstance()
        : fraudPreventionAssessment_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned by Fraud Prevention when TransactionData
   * is provided.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FraudPreventionAssessmentOrBuilder
      getFraudPreventionAssessmentOrBuilder() {
    return fraudPreventionAssessment_ == null
        ? com.google.recaptchaenterprise.v1.FraudPreventionAssessment.getDefaultInstance()
        : fraudPreventionAssessment_;
  }

  public static final int FRAUD_SIGNALS_FIELD_NUMBER = 13;
  private com.google.recaptchaenterprise.v1.FraudSignals fraudSignals_;

  /**
   *
   *
   * <pre>
   * Output only. Fraud Signals specific to the users involved in a payment
   * transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the fraudSignals field is set.
   */
  @java.lang.Override
  public boolean hasFraudSignals() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Fraud Signals specific to the users involved in a payment
   * transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The fraudSignals.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FraudSignals getFraudSignals() {
    return fraudSignals_ == null
        ? com.google.recaptchaenterprise.v1.FraudSignals.getDefaultInstance()
        : fraudSignals_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Fraud Signals specific to the users involved in a payment
   * transaction.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.FraudSignalsOrBuilder getFraudSignalsOrBuilder() {
    return fraudSignals_ == null
        ? com.google.recaptchaenterprise.v1.FraudSignals.getDefaultInstance()
        : fraudSignals_;
  }

  public static final int PHONE_FRAUD_ASSESSMENT_FIELD_NUMBER = 12;
  private com.google.recaptchaenterprise.v1.PhoneFraudAssessment phoneFraudAssessment_;

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned when a site key, a token, and a phone
   * number as `user_id` are provided. Account defender and SMS toll fraud
   * protection need to be enabled.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the phoneFraudAssessment field is set.
   */
  @java.lang.Override
  public boolean hasPhoneFraudAssessment() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned when a site key, a token, and a phone
   * number as `user_id` are provided. Account defender and SMS toll fraud
   * protection need to be enabled.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The phoneFraudAssessment.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.PhoneFraudAssessment getPhoneFraudAssessment() {
    return phoneFraudAssessment_ == null
        ? com.google.recaptchaenterprise.v1.PhoneFraudAssessment.getDefaultInstance()
        : phoneFraudAssessment_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Assessment returned when a site key, a token, and a phone
   * number as `user_id` are provided. Account defender and SMS toll fraud
   * protection need to be enabled.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.PhoneFraudAssessmentOrBuilder
      getPhoneFraudAssessmentOrBuilder() {
    return phoneFraudAssessment_ == null
        ? com.google.recaptchaenterprise.v1.PhoneFraudAssessment.getDefaultInstance()
        : phoneFraudAssessment_;
  }

  public static final int ASSESSMENT_ENVIRONMENT_FIELD_NUMBER = 14;
  private com.google.recaptchaenterprise.v1.AssessmentEnvironment assessmentEnvironment_;

  /**
   *
   *
   * <pre>
   * Optional. The environment creating the assessment. This describes your
   * environment (the system invoking CreateAssessment), NOT the environment of
   * your user.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the assessmentEnvironment field is set.
   */
  @java.lang.Override
  public boolean hasAssessmentEnvironment() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The environment creating the assessment. This describes your
   * environment (the system invoking CreateAssessment), NOT the environment of
   * your user.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The assessmentEnvironment.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AssessmentEnvironment getAssessmentEnvironment() {
    return assessmentEnvironment_ == null
        ? com.google.recaptchaenterprise.v1.AssessmentEnvironment.getDefaultInstance()
        : assessmentEnvironment_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The environment creating the assessment. This describes your
   * environment (the system invoking CreateAssessment), NOT the environment of
   * your user.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AssessmentEnvironmentOrBuilder
      getAssessmentEnvironmentOrBuilder() {
    return assessmentEnvironment_ == null
        ? com.google.recaptchaenterprise.v1.AssessmentEnvironment.getDefaultInstance()
        : assessmentEnvironment_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getEvent());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getRiskAnalysis());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getTokenProperties());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getAccountVerification());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(6, getAccountDefenderAssessment());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(8, getPrivatePasswordLeakVerification());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(10, getFirewallPolicyAssessment());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(11, getFraudPreventionAssessment());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(12, getPhoneFraudAssessment());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(13, getFraudSignals());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(14, getAssessmentEnvironment());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEvent());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRiskAnalysis());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTokenProperties());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAccountVerification());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, getAccountDefenderAssessment());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getPrivatePasswordLeakVerification());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, getFirewallPolicyAssessment());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, getFraudPreventionAssessment());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12, getPhoneFraudAssessment());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getFraudSignals());
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, getAssessmentEnvironment());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.Assessment)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.Assessment other =
        (com.google.recaptchaenterprise.v1.Assessment) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasEvent() != other.hasEvent()) return false;
    if (hasEvent()) {
      if (!getEvent().equals(other.getEvent())) return false;
    }
    if (hasRiskAnalysis() != other.hasRiskAnalysis()) return false;
    if (hasRiskAnalysis()) {
      if (!getRiskAnalysis().equals(other.getRiskAnalysis())) return false;
    }
    if (hasTokenProperties() != other.hasTokenProperties()) return false;
    if (hasTokenProperties()) {
      if (!getTokenProperties().equals(other.getTokenProperties())) return false;
    }
    if (hasAccountVerification() != other.hasAccountVerification()) return false;
    if (hasAccountVerification()) {
      if (!getAccountVerification().equals(other.getAccountVerification())) return false;
    }
    if (hasAccountDefenderAssessment() != other.hasAccountDefenderAssessment()) return false;
    if (hasAccountDefenderAssessment()) {
      if (!getAccountDefenderAssessment().equals(other.getAccountDefenderAssessment()))
        return false;
    }
    if (hasPrivatePasswordLeakVerification() != other.hasPrivatePasswordLeakVerification())
      return false;
    if (hasPrivatePasswordLeakVerification()) {
      if (!getPrivatePasswordLeakVerification().equals(other.getPrivatePasswordLeakVerification()))
        return false;
    }
    if (hasFirewallPolicyAssessment() != other.hasFirewallPolicyAssessment()) return false;
    if (hasFirewallPolicyAssessment()) {
      if (!getFirewallPolicyAssessment().equals(other.getFirewallPolicyAssessment())) return false;
    }
    if (hasFraudPreventionAssessment() != other.hasFraudPreventionAssessment()) return false;
    if (hasFraudPreventionAssessment()) {
      if (!getFraudPreventionAssessment().equals(other.getFraudPreventionAssessment()))
        return false;
    }
    if (hasFraudSignals() != other.hasFraudSignals()) return false;
    if (hasFraudSignals()) {
      if (!getFraudSignals().equals(other.getFraudSignals())) return false;
    }
    if (hasPhoneFraudAssessment() != other.hasPhoneFraudAssessment()) return false;
    if (hasPhoneFraudAssessment()) {
      if (!getPhoneFraudAssessment().equals(other.getPhoneFraudAssessment())) return false;
    }
    if (hasAssessmentEnvironment() != other.hasAssessmentEnvironment()) return false;
    if (hasAssessmentEnvironment()) {
      if (!getAssessmentEnvironment().equals(other.getAssessmentEnvironment())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasEvent()) {
      hash = (37 * hash) + EVENT_FIELD_NUMBER;
      hash = (53 * hash) + getEvent().hashCode();
    }
    if (hasRiskAnalysis()) {
      hash = (37 * hash) + RISK_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + getRiskAnalysis().hashCode();
    }
    if (hasTokenProperties()) {
      hash = (37 * hash) + TOKEN_PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + getTokenProperties().hashCode();
    }
    if (hasAccountVerification()) {
      hash = (37 * hash) + ACCOUNT_VERIFICATION_FIELD_NUMBER;
      hash = (53 * hash) + getAccountVerification().hashCode();
    }
    if (hasAccountDefenderAssessment()) {
      hash = (37 * hash) + ACCOUNT_DEFENDER_ASSESSMENT_FIELD_NUMBER;
      hash = (53 * hash) + getAccountDefenderAssessment().hashCode();
    }
    if (hasPrivatePasswordLeakVerification()) {
      hash = (37 * hash) + PRIVATE_PASSWORD_LEAK_VERIFICATION_FIELD_NUMBER;
      hash = (53 * hash) + getPrivatePasswordLeakVerification().hashCode();
    }
    if (hasFirewallPolicyAssessment()) {
      hash = (37 * hash) + FIREWALL_POLICY_ASSESSMENT_FIELD_NUMBER;
      hash = (53 * hash) + getFirewallPolicyAssessment().hashCode();
    }
    if (hasFraudPreventionAssessment()) {
      hash = (37 * hash) + FRAUD_PREVENTION_ASSESSMENT_FIELD_NUMBER;
      hash = (53 * hash) + getFraudPreventionAssessment().hashCode();
    }
    if (hasFraudSignals()) {
      hash = (37 * hash) + FRAUD_SIGNALS_FIELD_NUMBER;
      hash = (53 * hash) + getFraudSignals().hashCode();
    }
    if (hasPhoneFraudAssessment()) {
      hash = (37 * hash) + PHONE_FRAUD_ASSESSMENT_FIELD_NUMBER;
      hash = (53 * hash) + getPhoneFraudAssessment().hashCode();
    }
    if (hasAssessmentEnvironment()) {
      hash = (37 * hash) + ASSESSMENT_ENVIRONMENT_FIELD_NUMBER;
      hash = (53 * hash) + getAssessmentEnvironment().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.Assessment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.recaptchaenterprise.v1.Assessment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A reCAPTCHA Enterprise assessment resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.Assessment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.Assessment)
      com.google.recaptchaenterprise.v1.AssessmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Assessment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Assessment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.Assessment.class,
              com.google.recaptchaenterprise.v1.Assessment.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.Assessment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEventFieldBuilder();
        getRiskAnalysisFieldBuilder();
        getTokenPropertiesFieldBuilder();
        getAccountVerificationFieldBuilder();
        getAccountDefenderAssessmentFieldBuilder();
        getPrivatePasswordLeakVerificationFieldBuilder();
        getFirewallPolicyAssessmentFieldBuilder();
        getFraudPreventionAssessmentFieldBuilder();
        getFraudSignalsFieldBuilder();
        getPhoneFraudAssessmentFieldBuilder();
        getAssessmentEnvironmentFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      event_ = null;
      if (eventBuilder_ != null) {
        eventBuilder_.dispose();
        eventBuilder_ = null;
      }
      riskAnalysis_ = null;
      if (riskAnalysisBuilder_ != null) {
        riskAnalysisBuilder_.dispose();
        riskAnalysisBuilder_ = null;
      }
      tokenProperties_ = null;
      if (tokenPropertiesBuilder_ != null) {
        tokenPropertiesBuilder_.dispose();
        tokenPropertiesBuilder_ = null;
      }
      accountVerification_ = null;
      if (accountVerificationBuilder_ != null) {
        accountVerificationBuilder_.dispose();
        accountVerificationBuilder_ = null;
      }
      accountDefenderAssessment_ = null;
      if (accountDefenderAssessmentBuilder_ != null) {
        accountDefenderAssessmentBuilder_.dispose();
        accountDefenderAssessmentBuilder_ = null;
      }
      privatePasswordLeakVerification_ = null;
      if (privatePasswordLeakVerificationBuilder_ != null) {
        privatePasswordLeakVerificationBuilder_.dispose();
        privatePasswordLeakVerificationBuilder_ = null;
      }
      firewallPolicyAssessment_ = null;
      if (firewallPolicyAssessmentBuilder_ != null) {
        firewallPolicyAssessmentBuilder_.dispose();
        firewallPolicyAssessmentBuilder_ = null;
      }
      fraudPreventionAssessment_ = null;
      if (fraudPreventionAssessmentBuilder_ != null) {
        fraudPreventionAssessmentBuilder_.dispose();
        fraudPreventionAssessmentBuilder_ = null;
      }
      fraudSignals_ = null;
      if (fraudSignalsBuilder_ != null) {
        fraudSignalsBuilder_.dispose();
        fraudSignalsBuilder_ = null;
      }
      phoneFraudAssessment_ = null;
      if (phoneFraudAssessmentBuilder_ != null) {
        phoneFraudAssessmentBuilder_.dispose();
        phoneFraudAssessmentBuilder_ = null;
      }
      assessmentEnvironment_ = null;
      if (assessmentEnvironmentBuilder_ != null) {
        assessmentEnvironmentBuilder_.dispose();
        assessmentEnvironmentBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_Assessment_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Assessment getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.Assessment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Assessment build() {
      com.google.recaptchaenterprise.v1.Assessment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.Assessment buildPartial() {
      com.google.recaptchaenterprise.v1.Assessment result =
          new com.google.recaptchaenterprise.v1.Assessment(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1.Assessment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.event_ = eventBuilder_ == null ? event_ : eventBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.riskAnalysis_ =
            riskAnalysisBuilder_ == null ? riskAnalysis_ : riskAnalysisBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.tokenProperties_ =
            tokenPropertiesBuilder_ == null ? tokenProperties_ : tokenPropertiesBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.accountVerification_ =
            accountVerificationBuilder_ == null
                ? accountVerification_
                : accountVerificationBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.accountDefenderAssessment_ =
            accountDefenderAssessmentBuilder_ == null
                ? accountDefenderAssessment_
                : accountDefenderAssessmentBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.privatePasswordLeakVerification_ =
            privatePasswordLeakVerificationBuilder_ == null
                ? privatePasswordLeakVerification_
                : privatePasswordLeakVerificationBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.firewallPolicyAssessment_ =
            firewallPolicyAssessmentBuilder_ == null
                ? firewallPolicyAssessment_
                : firewallPolicyAssessmentBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.fraudPreventionAssessment_ =
            fraudPreventionAssessmentBuilder_ == null
                ? fraudPreventionAssessment_
                : fraudPreventionAssessmentBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.fraudSignals_ =
            fraudSignalsBuilder_ == null ? fraudSignals_ : fraudSignalsBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.phoneFraudAssessment_ =
            phoneFraudAssessmentBuilder_ == null
                ? phoneFraudAssessment_
                : phoneFraudAssessmentBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.assessmentEnvironment_ =
            assessmentEnvironmentBuilder_ == null
                ? assessmentEnvironment_
                : assessmentEnvironmentBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.Assessment) {
        return mergeFrom((com.google.recaptchaenterprise.v1.Assessment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.Assessment other) {
      if (other == com.google.recaptchaenterprise.v1.Assessment.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasEvent()) {
        mergeEvent(other.getEvent());
      }
      if (other.hasRiskAnalysis()) {
        mergeRiskAnalysis(other.getRiskAnalysis());
      }
      if (other.hasTokenProperties()) {
        mergeTokenProperties(other.getTokenProperties());
      }
      if (other.hasAccountVerification()) {
        mergeAccountVerification(other.getAccountVerification());
      }
      if (other.hasAccountDefenderAssessment()) {
        mergeAccountDefenderAssessment(other.getAccountDefenderAssessment());
      }
      if (other.hasPrivatePasswordLeakVerification()) {
        mergePrivatePasswordLeakVerification(other.getPrivatePasswordLeakVerification());
      }
      if (other.hasFirewallPolicyAssessment()) {
        mergeFirewallPolicyAssessment(other.getFirewallPolicyAssessment());
      }
      if (other.hasFraudPreventionAssessment()) {
        mergeFraudPreventionAssessment(other.getFraudPreventionAssessment());
      }
      if (other.hasFraudSignals()) {
        mergeFraudSignals(other.getFraudSignals());
      }
      if (other.hasPhoneFraudAssessment()) {
        mergePhoneFraudAssessment(other.getPhoneFraudAssessment());
      }
      if (other.hasAssessmentEnvironment()) {
        mergeAssessmentEnvironment(other.getAssessmentEnvironment());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEventFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRiskAnalysisFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTokenPropertiesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getAccountVerificationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getAccountDefenderAssessmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 66:
              {
                input.readMessage(
                    getPrivatePasswordLeakVerificationFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 82:
              {
                input.readMessage(
                    getFirewallPolicyAssessmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getFraudPreventionAssessmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getPhoneFraudAssessmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getFraudSignalsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getAssessmentEnvironmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name for the Assessment in the format
     * `projects/{project}/assessments/{assessment}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name for the Assessment in the format
     * `projects/{project}/assessments/{assessment}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name for the Assessment in the format
     * `projects/{project}/assessments/{assessment}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name for the Assessment in the format
     * `projects/{project}/assessments/{assessment}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name for the Assessment in the format
     * `projects/{project}/assessments/{assessment}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.recaptchaenterprise.v1.Event event_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.Event,
            com.google.recaptchaenterprise.v1.Event.Builder,
            com.google.recaptchaenterprise.v1.EventOrBuilder>
        eventBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the event field is set.
     */
    public boolean hasEvent() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The event.
     */
    public com.google.recaptchaenterprise.v1.Event getEvent() {
      if (eventBuilder_ == null) {
        return event_ == null
            ? com.google.recaptchaenterprise.v1.Event.getDefaultInstance()
            : event_;
      } else {
        return eventBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEvent(com.google.recaptchaenterprise.v1.Event value) {
      if (eventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        event_ = value;
      } else {
        eventBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEvent(com.google.recaptchaenterprise.v1.Event.Builder builderForValue) {
      if (eventBuilder_ == null) {
        event_ = builderForValue.build();
      } else {
        eventBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEvent(com.google.recaptchaenterprise.v1.Event value) {
      if (eventBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && event_ != null
            && event_ != com.google.recaptchaenterprise.v1.Event.getDefaultInstance()) {
          getEventBuilder().mergeFrom(value);
        } else {
          event_ = value;
        }
      } else {
        eventBuilder_.mergeFrom(value);
      }
      if (event_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEvent() {
      bitField0_ = (bitField0_ & ~0x00000002);
      event_ = null;
      if (eventBuilder_ != null) {
        eventBuilder_.dispose();
        eventBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.Event.Builder getEventBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEventFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.EventOrBuilder getEventOrBuilder() {
      if (eventBuilder_ != null) {
        return eventBuilder_.getMessageOrBuilder();
      } else {
        return event_ == null
            ? com.google.recaptchaenterprise.v1.Event.getDefaultInstance()
            : event_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.Event event = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.Event,
            com.google.recaptchaenterprise.v1.Event.Builder,
            com.google.recaptchaenterprise.v1.EventOrBuilder>
        getEventFieldBuilder() {
      if (eventBuilder_ == null) {
        eventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.Event,
                com.google.recaptchaenterprise.v1.Event.Builder,
                com.google.recaptchaenterprise.v1.EventOrBuilder>(
                getEvent(), getParentForChildren(), isClean());
        event_ = null;
      }
      return eventBuilder_;
    }

    private com.google.recaptchaenterprise.v1.RiskAnalysis riskAnalysis_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.RiskAnalysis,
            com.google.recaptchaenterprise.v1.RiskAnalysis.Builder,
            com.google.recaptchaenterprise.v1.RiskAnalysisOrBuilder>
        riskAnalysisBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the riskAnalysis field is set.
     */
    public boolean hasRiskAnalysis() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The riskAnalysis.
     */
    public com.google.recaptchaenterprise.v1.RiskAnalysis getRiskAnalysis() {
      if (riskAnalysisBuilder_ == null) {
        return riskAnalysis_ == null
            ? com.google.recaptchaenterprise.v1.RiskAnalysis.getDefaultInstance()
            : riskAnalysis_;
      } else {
        return riskAnalysisBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRiskAnalysis(com.google.recaptchaenterprise.v1.RiskAnalysis value) {
      if (riskAnalysisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        riskAnalysis_ = value;
      } else {
        riskAnalysisBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRiskAnalysis(
        com.google.recaptchaenterprise.v1.RiskAnalysis.Builder builderForValue) {
      if (riskAnalysisBuilder_ == null) {
        riskAnalysis_ = builderForValue.build();
      } else {
        riskAnalysisBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRiskAnalysis(com.google.recaptchaenterprise.v1.RiskAnalysis value) {
      if (riskAnalysisBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && riskAnalysis_ != null
            && riskAnalysis_
                != com.google.recaptchaenterprise.v1.RiskAnalysis.getDefaultInstance()) {
          getRiskAnalysisBuilder().mergeFrom(value);
        } else {
          riskAnalysis_ = value;
        }
      } else {
        riskAnalysisBuilder_.mergeFrom(value);
      }
      if (riskAnalysis_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRiskAnalysis() {
      bitField0_ = (bitField0_ & ~0x00000004);
      riskAnalysis_ = null;
      if (riskAnalysisBuilder_ != null) {
        riskAnalysisBuilder_.dispose();
        riskAnalysisBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.RiskAnalysis.Builder getRiskAnalysisBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRiskAnalysisFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.RiskAnalysisOrBuilder getRiskAnalysisOrBuilder() {
      if (riskAnalysisBuilder_ != null) {
        return riskAnalysisBuilder_.getMessageOrBuilder();
      } else {
        return riskAnalysis_ == null
            ? com.google.recaptchaenterprise.v1.RiskAnalysis.getDefaultInstance()
            : riskAnalysis_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The risk analysis result for the event being assessed.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.RiskAnalysis risk_analysis = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.RiskAnalysis,
            com.google.recaptchaenterprise.v1.RiskAnalysis.Builder,
            com.google.recaptchaenterprise.v1.RiskAnalysisOrBuilder>
        getRiskAnalysisFieldBuilder() {
      if (riskAnalysisBuilder_ == null) {
        riskAnalysisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.RiskAnalysis,
                com.google.recaptchaenterprise.v1.RiskAnalysis.Builder,
                com.google.recaptchaenterprise.v1.RiskAnalysisOrBuilder>(
                getRiskAnalysis(), getParentForChildren(), isClean());
        riskAnalysis_ = null;
      }
      return riskAnalysisBuilder_;
    }

    private com.google.recaptchaenterprise.v1.TokenProperties tokenProperties_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.TokenProperties,
            com.google.recaptchaenterprise.v1.TokenProperties.Builder,
            com.google.recaptchaenterprise.v1.TokenPropertiesOrBuilder>
        tokenPropertiesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the tokenProperties field is set.
     */
    public boolean hasTokenProperties() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tokenProperties.
     */
    public com.google.recaptchaenterprise.v1.TokenProperties getTokenProperties() {
      if (tokenPropertiesBuilder_ == null) {
        return tokenProperties_ == null
            ? com.google.recaptchaenterprise.v1.TokenProperties.getDefaultInstance()
            : tokenProperties_;
      } else {
        return tokenPropertiesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTokenProperties(com.google.recaptchaenterprise.v1.TokenProperties value) {
      if (tokenPropertiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tokenProperties_ = value;
      } else {
        tokenPropertiesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTokenProperties(
        com.google.recaptchaenterprise.v1.TokenProperties.Builder builderForValue) {
      if (tokenPropertiesBuilder_ == null) {
        tokenProperties_ = builderForValue.build();
      } else {
        tokenPropertiesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTokenProperties(com.google.recaptchaenterprise.v1.TokenProperties value) {
      if (tokenPropertiesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && tokenProperties_ != null
            && tokenProperties_
                != com.google.recaptchaenterprise.v1.TokenProperties.getDefaultInstance()) {
          getTokenPropertiesBuilder().mergeFrom(value);
        } else {
          tokenProperties_ = value;
        }
      } else {
        tokenPropertiesBuilder_.mergeFrom(value);
      }
      if (tokenProperties_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTokenProperties() {
      bitField0_ = (bitField0_ & ~0x00000008);
      tokenProperties_ = null;
      if (tokenPropertiesBuilder_ != null) {
        tokenPropertiesBuilder_.dispose();
        tokenPropertiesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.TokenProperties.Builder getTokenPropertiesBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTokenPropertiesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.TokenPropertiesOrBuilder
        getTokenPropertiesOrBuilder() {
      if (tokenPropertiesBuilder_ != null) {
        return tokenPropertiesBuilder_.getMessageOrBuilder();
      } else {
        return tokenProperties_ == null
            ? com.google.recaptchaenterprise.v1.TokenProperties.getDefaultInstance()
            : tokenProperties_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Properties of the provided event token.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.TokenProperties token_properties = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.TokenProperties,
            com.google.recaptchaenterprise.v1.TokenProperties.Builder,
            com.google.recaptchaenterprise.v1.TokenPropertiesOrBuilder>
        getTokenPropertiesFieldBuilder() {
      if (tokenPropertiesBuilder_ == null) {
        tokenPropertiesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.TokenProperties,
                com.google.recaptchaenterprise.v1.TokenProperties.Builder,
                com.google.recaptchaenterprise.v1.TokenPropertiesOrBuilder>(
                getTokenProperties(), getParentForChildren(), isClean());
        tokenProperties_ = null;
      }
      return tokenPropertiesBuilder_;
    }

    private com.google.recaptchaenterprise.v1.AccountVerificationInfo accountVerification_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AccountVerificationInfo,
            com.google.recaptchaenterprise.v1.AccountVerificationInfo.Builder,
            com.google.recaptchaenterprise.v1.AccountVerificationInfoOrBuilder>
        accountVerificationBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Account verification information for identity verification. The
     * assessment event must include a token and site key to use this feature.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the accountVerification field is set.
     */
    public boolean hasAccountVerification() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Account verification information for identity verification. The
     * assessment event must include a token and site key to use this feature.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The accountVerification.
     */
    public com.google.recaptchaenterprise.v1.AccountVerificationInfo getAccountVerification() {
      if (accountVerificationBuilder_ == null) {
        return accountVerification_ == null
            ? com.google.recaptchaenterprise.v1.AccountVerificationInfo.getDefaultInstance()
            : accountVerification_;
      } else {
        return accountVerificationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Account verification information for identity verification. The
     * assessment event must include a token and site key to use this feature.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAccountVerification(
        com.google.recaptchaenterprise.v1.AccountVerificationInfo value) {
      if (accountVerificationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accountVerification_ = value;
      } else {
        accountVerificationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Account verification information for identity verification. The
     * assessment event must include a token and site key to use this feature.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAccountVerification(
        com.google.recaptchaenterprise.v1.AccountVerificationInfo.Builder builderForValue) {
      if (accountVerificationBuilder_ == null) {
        accountVerification_ = builderForValue.build();
      } else {
        accountVerificationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Account verification information for identity verification. The
     * assessment event must include a token and site key to use this feature.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAccountVerification(
        com.google.recaptchaenterprise.v1.AccountVerificationInfo value) {
      if (accountVerificationBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && accountVerification_ != null
            && accountVerification_
                != com.google.recaptchaenterprise.v1.AccountVerificationInfo.getDefaultInstance()) {
          getAccountVerificationBuilder().mergeFrom(value);
        } else {
          accountVerification_ = value;
        }
      } else {
        accountVerificationBuilder_.mergeFrom(value);
      }
      if (accountVerification_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Account verification information for identity verification. The
     * assessment event must include a token and site key to use this feature.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAccountVerification() {
      bitField0_ = (bitField0_ & ~0x00000010);
      accountVerification_ = null;
      if (accountVerificationBuilder_ != null) {
        accountVerificationBuilder_.dispose();
        accountVerificationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Account verification information for identity verification. The
     * assessment event must include a token and site key to use this feature.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.AccountVerificationInfo.Builder
        getAccountVerificationBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAccountVerificationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Account verification information for identity verification. The
     * assessment event must include a token and site key to use this feature.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.AccountVerificationInfoOrBuilder
        getAccountVerificationOrBuilder() {
      if (accountVerificationBuilder_ != null) {
        return accountVerificationBuilder_.getMessageOrBuilder();
      } else {
        return accountVerification_ == null
            ? com.google.recaptchaenterprise.v1.AccountVerificationInfo.getDefaultInstance()
            : accountVerification_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Account verification information for identity verification. The
     * assessment event must include a token and site key to use this feature.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo account_verification = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AccountVerificationInfo,
            com.google.recaptchaenterprise.v1.AccountVerificationInfo.Builder,
            com.google.recaptchaenterprise.v1.AccountVerificationInfoOrBuilder>
        getAccountVerificationFieldBuilder() {
      if (accountVerificationBuilder_ == null) {
        accountVerificationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.AccountVerificationInfo,
                com.google.recaptchaenterprise.v1.AccountVerificationInfo.Builder,
                com.google.recaptchaenterprise.v1.AccountVerificationInfoOrBuilder>(
                getAccountVerification(), getParentForChildren(), isClean());
        accountVerification_ = null;
      }
      return accountVerificationBuilder_;
    }

    private com.google.recaptchaenterprise.v1.AccountDefenderAssessment accountDefenderAssessment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AccountDefenderAssessment,
            com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder,
            com.google.recaptchaenterprise.v1.AccountDefenderAssessmentOrBuilder>
        accountDefenderAssessmentBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by account defender when an account
     * identifier is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the accountDefenderAssessment field is set.
     */
    public boolean hasAccountDefenderAssessment() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by account defender when an account
     * identifier is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The accountDefenderAssessment.
     */
    public com.google.recaptchaenterprise.v1.AccountDefenderAssessment
        getAccountDefenderAssessment() {
      if (accountDefenderAssessmentBuilder_ == null) {
        return accountDefenderAssessment_ == null
            ? com.google.recaptchaenterprise.v1.AccountDefenderAssessment.getDefaultInstance()
            : accountDefenderAssessment_;
      } else {
        return accountDefenderAssessmentBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by account defender when an account
     * identifier is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAccountDefenderAssessment(
        com.google.recaptchaenterprise.v1.AccountDefenderAssessment value) {
      if (accountDefenderAssessmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        accountDefenderAssessment_ = value;
      } else {
        accountDefenderAssessmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by account defender when an account
     * identifier is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAccountDefenderAssessment(
        com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder builderForValue) {
      if (accountDefenderAssessmentBuilder_ == null) {
        accountDefenderAssessment_ = builderForValue.build();
      } else {
        accountDefenderAssessmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by account defender when an account
     * identifier is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAccountDefenderAssessment(
        com.google.recaptchaenterprise.v1.AccountDefenderAssessment value) {
      if (accountDefenderAssessmentBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && accountDefenderAssessment_ != null
            && accountDefenderAssessment_
                != com.google.recaptchaenterprise.v1.AccountDefenderAssessment
                    .getDefaultInstance()) {
          getAccountDefenderAssessmentBuilder().mergeFrom(value);
        } else {
          accountDefenderAssessment_ = value;
        }
      } else {
        accountDefenderAssessmentBuilder_.mergeFrom(value);
      }
      if (accountDefenderAssessment_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by account defender when an account
     * identifier is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAccountDefenderAssessment() {
      bitField0_ = (bitField0_ & ~0x00000020);
      accountDefenderAssessment_ = null;
      if (accountDefenderAssessmentBuilder_ != null) {
        accountDefenderAssessmentBuilder_.dispose();
        accountDefenderAssessmentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by account defender when an account
     * identifier is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder
        getAccountDefenderAssessmentBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getAccountDefenderAssessmentFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by account defender when an account
     * identifier is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.AccountDefenderAssessmentOrBuilder
        getAccountDefenderAssessmentOrBuilder() {
      if (accountDefenderAssessmentBuilder_ != null) {
        return accountDefenderAssessmentBuilder_.getMessageOrBuilder();
      } else {
        return accountDefenderAssessment_ == null
            ? com.google.recaptchaenterprise.v1.AccountDefenderAssessment.getDefaultInstance()
            : accountDefenderAssessment_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by account defender when an account
     * identifier is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountDefenderAssessment account_defender_assessment = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AccountDefenderAssessment,
            com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder,
            com.google.recaptchaenterprise.v1.AccountDefenderAssessmentOrBuilder>
        getAccountDefenderAssessmentFieldBuilder() {
      if (accountDefenderAssessmentBuilder_ == null) {
        accountDefenderAssessmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.AccountDefenderAssessment,
                com.google.recaptchaenterprise.v1.AccountDefenderAssessment.Builder,
                com.google.recaptchaenterprise.v1.AccountDefenderAssessmentOrBuilder>(
                getAccountDefenderAssessment(), getParentForChildren(), isClean());
        accountDefenderAssessment_ = null;
      }
      return accountDefenderAssessmentBuilder_;
    }

    private com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification
        privatePasswordLeakVerification_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification,
            com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification.Builder,
            com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerificationOrBuilder>
        privatePasswordLeakVerificationBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The private password leak verification field contains the
     * parameters that are used to to check for leaks privately without sharing
     * user credentials.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the privatePasswordLeakVerification field is set.
     */
    public boolean hasPrivatePasswordLeakVerification() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The private password leak verification field contains the
     * parameters that are used to to check for leaks privately without sharing
     * user credentials.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The privatePasswordLeakVerification.
     */
    public com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification
        getPrivatePasswordLeakVerification() {
      if (privatePasswordLeakVerificationBuilder_ == null) {
        return privatePasswordLeakVerification_ == null
            ? com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification.getDefaultInstance()
            : privatePasswordLeakVerification_;
      } else {
        return privatePasswordLeakVerificationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The private password leak verification field contains the
     * parameters that are used to to check for leaks privately without sharing
     * user credentials.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivatePasswordLeakVerification(
        com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification value) {
      if (privatePasswordLeakVerificationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privatePasswordLeakVerification_ = value;
      } else {
        privatePasswordLeakVerificationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The private password leak verification field contains the
     * parameters that are used to to check for leaks privately without sharing
     * user credentials.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrivatePasswordLeakVerification(
        com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification.Builder builderForValue) {
      if (privatePasswordLeakVerificationBuilder_ == null) {
        privatePasswordLeakVerification_ = builderForValue.build();
      } else {
        privatePasswordLeakVerificationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The private password leak verification field contains the
     * parameters that are used to to check for leaks privately without sharing
     * user credentials.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePrivatePasswordLeakVerification(
        com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification value) {
      if (privatePasswordLeakVerificationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && privatePasswordLeakVerification_ != null
            && privatePasswordLeakVerification_
                != com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification
                    .getDefaultInstance()) {
          getPrivatePasswordLeakVerificationBuilder().mergeFrom(value);
        } else {
          privatePasswordLeakVerification_ = value;
        }
      } else {
        privatePasswordLeakVerificationBuilder_.mergeFrom(value);
      }
      if (privatePasswordLeakVerification_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The private password leak verification field contains the
     * parameters that are used to to check for leaks privately without sharing
     * user credentials.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPrivatePasswordLeakVerification() {
      bitField0_ = (bitField0_ & ~0x00000040);
      privatePasswordLeakVerification_ = null;
      if (privatePasswordLeakVerificationBuilder_ != null) {
        privatePasswordLeakVerificationBuilder_.dispose();
        privatePasswordLeakVerificationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The private password leak verification field contains the
     * parameters that are used to to check for leaks privately without sharing
     * user credentials.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification.Builder
        getPrivatePasswordLeakVerificationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getPrivatePasswordLeakVerificationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The private password leak verification field contains the
     * parameters that are used to to check for leaks privately without sharing
     * user credentials.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerificationOrBuilder
        getPrivatePasswordLeakVerificationOrBuilder() {
      if (privatePasswordLeakVerificationBuilder_ != null) {
        return privatePasswordLeakVerificationBuilder_.getMessageOrBuilder();
      } else {
        return privatePasswordLeakVerification_ == null
            ? com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification.getDefaultInstance()
            : privatePasswordLeakVerification_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The private password leak verification field contains the
     * parameters that are used to to check for leaks privately without sharing
     * user credentials.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PrivatePasswordLeakVerification private_password_leak_verification = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification,
            com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification.Builder,
            com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerificationOrBuilder>
        getPrivatePasswordLeakVerificationFieldBuilder() {
      if (privatePasswordLeakVerificationBuilder_ == null) {
        privatePasswordLeakVerificationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification,
                com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerification.Builder,
                com.google.recaptchaenterprise.v1.PrivatePasswordLeakVerificationOrBuilder>(
                getPrivatePasswordLeakVerification(), getParentForChildren(), isClean());
        privatePasswordLeakVerification_ = null;
      }
      return privatePasswordLeakVerificationBuilder_;
    }

    private com.google.recaptchaenterprise.v1.FirewallPolicyAssessment firewallPolicyAssessment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FirewallPolicyAssessment,
            com.google.recaptchaenterprise.v1.FirewallPolicyAssessment.Builder,
            com.google.recaptchaenterprise.v1.FirewallPolicyAssessmentOrBuilder>
        firewallPolicyAssessmentBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when firewall policies belonging to the
     * project are evaluated using the field firewall_policy_evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the firewallPolicyAssessment field is set.
     */
    public boolean hasFirewallPolicyAssessment() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when firewall policies belonging to the
     * project are evaluated using the field firewall_policy_evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The firewallPolicyAssessment.
     */
    public com.google.recaptchaenterprise.v1.FirewallPolicyAssessment
        getFirewallPolicyAssessment() {
      if (firewallPolicyAssessmentBuilder_ == null) {
        return firewallPolicyAssessment_ == null
            ? com.google.recaptchaenterprise.v1.FirewallPolicyAssessment.getDefaultInstance()
            : firewallPolicyAssessment_;
      } else {
        return firewallPolicyAssessmentBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when firewall policies belonging to the
     * project are evaluated using the field firewall_policy_evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFirewallPolicyAssessment(
        com.google.recaptchaenterprise.v1.FirewallPolicyAssessment value) {
      if (firewallPolicyAssessmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        firewallPolicyAssessment_ = value;
      } else {
        firewallPolicyAssessmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when firewall policies belonging to the
     * project are evaluated using the field firewall_policy_evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFirewallPolicyAssessment(
        com.google.recaptchaenterprise.v1.FirewallPolicyAssessment.Builder builderForValue) {
      if (firewallPolicyAssessmentBuilder_ == null) {
        firewallPolicyAssessment_ = builderForValue.build();
      } else {
        firewallPolicyAssessmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when firewall policies belonging to the
     * project are evaluated using the field firewall_policy_evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFirewallPolicyAssessment(
        com.google.recaptchaenterprise.v1.FirewallPolicyAssessment value) {
      if (firewallPolicyAssessmentBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && firewallPolicyAssessment_ != null
            && firewallPolicyAssessment_
                != com.google.recaptchaenterprise.v1.FirewallPolicyAssessment
                    .getDefaultInstance()) {
          getFirewallPolicyAssessmentBuilder().mergeFrom(value);
        } else {
          firewallPolicyAssessment_ = value;
        }
      } else {
        firewallPolicyAssessmentBuilder_.mergeFrom(value);
      }
      if (firewallPolicyAssessment_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when firewall policies belonging to the
     * project are evaluated using the field firewall_policy_evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFirewallPolicyAssessment() {
      bitField0_ = (bitField0_ & ~0x00000080);
      firewallPolicyAssessment_ = null;
      if (firewallPolicyAssessmentBuilder_ != null) {
        firewallPolicyAssessmentBuilder_.dispose();
        firewallPolicyAssessmentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when firewall policies belonging to the
     * project are evaluated using the field firewall_policy_evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FirewallPolicyAssessment.Builder
        getFirewallPolicyAssessmentBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getFirewallPolicyAssessmentFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when firewall policies belonging to the
     * project are evaluated using the field firewall_policy_evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FirewallPolicyAssessmentOrBuilder
        getFirewallPolicyAssessmentOrBuilder() {
      if (firewallPolicyAssessmentBuilder_ != null) {
        return firewallPolicyAssessmentBuilder_.getMessageOrBuilder();
      } else {
        return firewallPolicyAssessment_ == null
            ? com.google.recaptchaenterprise.v1.FirewallPolicyAssessment.getDefaultInstance()
            : firewallPolicyAssessment_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when firewall policies belonging to the
     * project are evaluated using the field firewall_policy_evaluation.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FirewallPolicyAssessment firewall_policy_assessment = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FirewallPolicyAssessment,
            com.google.recaptchaenterprise.v1.FirewallPolicyAssessment.Builder,
            com.google.recaptchaenterprise.v1.FirewallPolicyAssessmentOrBuilder>
        getFirewallPolicyAssessmentFieldBuilder() {
      if (firewallPolicyAssessmentBuilder_ == null) {
        firewallPolicyAssessmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.FirewallPolicyAssessment,
                com.google.recaptchaenterprise.v1.FirewallPolicyAssessment.Builder,
                com.google.recaptchaenterprise.v1.FirewallPolicyAssessmentOrBuilder>(
                getFirewallPolicyAssessment(), getParentForChildren(), isClean());
        firewallPolicyAssessment_ = null;
      }
      return firewallPolicyAssessmentBuilder_;
    }

    private com.google.recaptchaenterprise.v1.FraudPreventionAssessment fraudPreventionAssessment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FraudPreventionAssessment,
            com.google.recaptchaenterprise.v1.FraudPreventionAssessment.Builder,
            com.google.recaptchaenterprise.v1.FraudPreventionAssessmentOrBuilder>
        fraudPreventionAssessmentBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by Fraud Prevention when TransactionData
     * is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the fraudPreventionAssessment field is set.
     */
    public boolean hasFraudPreventionAssessment() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by Fraud Prevention when TransactionData
     * is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The fraudPreventionAssessment.
     */
    public com.google.recaptchaenterprise.v1.FraudPreventionAssessment
        getFraudPreventionAssessment() {
      if (fraudPreventionAssessmentBuilder_ == null) {
        return fraudPreventionAssessment_ == null
            ? com.google.recaptchaenterprise.v1.FraudPreventionAssessment.getDefaultInstance()
            : fraudPreventionAssessment_;
      } else {
        return fraudPreventionAssessmentBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by Fraud Prevention when TransactionData
     * is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFraudPreventionAssessment(
        com.google.recaptchaenterprise.v1.FraudPreventionAssessment value) {
      if (fraudPreventionAssessmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fraudPreventionAssessment_ = value;
      } else {
        fraudPreventionAssessmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by Fraud Prevention when TransactionData
     * is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFraudPreventionAssessment(
        com.google.recaptchaenterprise.v1.FraudPreventionAssessment.Builder builderForValue) {
      if (fraudPreventionAssessmentBuilder_ == null) {
        fraudPreventionAssessment_ = builderForValue.build();
      } else {
        fraudPreventionAssessmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by Fraud Prevention when TransactionData
     * is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFraudPreventionAssessment(
        com.google.recaptchaenterprise.v1.FraudPreventionAssessment value) {
      if (fraudPreventionAssessmentBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && fraudPreventionAssessment_ != null
            && fraudPreventionAssessment_
                != com.google.recaptchaenterprise.v1.FraudPreventionAssessment
                    .getDefaultInstance()) {
          getFraudPreventionAssessmentBuilder().mergeFrom(value);
        } else {
          fraudPreventionAssessment_ = value;
        }
      } else {
        fraudPreventionAssessmentBuilder_.mergeFrom(value);
      }
      if (fraudPreventionAssessment_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by Fraud Prevention when TransactionData
     * is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFraudPreventionAssessment() {
      bitField0_ = (bitField0_ & ~0x00000100);
      fraudPreventionAssessment_ = null;
      if (fraudPreventionAssessmentBuilder_ != null) {
        fraudPreventionAssessmentBuilder_.dispose();
        fraudPreventionAssessmentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by Fraud Prevention when TransactionData
     * is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FraudPreventionAssessment.Builder
        getFraudPreventionAssessmentBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getFraudPreventionAssessmentFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by Fraud Prevention when TransactionData
     * is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FraudPreventionAssessmentOrBuilder
        getFraudPreventionAssessmentOrBuilder() {
      if (fraudPreventionAssessmentBuilder_ != null) {
        return fraudPreventionAssessmentBuilder_.getMessageOrBuilder();
      } else {
        return fraudPreventionAssessment_ == null
            ? com.google.recaptchaenterprise.v1.FraudPreventionAssessment.getDefaultInstance()
            : fraudPreventionAssessment_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned by Fraud Prevention when TransactionData
     * is provided.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudPreventionAssessment fraud_prevention_assessment = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FraudPreventionAssessment,
            com.google.recaptchaenterprise.v1.FraudPreventionAssessment.Builder,
            com.google.recaptchaenterprise.v1.FraudPreventionAssessmentOrBuilder>
        getFraudPreventionAssessmentFieldBuilder() {
      if (fraudPreventionAssessmentBuilder_ == null) {
        fraudPreventionAssessmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.FraudPreventionAssessment,
                com.google.recaptchaenterprise.v1.FraudPreventionAssessment.Builder,
                com.google.recaptchaenterprise.v1.FraudPreventionAssessmentOrBuilder>(
                getFraudPreventionAssessment(), getParentForChildren(), isClean());
        fraudPreventionAssessment_ = null;
      }
      return fraudPreventionAssessmentBuilder_;
    }

    private com.google.recaptchaenterprise.v1.FraudSignals fraudSignals_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FraudSignals,
            com.google.recaptchaenterprise.v1.FraudSignals.Builder,
            com.google.recaptchaenterprise.v1.FraudSignalsOrBuilder>
        fraudSignalsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Fraud Signals specific to the users involved in a payment
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the fraudSignals field is set.
     */
    public boolean hasFraudSignals() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Fraud Signals specific to the users involved in a payment
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The fraudSignals.
     */
    public com.google.recaptchaenterprise.v1.FraudSignals getFraudSignals() {
      if (fraudSignalsBuilder_ == null) {
        return fraudSignals_ == null
            ? com.google.recaptchaenterprise.v1.FraudSignals.getDefaultInstance()
            : fraudSignals_;
      } else {
        return fraudSignalsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Fraud Signals specific to the users involved in a payment
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFraudSignals(com.google.recaptchaenterprise.v1.FraudSignals value) {
      if (fraudSignalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fraudSignals_ = value;
      } else {
        fraudSignalsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Fraud Signals specific to the users involved in a payment
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFraudSignals(
        com.google.recaptchaenterprise.v1.FraudSignals.Builder builderForValue) {
      if (fraudSignalsBuilder_ == null) {
        fraudSignals_ = builderForValue.build();
      } else {
        fraudSignalsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Fraud Signals specific to the users involved in a payment
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFraudSignals(com.google.recaptchaenterprise.v1.FraudSignals value) {
      if (fraudSignalsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && fraudSignals_ != null
            && fraudSignals_
                != com.google.recaptchaenterprise.v1.FraudSignals.getDefaultInstance()) {
          getFraudSignalsBuilder().mergeFrom(value);
        } else {
          fraudSignals_ = value;
        }
      } else {
        fraudSignalsBuilder_.mergeFrom(value);
      }
      if (fraudSignals_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Fraud Signals specific to the users involved in a payment
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFraudSignals() {
      bitField0_ = (bitField0_ & ~0x00000200);
      fraudSignals_ = null;
      if (fraudSignalsBuilder_ != null) {
        fraudSignalsBuilder_.dispose();
        fraudSignalsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Fraud Signals specific to the users involved in a payment
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FraudSignals.Builder getFraudSignalsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getFraudSignalsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Fraud Signals specific to the users involved in a payment
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.FraudSignalsOrBuilder getFraudSignalsOrBuilder() {
      if (fraudSignalsBuilder_ != null) {
        return fraudSignalsBuilder_.getMessageOrBuilder();
      } else {
        return fraudSignals_ == null
            ? com.google.recaptchaenterprise.v1.FraudSignals.getDefaultInstance()
            : fraudSignals_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Fraud Signals specific to the users involved in a payment
     * transaction.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.FraudSignals fraud_signals = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.FraudSignals,
            com.google.recaptchaenterprise.v1.FraudSignals.Builder,
            com.google.recaptchaenterprise.v1.FraudSignalsOrBuilder>
        getFraudSignalsFieldBuilder() {
      if (fraudSignalsBuilder_ == null) {
        fraudSignalsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.FraudSignals,
                com.google.recaptchaenterprise.v1.FraudSignals.Builder,
                com.google.recaptchaenterprise.v1.FraudSignalsOrBuilder>(
                getFraudSignals(), getParentForChildren(), isClean());
        fraudSignals_ = null;
      }
      return fraudSignalsBuilder_;
    }

    private com.google.recaptchaenterprise.v1.PhoneFraudAssessment phoneFraudAssessment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.PhoneFraudAssessment,
            com.google.recaptchaenterprise.v1.PhoneFraudAssessment.Builder,
            com.google.recaptchaenterprise.v1.PhoneFraudAssessmentOrBuilder>
        phoneFraudAssessmentBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when a site key, a token, and a phone
     * number as `user_id` are provided. Account defender and SMS toll fraud
     * protection need to be enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the phoneFraudAssessment field is set.
     */
    public boolean hasPhoneFraudAssessment() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when a site key, a token, and a phone
     * number as `user_id` are provided. Account defender and SMS toll fraud
     * protection need to be enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The phoneFraudAssessment.
     */
    public com.google.recaptchaenterprise.v1.PhoneFraudAssessment getPhoneFraudAssessment() {
      if (phoneFraudAssessmentBuilder_ == null) {
        return phoneFraudAssessment_ == null
            ? com.google.recaptchaenterprise.v1.PhoneFraudAssessment.getDefaultInstance()
            : phoneFraudAssessment_;
      } else {
        return phoneFraudAssessmentBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when a site key, a token, and a phone
     * number as `user_id` are provided. Account defender and SMS toll fraud
     * protection need to be enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPhoneFraudAssessment(
        com.google.recaptchaenterprise.v1.PhoneFraudAssessment value) {
      if (phoneFraudAssessmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        phoneFraudAssessment_ = value;
      } else {
        phoneFraudAssessmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when a site key, a token, and a phone
     * number as `user_id` are provided. Account defender and SMS toll fraud
     * protection need to be enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPhoneFraudAssessment(
        com.google.recaptchaenterprise.v1.PhoneFraudAssessment.Builder builderForValue) {
      if (phoneFraudAssessmentBuilder_ == null) {
        phoneFraudAssessment_ = builderForValue.build();
      } else {
        phoneFraudAssessmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when a site key, a token, and a phone
     * number as `user_id` are provided. Account defender and SMS toll fraud
     * protection need to be enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePhoneFraudAssessment(
        com.google.recaptchaenterprise.v1.PhoneFraudAssessment value) {
      if (phoneFraudAssessmentBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && phoneFraudAssessment_ != null
            && phoneFraudAssessment_
                != com.google.recaptchaenterprise.v1.PhoneFraudAssessment.getDefaultInstance()) {
          getPhoneFraudAssessmentBuilder().mergeFrom(value);
        } else {
          phoneFraudAssessment_ = value;
        }
      } else {
        phoneFraudAssessmentBuilder_.mergeFrom(value);
      }
      if (phoneFraudAssessment_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when a site key, a token, and a phone
     * number as `user_id` are provided. Account defender and SMS toll fraud
     * protection need to be enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPhoneFraudAssessment() {
      bitField0_ = (bitField0_ & ~0x00000400);
      phoneFraudAssessment_ = null;
      if (phoneFraudAssessmentBuilder_ != null) {
        phoneFraudAssessmentBuilder_.dispose();
        phoneFraudAssessmentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when a site key, a token, and a phone
     * number as `user_id` are provided. Account defender and SMS toll fraud
     * protection need to be enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.PhoneFraudAssessment.Builder
        getPhoneFraudAssessmentBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getPhoneFraudAssessmentFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when a site key, a token, and a phone
     * number as `user_id` are provided. Account defender and SMS toll fraud
     * protection need to be enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.PhoneFraudAssessmentOrBuilder
        getPhoneFraudAssessmentOrBuilder() {
      if (phoneFraudAssessmentBuilder_ != null) {
        return phoneFraudAssessmentBuilder_.getMessageOrBuilder();
      } else {
        return phoneFraudAssessment_ == null
            ? com.google.recaptchaenterprise.v1.PhoneFraudAssessment.getDefaultInstance()
            : phoneFraudAssessment_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Assessment returned when a site key, a token, and a phone
     * number as `user_id` are provided. Account defender and SMS toll fraud
     * protection need to be enabled.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.PhoneFraudAssessment phone_fraud_assessment = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.PhoneFraudAssessment,
            com.google.recaptchaenterprise.v1.PhoneFraudAssessment.Builder,
            com.google.recaptchaenterprise.v1.PhoneFraudAssessmentOrBuilder>
        getPhoneFraudAssessmentFieldBuilder() {
      if (phoneFraudAssessmentBuilder_ == null) {
        phoneFraudAssessmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.PhoneFraudAssessment,
                com.google.recaptchaenterprise.v1.PhoneFraudAssessment.Builder,
                com.google.recaptchaenterprise.v1.PhoneFraudAssessmentOrBuilder>(
                getPhoneFraudAssessment(), getParentForChildren(), isClean());
        phoneFraudAssessment_ = null;
      }
      return phoneFraudAssessmentBuilder_;
    }

    private com.google.recaptchaenterprise.v1.AssessmentEnvironment assessmentEnvironment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AssessmentEnvironment,
            com.google.recaptchaenterprise.v1.AssessmentEnvironment.Builder,
            com.google.recaptchaenterprise.v1.AssessmentEnvironmentOrBuilder>
        assessmentEnvironmentBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The environment creating the assessment. This describes your
     * environment (the system invoking CreateAssessment), NOT the environment of
     * your user.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the assessmentEnvironment field is set.
     */
    public boolean hasAssessmentEnvironment() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The environment creating the assessment. This describes your
     * environment (the system invoking CreateAssessment), NOT the environment of
     * your user.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The assessmentEnvironment.
     */
    public com.google.recaptchaenterprise.v1.AssessmentEnvironment getAssessmentEnvironment() {
      if (assessmentEnvironmentBuilder_ == null) {
        return assessmentEnvironment_ == null
            ? com.google.recaptchaenterprise.v1.AssessmentEnvironment.getDefaultInstance()
            : assessmentEnvironment_;
      } else {
        return assessmentEnvironmentBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The environment creating the assessment. This describes your
     * environment (the system invoking CreateAssessment), NOT the environment of
     * your user.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAssessmentEnvironment(
        com.google.recaptchaenterprise.v1.AssessmentEnvironment value) {
      if (assessmentEnvironmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assessmentEnvironment_ = value;
      } else {
        assessmentEnvironmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The environment creating the assessment. This describes your
     * environment (the system invoking CreateAssessment), NOT the environment of
     * your user.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAssessmentEnvironment(
        com.google.recaptchaenterprise.v1.AssessmentEnvironment.Builder builderForValue) {
      if (assessmentEnvironmentBuilder_ == null) {
        assessmentEnvironment_ = builderForValue.build();
      } else {
        assessmentEnvironmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The environment creating the assessment. This describes your
     * environment (the system invoking CreateAssessment), NOT the environment of
     * your user.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAssessmentEnvironment(
        com.google.recaptchaenterprise.v1.AssessmentEnvironment value) {
      if (assessmentEnvironmentBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && assessmentEnvironment_ != null
            && assessmentEnvironment_
                != com.google.recaptchaenterprise.v1.AssessmentEnvironment.getDefaultInstance()) {
          getAssessmentEnvironmentBuilder().mergeFrom(value);
        } else {
          assessmentEnvironment_ = value;
        }
      } else {
        assessmentEnvironmentBuilder_.mergeFrom(value);
      }
      if (assessmentEnvironment_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The environment creating the assessment. This describes your
     * environment (the system invoking CreateAssessment), NOT the environment of
     * your user.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAssessmentEnvironment() {
      bitField0_ = (bitField0_ & ~0x00000800);
      assessmentEnvironment_ = null;
      if (assessmentEnvironmentBuilder_ != null) {
        assessmentEnvironmentBuilder_.dispose();
        assessmentEnvironmentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The environment creating the assessment. This describes your
     * environment (the system invoking CreateAssessment), NOT the environment of
     * your user.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.AssessmentEnvironment.Builder
        getAssessmentEnvironmentBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getAssessmentEnvironmentFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The environment creating the assessment. This describes your
     * environment (the system invoking CreateAssessment), NOT the environment of
     * your user.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.AssessmentEnvironmentOrBuilder
        getAssessmentEnvironmentOrBuilder() {
      if (assessmentEnvironmentBuilder_ != null) {
        return assessmentEnvironmentBuilder_.getMessageOrBuilder();
      } else {
        return assessmentEnvironment_ == null
            ? com.google.recaptchaenterprise.v1.AssessmentEnvironment.getDefaultInstance()
            : assessmentEnvironment_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The environment creating the assessment. This describes your
     * environment (the system invoking CreateAssessment), NOT the environment of
     * your user.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AssessmentEnvironment assessment_environment = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.recaptchaenterprise.v1.AssessmentEnvironment,
            com.google.recaptchaenterprise.v1.AssessmentEnvironment.Builder,
            com.google.recaptchaenterprise.v1.AssessmentEnvironmentOrBuilder>
        getAssessmentEnvironmentFieldBuilder() {
      if (assessmentEnvironmentBuilder_ == null) {
        assessmentEnvironmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.recaptchaenterprise.v1.AssessmentEnvironment,
                com.google.recaptchaenterprise.v1.AssessmentEnvironment.Builder,
                com.google.recaptchaenterprise.v1.AssessmentEnvironmentOrBuilder>(
                getAssessmentEnvironment(), getParentForChildren(), isClean());
        assessmentEnvironment_ = null;
      }
      return assessmentEnvironmentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.Assessment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.Assessment)
  private static final com.google.recaptchaenterprise.v1.Assessment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.Assessment();
  }

  public static com.google.recaptchaenterprise.v1.Assessment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Assessment> PARSER =
      new com.google.protobuf.AbstractParser<Assessment>() {
        @java.lang.Override
        public Assessment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Assessment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Assessment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.Assessment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
