/*
 * Decompiled with CFR 0.152.
 */
package com.google.recaptchaenterprise.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetricsName
implements ResourceName {
    private static final PathTemplate PROJECT_KEY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/keys/{key}/metrics");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String key;

    @Deprecated
    protected MetricsName() {
        this.project = null;
        this.key = null;
    }

    private MetricsName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.key = (String)Preconditions.checkNotNull((Object)builder.getKey());
    }

    public String getProject() {
        return this.project;
    }

    public String getKey() {
        return this.key;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MetricsName of(String project, String key) {
        return MetricsName.newBuilder().setProject(project).setKey(key).build();
    }

    public static String format(String project, String key) {
        return MetricsName.newBuilder().setProject(project).setKey(key).build().toString();
    }

    public static MetricsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_KEY.validatedMatch(formattedString, "MetricsName.parse: formattedString not in valid format");
        return MetricsName.of((String)matchMap.get("project"), (String)matchMap.get("key"));
    }

    public static List<MetricsName> parseList(List<String> formattedStrings) {
        ArrayList<MetricsName> list = new ArrayList<MetricsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MetricsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MetricsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MetricsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MetricsName metricsName = this;
            synchronized (metricsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.key != null) {
                        fieldMapBuilder.put((Object)"key", (Object)this.key);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_KEY.instantiate(new String[]{"project", this.project, "key", this.key});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MetricsName that = (MetricsName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.key, that.key);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.key);
    }

    public static class Builder {
        private String project;
        private String key;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        private Builder(MetricsName metricsName) {
            this.project = metricsName.project;
            this.key = metricsName.key;
        }

        public MetricsName build() {
            return new MetricsName(this);
        }
    }
}

