/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

// Protobuf Java Version: 3.25.5
package com.google.recaptchaenterprise.v1;

/**
 *
 *
 * <pre>
 * Information about account verification, used for identity verification.
 * </pre>
 *
 * Protobuf type {@code google.cloud.recaptchaenterprise.v1.AccountVerificationInfo}
 */
public final class AccountVerificationInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.recaptchaenterprise.v1.AccountVerificationInfo)
    AccountVerificationInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AccountVerificationInfo.newBuilder() to construct.
  private AccountVerificationInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AccountVerificationInfo() {
    endpoints_ = java.util.Collections.emptyList();
    languageCode_ = "";
    latestVerificationResult_ = 0;
    username_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AccountVerificationInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_AccountVerificationInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
        .internal_static_google_cloud_recaptchaenterprise_v1_AccountVerificationInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.recaptchaenterprise.v1.AccountVerificationInfo.class,
            com.google.recaptchaenterprise.v1.AccountVerificationInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Result of the account verification as contained in the verdict token issued
   * at the end of the verification flow.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.Result}
   */
  public enum Result implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No information about the latest account verification.
     * </pre>
     *
     * <code>RESULT_UNSPECIFIED = 0;</code>
     */
    RESULT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The user was successfully verified. This means the account verification
     * challenge was successfully completed.
     * </pre>
     *
     * <code>SUCCESS_USER_VERIFIED = 1;</code>
     */
    SUCCESS_USER_VERIFIED(1),
    /**
     *
     *
     * <pre>
     * The user failed the verification challenge.
     * </pre>
     *
     * <code>ERROR_USER_NOT_VERIFIED = 2;</code>
     */
    ERROR_USER_NOT_VERIFIED(2),
    /**
     *
     *
     * <pre>
     * The site is not properly onboarded to use the account verification
     * feature.
     * </pre>
     *
     * <code>ERROR_SITE_ONBOARDING_INCOMPLETE = 3;</code>
     */
    ERROR_SITE_ONBOARDING_INCOMPLETE(3),
    /**
     *
     *
     * <pre>
     * The recipient is not allowed for account verification. This can occur
     * during integration but should not occur in production.
     * </pre>
     *
     * <code>ERROR_RECIPIENT_NOT_ALLOWED = 4;</code>
     */
    ERROR_RECIPIENT_NOT_ALLOWED(4),
    /**
     *
     *
     * <pre>
     * The recipient has already been sent too many verification codes in a
     * short amount of time.
     * </pre>
     *
     * <code>ERROR_RECIPIENT_ABUSE_LIMIT_EXHAUSTED = 5;</code>
     */
    ERROR_RECIPIENT_ABUSE_LIMIT_EXHAUSTED(5),
    /**
     *
     *
     * <pre>
     * The verification flow could not be completed due to a critical internal
     * error.
     * </pre>
     *
     * <code>ERROR_CRITICAL_INTERNAL = 6;</code>
     */
    ERROR_CRITICAL_INTERNAL(6),
    /**
     *
     *
     * <pre>
     * The client has exceeded their two factor request quota for this period of
     * time.
     * </pre>
     *
     * <code>ERROR_CUSTOMER_QUOTA_EXHAUSTED = 7;</code>
     */
    ERROR_CUSTOMER_QUOTA_EXHAUSTED(7),
    /**
     *
     *
     * <pre>
     * The request cannot be processed at the time because of an incident. This
     * bypass can be restricted to a problematic destination email domain, a
     * customer, or could affect the entire service.
     * </pre>
     *
     * <code>ERROR_VERIFICATION_BYPASSED = 8;</code>
     */
    ERROR_VERIFICATION_BYPASSED(8),
    /**
     *
     *
     * <pre>
     * The request parameters do not match with the token provided and cannot be
     * processed.
     * </pre>
     *
     * <code>ERROR_VERDICT_MISMATCH = 9;</code>
     */
    ERROR_VERDICT_MISMATCH(9),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No information about the latest account verification.
     * </pre>
     *
     * <code>RESULT_UNSPECIFIED = 0;</code>
     */
    public static final int RESULT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The user was successfully verified. This means the account verification
     * challenge was successfully completed.
     * </pre>
     *
     * <code>SUCCESS_USER_VERIFIED = 1;</code>
     */
    public static final int SUCCESS_USER_VERIFIED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The user failed the verification challenge.
     * </pre>
     *
     * <code>ERROR_USER_NOT_VERIFIED = 2;</code>
     */
    public static final int ERROR_USER_NOT_VERIFIED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The site is not properly onboarded to use the account verification
     * feature.
     * </pre>
     *
     * <code>ERROR_SITE_ONBOARDING_INCOMPLETE = 3;</code>
     */
    public static final int ERROR_SITE_ONBOARDING_INCOMPLETE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The recipient is not allowed for account verification. This can occur
     * during integration but should not occur in production.
     * </pre>
     *
     * <code>ERROR_RECIPIENT_NOT_ALLOWED = 4;</code>
     */
    public static final int ERROR_RECIPIENT_NOT_ALLOWED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The recipient has already been sent too many verification codes in a
     * short amount of time.
     * </pre>
     *
     * <code>ERROR_RECIPIENT_ABUSE_LIMIT_EXHAUSTED = 5;</code>
     */
    public static final int ERROR_RECIPIENT_ABUSE_LIMIT_EXHAUSTED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The verification flow could not be completed due to a critical internal
     * error.
     * </pre>
     *
     * <code>ERROR_CRITICAL_INTERNAL = 6;</code>
     */
    public static final int ERROR_CRITICAL_INTERNAL_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The client has exceeded their two factor request quota for this period of
     * time.
     * </pre>
     *
     * <code>ERROR_CUSTOMER_QUOTA_EXHAUSTED = 7;</code>
     */
    public static final int ERROR_CUSTOMER_QUOTA_EXHAUSTED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The request cannot be processed at the time because of an incident. This
     * bypass can be restricted to a problematic destination email domain, a
     * customer, or could affect the entire service.
     * </pre>
     *
     * <code>ERROR_VERIFICATION_BYPASSED = 8;</code>
     */
    public static final int ERROR_VERIFICATION_BYPASSED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * The request parameters do not match with the token provided and cannot be
     * processed.
     * </pre>
     *
     * <code>ERROR_VERDICT_MISMATCH = 9;</code>
     */
    public static final int ERROR_VERDICT_MISMATCH_VALUE = 9;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Result valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Result forNumber(int value) {
      switch (value) {
        case 0:
          return RESULT_UNSPECIFIED;
        case 1:
          return SUCCESS_USER_VERIFIED;
        case 2:
          return ERROR_USER_NOT_VERIFIED;
        case 3:
          return ERROR_SITE_ONBOARDING_INCOMPLETE;
        case 4:
          return ERROR_RECIPIENT_NOT_ALLOWED;
        case 5:
          return ERROR_RECIPIENT_ABUSE_LIMIT_EXHAUSTED;
        case 6:
          return ERROR_CRITICAL_INTERNAL;
        case 7:
          return ERROR_CUSTOMER_QUOTA_EXHAUSTED;
        case 8:
          return ERROR_VERIFICATION_BYPASSED;
        case 9:
          return ERROR_VERDICT_MISMATCH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Result> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Result> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Result>() {
          public Result findValueByNumber(int number) {
            return Result.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.AccountVerificationInfo.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Result[] VALUES = values();

    public static Result valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Result(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.Result)
  }

  public static final int ENDPOINTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.recaptchaenterprise.v1.EndpointVerificationInfo> endpoints_;
  /**
   *
   *
   * <pre>
   * Optional. Endpoints that can be used for identity verification.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.recaptchaenterprise.v1.EndpointVerificationInfo>
      getEndpointsList() {
    return endpoints_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Endpoints that can be used for identity verification.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.recaptchaenterprise.v1.EndpointVerificationInfoOrBuilder>
      getEndpointsOrBuilderList() {
    return endpoints_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Endpoints that can be used for identity verification.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getEndpointsCount() {
    return endpoints_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Endpoints that can be used for identity verification.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.EndpointVerificationInfo getEndpoints(int index) {
    return endpoints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Endpoints that can be used for identity verification.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.EndpointVerificationInfoOrBuilder getEndpointsOrBuilder(
      int index) {
    return endpoints_.get(index);
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Language code preference for the verification message, set as a
   * IETF BCP 47 language code.
   * </pre>
   *
   * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Language code preference for the verification message, set as a
   * IETF BCP 47 language code.
   * </pre>
   *
   * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LATEST_VERIFICATION_RESULT_FIELD_NUMBER = 7;
  private int latestVerificationResult_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Result of the latest account verification challenge.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.Result latest_verification_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for latestVerificationResult.
   */
  @java.lang.Override
  public int getLatestVerificationResultValue() {
    return latestVerificationResult_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Result of the latest account verification challenge.
   * </pre>
   *
   * <code>
   * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.Result latest_verification_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The latestVerificationResult.
   */
  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result
      getLatestVerificationResult() {
    com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result result =
        com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result.forNumber(
            latestVerificationResult_);
    return result == null
        ? com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result.UNRECOGNIZED
        : result;
  }

  public static final int USERNAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object username_ = "";
  /**
   *
   *
   * <pre>
   * Username of the account that is being verified. Deprecated. Customers
   * should now provide the `account_id` field in `event.user_info`.
   * </pre>
   *
   * <code>string username = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.username is deprecated.
   *     See google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=579
   * @return The username.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getUsername() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      username_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Username of the account that is being verified. Deprecated. Customers
   * should now provide the `account_id` field in `event.user_info`.
   * </pre>
   *
   * <code>string username = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.username is deprecated.
   *     See google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=579
   * @return The bytes for username.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getUsernameBytes() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      username_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < endpoints_.size(); i++) {
      output.writeMessage(1, endpoints_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, username_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, languageCode_);
    }
    if (latestVerificationResult_
        != com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result.RESULT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, latestVerificationResult_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < endpoints_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, endpoints_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, username_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, languageCode_);
    }
    if (latestVerificationResult_
        != com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result.RESULT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, latestVerificationResult_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.recaptchaenterprise.v1.AccountVerificationInfo)) {
      return super.equals(obj);
    }
    com.google.recaptchaenterprise.v1.AccountVerificationInfo other =
        (com.google.recaptchaenterprise.v1.AccountVerificationInfo) obj;

    if (!getEndpointsList().equals(other.getEndpointsList())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (latestVerificationResult_ != other.latestVerificationResult_) return false;
    if (!getUsername().equals(other.getUsername())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getEndpointsCount() > 0) {
      hash = (37 * hash) + ENDPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointsList().hashCode();
    }
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + LATEST_VERIFICATION_RESULT_FIELD_NUMBER;
    hash = (53 * hash) + latestVerificationResult_;
    hash = (37 * hash) + USERNAME_FIELD_NUMBER;
    hash = (53 * hash) + getUsername().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.recaptchaenterprise.v1.AccountVerificationInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about account verification, used for identity verification.
   * </pre>
   *
   * Protobuf type {@code google.cloud.recaptchaenterprise.v1.AccountVerificationInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.recaptchaenterprise.v1.AccountVerificationInfo)
      com.google.recaptchaenterprise.v1.AccountVerificationInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_AccountVerificationInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_AccountVerificationInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.recaptchaenterprise.v1.AccountVerificationInfo.class,
              com.google.recaptchaenterprise.v1.AccountVerificationInfo.Builder.class);
    }

    // Construct using com.google.recaptchaenterprise.v1.AccountVerificationInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (endpointsBuilder_ == null) {
        endpoints_ = java.util.Collections.emptyList();
      } else {
        endpoints_ = null;
        endpointsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      languageCode_ = "";
      latestVerificationResult_ = 0;
      username_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.recaptchaenterprise.v1.RecaptchaEnterpriseProto
          .internal_static_google_cloud_recaptchaenterprise_v1_AccountVerificationInfo_descriptor;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.AccountVerificationInfo getDefaultInstanceForType() {
      return com.google.recaptchaenterprise.v1.AccountVerificationInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.AccountVerificationInfo build() {
      com.google.recaptchaenterprise.v1.AccountVerificationInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.recaptchaenterprise.v1.AccountVerificationInfo buildPartial() {
      com.google.recaptchaenterprise.v1.AccountVerificationInfo result =
          new com.google.recaptchaenterprise.v1.AccountVerificationInfo(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.recaptchaenterprise.v1.AccountVerificationInfo result) {
      if (endpointsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          endpoints_ = java.util.Collections.unmodifiableList(endpoints_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.endpoints_ = endpoints_;
      } else {
        result.endpoints_ = endpointsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.recaptchaenterprise.v1.AccountVerificationInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.latestVerificationResult_ = latestVerificationResult_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.username_ = username_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.recaptchaenterprise.v1.AccountVerificationInfo) {
        return mergeFrom((com.google.recaptchaenterprise.v1.AccountVerificationInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.recaptchaenterprise.v1.AccountVerificationInfo other) {
      if (other == com.google.recaptchaenterprise.v1.AccountVerificationInfo.getDefaultInstance())
        return this;
      if (endpointsBuilder_ == null) {
        if (!other.endpoints_.isEmpty()) {
          if (endpoints_.isEmpty()) {
            endpoints_ = other.endpoints_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEndpointsIsMutable();
            endpoints_.addAll(other.endpoints_);
          }
          onChanged();
        }
      } else {
        if (!other.endpoints_.isEmpty()) {
          if (endpointsBuilder_.isEmpty()) {
            endpointsBuilder_.dispose();
            endpointsBuilder_ = null;
            endpoints_ = other.endpoints_;
            bitField0_ = (bitField0_ & ~0x00000001);
            endpointsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEndpointsFieldBuilder()
                    : null;
          } else {
            endpointsBuilder_.addAllMessages(other.endpoints_);
          }
        }
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.latestVerificationResult_ != 0) {
        setLatestVerificationResultValue(other.getLatestVerificationResultValue());
      }
      if (!other.getUsername().isEmpty()) {
        username_ = other.username_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.recaptchaenterprise.v1.EndpointVerificationInfo m =
                    input.readMessage(
                        com.google.recaptchaenterprise.v1.EndpointVerificationInfo.parser(),
                        extensionRegistry);
                if (endpointsBuilder_ == null) {
                  ensureEndpointsIsMutable();
                  endpoints_.add(m);
                } else {
                  endpointsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                username_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 56:
              {
                latestVerificationResult_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.recaptchaenterprise.v1.EndpointVerificationInfo> endpoints_ =
        java.util.Collections.emptyList();

    private void ensureEndpointsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        endpoints_ =
            new java.util.ArrayList<com.google.recaptchaenterprise.v1.EndpointVerificationInfo>(
                endpoints_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1.EndpointVerificationInfo,
            com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder,
            com.google.recaptchaenterprise.v1.EndpointVerificationInfoOrBuilder>
        endpointsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1.EndpointVerificationInfo>
        getEndpointsList() {
      if (endpointsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(endpoints_);
      } else {
        return endpointsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getEndpointsCount() {
      if (endpointsBuilder_ == null) {
        return endpoints_.size();
      } else {
        return endpointsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.EndpointVerificationInfo getEndpoints(int index) {
      if (endpointsBuilder_ == null) {
        return endpoints_.get(index);
      } else {
        return endpointsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndpoints(
        int index, com.google.recaptchaenterprise.v1.EndpointVerificationInfo value) {
      if (endpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.set(index, value);
        onChanged();
      } else {
        endpointsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEndpoints(
        int index,
        com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder builderForValue) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.set(index, builderForValue.build());
        onChanged();
      } else {
        endpointsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addEndpoints(com.google.recaptchaenterprise.v1.EndpointVerificationInfo value) {
      if (endpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.add(value);
        onChanged();
      } else {
        endpointsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addEndpoints(
        int index, com.google.recaptchaenterprise.v1.EndpointVerificationInfo value) {
      if (endpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.add(index, value);
        onChanged();
      } else {
        endpointsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addEndpoints(
        com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder builderForValue) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.add(builderForValue.build());
        onChanged();
      } else {
        endpointsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addEndpoints(
        int index,
        com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder builderForValue) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.add(index, builderForValue.build());
        onChanged();
      } else {
        endpointsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllEndpoints(
        java.lang.Iterable<? extends com.google.recaptchaenterprise.v1.EndpointVerificationInfo>
            values) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, endpoints_);
        onChanged();
      } else {
        endpointsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEndpoints() {
      if (endpointsBuilder_ == null) {
        endpoints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        endpointsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeEndpoints(int index) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.remove(index);
        onChanged();
      } else {
        endpointsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder getEndpointsBuilder(
        int index) {
      return getEndpointsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.EndpointVerificationInfoOrBuilder
        getEndpointsOrBuilder(int index) {
      if (endpointsBuilder_ == null) {
        return endpoints_.get(index);
      } else {
        return endpointsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.recaptchaenterprise.v1.EndpointVerificationInfoOrBuilder>
        getEndpointsOrBuilderList() {
      if (endpointsBuilder_ != null) {
        return endpointsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(endpoints_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder
        addEndpointsBuilder() {
      return getEndpointsFieldBuilder()
          .addBuilder(
              com.google.recaptchaenterprise.v1.EndpointVerificationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder addEndpointsBuilder(
        int index) {
      return getEndpointsFieldBuilder()
          .addBuilder(
              index,
              com.google.recaptchaenterprise.v1.EndpointVerificationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoints that can be used for identity verification.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.recaptchaenterprise.v1.EndpointVerificationInfo endpoints = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder>
        getEndpointsBuilderList() {
      return getEndpointsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.recaptchaenterprise.v1.EndpointVerificationInfo,
            com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder,
            com.google.recaptchaenterprise.v1.EndpointVerificationInfoOrBuilder>
        getEndpointsFieldBuilder() {
      if (endpointsBuilder_ == null) {
        endpointsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.recaptchaenterprise.v1.EndpointVerificationInfo,
                com.google.recaptchaenterprise.v1.EndpointVerificationInfo.Builder,
                com.google.recaptchaenterprise.v1.EndpointVerificationInfoOrBuilder>(
                endpoints_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        endpoints_ = null;
      }
      return endpointsBuilder_;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Language code preference for the verification message, set as a
     * IETF BCP 47 language code.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Language code preference for the verification message, set as a
     * IETF BCP 47 language code.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Language code preference for the verification message, set as a
     * IETF BCP 47 language code.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Language code preference for the verification message, set as a
     * IETF BCP 47 language code.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Language code preference for the verification message, set as a
     * IETF BCP 47 language code.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int latestVerificationResult_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Result of the latest account verification challenge.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.Result latest_verification_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for latestVerificationResult.
     */
    @java.lang.Override
    public int getLatestVerificationResultValue() {
      return latestVerificationResult_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the latest account verification challenge.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.Result latest_verification_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for latestVerificationResult to set.
     * @return This builder for chaining.
     */
    public Builder setLatestVerificationResultValue(int value) {
      latestVerificationResult_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the latest account verification challenge.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.Result latest_verification_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The latestVerificationResult.
     */
    @java.lang.Override
    public com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result
        getLatestVerificationResult() {
      com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result result =
          com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result.forNumber(
              latestVerificationResult_);
      return result == null
          ? com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the latest account verification challenge.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.Result latest_verification_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The latestVerificationResult to set.
     * @return This builder for chaining.
     */
    public Builder setLatestVerificationResult(
        com.google.recaptchaenterprise.v1.AccountVerificationInfo.Result value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      latestVerificationResult_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Result of the latest account verification challenge.
     * </pre>
     *
     * <code>
     * .google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.Result latest_verification_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestVerificationResult() {
      bitField0_ = (bitField0_ & ~0x00000004);
      latestVerificationResult_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object username_ = "";
    /**
     *
     *
     * <pre>
     * Username of the account that is being verified. Deprecated. Customers
     * should now provide the `account_id` field in `event.user_info`.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.username is
     *     deprecated. See google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=579
     * @return The username.
     */
    @java.lang.Deprecated
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Username of the account that is being verified. Deprecated. Customers
     * should now provide the `account_id` field in `event.user_info`.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.username is
     *     deprecated. See google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=579
     * @return The bytes for username.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Username of the account that is being verified. Deprecated. Customers
     * should now provide the `account_id` field in `event.user_info`.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.username is
     *     deprecated. See google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=579
     * @param value The username to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setUsername(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      username_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Username of the account that is being verified. Deprecated. Customers
     * should now provide the `account_id` field in `event.user_info`.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.username is
     *     deprecated. See google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=579
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearUsername() {
      username_ = getDefaultInstance().getUsername();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Username of the account that is being verified. Deprecated. Customers
     * should now provide the `account_id` field in `event.user_info`.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.recaptchaenterprise.v1.AccountVerificationInfo.username is
     *     deprecated. See google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto;l=579
     * @param value The bytes for username to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      username_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.recaptchaenterprise.v1.AccountVerificationInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.recaptchaenterprise.v1.AccountVerificationInfo)
  private static final com.google.recaptchaenterprise.v1.AccountVerificationInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.recaptchaenterprise.v1.AccountVerificationInfo();
  }

  public static com.google.recaptchaenterprise.v1.AccountVerificationInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AccountVerificationInfo> PARSER =
      new com.google.protobuf.AbstractParser<AccountVerificationInfo>() {
        @java.lang.Override
        public AccountVerificationInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AccountVerificationInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AccountVerificationInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.recaptchaenterprise.v1.AccountVerificationInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
