/*
 * Decompiled with CFR 0.152.
 */
package com.google.recaptchaenterprise.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssessmentName
implements ResourceName {
    private static final PathTemplate PROJECT_ASSESSMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/assessments/{assessment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String assessment;

    @Deprecated
    protected AssessmentName() {
        this.project = null;
        this.assessment = null;
    }

    private AssessmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.assessment = (String)Preconditions.checkNotNull((Object)builder.getAssessment());
    }

    public String getProject() {
        return this.project;
    }

    public String getAssessment() {
        return this.assessment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssessmentName of(String project, String assessment) {
        return AssessmentName.newBuilder().setProject(project).setAssessment(assessment).build();
    }

    public static String format(String project, String assessment) {
        return AssessmentName.newBuilder().setProject(project).setAssessment(assessment).build().toString();
    }

    public static AssessmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_ASSESSMENT.validatedMatch(formattedString, "AssessmentName.parse: formattedString not in valid format");
        return AssessmentName.of((String)matchMap.get("project"), (String)matchMap.get("assessment"));
    }

    public static List<AssessmentName> parseList(List<String> formattedStrings) {
        ArrayList<AssessmentName> list = new ArrayList<AssessmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssessmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssessmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssessmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_ASSESSMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssessmentName assessmentName = this;
            synchronized (assessmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.assessment != null) {
                        fieldMapBuilder.put((Object)"assessment", (Object)this.assessment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_ASSESSMENT.instantiate(new String[]{"project", this.project, "assessment", this.assessment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssessmentName that = (AssessmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.assessment, that.assessment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assessment);
    }

    public static class Builder {
        private String project;
        private String assessment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getAssessment() {
            return this.assessment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setAssessment(String assessment) {
            this.assessment = assessment;
            return this;
        }

        private Builder(AssessmentName assessmentName) {
            this.project = assessmentName.project;
            this.assessment = assessmentName.assessment;
        }

        public AssessmentName build() {
            return new AssessmentName(this);
        }
    }
}

