/*
 * Decompiled with CFR 0.152.
 */
package com.google.recaptchaenterprise.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RelatedAccountGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_RELATEDACCOUNTGROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/relatedaccountgroups/{relatedaccountgroup}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String relatedaccountgroup;

    @Deprecated
    protected RelatedAccountGroupName() {
        this.project = null;
        this.relatedaccountgroup = null;
    }

    private RelatedAccountGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.relatedaccountgroup = (String)Preconditions.checkNotNull((Object)builder.getRelatedaccountgroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getRelatedaccountgroup() {
        return this.relatedaccountgroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RelatedAccountGroupName of(String project, String relatedaccountgroup) {
        return RelatedAccountGroupName.newBuilder().setProject(project).setRelatedaccountgroup(relatedaccountgroup).build();
    }

    public static String format(String project, String relatedaccountgroup) {
        return RelatedAccountGroupName.newBuilder().setProject(project).setRelatedaccountgroup(relatedaccountgroup).build().toString();
    }

    public static RelatedAccountGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_RELATEDACCOUNTGROUP.validatedMatch(formattedString, "RelatedAccountGroupName.parse: formattedString not in valid format");
        return RelatedAccountGroupName.of((String)matchMap.get("project"), (String)matchMap.get("relatedaccountgroup"));
    }

    public static List<RelatedAccountGroupName> parseList(List<String> formattedStrings) {
        ArrayList<RelatedAccountGroupName> list = new ArrayList<RelatedAccountGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RelatedAccountGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RelatedAccountGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RelatedAccountGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_RELATEDACCOUNTGROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RelatedAccountGroupName relatedAccountGroupName = this;
            synchronized (relatedAccountGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.relatedaccountgroup != null) {
                        fieldMapBuilder.put((Object)"relatedaccountgroup", (Object)this.relatedaccountgroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_RELATEDACCOUNTGROUP.instantiate(new String[]{"project", this.project, "relatedaccountgroup", this.relatedaccountgroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RelatedAccountGroupName that = (RelatedAccountGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.relatedaccountgroup, that.relatedaccountgroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.relatedaccountgroup);
    }

    public static class Builder {
        private String project;
        private String relatedaccountgroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRelatedaccountgroup() {
            return this.relatedaccountgroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRelatedaccountgroup(String relatedaccountgroup) {
            this.relatedaccountgroup = relatedaccountgroup;
            return this;
        }

        private Builder(RelatedAccountGroupName relatedAccountGroupName) {
            this.project = relatedAccountGroupName.project;
            this.relatedaccountgroup = relatedAccountGroupName.relatedaccountgroup;
        }

        public RelatedAccountGroupName build() {
            return new RelatedAccountGroupName(this);
        }
    }
}

