/*
 * Decompiled with CFR 0.152.
 */
package com.google.recaptchaenterprise.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RelatedAccountGroupMembershipName
implements ResourceName {
    private static final PathTemplate PROJECT_RELATEDACCOUNTGROUP_MEMBERSHIP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/relatedaccountgroups/{relatedaccountgroup}/memberships/{membership}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String relatedaccountgroup;
    private final String membership;

    @Deprecated
    protected RelatedAccountGroupMembershipName() {
        this.project = null;
        this.relatedaccountgroup = null;
        this.membership = null;
    }

    private RelatedAccountGroupMembershipName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.relatedaccountgroup = (String)Preconditions.checkNotNull((Object)builder.getRelatedaccountgroup());
        this.membership = (String)Preconditions.checkNotNull((Object)builder.getMembership());
    }

    public String getProject() {
        return this.project;
    }

    public String getRelatedaccountgroup() {
        return this.relatedaccountgroup;
    }

    public String getMembership() {
        return this.membership;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RelatedAccountGroupMembershipName of(String project, String relatedaccountgroup, String membership) {
        return RelatedAccountGroupMembershipName.newBuilder().setProject(project).setRelatedaccountgroup(relatedaccountgroup).setMembership(membership).build();
    }

    public static String format(String project, String relatedaccountgroup, String membership) {
        return RelatedAccountGroupMembershipName.newBuilder().setProject(project).setRelatedaccountgroup(relatedaccountgroup).setMembership(membership).build().toString();
    }

    public static RelatedAccountGroupMembershipName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_RELATEDACCOUNTGROUP_MEMBERSHIP.validatedMatch(formattedString, "RelatedAccountGroupMembershipName.parse: formattedString not in valid format");
        return RelatedAccountGroupMembershipName.of((String)matchMap.get("project"), (String)matchMap.get("relatedaccountgroup"), (String)matchMap.get("membership"));
    }

    public static List<RelatedAccountGroupMembershipName> parseList(List<String> formattedStrings) {
        ArrayList<RelatedAccountGroupMembershipName> list = new ArrayList<RelatedAccountGroupMembershipName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RelatedAccountGroupMembershipName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RelatedAccountGroupMembershipName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RelatedAccountGroupMembershipName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_RELATEDACCOUNTGROUP_MEMBERSHIP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RelatedAccountGroupMembershipName relatedAccountGroupMembershipName = this;
            synchronized (relatedAccountGroupMembershipName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.relatedaccountgroup != null) {
                        fieldMapBuilder.put((Object)"relatedaccountgroup", (Object)this.relatedaccountgroup);
                    }
                    if (this.membership != null) {
                        fieldMapBuilder.put((Object)"membership", (Object)this.membership);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_RELATEDACCOUNTGROUP_MEMBERSHIP.instantiate(new String[]{"project", this.project, "relatedaccountgroup", this.relatedaccountgroup, "membership", this.membership});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RelatedAccountGroupMembershipName that = (RelatedAccountGroupMembershipName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.relatedaccountgroup, that.relatedaccountgroup) && Objects.equals(this.membership, that.membership);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.relatedaccountgroup);
        h *= 1000003;
        return h ^= Objects.hashCode(this.membership);
    }

    public static class Builder {
        private String project;
        private String relatedaccountgroup;
        private String membership;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getRelatedaccountgroup() {
            return this.relatedaccountgroup;
        }

        public String getMembership() {
            return this.membership;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRelatedaccountgroup(String relatedaccountgroup) {
            this.relatedaccountgroup = relatedaccountgroup;
            return this;
        }

        public Builder setMembership(String membership) {
            this.membership = membership;
            return this;
        }

        private Builder(RelatedAccountGroupMembershipName relatedAccountGroupMembershipName) {
            this.project = relatedAccountGroupMembershipName.project;
            this.relatedaccountgroup = relatedAccountGroupMembershipName.relatedaccountgroup;
            this.membership = relatedAccountGroupMembershipName.membership;
        }

        public RelatedAccountGroupMembershipName build() {
            return new RelatedAccountGroupMembershipName(this);
        }
    }
}

