/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/schema.proto

package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Request for the `ValidateMessage` method.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.ValidateMessageRequest}
 */
public final class ValidateMessageRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.ValidateMessageRequest)
    ValidateMessageRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ValidateMessageRequest.newBuilder() to construct.
  private ValidateMessageRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ValidateMessageRequest() {
    parent_ = "";
    message_ = com.google.protobuf.ByteString.EMPTY;
    encoding_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ValidateMessageRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ValidateMessageRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();
              schemaSpecCase_ = 2;
              schemaSpec_ = s;
              break;
            }
          case 26:
            {
              com.google.pubsub.v1.Schema.Builder subBuilder = null;
              if (schemaSpecCase_ == 3) {
                subBuilder = ((com.google.pubsub.v1.Schema) schemaSpec_).toBuilder();
              }
              schemaSpec_ =
                  input.readMessage(com.google.pubsub.v1.Schema.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.pubsub.v1.Schema) schemaSpec_);
                schemaSpec_ = subBuilder.buildPartial();
              }
              schemaSpecCase_ = 3;
              break;
            }
          case 34:
            {
              message_ = input.readBytes();
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();

              encoding_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.SchemaProto
        .internal_static_google_pubsub_v1_ValidateMessageRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.SchemaProto
        .internal_static_google_pubsub_v1_ValidateMessageRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.ValidateMessageRequest.class,
            com.google.pubsub.v1.ValidateMessageRequest.Builder.class);
  }

  private int schemaSpecCase_ = 0;
  private java.lang.Object schemaSpec_;

  public enum SchemaSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NAME(2),
    SCHEMA(3),
    SCHEMASPEC_NOT_SET(0);
    private final int value;

    private SchemaSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SchemaSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static SchemaSpecCase forNumber(int value) {
      switch (value) {
        case 2:
          return NAME;
        case 3:
          return SCHEMA;
        case 0:
          return SCHEMASPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SchemaSpecCase getSchemaSpecCase() {
    return SchemaSpecCase.forNumber(schemaSpecCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The name of the project in which to validate schemas.
   * Format is `projects/{project-id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the project in which to validate schemas.
   * Format is `projects/{project-id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Name of the schema against which to validate.
   * Format is `projects/{project}/schemas/{schema}`.
   * </pre>
   *
   * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the name field is set.
   */
  public boolean hasName() {
    return schemaSpecCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Name of the schema against which to validate.
   * Format is `projects/{project}/schemas/{schema}`.
   * </pre>
   *
   * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = "";
    if (schemaSpecCase_ == 2) {
      ref = schemaSpec_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (schemaSpecCase_ == 2) {
        schemaSpec_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the schema against which to validate.
   * Format is `projects/{project}/schemas/{schema}`.
   * </pre>
   *
   * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = "";
    if (schemaSpecCase_ == 2) {
      ref = schemaSpec_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (schemaSpecCase_ == 2) {
        schemaSpec_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEMA_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Ad-hoc schema against which to validate
   * </pre>
   *
   * <code>.google.pubsub.v1.Schema schema = 3;</code>
   *
   * @return Whether the schema field is set.
   */
  @java.lang.Override
  public boolean hasSchema() {
    return schemaSpecCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Ad-hoc schema against which to validate
   * </pre>
   *
   * <code>.google.pubsub.v1.Schema schema = 3;</code>
   *
   * @return The schema.
   */
  @java.lang.Override
  public com.google.pubsub.v1.Schema getSchema() {
    if (schemaSpecCase_ == 3) {
      return (com.google.pubsub.v1.Schema) schemaSpec_;
    }
    return com.google.pubsub.v1.Schema.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Ad-hoc schema against which to validate
   * </pre>
   *
   * <code>.google.pubsub.v1.Schema schema = 3;</code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.SchemaOrBuilder getSchemaOrBuilder() {
    if (schemaSpecCase_ == 3) {
      return (com.google.pubsub.v1.Schema) schemaSpec_;
    }
    return com.google.pubsub.v1.Schema.getDefaultInstance();
  }

  public static final int MESSAGE_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString message_;
  /**
   *
   *
   * <pre>
   * Message to validate against the provided `schema_spec`.
   * </pre>
   *
   * <code>bytes message = 4;</code>
   *
   * @return The message.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMessage() {
    return message_;
  }

  public static final int ENCODING_FIELD_NUMBER = 5;
  private int encoding_;
  /**
   *
   *
   * <pre>
   * The encoding expected for messages
   * </pre>
   *
   * <code>.google.pubsub.v1.Encoding encoding = 5;</code>
   *
   * @return The enum numeric value on the wire for encoding.
   */
  @java.lang.Override
  public int getEncodingValue() {
    return encoding_;
  }
  /**
   *
   *
   * <pre>
   * The encoding expected for messages
   * </pre>
   *
   * <code>.google.pubsub.v1.Encoding encoding = 5;</code>
   *
   * @return The encoding.
   */
  @java.lang.Override
  public com.google.pubsub.v1.Encoding getEncoding() {
    @SuppressWarnings("deprecation")
    com.google.pubsub.v1.Encoding result = com.google.pubsub.v1.Encoding.valueOf(encoding_);
    return result == null ? com.google.pubsub.v1.Encoding.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getParentBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (schemaSpecCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, schemaSpec_);
    }
    if (schemaSpecCase_ == 3) {
      output.writeMessage(3, (com.google.pubsub.v1.Schema) schemaSpec_);
    }
    if (!message_.isEmpty()) {
      output.writeBytes(4, message_);
    }
    if (encoding_ != com.google.pubsub.v1.Encoding.ENCODING_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, encoding_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getParentBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (schemaSpecCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, schemaSpec_);
    }
    if (schemaSpecCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.pubsub.v1.Schema) schemaSpec_);
    }
    if (!message_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, message_);
    }
    if (encoding_ != com.google.pubsub.v1.Encoding.ENCODING_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, encoding_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.ValidateMessageRequest)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.ValidateMessageRequest other =
        (com.google.pubsub.v1.ValidateMessageRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getMessage().equals(other.getMessage())) return false;
    if (encoding_ != other.encoding_) return false;
    if (!getSchemaSpecCase().equals(other.getSchemaSpecCase())) return false;
    switch (schemaSpecCase_) {
      case 2:
        if (!getName().equals(other.getName())) return false;
        break;
      case 3:
        if (!getSchema().equals(other.getSchema())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getMessage().hashCode();
    hash = (37 * hash) + ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + encoding_;
    switch (schemaSpecCase_) {
      case 2:
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        break;
      case 3:
        hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getSchema().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.ValidateMessageRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.ValidateMessageRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for the `ValidateMessage` method.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.ValidateMessageRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.ValidateMessageRequest)
      com.google.pubsub.v1.ValidateMessageRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.SchemaProto
          .internal_static_google_pubsub_v1_ValidateMessageRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.SchemaProto
          .internal_static_google_pubsub_v1_ValidateMessageRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.ValidateMessageRequest.class,
              com.google.pubsub.v1.ValidateMessageRequest.Builder.class);
    }

    // Construct using com.google.pubsub.v1.ValidateMessageRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      message_ = com.google.protobuf.ByteString.EMPTY;

      encoding_ = 0;

      schemaSpecCase_ = 0;
      schemaSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.SchemaProto
          .internal_static_google_pubsub_v1_ValidateMessageRequest_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.ValidateMessageRequest getDefaultInstanceForType() {
      return com.google.pubsub.v1.ValidateMessageRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.ValidateMessageRequest build() {
      com.google.pubsub.v1.ValidateMessageRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.ValidateMessageRequest buildPartial() {
      com.google.pubsub.v1.ValidateMessageRequest result =
          new com.google.pubsub.v1.ValidateMessageRequest(this);
      result.parent_ = parent_;
      if (schemaSpecCase_ == 2) {
        result.schemaSpec_ = schemaSpec_;
      }
      if (schemaSpecCase_ == 3) {
        if (schemaBuilder_ == null) {
          result.schemaSpec_ = schemaSpec_;
        } else {
          result.schemaSpec_ = schemaBuilder_.build();
        }
      }
      result.message_ = message_;
      result.encoding_ = encoding_;
      result.schemaSpecCase_ = schemaSpecCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.ValidateMessageRequest) {
        return mergeFrom((com.google.pubsub.v1.ValidateMessageRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.ValidateMessageRequest other) {
      if (other == com.google.pubsub.v1.ValidateMessageRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.getMessage() != com.google.protobuf.ByteString.EMPTY) {
        setMessage(other.getMessage());
      }
      if (other.encoding_ != 0) {
        setEncodingValue(other.getEncodingValue());
      }
      switch (other.getSchemaSpecCase()) {
        case NAME:
          {
            schemaSpecCase_ = 2;
            schemaSpec_ = other.schemaSpec_;
            onChanged();
            break;
          }
        case SCHEMA:
          {
            mergeSchema(other.getSchema());
            break;
          }
        case SCHEMASPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.pubsub.v1.ValidateMessageRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.pubsub.v1.ValidateMessageRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int schemaSpecCase_ = 0;
    private java.lang.Object schemaSpec_;

    public SchemaSpecCase getSchemaSpecCase() {
      return SchemaSpecCase.forNumber(schemaSpecCase_);
    }

    public Builder clearSchemaSpec() {
      schemaSpecCase_ = 0;
      schemaSpec_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to validate schemas.
     * Format is `projects/{project-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to validate schemas.
     * Format is `projects/{project-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to validate schemas.
     * Format is `projects/{project-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to validate schemas.
     * Format is `projects/{project-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the project in which to validate schemas.
     * Format is `projects/{project-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the schema against which to validate.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the name field is set.
     */
    @java.lang.Override
    public boolean hasName() {
      return schemaSpecCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Name of the schema against which to validate.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = "";
      if (schemaSpecCase_ == 2) {
        ref = schemaSpec_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (schemaSpecCase_ == 2) {
          schemaSpec_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the schema against which to validate.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = "";
      if (schemaSpecCase_ == 2) {
        ref = schemaSpec_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (schemaSpecCase_ == 2) {
          schemaSpec_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the schema against which to validate.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      schemaSpecCase_ = 2;
      schemaSpec_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the schema against which to validate.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      if (schemaSpecCase_ == 2) {
        schemaSpecCase_ = 0;
        schemaSpec_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the schema against which to validate.
     * Format is `projects/{project}/schemas/{schema}`.
     * </pre>
     *
     * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      schemaSpecCase_ = 2;
      schemaSpec_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.Schema,
            com.google.pubsub.v1.Schema.Builder,
            com.google.pubsub.v1.SchemaOrBuilder>
        schemaBuilder_;
    /**
     *
     *
     * <pre>
     * Ad-hoc schema against which to validate
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema schema = 3;</code>
     *
     * @return Whether the schema field is set.
     */
    @java.lang.Override
    public boolean hasSchema() {
      return schemaSpecCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Ad-hoc schema against which to validate
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema schema = 3;</code>
     *
     * @return The schema.
     */
    @java.lang.Override
    public com.google.pubsub.v1.Schema getSchema() {
      if (schemaBuilder_ == null) {
        if (schemaSpecCase_ == 3) {
          return (com.google.pubsub.v1.Schema) schemaSpec_;
        }
        return com.google.pubsub.v1.Schema.getDefaultInstance();
      } else {
        if (schemaSpecCase_ == 3) {
          return schemaBuilder_.getMessage();
        }
        return com.google.pubsub.v1.Schema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Ad-hoc schema against which to validate
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema schema = 3;</code>
     */
    public Builder setSchema(com.google.pubsub.v1.Schema value) {
      if (schemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schemaSpec_ = value;
        onChanged();
      } else {
        schemaBuilder_.setMessage(value);
      }
      schemaSpecCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ad-hoc schema against which to validate
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema schema = 3;</code>
     */
    public Builder setSchema(com.google.pubsub.v1.Schema.Builder builderForValue) {
      if (schemaBuilder_ == null) {
        schemaSpec_ = builderForValue.build();
        onChanged();
      } else {
        schemaBuilder_.setMessage(builderForValue.build());
      }
      schemaSpecCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ad-hoc schema against which to validate
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema schema = 3;</code>
     */
    public Builder mergeSchema(com.google.pubsub.v1.Schema value) {
      if (schemaBuilder_ == null) {
        if (schemaSpecCase_ == 3
            && schemaSpec_ != com.google.pubsub.v1.Schema.getDefaultInstance()) {
          schemaSpec_ =
              com.google.pubsub.v1.Schema.newBuilder((com.google.pubsub.v1.Schema) schemaSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schemaSpec_ = value;
        }
        onChanged();
      } else {
        if (schemaSpecCase_ == 3) {
          schemaBuilder_.mergeFrom(value);
        }
        schemaBuilder_.setMessage(value);
      }
      schemaSpecCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ad-hoc schema against which to validate
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema schema = 3;</code>
     */
    public Builder clearSchema() {
      if (schemaBuilder_ == null) {
        if (schemaSpecCase_ == 3) {
          schemaSpecCase_ = 0;
          schemaSpec_ = null;
          onChanged();
        }
      } else {
        if (schemaSpecCase_ == 3) {
          schemaSpecCase_ = 0;
          schemaSpec_ = null;
        }
        schemaBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ad-hoc schema against which to validate
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema schema = 3;</code>
     */
    public com.google.pubsub.v1.Schema.Builder getSchemaBuilder() {
      return getSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Ad-hoc schema against which to validate
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema schema = 3;</code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.SchemaOrBuilder getSchemaOrBuilder() {
      if ((schemaSpecCase_ == 3) && (schemaBuilder_ != null)) {
        return schemaBuilder_.getMessageOrBuilder();
      } else {
        if (schemaSpecCase_ == 3) {
          return (com.google.pubsub.v1.Schema) schemaSpec_;
        }
        return com.google.pubsub.v1.Schema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Ad-hoc schema against which to validate
     * </pre>
     *
     * <code>.google.pubsub.v1.Schema schema = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.Schema,
            com.google.pubsub.v1.Schema.Builder,
            com.google.pubsub.v1.SchemaOrBuilder>
        getSchemaFieldBuilder() {
      if (schemaBuilder_ == null) {
        if (!(schemaSpecCase_ == 3)) {
          schemaSpec_ = com.google.pubsub.v1.Schema.getDefaultInstance();
        }
        schemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.Schema,
                com.google.pubsub.v1.Schema.Builder,
                com.google.pubsub.v1.SchemaOrBuilder>(
                (com.google.pubsub.v1.Schema) schemaSpec_, getParentForChildren(), isClean());
        schemaSpec_ = null;
      }
      schemaSpecCase_ = 3;
      onChanged();
      ;
      return schemaBuilder_;
    }

    private com.google.protobuf.ByteString message_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Message to validate against the provided `schema_spec`.
     * </pre>
     *
     * <code>bytes message = 4;</code>
     *
     * @return The message.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMessage() {
      return message_;
    }
    /**
     *
     *
     * <pre>
     * Message to validate against the provided `schema_spec`.
     * </pre>
     *
     * <code>bytes message = 4;</code>
     *
     * @param value The message to set.
     * @return This builder for chaining.
     */
    public Builder setMessage(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      message_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Message to validate against the provided `schema_spec`.
     * </pre>
     *
     * <code>bytes message = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessage() {

      message_ = getDefaultInstance().getMessage();
      onChanged();
      return this;
    }

    private int encoding_ = 0;
    /**
     *
     *
     * <pre>
     * The encoding expected for messages
     * </pre>
     *
     * <code>.google.pubsub.v1.Encoding encoding = 5;</code>
     *
     * @return The enum numeric value on the wire for encoding.
     */
    @java.lang.Override
    public int getEncodingValue() {
      return encoding_;
    }
    /**
     *
     *
     * <pre>
     * The encoding expected for messages
     * </pre>
     *
     * <code>.google.pubsub.v1.Encoding encoding = 5;</code>
     *
     * @param value The enum numeric value on the wire for encoding to set.
     * @return This builder for chaining.
     */
    public Builder setEncodingValue(int value) {

      encoding_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The encoding expected for messages
     * </pre>
     *
     * <code>.google.pubsub.v1.Encoding encoding = 5;</code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.pubsub.v1.Encoding getEncoding() {
      @SuppressWarnings("deprecation")
      com.google.pubsub.v1.Encoding result = com.google.pubsub.v1.Encoding.valueOf(encoding_);
      return result == null ? com.google.pubsub.v1.Encoding.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The encoding expected for messages
     * </pre>
     *
     * <code>.google.pubsub.v1.Encoding encoding = 5;</code>
     *
     * @param value The encoding to set.
     * @return This builder for chaining.
     */
    public Builder setEncoding(com.google.pubsub.v1.Encoding value) {
      if (value == null) {
        throw new NullPointerException();
      }

      encoding_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The encoding expected for messages
     * </pre>
     *
     * <code>.google.pubsub.v1.Encoding encoding = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncoding() {

      encoding_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.ValidateMessageRequest)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.ValidateMessageRequest)
  private static final com.google.pubsub.v1.ValidateMessageRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.ValidateMessageRequest();
  }

  public static com.google.pubsub.v1.ValidateMessageRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ValidateMessageRequest> PARSER =
      new com.google.protobuf.AbstractParser<ValidateMessageRequest>() {
        @java.lang.Override
        public ValidateMessageRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ValidateMessageRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ValidateMessageRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ValidateMessageRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.ValidateMessageRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
