/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.5
package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * A topic resource.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.Topic}
 */
public final class Topic extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.Topic)
    TopicOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Topic.newBuilder() to construct.
  private Topic(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Topic() {
    name_ = "";
    kmsKeyName_ = "";
    state_ = 0;
    messageTransforms_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Topic();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto.internal_static_google_pubsub_v1_Topic_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_Topic_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.Topic.class, com.google.pubsub.v1.Topic.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of the topic.
   * </pre>
   *
   * Protobuf enum {@code google.pubsub.v1.Topic.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The topic does not have any persistent errors.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * Ingestion from the data source has encountered a permanent error.
     * See the more detailed error state in the corresponding ingestion
     * source configuration.
     * </pre>
     *
     * <code>INGESTION_RESOURCE_ERROR = 2;</code>
     */
    INGESTION_RESOURCE_ERROR(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The topic does not have any persistent errors.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Ingestion from the data source has encountered a permanent error.
     * See the more detailed error state in the corresponding ingestion
     * source configuration.
     * </pre>
     *
     * <code>INGESTION_RESOURCE_ERROR = 2;</code>
     */
    public static final int INGESTION_RESOURCE_ERROR_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return INGESTION_RESOURCE_ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.pubsub.v1.Topic.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.pubsub.v1.Topic.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the topic. It must have the format
   * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
   * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
   * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
   * signs (`%`). It must be between 3 and 255 characters in length, and it
   * must not start with `"goog"`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the topic. It must have the format
   * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
   * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
   * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
   * signs (`%`). It must be between 3 and 255 characters in length, and it
   * must not start with `"goog"`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 2;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.pubsub.v1.PubsubProto
                .internal_static_google_pubsub_v1_Topic_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing labels]
   * (https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing labels]
   * (https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing labels]
   * (https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing labels]
   * (https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MESSAGE_STORAGE_POLICY_FIELD_NUMBER = 3;
  private com.google.pubsub.v1.MessageStoragePolicy messageStoragePolicy_;
  /**
   *
   *
   * <pre>
   * Optional. Policy constraining the set of Google Cloud Platform regions
   * where messages published to the topic may be stored. If not present, then
   * no constraints are in effect.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the messageStoragePolicy field is set.
   */
  @java.lang.Override
  public boolean hasMessageStoragePolicy() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Policy constraining the set of Google Cloud Platform regions
   * where messages published to the topic may be stored. If not present, then
   * no constraints are in effect.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The messageStoragePolicy.
   */
  @java.lang.Override
  public com.google.pubsub.v1.MessageStoragePolicy getMessageStoragePolicy() {
    return messageStoragePolicy_ == null
        ? com.google.pubsub.v1.MessageStoragePolicy.getDefaultInstance()
        : messageStoragePolicy_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Policy constraining the set of Google Cloud Platform regions
   * where messages published to the topic may be stored. If not present, then
   * no constraints are in effect.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.MessageStoragePolicyOrBuilder getMessageStoragePolicyOrBuilder() {
    return messageStoragePolicy_ == null
        ? com.google.pubsub.v1.MessageStoragePolicy.getDefaultInstance()
        : messageStoragePolicy_;
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the Cloud KMS CryptoKey to be used to
   * protect access to messages published on this topic.
   *
   * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
   * </pre>
   *
   * <code>string kms_key_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the Cloud KMS CryptoKey to be used to
   * protect access to messages published on this topic.
   *
   * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
   * </pre>
   *
   * <code>string kms_key_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEMA_SETTINGS_FIELD_NUMBER = 6;
  private com.google.pubsub.v1.SchemaSettings schemaSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Settings for validating messages published against a schema.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the schemaSettings field is set.
   */
  @java.lang.Override
  public boolean hasSchemaSettings() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Settings for validating messages published against a schema.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The schemaSettings.
   */
  @java.lang.Override
  public com.google.pubsub.v1.SchemaSettings getSchemaSettings() {
    return schemaSettings_ == null
        ? com.google.pubsub.v1.SchemaSettings.getDefaultInstance()
        : schemaSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Settings for validating messages published against a schema.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.SchemaSettingsOrBuilder getSchemaSettingsOrBuilder() {
    return schemaSettings_ == null
        ? com.google.pubsub.v1.SchemaSettings.getDefaultInstance()
        : schemaSettings_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 7;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Reserved for future use. This field is set only in responses from
   * the server; it is ignored if it is set in any requests.
   * </pre>
   *
   * <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int MESSAGE_RETENTION_DURATION_FIELD_NUMBER = 8;
  private com.google.protobuf.Duration messageRetentionDuration_;
  /**
   *
   *
   * <pre>
   * Optional. Indicates the minimum duration to retain a message after it is
   * published to the topic. If this field is set, messages published to the
   * topic in the last `message_retention_duration` are always available to
   * subscribers. For instance, it allows any attached subscription to [seek to
   * a
   * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
   * that is up to `message_retention_duration` in the past. If this field is
   * not set, message retention is controlled by settings on individual
   * subscriptions. Cannot be more than 31 days or less than 10 minutes.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the messageRetentionDuration field is set.
   */
  @java.lang.Override
  public boolean hasMessageRetentionDuration() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Indicates the minimum duration to retain a message after it is
   * published to the topic. If this field is set, messages published to the
   * topic in the last `message_retention_duration` are always available to
   * subscribers. For instance, it allows any attached subscription to [seek to
   * a
   * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
   * that is up to `message_retention_duration` in the past. If this field is
   * not set, message retention is controlled by settings on individual
   * subscriptions. Cannot be more than 31 days or less than 10 minutes.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The messageRetentionDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMessageRetentionDuration() {
    return messageRetentionDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : messageRetentionDuration_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Indicates the minimum duration to retain a message after it is
   * published to the topic. If this field is set, messages published to the
   * topic in the last `message_retention_duration` are always available to
   * subscribers. For instance, it allows any attached subscription to [seek to
   * a
   * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
   * that is up to `message_retention_duration` in the past. If this field is
   * not set, message retention is controlled by settings on individual
   * subscriptions. Cannot be more than 31 days or less than 10 minutes.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMessageRetentionDurationOrBuilder() {
    return messageRetentionDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : messageRetentionDuration_;
  }

  public static final int STATE_FIELD_NUMBER = 9;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. An output-only field indicating the state of the topic.
   * </pre>
   *
   * <code>.google.pubsub.v1.Topic.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. An output-only field indicating the state of the topic.
   * </pre>
   *
   * <code>.google.pubsub.v1.Topic.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.pubsub.v1.Topic.State getState() {
    com.google.pubsub.v1.Topic.State result = com.google.pubsub.v1.Topic.State.forNumber(state_);
    return result == null ? com.google.pubsub.v1.Topic.State.UNRECOGNIZED : result;
  }

  public static final int INGESTION_DATA_SOURCE_SETTINGS_FIELD_NUMBER = 10;
  private com.google.pubsub.v1.IngestionDataSourceSettings ingestionDataSourceSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Settings for ingestion from a data source into this topic.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ingestionDataSourceSettings field is set.
   */
  @java.lang.Override
  public boolean hasIngestionDataSourceSettings() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Settings for ingestion from a data source into this topic.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ingestionDataSourceSettings.
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings getIngestionDataSourceSettings() {
    return ingestionDataSourceSettings_ == null
        ? com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance()
        : ingestionDataSourceSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Settings for ingestion from a data source into this topic.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettingsOrBuilder
      getIngestionDataSourceSettingsOrBuilder() {
    return ingestionDataSourceSettings_ == null
        ? com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance()
        : ingestionDataSourceSettings_;
  }

  public static final int MESSAGE_TRANSFORMS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.pubsub.v1.MessageTransform> messageTransforms_;
  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages published to the topic.
   * Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.pubsub.v1.MessageTransform> getMessageTransformsList() {
    return messageTransforms_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages published to the topic.
   * Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.pubsub.v1.MessageTransformOrBuilder>
      getMessageTransformsOrBuilderList() {
    return messageTransforms_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages published to the topic.
   * Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getMessageTransformsCount() {
    return messageTransforms_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages published to the topic.
   * Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.MessageTransform getMessageTransforms(int index) {
    return messageTransforms_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages published to the topic.
   * Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.MessageTransformOrBuilder getMessageTransformsOrBuilder(int index) {
    return messageTransforms_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 2);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getMessageStoragePolicy());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, kmsKeyName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getSchemaSettings());
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(7, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getMessageRetentionDuration());
    }
    if (state_ != com.google.pubsub.v1.Topic.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, state_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getIngestionDataSourceSettings());
    }
    for (int i = 0; i < messageTransforms_.size(); i++) {
      output.writeMessage(13, messageTransforms_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMessageStoragePolicy());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, kmsKeyName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getSchemaSettings());
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getMessageRetentionDuration());
    }
    if (state_ != com.google.pubsub.v1.Topic.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, state_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, getIngestionDataSourceSettings());
    }
    for (int i = 0; i < messageTransforms_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, messageTransforms_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.Topic)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.Topic other = (com.google.pubsub.v1.Topic) obj;

    if (!getName().equals(other.getName())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasMessageStoragePolicy() != other.hasMessageStoragePolicy()) return false;
    if (hasMessageStoragePolicy()) {
      if (!getMessageStoragePolicy().equals(other.getMessageStoragePolicy())) return false;
    }
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (hasSchemaSettings() != other.hasSchemaSettings()) return false;
    if (hasSchemaSettings()) {
      if (!getSchemaSettings().equals(other.getSchemaSettings())) return false;
    }
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (hasMessageRetentionDuration() != other.hasMessageRetentionDuration()) return false;
    if (hasMessageRetentionDuration()) {
      if (!getMessageRetentionDuration().equals(other.getMessageRetentionDuration())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasIngestionDataSourceSettings() != other.hasIngestionDataSourceSettings()) return false;
    if (hasIngestionDataSourceSettings()) {
      if (!getIngestionDataSourceSettings().equals(other.getIngestionDataSourceSettings()))
        return false;
    }
    if (!getMessageTransformsList().equals(other.getMessageTransformsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasMessageStoragePolicy()) {
      hash = (37 * hash) + MESSAGE_STORAGE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getMessageStoragePolicy().hashCode();
    }
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    if (hasSchemaSettings()) {
      hash = (37 * hash) + SCHEMA_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSchemaSettings().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    if (hasMessageRetentionDuration()) {
      hash = (37 * hash) + MESSAGE_RETENTION_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMessageRetentionDuration().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasIngestionDataSourceSettings()) {
      hash = (37 * hash) + INGESTION_DATA_SOURCE_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getIngestionDataSourceSettings().hashCode();
    }
    if (getMessageTransformsCount() > 0) {
      hash = (37 * hash) + MESSAGE_TRANSFORMS_FIELD_NUMBER;
      hash = (53 * hash) + getMessageTransformsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.Topic parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.Topic parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.Topic parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.Topic parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.Topic parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.Topic parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.Topic parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.Topic parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.Topic parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.Topic parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.Topic parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.Topic parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.Topic prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A topic resource.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.Topic}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.Topic)
      com.google.pubsub.v1.TopicOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto.internal_static_google_pubsub_v1_Topic_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_Topic_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.Topic.class, com.google.pubsub.v1.Topic.Builder.class);
    }

    // Construct using com.google.pubsub.v1.Topic.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMessageStoragePolicyFieldBuilder();
        getSchemaSettingsFieldBuilder();
        getMessageRetentionDurationFieldBuilder();
        getIngestionDataSourceSettingsFieldBuilder();
        getMessageTransformsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      internalGetMutableLabels().clear();
      messageStoragePolicy_ = null;
      if (messageStoragePolicyBuilder_ != null) {
        messageStoragePolicyBuilder_.dispose();
        messageStoragePolicyBuilder_ = null;
      }
      kmsKeyName_ = "";
      schemaSettings_ = null;
      if (schemaSettingsBuilder_ != null) {
        schemaSettingsBuilder_.dispose();
        schemaSettingsBuilder_ = null;
      }
      satisfiesPzs_ = false;
      messageRetentionDuration_ = null;
      if (messageRetentionDurationBuilder_ != null) {
        messageRetentionDurationBuilder_.dispose();
        messageRetentionDurationBuilder_ = null;
      }
      state_ = 0;
      ingestionDataSourceSettings_ = null;
      if (ingestionDataSourceSettingsBuilder_ != null) {
        ingestionDataSourceSettingsBuilder_.dispose();
        ingestionDataSourceSettingsBuilder_ = null;
      }
      if (messageTransformsBuilder_ == null) {
        messageTransforms_ = java.util.Collections.emptyList();
      } else {
        messageTransforms_ = null;
        messageTransformsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto.internal_static_google_pubsub_v1_Topic_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.Topic getDefaultInstanceForType() {
      return com.google.pubsub.v1.Topic.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.Topic build() {
      com.google.pubsub.v1.Topic result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.Topic buildPartial() {
      com.google.pubsub.v1.Topic result = new com.google.pubsub.v1.Topic(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.pubsub.v1.Topic result) {
      if (messageTransformsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          messageTransforms_ = java.util.Collections.unmodifiableList(messageTransforms_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.messageTransforms_ = messageTransforms_;
      } else {
        result.messageTransforms_ = messageTransformsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.pubsub.v1.Topic result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.messageStoragePolicy_ =
            messageStoragePolicyBuilder_ == null
                ? messageStoragePolicy_
                : messageStoragePolicyBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.schemaSettings_ =
            schemaSettingsBuilder_ == null ? schemaSettings_ : schemaSettingsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.messageRetentionDuration_ =
            messageRetentionDurationBuilder_ == null
                ? messageRetentionDuration_
                : messageRetentionDurationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.ingestionDataSourceSettings_ =
            ingestionDataSourceSettingsBuilder_ == null
                ? ingestionDataSourceSettings_
                : ingestionDataSourceSettingsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.Topic) {
        return mergeFrom((com.google.pubsub.v1.Topic) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.Topic other) {
      if (other == com.google.pubsub.v1.Topic.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000002;
      if (other.hasMessageStoragePolicy()) {
        mergeMessageStoragePolicy(other.getMessageStoragePolicy());
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasSchemaSettings()) {
        mergeSchemaSettings(other.getSchemaSettings());
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.hasMessageRetentionDuration()) {
        mergeMessageRetentionDuration(other.getMessageRetentionDuration());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasIngestionDataSourceSettings()) {
        mergeIngestionDataSourceSettings(other.getIngestionDataSourceSettings());
      }
      if (messageTransformsBuilder_ == null) {
        if (!other.messageTransforms_.isEmpty()) {
          if (messageTransforms_.isEmpty()) {
            messageTransforms_ = other.messageTransforms_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureMessageTransformsIsMutable();
            messageTransforms_.addAll(other.messageTransforms_);
          }
          onChanged();
        }
      } else {
        if (!other.messageTransforms_.isEmpty()) {
          if (messageTransformsBuilder_.isEmpty()) {
            messageTransformsBuilder_.dispose();
            messageTransformsBuilder_ = null;
            messageTransforms_ = other.messageTransforms_;
            bitField0_ = (bitField0_ & ~0x00000200);
            messageTransformsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMessageTransformsFieldBuilder()
                    : null;
          } else {
            messageTransformsBuilder_.addAllMessages(other.messageTransforms_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getMessageStoragePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getSchemaSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 56:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(
                    getMessageRetentionDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 72:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(
                    getIngestionDataSourceSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 106:
              {
                com.google.pubsub.v1.MessageTransform m =
                    input.readMessage(
                        com.google.pubsub.v1.MessageTransform.parser(), extensionRegistry);
                if (messageTransformsBuilder_ == null) {
                  ensureMessageTransformsIsMutable();
                  messageTransforms_.add(m);
                } else {
                  messageTransformsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the topic. It must have the format
     * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
     * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
     * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
     * signs (`%`). It must be between 3 and 255 characters in length, and it
     * must not start with `"goog"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the topic. It must have the format
     * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
     * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
     * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
     * signs (`%`). It must be between 3 and 255 characters in length, and it
     * must not start with `"goog"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the topic. It must have the format
     * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
     * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
     * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
     * signs (`%`). It must be between 3 and 255 characters in length, and it
     * must not start with `"goog"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the topic. It must have the format
     * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
     * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
     * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
     * signs (`%`). It must be between 3 and 255 characters in length, and it
     * must not start with `"goog"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the topic. It must have the format
     * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
     * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
     * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
     * signs (`%`). It must be between 3 and 255 characters in length, and it
     * must not start with `"goog"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000002;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/pubsub/docs/labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.pubsub.v1.MessageStoragePolicy messageStoragePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.MessageStoragePolicy,
            com.google.pubsub.v1.MessageStoragePolicy.Builder,
            com.google.pubsub.v1.MessageStoragePolicyOrBuilder>
        messageStoragePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the messageStoragePolicy field is set.
     */
    public boolean hasMessageStoragePolicy() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The messageStoragePolicy.
     */
    public com.google.pubsub.v1.MessageStoragePolicy getMessageStoragePolicy() {
      if (messageStoragePolicyBuilder_ == null) {
        return messageStoragePolicy_ == null
            ? com.google.pubsub.v1.MessageStoragePolicy.getDefaultInstance()
            : messageStoragePolicy_;
      } else {
        return messageStoragePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMessageStoragePolicy(com.google.pubsub.v1.MessageStoragePolicy value) {
      if (messageStoragePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        messageStoragePolicy_ = value;
      } else {
        messageStoragePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMessageStoragePolicy(
        com.google.pubsub.v1.MessageStoragePolicy.Builder builderForValue) {
      if (messageStoragePolicyBuilder_ == null) {
        messageStoragePolicy_ = builderForValue.build();
      } else {
        messageStoragePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMessageStoragePolicy(com.google.pubsub.v1.MessageStoragePolicy value) {
      if (messageStoragePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && messageStoragePolicy_ != null
            && messageStoragePolicy_
                != com.google.pubsub.v1.MessageStoragePolicy.getDefaultInstance()) {
          getMessageStoragePolicyBuilder().mergeFrom(value);
        } else {
          messageStoragePolicy_ = value;
        }
      } else {
        messageStoragePolicyBuilder_.mergeFrom(value);
      }
      if (messageStoragePolicy_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMessageStoragePolicy() {
      bitField0_ = (bitField0_ & ~0x00000004);
      messageStoragePolicy_ = null;
      if (messageStoragePolicyBuilder_ != null) {
        messageStoragePolicyBuilder_.dispose();
        messageStoragePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.MessageStoragePolicy.Builder getMessageStoragePolicyBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMessageStoragePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.MessageStoragePolicyOrBuilder getMessageStoragePolicyOrBuilder() {
      if (messageStoragePolicyBuilder_ != null) {
        return messageStoragePolicyBuilder_.getMessageOrBuilder();
      } else {
        return messageStoragePolicy_ == null
            ? com.google.pubsub.v1.MessageStoragePolicy.getDefaultInstance()
            : messageStoragePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.MessageStoragePolicy,
            com.google.pubsub.v1.MessageStoragePolicy.Builder,
            com.google.pubsub.v1.MessageStoragePolicyOrBuilder>
        getMessageStoragePolicyFieldBuilder() {
      if (messageStoragePolicyBuilder_ == null) {
        messageStoragePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.MessageStoragePolicy,
                com.google.pubsub.v1.MessageStoragePolicy.Builder,
                com.google.pubsub.v1.MessageStoragePolicyOrBuilder>(
                getMessageStoragePolicy(), getParentForChildren(), isClean());
        messageStoragePolicy_ = null;
      }
      return messageStoragePolicyBuilder_;
    }

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the Cloud KMS CryptoKey to be used to
     * protect access to messages published on this topic.
     *
     * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string kms_key_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the Cloud KMS CryptoKey to be used to
     * protect access to messages published on this topic.
     *
     * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string kms_key_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the Cloud KMS CryptoKey to be used to
     * protect access to messages published on this topic.
     *
     * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string kms_key_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the Cloud KMS CryptoKey to be used to
     * protect access to messages published on this topic.
     *
     * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string kms_key_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the Cloud KMS CryptoKey to be used to
     * protect access to messages published on this topic.
     *
     * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     * </pre>
     *
     * <code>string kms_key_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.pubsub.v1.SchemaSettings schemaSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.SchemaSettings,
            com.google.pubsub.v1.SchemaSettings.Builder,
            com.google.pubsub.v1.SchemaSettingsOrBuilder>
        schemaSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Settings for validating messages published against a schema.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the schemaSettings field is set.
     */
    public boolean hasSchemaSettings() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for validating messages published against a schema.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The schemaSettings.
     */
    public com.google.pubsub.v1.SchemaSettings getSchemaSettings() {
      if (schemaSettingsBuilder_ == null) {
        return schemaSettings_ == null
            ? com.google.pubsub.v1.SchemaSettings.getDefaultInstance()
            : schemaSettings_;
      } else {
        return schemaSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for validating messages published against a schema.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSchemaSettings(com.google.pubsub.v1.SchemaSettings value) {
      if (schemaSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schemaSettings_ = value;
      } else {
        schemaSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for validating messages published against a schema.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSchemaSettings(com.google.pubsub.v1.SchemaSettings.Builder builderForValue) {
      if (schemaSettingsBuilder_ == null) {
        schemaSettings_ = builderForValue.build();
      } else {
        schemaSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for validating messages published against a schema.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSchemaSettings(com.google.pubsub.v1.SchemaSettings value) {
      if (schemaSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && schemaSettings_ != null
            && schemaSettings_ != com.google.pubsub.v1.SchemaSettings.getDefaultInstance()) {
          getSchemaSettingsBuilder().mergeFrom(value);
        } else {
          schemaSettings_ = value;
        }
      } else {
        schemaSettingsBuilder_.mergeFrom(value);
      }
      if (schemaSettings_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for validating messages published against a schema.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSchemaSettings() {
      bitField0_ = (bitField0_ & ~0x00000010);
      schemaSettings_ = null;
      if (schemaSettingsBuilder_ != null) {
        schemaSettingsBuilder_.dispose();
        schemaSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for validating messages published against a schema.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.SchemaSettings.Builder getSchemaSettingsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSchemaSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for validating messages published against a schema.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.SchemaSettingsOrBuilder getSchemaSettingsOrBuilder() {
      if (schemaSettingsBuilder_ != null) {
        return schemaSettingsBuilder_.getMessageOrBuilder();
      } else {
        return schemaSettings_ == null
            ? com.google.pubsub.v1.SchemaSettings.getDefaultInstance()
            : schemaSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for validating messages published against a schema.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.SchemaSettings,
            com.google.pubsub.v1.SchemaSettings.Builder,
            com.google.pubsub.v1.SchemaSettingsOrBuilder>
        getSchemaSettingsFieldBuilder() {
      if (schemaSettingsBuilder_ == null) {
        schemaSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.SchemaSettings,
                com.google.pubsub.v1.SchemaSettings.Builder,
                com.google.pubsub.v1.SchemaSettingsOrBuilder>(
                getSchemaSettings(), getParentForChildren(), isClean());
        schemaSettings_ = null;
      }
      return schemaSettingsBuilder_;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use. This field is set only in responses from
     * the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use. This field is set only in responses from
     * the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Reserved for future use. This field is set only in responses from
     * the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00000020);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration messageRetentionDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        messageRetentionDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the messageRetentionDuration field is set.
     */
    public boolean hasMessageRetentionDuration() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The messageRetentionDuration.
     */
    public com.google.protobuf.Duration getMessageRetentionDuration() {
      if (messageRetentionDurationBuilder_ == null) {
        return messageRetentionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : messageRetentionDuration_;
      } else {
        return messageRetentionDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMessageRetentionDuration(com.google.protobuf.Duration value) {
      if (messageRetentionDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        messageRetentionDuration_ = value;
      } else {
        messageRetentionDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMessageRetentionDuration(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (messageRetentionDurationBuilder_ == null) {
        messageRetentionDuration_ = builderForValue.build();
      } else {
        messageRetentionDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMessageRetentionDuration(com.google.protobuf.Duration value) {
      if (messageRetentionDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && messageRetentionDuration_ != null
            && messageRetentionDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMessageRetentionDurationBuilder().mergeFrom(value);
        } else {
          messageRetentionDuration_ = value;
        }
      } else {
        messageRetentionDurationBuilder_.mergeFrom(value);
      }
      if (messageRetentionDuration_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMessageRetentionDuration() {
      bitField0_ = (bitField0_ & ~0x00000040);
      messageRetentionDuration_ = null;
      if (messageRetentionDurationBuilder_ != null) {
        messageRetentionDurationBuilder_.dispose();
        messageRetentionDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getMessageRetentionDurationBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getMessageRetentionDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getMessageRetentionDurationOrBuilder() {
      if (messageRetentionDurationBuilder_ != null) {
        return messageRetentionDurationBuilder_.getMessageOrBuilder();
      } else {
        return messageRetentionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : messageRetentionDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMessageRetentionDurationFieldBuilder() {
      if (messageRetentionDurationBuilder_ == null) {
        messageRetentionDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMessageRetentionDuration(), getParentForChildren(), isClean());
        messageRetentionDuration_ = null;
      }
      return messageRetentionDurationBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. An output-only field indicating the state of the topic.
     * </pre>
     *
     * <code>.google.pubsub.v1.Topic.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field indicating the state of the topic.
     * </pre>
     *
     * <code>.google.pubsub.v1.Topic.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field indicating the state of the topic.
     * </pre>
     *
     * <code>.google.pubsub.v1.Topic.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.Topic.State getState() {
      com.google.pubsub.v1.Topic.State result = com.google.pubsub.v1.Topic.State.forNumber(state_);
      return result == null ? com.google.pubsub.v1.Topic.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field indicating the state of the topic.
     * </pre>
     *
     * <code>.google.pubsub.v1.Topic.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.pubsub.v1.Topic.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field indicating the state of the topic.
     * </pre>
     *
     * <code>.google.pubsub.v1.Topic.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.pubsub.v1.IngestionDataSourceSettings ingestionDataSourceSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings,
            com.google.pubsub.v1.IngestionDataSourceSettings.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettingsOrBuilder>
        ingestionDataSourceSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Settings for ingestion from a data source into this topic.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ingestionDataSourceSettings field is set.
     */
    public boolean hasIngestionDataSourceSettings() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for ingestion from a data source into this topic.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ingestionDataSourceSettings.
     */
    public com.google.pubsub.v1.IngestionDataSourceSettings getIngestionDataSourceSettings() {
      if (ingestionDataSourceSettingsBuilder_ == null) {
        return ingestionDataSourceSettings_ == null
            ? com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance()
            : ingestionDataSourceSettings_;
      } else {
        return ingestionDataSourceSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for ingestion from a data source into this topic.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIngestionDataSourceSettings(
        com.google.pubsub.v1.IngestionDataSourceSettings value) {
      if (ingestionDataSourceSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ingestionDataSourceSettings_ = value;
      } else {
        ingestionDataSourceSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for ingestion from a data source into this topic.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIngestionDataSourceSettings(
        com.google.pubsub.v1.IngestionDataSourceSettings.Builder builderForValue) {
      if (ingestionDataSourceSettingsBuilder_ == null) {
        ingestionDataSourceSettings_ = builderForValue.build();
      } else {
        ingestionDataSourceSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for ingestion from a data source into this topic.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeIngestionDataSourceSettings(
        com.google.pubsub.v1.IngestionDataSourceSettings value) {
      if (ingestionDataSourceSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && ingestionDataSourceSettings_ != null
            && ingestionDataSourceSettings_
                != com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance()) {
          getIngestionDataSourceSettingsBuilder().mergeFrom(value);
        } else {
          ingestionDataSourceSettings_ = value;
        }
      } else {
        ingestionDataSourceSettingsBuilder_.mergeFrom(value);
      }
      if (ingestionDataSourceSettings_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for ingestion from a data source into this topic.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearIngestionDataSourceSettings() {
      bitField0_ = (bitField0_ & ~0x00000100);
      ingestionDataSourceSettings_ = null;
      if (ingestionDataSourceSettingsBuilder_ != null) {
        ingestionDataSourceSettingsBuilder_.dispose();
        ingestionDataSourceSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for ingestion from a data source into this topic.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionDataSourceSettings.Builder
        getIngestionDataSourceSettingsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getIngestionDataSourceSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for ingestion from a data source into this topic.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionDataSourceSettingsOrBuilder
        getIngestionDataSourceSettingsOrBuilder() {
      if (ingestionDataSourceSettingsBuilder_ != null) {
        return ingestionDataSourceSettingsBuilder_.getMessageOrBuilder();
      } else {
        return ingestionDataSourceSettings_ == null
            ? com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance()
            : ingestionDataSourceSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Settings for ingestion from a data source into this topic.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings,
            com.google.pubsub.v1.IngestionDataSourceSettings.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettingsOrBuilder>
        getIngestionDataSourceSettingsFieldBuilder() {
      if (ingestionDataSourceSettingsBuilder_ == null) {
        ingestionDataSourceSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.IngestionDataSourceSettings,
                com.google.pubsub.v1.IngestionDataSourceSettings.Builder,
                com.google.pubsub.v1.IngestionDataSourceSettingsOrBuilder>(
                getIngestionDataSourceSettings(), getParentForChildren(), isClean());
        ingestionDataSourceSettings_ = null;
      }
      return ingestionDataSourceSettingsBuilder_;
    }

    private java.util.List<com.google.pubsub.v1.MessageTransform> messageTransforms_ =
        java.util.Collections.emptyList();

    private void ensureMessageTransformsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        messageTransforms_ =
            new java.util.ArrayList<com.google.pubsub.v1.MessageTransform>(messageTransforms_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.pubsub.v1.MessageTransform,
            com.google.pubsub.v1.MessageTransform.Builder,
            com.google.pubsub.v1.MessageTransformOrBuilder>
        messageTransformsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.pubsub.v1.MessageTransform> getMessageTransformsList() {
      if (messageTransformsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(messageTransforms_);
      } else {
        return messageTransformsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getMessageTransformsCount() {
      if (messageTransformsBuilder_ == null) {
        return messageTransforms_.size();
      } else {
        return messageTransformsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.MessageTransform getMessageTransforms(int index) {
      if (messageTransformsBuilder_ == null) {
        return messageTransforms_.get(index);
      } else {
        return messageTransformsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMessageTransforms(int index, com.google.pubsub.v1.MessageTransform value) {
      if (messageTransformsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessageTransformsIsMutable();
        messageTransforms_.set(index, value);
        onChanged();
      } else {
        messageTransformsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMessageTransforms(
        int index, com.google.pubsub.v1.MessageTransform.Builder builderForValue) {
      if (messageTransformsBuilder_ == null) {
        ensureMessageTransformsIsMutable();
        messageTransforms_.set(index, builderForValue.build());
        onChanged();
      } else {
        messageTransformsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMessageTransforms(com.google.pubsub.v1.MessageTransform value) {
      if (messageTransformsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessageTransformsIsMutable();
        messageTransforms_.add(value);
        onChanged();
      } else {
        messageTransformsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMessageTransforms(int index, com.google.pubsub.v1.MessageTransform value) {
      if (messageTransformsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessageTransformsIsMutable();
        messageTransforms_.add(index, value);
        onChanged();
      } else {
        messageTransformsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMessageTransforms(
        com.google.pubsub.v1.MessageTransform.Builder builderForValue) {
      if (messageTransformsBuilder_ == null) {
        ensureMessageTransformsIsMutable();
        messageTransforms_.add(builderForValue.build());
        onChanged();
      } else {
        messageTransformsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMessageTransforms(
        int index, com.google.pubsub.v1.MessageTransform.Builder builderForValue) {
      if (messageTransformsBuilder_ == null) {
        ensureMessageTransformsIsMutable();
        messageTransforms_.add(index, builderForValue.build());
        onChanged();
      } else {
        messageTransformsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllMessageTransforms(
        java.lang.Iterable<? extends com.google.pubsub.v1.MessageTransform> values) {
      if (messageTransformsBuilder_ == null) {
        ensureMessageTransformsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, messageTransforms_);
        onChanged();
      } else {
        messageTransformsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMessageTransforms() {
      if (messageTransformsBuilder_ == null) {
        messageTransforms_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        messageTransformsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeMessageTransforms(int index) {
      if (messageTransformsBuilder_ == null) {
        ensureMessageTransformsIsMutable();
        messageTransforms_.remove(index);
        onChanged();
      } else {
        messageTransformsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.MessageTransform.Builder getMessageTransformsBuilder(int index) {
      return getMessageTransformsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.MessageTransformOrBuilder getMessageTransformsOrBuilder(int index) {
      if (messageTransformsBuilder_ == null) {
        return messageTransforms_.get(index);
      } else {
        return messageTransformsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.pubsub.v1.MessageTransformOrBuilder>
        getMessageTransformsOrBuilderList() {
      if (messageTransformsBuilder_ != null) {
        return messageTransformsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(messageTransforms_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.MessageTransform.Builder addMessageTransformsBuilder() {
      return getMessageTransformsFieldBuilder()
          .addBuilder(com.google.pubsub.v1.MessageTransform.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.MessageTransform.Builder addMessageTransformsBuilder(int index) {
      return getMessageTransformsFieldBuilder()
          .addBuilder(index, com.google.pubsub.v1.MessageTransform.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     * </pre>
     *
     * <code>
     * repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.pubsub.v1.MessageTransform.Builder>
        getMessageTransformsBuilderList() {
      return getMessageTransformsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.pubsub.v1.MessageTransform,
            com.google.pubsub.v1.MessageTransform.Builder,
            com.google.pubsub.v1.MessageTransformOrBuilder>
        getMessageTransformsFieldBuilder() {
      if (messageTransformsBuilder_ == null) {
        messageTransformsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.pubsub.v1.MessageTransform,
                com.google.pubsub.v1.MessageTransform.Builder,
                com.google.pubsub.v1.MessageTransformOrBuilder>(
                messageTransforms_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        messageTransforms_ = null;
      }
      return messageTransformsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.Topic)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.Topic)
  private static final com.google.pubsub.v1.Topic DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.Topic();
  }

  public static com.google.pubsub.v1.Topic getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Topic> PARSER =
      new com.google.protobuf.AbstractParser<Topic>() {
        @java.lang.Override
        public Topic parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Topic> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Topic> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.Topic getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
