/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.5
package com.google.pubsub.v1;

public interface SubscriptionOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.pubsub.v1.Subscription)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the subscription. It must have the format
   * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
   * start with a letter, and contain only letters (`[A-Za-z]`), numbers
   * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
   * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
   * in length, and it must not start with `"goog"`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The name of the subscription. It must have the format
   * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
   * start with a letter, and contain only letters (`[A-Za-z]`), numbers
   * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
   * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
   * in length, and it must not start with `"goog"`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The name of the topic from which this subscription is receiving
   * messages. Format is `projects/{project}/topics/{topic}`. The value of this
   * field will be `_deleted-topic_` if the topic has been deleted.
   * </pre>
   *
   * <code>
   * string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The topic.
   */
  java.lang.String getTopic();
  /**
   *
   *
   * <pre>
   * Required. The name of the topic from which this subscription is receiving
   * messages. Format is `projects/{project}/topics/{topic}`. The value of this
   * field will be `_deleted-topic_` if the topic has been deleted.
   * </pre>
   *
   * <code>
   * string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for topic.
   */
  com.google.protobuf.ByteString getTopicBytes();

  /**
   *
   *
   * <pre>
   * Optional. If push delivery is used with this subscription, this field is
   * used to configure it.
   * </pre>
   *
   * <code>.google.pubsub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the pushConfig field is set.
   */
  boolean hasPushConfig();
  /**
   *
   *
   * <pre>
   * Optional. If push delivery is used with this subscription, this field is
   * used to configure it.
   * </pre>
   *
   * <code>.google.pubsub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The pushConfig.
   */
  com.google.pubsub.v1.PushConfig getPushConfig();
  /**
   *
   *
   * <pre>
   * Optional. If push delivery is used with this subscription, this field is
   * used to configure it.
   * </pre>
   *
   * <code>.google.pubsub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.pubsub.v1.PushConfigOrBuilder getPushConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. If delivery to BigQuery is used with this subscription, this
   * field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the bigqueryConfig field is set.
   */
  boolean hasBigqueryConfig();
  /**
   *
   *
   * <pre>
   * Optional. If delivery to BigQuery is used with this subscription, this
   * field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bigqueryConfig.
   */
  com.google.pubsub.v1.BigQueryConfig getBigqueryConfig();
  /**
   *
   *
   * <pre>
   * Optional. If delivery to BigQuery is used with this subscription, this
   * field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.pubsub.v1.BigQueryConfigOrBuilder getBigqueryConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. If delivery to Google Cloud Storage is used with this
   * subscription, this field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the cloudStorageConfig field is set.
   */
  boolean hasCloudStorageConfig();
  /**
   *
   *
   * <pre>
   * Optional. If delivery to Google Cloud Storage is used with this
   * subscription, this field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The cloudStorageConfig.
   */
  com.google.pubsub.v1.CloudStorageConfig getCloudStorageConfig();
  /**
   *
   *
   * <pre>
   * Optional. If delivery to Google Cloud Storage is used with this
   * subscription, this field is used to configure it.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.pubsub.v1.CloudStorageConfigOrBuilder getCloudStorageConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
   * waits for the subscriber to acknowledge receipt before resending the
   * message. In the interval after the message is delivered and before it is
   * acknowledged, it is considered to be _outstanding_. During that time
   * period, the message will not be redelivered (on a best-effort basis).
   *
   * For pull subscriptions, this value is used as the initial value for the ack
   * deadline. To override this value for a given message, call
   * `ModifyAckDeadline` with the corresponding `ack_id` if using
   * non-streaming pull or send the `ack_id` in a
   * `StreamingModifyAckDeadlineRequest` if using streaming pull.
   * The minimum custom deadline you can specify is 10 seconds.
   * The maximum custom deadline you can specify is 600 seconds (10 minutes).
   * If this parameter is 0, a default value of 10 seconds is used.
   *
   * For push delivery, this value is also used to set the request timeout for
   * the call to the push endpoint.
   *
   * If the subscriber never acknowledges the message, the Pub/Sub
   * system will eventually redeliver the message.
   * </pre>
   *
   * <code>int32 ack_deadline_seconds = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The ackDeadlineSeconds.
   */
  int getAckDeadlineSeconds();

  /**
   *
   *
   * <pre>
   * Optional. Indicates whether to retain acknowledged messages. If true, then
   * messages are not expunged from the subscription's backlog, even if they are
   * acknowledged, until they fall out of the `message_retention_duration`
   * window. This must be true if you would like to [`Seek` to a timestamp]
   * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
   * the past to replay previously-acknowledged messages.
   * </pre>
   *
   * <code>bool retain_acked_messages = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The retainAckedMessages.
   */
  boolean getRetainAckedMessages();

  /**
   *
   *
   * <pre>
   * Optional. How long to retain unacknowledged messages in the subscription's
   * backlog, from the moment a message is published. If `retain_acked_messages`
   * is true, then this also configures the retention of acknowledged messages,
   * and thus configures how far back in time a `Seek` can be done. Defaults to
   * 7 days. Cannot be more than 31 days or less than 10 minutes.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the messageRetentionDuration field is set.
   */
  boolean hasMessageRetentionDuration();
  /**
   *
   *
   * <pre>
   * Optional. How long to retain unacknowledged messages in the subscription's
   * backlog, from the moment a message is published. If `retain_acked_messages`
   * is true, then this also configures the retention of acknowledged messages,
   * and thus configures how far back in time a `Seek` can be done. Defaults to
   * 7 days. Cannot be more than 31 days or less than 10 minutes.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The messageRetentionDuration.
   */
  com.google.protobuf.Duration getMessageRetentionDuration();
  /**
   *
   *
   * <pre>
   * Optional. How long to retain unacknowledged messages in the subscription's
   * backlog, from the moment a message is published. If `retain_acked_messages`
   * is true, then this also configures the retention of acknowledged messages,
   * and thus configures how far back in time a `Seek` can be done. Defaults to
   * 7 days. Cannot be more than 31 days or less than 10 minutes.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.DurationOrBuilder getMessageRetentionDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing
   * labels](https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing
   * labels](https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing
   * labels](https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing
   * labels](https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. See [Creating and managing
   * labels](https://cloud.google.com/pubsub/docs/labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. If true, messages published with the same `ordering_key` in
   * `PubsubMessage` will be delivered to the subscribers in the order in which
   * they are received by the Pub/Sub system. Otherwise, they may be delivered
   * in any order.
   * </pre>
   *
   * <code>bool enable_message_ordering = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableMessageOrdering.
   */
  boolean getEnableMessageOrdering();

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for this subscription's
   * expiration. A subscription is considered active as long as any connected
   * subscriber is successfully consuming messages from the subscription or is
   * issuing operations on the subscription. If `expiration_policy` is not set,
   * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
   * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
   * but `expiration_policy.ttl` is not set, the subscription never expires.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the expirationPolicy field is set.
   */
  boolean hasExpirationPolicy();
  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for this subscription's
   * expiration. A subscription is considered active as long as any connected
   * subscriber is successfully consuming messages from the subscription or is
   * issuing operations on the subscription. If `expiration_policy` is not set,
   * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
   * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
   * but `expiration_policy.ttl` is not set, the subscription never expires.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The expirationPolicy.
   */
  com.google.pubsub.v1.ExpirationPolicy getExpirationPolicy();
  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for this subscription's
   * expiration. A subscription is considered active as long as any connected
   * subscriber is successfully consuming messages from the subscription or is
   * issuing operations on the subscription. If `expiration_policy` is not set,
   * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
   * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
   * but `expiration_policy.ttl` is not set, the subscription never expires.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.pubsub.v1.ExpirationPolicyOrBuilder getExpirationPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. An expression written in the Pub/Sub [filter
   * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
   * then only `PubsubMessage`s whose `attributes` field matches the filter are
   * delivered on this subscription. If empty, then no messages are filtered
   * out.
   * </pre>
   *
   * <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();
  /**
   *
   *
   * <pre>
   * Optional. An expression written in the Pub/Sub [filter
   * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
   * then only `PubsubMessage`s whose `attributes` field matches the filter are
   * delivered on this subscription. If empty, then no messages are filtered
   * out.
   * </pre>
   *
   * <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for dead lettering
   * messages in this subscription. If dead_letter_policy is not set, dead
   * lettering is disabled.
   *
   * The Pub/Sub service account associated with this subscriptions's
   * parent project (i.e.,
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
   * permission to Acknowledge() messages on this subscription.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the deadLetterPolicy field is set.
   */
  boolean hasDeadLetterPolicy();
  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for dead lettering
   * messages in this subscription. If dead_letter_policy is not set, dead
   * lettering is disabled.
   *
   * The Pub/Sub service account associated with this subscriptions's
   * parent project (i.e.,
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
   * permission to Acknowledge() messages on this subscription.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The deadLetterPolicy.
   */
  com.google.pubsub.v1.DeadLetterPolicy getDeadLetterPolicy();
  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies the conditions for dead lettering
   * messages in this subscription. If dead_letter_policy is not set, dead
   * lettering is disabled.
   *
   * The Pub/Sub service account associated with this subscriptions's
   * parent project (i.e.,
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
   * permission to Acknowledge() messages on this subscription.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.pubsub.v1.DeadLetterPolicyOrBuilder getDeadLetterPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies how Pub/Sub retries message delivery for
   * this subscription.
   *
   * If not set, the default retry policy is applied. This generally implies
   * that messages will be retried as soon as possible for healthy subscribers.
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline
   * exceeded events for a given message.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the retryPolicy field is set.
   */
  boolean hasRetryPolicy();
  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies how Pub/Sub retries message delivery for
   * this subscription.
   *
   * If not set, the default retry policy is applied. This generally implies
   * that messages will be retried as soon as possible for healthy subscribers.
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline
   * exceeded events for a given message.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The retryPolicy.
   */
  com.google.pubsub.v1.RetryPolicy getRetryPolicy();
  /**
   *
   *
   * <pre>
   * Optional. A policy that specifies how Pub/Sub retries message delivery for
   * this subscription.
   *
   * If not set, the default retry policy is applied. This generally implies
   * that messages will be retried as soon as possible for healthy subscribers.
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline
   * exceeded events for a given message.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.pubsub.v1.RetryPolicyOrBuilder getRetryPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Indicates whether the subscription is detached from its topic.
   * Detached subscriptions don't receive messages from their topic and don't
   * retain any backlog. `Pull` and `StreamingPull` requests will return
   * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
   * the endpoint will not be made.
   * </pre>
   *
   * <code>bool detached = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The detached.
   */
  boolean getDetached();

  /**
   *
   *
   * <pre>
   * Optional. If true, Pub/Sub provides the following guarantees for the
   * delivery of a message with a given value of `message_id` on this
   * subscription:
   *
   * * The message sent to a subscriber is guaranteed not to be resent
   * before the message's acknowledgement deadline expires.
   * * An acknowledged message will not be resent to a subscriber.
   *
   * Note that subscribers may still receive multiple copies of a message
   * when `enable_exactly_once_delivery` is true if the message was published
   * multiple times by a publisher client. These copies are  considered distinct
   * by Pub/Sub and have distinct `message_id` values.
   * </pre>
   *
   * <code>bool enable_exactly_once_delivery = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableExactlyOnceDelivery.
   */
  boolean getEnableExactlyOnceDelivery();

  /**
   *
   *
   * <pre>
   * Output only. Indicates the minimum duration for which a message is retained
   * after it is published to the subscription's topic. If this field is set,
   * messages published to the subscription's topic in the last
   * `topic_message_retention_duration` are always available to subscribers. See
   * the `message_retention_duration` field in `Topic`. This field is set only
   * in responses from the server; it is ignored if it is set in any requests.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the topicMessageRetentionDuration field is set.
   */
  boolean hasTopicMessageRetentionDuration();
  /**
   *
   *
   * <pre>
   * Output only. Indicates the minimum duration for which a message is retained
   * after it is published to the subscription's topic. If this field is set,
   * messages published to the subscription's topic in the last
   * `topic_message_retention_duration` are always available to subscribers. See
   * the `message_retention_duration` field in `Topic`. This field is set only
   * in responses from the server; it is ignored if it is set in any requests.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The topicMessageRetentionDuration.
   */
  com.google.protobuf.Duration getTopicMessageRetentionDuration();
  /**
   *
   *
   * <pre>
   * Output only. Indicates the minimum duration for which a message is retained
   * after it is published to the subscription's topic. If this field is set,
   * messages published to the subscription's topic in the last
   * `topic_message_retention_duration` are always available to subscribers. See
   * the `message_retention_duration` field in `Topic`. This field is set only
   * in responses from the server; it is ignored if it is set in any requests.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.DurationOrBuilder getTopicMessageRetentionDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. An output-only field indicating whether or not the
   * subscription can receive messages.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. An output-only field indicating whether or not the
   * subscription can receive messages.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.pubsub.v1.Subscription.State getState();

  /**
   *
   *
   * <pre>
   * Output only. Information about the associated Analytics Hub subscription.
   * Only set if the subscritpion is created by Analytics Hub.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo analytics_hub_subscription_info = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the analyticsHubSubscriptionInfo field is set.
   */
  boolean hasAnalyticsHubSubscriptionInfo();
  /**
   *
   *
   * <pre>
   * Output only. Information about the associated Analytics Hub subscription.
   * Only set if the subscritpion is created by Analytics Hub.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo analytics_hub_subscription_info = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The analyticsHubSubscriptionInfo.
   */
  com.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo getAnalyticsHubSubscriptionInfo();
  /**
   *
   *
   * <pre>
   * Output only. Information about the associated Analytics Hub subscription.
   * Only set if the subscritpion is created by Analytics Hub.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo analytics_hub_subscription_info = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfoOrBuilder
      getAnalyticsHubSubscriptionInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages before they are delivered to
   * subscribers. Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.pubsub.v1.MessageTransform> getMessageTransformsList();
  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages before they are delivered to
   * subscribers. Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.pubsub.v1.MessageTransform getMessageTransforms(int index);
  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages before they are delivered to
   * subscribers. Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getMessageTransformsCount();
  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages before they are delivered to
   * subscribers. Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.pubsub.v1.MessageTransformOrBuilder>
      getMessageTransformsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Optional. Transforms to be applied to messages before they are delivered to
   * subscribers. Transforms are applied in the order specified.
   * </pre>
   *
   * <code>
   * repeated .google.pubsub.v1.MessageTransform message_transforms = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.pubsub.v1.MessageTransformOrBuilder getMessageTransformsOrBuilder(int index);
}
