/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.5
package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Configuration for a push delivery endpoint.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.PushConfig}
 */
public final class PushConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.PushConfig)
    PushConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PushConfig.newBuilder() to construct.
  private PushConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PushConfig() {
    pushEndpoint_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PushConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto.internal_static_google_pubsub_v1_PushConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_PushConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.PushConfig.class, com.google.pubsub.v1.PushConfig.Builder.class);
  }

  public interface OidcTokenOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.PushConfig.OidcToken)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. [Service account
     * email](https://cloud.google.com/iam/docs/service-accounts)
     * used for generating the OIDC token. For more information
     * on setting up authentication, see
     * [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
     * </pre>
     *
     * <code>string service_account_email = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccountEmail.
     */
    java.lang.String getServiceAccountEmail();
    /**
     *
     *
     * <pre>
     * Optional. [Service account
     * email](https://cloud.google.com/iam/docs/service-accounts)
     * used for generating the OIDC token. For more information
     * on setting up authentication, see
     * [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
     * </pre>
     *
     * <code>string service_account_email = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccountEmail.
     */
    com.google.protobuf.ByteString getServiceAccountEmailBytes();

    /**
     *
     *
     * <pre>
     * Optional. Audience to be used when generating OIDC token. The audience
     * claim identifies the recipients that the JWT is intended for. The
     * audience value is a single case-sensitive string. Having multiple values
     * (array) for the audience field is not supported. More info about the OIDC
     * JWT token audience here:
     * https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
     * the Push endpoint URL will be used.
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The audience.
     */
    java.lang.String getAudience();
    /**
     *
     *
     * <pre>
     * Optional. Audience to be used when generating OIDC token. The audience
     * claim identifies the recipients that the JWT is intended for. The
     * audience value is a single case-sensitive string. Having multiple values
     * (array) for the audience field is not supported. More info about the OIDC
     * JWT token audience here:
     * https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
     * the Push endpoint URL will be used.
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for audience.
     */
    com.google.protobuf.ByteString getAudienceBytes();
  }
  /**
   *
   *
   * <pre>
   * Contains information needed for generating an
   * [OpenID Connect
   * token](https://developers.google.com/identity/protocols/OpenIDConnect).
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.PushConfig.OidcToken}
   */
  public static final class OidcToken extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.PushConfig.OidcToken)
      OidcTokenOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use OidcToken.newBuilder() to construct.
    private OidcToken(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private OidcToken() {
      serviceAccountEmail_ = "";
      audience_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new OidcToken();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_PushConfig_OidcToken_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_PushConfig_OidcToken_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.PushConfig.OidcToken.class,
              com.google.pubsub.v1.PushConfig.OidcToken.Builder.class);
    }

    public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serviceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * Optional. [Service account
     * email](https://cloud.google.com/iam/docs/service-accounts)
     * used for generating the OIDC token. For more information
     * on setting up authentication, see
     * [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
     * </pre>
     *
     * <code>string service_account_email = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccountEmail.
     */
    @java.lang.Override
    public java.lang.String getServiceAccountEmail() {
      java.lang.Object ref = serviceAccountEmail_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountEmail_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. [Service account
     * email](https://cloud.google.com/iam/docs/service-accounts)
     * used for generating the OIDC token. For more information
     * on setting up authentication, see
     * [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
     * </pre>
     *
     * <code>string service_account_email = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccountEmail.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
      java.lang.Object ref = serviceAccountEmail_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AUDIENCE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object audience_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Audience to be used when generating OIDC token. The audience
     * claim identifies the recipients that the JWT is intended for. The
     * audience value is a single case-sensitive string. Having multiple values
     * (array) for the audience field is not supported. More info about the OIDC
     * JWT token audience here:
     * https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
     * the Push endpoint URL will be used.
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The audience.
     */
    @java.lang.Override
    public java.lang.String getAudience() {
      java.lang.Object ref = audience_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audience_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Audience to be used when generating OIDC token. The audience
     * claim identifies the recipients that the JWT is intended for. The
     * audience value is a single case-sensitive string. Having multiple values
     * (array) for the audience field is not supported. More info about the OIDC
     * JWT token audience here:
     * https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
     * the Push endpoint URL will be used.
     * </pre>
     *
     * <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for audience.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAudienceBytes() {
      java.lang.Object ref = audience_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audience_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serviceAccountEmail_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, audience_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serviceAccountEmail_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audience_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, audience_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.PushConfig.OidcToken)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.PushConfig.OidcToken other =
          (com.google.pubsub.v1.PushConfig.OidcToken) obj;

      if (!getServiceAccountEmail().equals(other.getServiceAccountEmail())) return false;
      if (!getAudience().equals(other.getAudience())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountEmail().hashCode();
      hash = (37 * hash) + AUDIENCE_FIELD_NUMBER;
      hash = (53 * hash) + getAudience().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.pubsub.v1.PushConfig.OidcToken prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains information needed for generating an
     * [OpenID Connect
     * token](https://developers.google.com/identity/protocols/OpenIDConnect).
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.PushConfig.OidcToken}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.PushConfig.OidcToken)
        com.google.pubsub.v1.PushConfig.OidcTokenOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_PushConfig_OidcToken_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_PushConfig_OidcToken_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.PushConfig.OidcToken.class,
                com.google.pubsub.v1.PushConfig.OidcToken.Builder.class);
      }

      // Construct using com.google.pubsub.v1.PushConfig.OidcToken.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        serviceAccountEmail_ = "";
        audience_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_PushConfig_OidcToken_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.PushConfig.OidcToken getDefaultInstanceForType() {
        return com.google.pubsub.v1.PushConfig.OidcToken.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.PushConfig.OidcToken build() {
        com.google.pubsub.v1.PushConfig.OidcToken result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.PushConfig.OidcToken buildPartial() {
        com.google.pubsub.v1.PushConfig.OidcToken result =
            new com.google.pubsub.v1.PushConfig.OidcToken(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.pubsub.v1.PushConfig.OidcToken result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.serviceAccountEmail_ = serviceAccountEmail_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.audience_ = audience_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.PushConfig.OidcToken) {
          return mergeFrom((com.google.pubsub.v1.PushConfig.OidcToken) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.pubsub.v1.PushConfig.OidcToken other) {
        if (other == com.google.pubsub.v1.PushConfig.OidcToken.getDefaultInstance()) return this;
        if (!other.getServiceAccountEmail().isEmpty()) {
          serviceAccountEmail_ = other.serviceAccountEmail_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getAudience().isEmpty()) {
          audience_ = other.audience_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  serviceAccountEmail_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  audience_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object serviceAccountEmail_ = "";
      /**
       *
       *
       * <pre>
       * Optional. [Service account
       * email](https://cloud.google.com/iam/docs/service-accounts)
       * used for generating the OIDC token. For more information
       * on setting up authentication, see
       * [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
       * </pre>
       *
       * <code>string service_account_email = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The serviceAccountEmail.
       */
      public java.lang.String getServiceAccountEmail() {
        java.lang.Object ref = serviceAccountEmail_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceAccountEmail_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. [Service account
       * email](https://cloud.google.com/iam/docs/service-accounts)
       * used for generating the OIDC token. For more information
       * on setting up authentication, see
       * [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
       * </pre>
       *
       * <code>string service_account_email = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for serviceAccountEmail.
       */
      public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
        java.lang.Object ref = serviceAccountEmail_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceAccountEmail_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. [Service account
       * email](https://cloud.google.com/iam/docs/service-accounts)
       * used for generating the OIDC token. For more information
       * on setting up authentication, see
       * [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
       * </pre>
       *
       * <code>string service_account_email = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The serviceAccountEmail to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccountEmail(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceAccountEmail_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. [Service account
       * email](https://cloud.google.com/iam/docs/service-accounts)
       * used for generating the OIDC token. For more information
       * on setting up authentication, see
       * [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
       * </pre>
       *
       * <code>string service_account_email = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServiceAccountEmail() {
        serviceAccountEmail_ = getDefaultInstance().getServiceAccountEmail();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. [Service account
       * email](https://cloud.google.com/iam/docs/service-accounts)
       * used for generating the OIDC token. For more information
       * on setting up authentication, see
       * [Push subscriptions](https://cloud.google.com/pubsub/docs/push).
       * </pre>
       *
       * <code>string service_account_email = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for serviceAccountEmail to set.
       * @return This builder for chaining.
       */
      public Builder setServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serviceAccountEmail_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object audience_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Audience to be used when generating OIDC token. The audience
       * claim identifies the recipients that the JWT is intended for. The
       * audience value is a single case-sensitive string. Having multiple values
       * (array) for the audience field is not supported. More info about the OIDC
       * JWT token audience here:
       * https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
       * the Push endpoint URL will be used.
       * </pre>
       *
       * <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The audience.
       */
      public java.lang.String getAudience() {
        java.lang.Object ref = audience_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          audience_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Audience to be used when generating OIDC token. The audience
       * claim identifies the recipients that the JWT is intended for. The
       * audience value is a single case-sensitive string. Having multiple values
       * (array) for the audience field is not supported. More info about the OIDC
       * JWT token audience here:
       * https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
       * the Push endpoint URL will be used.
       * </pre>
       *
       * <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for audience.
       */
      public com.google.protobuf.ByteString getAudienceBytes() {
        java.lang.Object ref = audience_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          audience_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Audience to be used when generating OIDC token. The audience
       * claim identifies the recipients that the JWT is intended for. The
       * audience value is a single case-sensitive string. Having multiple values
       * (array) for the audience field is not supported. More info about the OIDC
       * JWT token audience here:
       * https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
       * the Push endpoint URL will be used.
       * </pre>
       *
       * <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The audience to set.
       * @return This builder for chaining.
       */
      public Builder setAudience(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        audience_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Audience to be used when generating OIDC token. The audience
       * claim identifies the recipients that the JWT is intended for. The
       * audience value is a single case-sensitive string. Having multiple values
       * (array) for the audience field is not supported. More info about the OIDC
       * JWT token audience here:
       * https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
       * the Push endpoint URL will be used.
       * </pre>
       *
       * <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAudience() {
        audience_ = getDefaultInstance().getAudience();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Audience to be used when generating OIDC token. The audience
       * claim identifies the recipients that the JWT is intended for. The
       * audience value is a single case-sensitive string. Having multiple values
       * (array) for the audience field is not supported. More info about the OIDC
       * JWT token audience here:
       * https://tools.ietf.org/html/rfc7519#section-4.1.3 Note: if not specified,
       * the Push endpoint URL will be used.
       * </pre>
       *
       * <code>string audience = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for audience to set.
       * @return This builder for chaining.
       */
      public Builder setAudienceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        audience_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.PushConfig.OidcToken)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.PushConfig.OidcToken)
    private static final com.google.pubsub.v1.PushConfig.OidcToken DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.PushConfig.OidcToken();
    }

    public static com.google.pubsub.v1.PushConfig.OidcToken getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OidcToken> PARSER =
        new com.google.protobuf.AbstractParser<OidcToken>() {
          @java.lang.Override
          public OidcToken parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<OidcToken> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OidcToken> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.PushConfig.OidcToken getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PubsubWrapperOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.PushConfig.PubsubWrapper)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * The payload to the push endpoint is in the form of the JSON representation
   * of a PubsubMessage
   * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.PushConfig.PubsubWrapper}
   */
  public static final class PubsubWrapper extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.PushConfig.PubsubWrapper)
      PubsubWrapperOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PubsubWrapper.newBuilder() to construct.
    private PubsubWrapper(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PubsubWrapper() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PubsubWrapper();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_PushConfig_PubsubWrapper_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_PushConfig_PubsubWrapper_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.PushConfig.PubsubWrapper.class,
              com.google.pubsub.v1.PushConfig.PubsubWrapper.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.PushConfig.PubsubWrapper)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.PushConfig.PubsubWrapper other =
          (com.google.pubsub.v1.PushConfig.PubsubWrapper) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.pubsub.v1.PushConfig.PubsubWrapper prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The payload to the push endpoint is in the form of the JSON representation
     * of a PubsubMessage
     * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.PushConfig.PubsubWrapper}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.PushConfig.PubsubWrapper)
        com.google.pubsub.v1.PushConfig.PubsubWrapperOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_PushConfig_PubsubWrapper_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_PushConfig_PubsubWrapper_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.PushConfig.PubsubWrapper.class,
                com.google.pubsub.v1.PushConfig.PubsubWrapper.Builder.class);
      }

      // Construct using com.google.pubsub.v1.PushConfig.PubsubWrapper.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_PushConfig_PubsubWrapper_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.PushConfig.PubsubWrapper getDefaultInstanceForType() {
        return com.google.pubsub.v1.PushConfig.PubsubWrapper.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.PushConfig.PubsubWrapper build() {
        com.google.pubsub.v1.PushConfig.PubsubWrapper result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.PushConfig.PubsubWrapper buildPartial() {
        com.google.pubsub.v1.PushConfig.PubsubWrapper result =
            new com.google.pubsub.v1.PushConfig.PubsubWrapper(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.PushConfig.PubsubWrapper) {
          return mergeFrom((com.google.pubsub.v1.PushConfig.PubsubWrapper) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.pubsub.v1.PushConfig.PubsubWrapper other) {
        if (other == com.google.pubsub.v1.PushConfig.PubsubWrapper.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.PushConfig.PubsubWrapper)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.PushConfig.PubsubWrapper)
    private static final com.google.pubsub.v1.PushConfig.PubsubWrapper DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.PushConfig.PubsubWrapper();
    }

    public static com.google.pubsub.v1.PushConfig.PubsubWrapper getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PubsubWrapper> PARSER =
        new com.google.protobuf.AbstractParser<PubsubWrapper>() {
          @java.lang.Override
          public PubsubWrapper parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PubsubWrapper> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PubsubWrapper> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.PushConfig.PubsubWrapper getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NoWrapperOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.PushConfig.NoWrapper)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. When true, writes the Pub/Sub message metadata to
     * `x-goog-pubsub-&lt;KEY&gt;:&lt;VAL&gt;` headers of the HTTP request. Writes the
     * Pub/Sub message attributes to `&lt;KEY&gt;:&lt;VAL&gt;` headers of the HTTP request.
     * </pre>
     *
     * <code>bool write_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The writeMetadata.
     */
    boolean getWriteMetadata();
  }
  /**
   *
   *
   * <pre>
   * Sets the `data` field as the HTTP body for delivery.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.PushConfig.NoWrapper}
   */
  public static final class NoWrapper extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.PushConfig.NoWrapper)
      NoWrapperOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NoWrapper.newBuilder() to construct.
    private NoWrapper(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NoWrapper() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NoWrapper();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_PushConfig_NoWrapper_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_PushConfig_NoWrapper_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.PushConfig.NoWrapper.class,
              com.google.pubsub.v1.PushConfig.NoWrapper.Builder.class);
    }

    public static final int WRITE_METADATA_FIELD_NUMBER = 1;
    private boolean writeMetadata_ = false;
    /**
     *
     *
     * <pre>
     * Optional. When true, writes the Pub/Sub message metadata to
     * `x-goog-pubsub-&lt;KEY&gt;:&lt;VAL&gt;` headers of the HTTP request. Writes the
     * Pub/Sub message attributes to `&lt;KEY&gt;:&lt;VAL&gt;` headers of the HTTP request.
     * </pre>
     *
     * <code>bool write_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The writeMetadata.
     */
    @java.lang.Override
    public boolean getWriteMetadata() {
      return writeMetadata_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (writeMetadata_ != false) {
        output.writeBool(1, writeMetadata_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (writeMetadata_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, writeMetadata_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.PushConfig.NoWrapper)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.PushConfig.NoWrapper other =
          (com.google.pubsub.v1.PushConfig.NoWrapper) obj;

      if (getWriteMetadata() != other.getWriteMetadata()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WRITE_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getWriteMetadata());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.pubsub.v1.PushConfig.NoWrapper prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Sets the `data` field as the HTTP body for delivery.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.PushConfig.NoWrapper}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.PushConfig.NoWrapper)
        com.google.pubsub.v1.PushConfig.NoWrapperOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_PushConfig_NoWrapper_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_PushConfig_NoWrapper_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.PushConfig.NoWrapper.class,
                com.google.pubsub.v1.PushConfig.NoWrapper.Builder.class);
      }

      // Construct using com.google.pubsub.v1.PushConfig.NoWrapper.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        writeMetadata_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_PushConfig_NoWrapper_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.PushConfig.NoWrapper getDefaultInstanceForType() {
        return com.google.pubsub.v1.PushConfig.NoWrapper.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.PushConfig.NoWrapper build() {
        com.google.pubsub.v1.PushConfig.NoWrapper result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.PushConfig.NoWrapper buildPartial() {
        com.google.pubsub.v1.PushConfig.NoWrapper result =
            new com.google.pubsub.v1.PushConfig.NoWrapper(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.pubsub.v1.PushConfig.NoWrapper result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.writeMetadata_ = writeMetadata_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.PushConfig.NoWrapper) {
          return mergeFrom((com.google.pubsub.v1.PushConfig.NoWrapper) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.pubsub.v1.PushConfig.NoWrapper other) {
        if (other == com.google.pubsub.v1.PushConfig.NoWrapper.getDefaultInstance()) return this;
        if (other.getWriteMetadata() != false) {
          setWriteMetadata(other.getWriteMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  writeMetadata_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean writeMetadata_;
      /**
       *
       *
       * <pre>
       * Optional. When true, writes the Pub/Sub message metadata to
       * `x-goog-pubsub-&lt;KEY&gt;:&lt;VAL&gt;` headers of the HTTP request. Writes the
       * Pub/Sub message attributes to `&lt;KEY&gt;:&lt;VAL&gt;` headers of the HTTP request.
       * </pre>
       *
       * <code>bool write_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The writeMetadata.
       */
      @java.lang.Override
      public boolean getWriteMetadata() {
        return writeMetadata_;
      }
      /**
       *
       *
       * <pre>
       * Optional. When true, writes the Pub/Sub message metadata to
       * `x-goog-pubsub-&lt;KEY&gt;:&lt;VAL&gt;` headers of the HTTP request. Writes the
       * Pub/Sub message attributes to `&lt;KEY&gt;:&lt;VAL&gt;` headers of the HTTP request.
       * </pre>
       *
       * <code>bool write_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The writeMetadata to set.
       * @return This builder for chaining.
       */
      public Builder setWriteMetadata(boolean value) {

        writeMetadata_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. When true, writes the Pub/Sub message metadata to
       * `x-goog-pubsub-&lt;KEY&gt;:&lt;VAL&gt;` headers of the HTTP request. Writes the
       * Pub/Sub message attributes to `&lt;KEY&gt;:&lt;VAL&gt;` headers of the HTTP request.
       * </pre>
       *
       * <code>bool write_metadata = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWriteMetadata() {
        bitField0_ = (bitField0_ & ~0x00000001);
        writeMetadata_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.PushConfig.NoWrapper)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.PushConfig.NoWrapper)
    private static final com.google.pubsub.v1.PushConfig.NoWrapper DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.PushConfig.NoWrapper();
    }

    public static com.google.pubsub.v1.PushConfig.NoWrapper getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NoWrapper> PARSER =
        new com.google.protobuf.AbstractParser<NoWrapper>() {
          @java.lang.Override
          public NoWrapper parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NoWrapper> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NoWrapper> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.PushConfig.NoWrapper getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int authenticationMethodCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object authenticationMethod_;

  public enum AuthenticationMethodCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    OIDC_TOKEN(3),
    AUTHENTICATIONMETHOD_NOT_SET(0);
    private final int value;

    private AuthenticationMethodCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AuthenticationMethodCase valueOf(int value) {
      return forNumber(value);
    }

    public static AuthenticationMethodCase forNumber(int value) {
      switch (value) {
        case 3:
          return OIDC_TOKEN;
        case 0:
          return AUTHENTICATIONMETHOD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AuthenticationMethodCase getAuthenticationMethodCase() {
    return AuthenticationMethodCase.forNumber(authenticationMethodCase_);
  }

  private int wrapperCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object wrapper_;

  public enum WrapperCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PUBSUB_WRAPPER(4),
    NO_WRAPPER(5),
    WRAPPER_NOT_SET(0);
    private final int value;

    private WrapperCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static WrapperCase valueOf(int value) {
      return forNumber(value);
    }

    public static WrapperCase forNumber(int value) {
      switch (value) {
        case 4:
          return PUBSUB_WRAPPER;
        case 5:
          return NO_WRAPPER;
        case 0:
          return WRAPPER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public WrapperCase getWrapperCase() {
    return WrapperCase.forNumber(wrapperCase_);
  }

  public static final int PUSH_ENDPOINT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pushEndpoint_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A URL locating the endpoint to which messages should be pushed.
   * For example, a Webhook endpoint might use `https://example.com/push`.
   * </pre>
   *
   * <code>string push_endpoint = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pushEndpoint.
   */
  @java.lang.Override
  public java.lang.String getPushEndpoint() {
    java.lang.Object ref = pushEndpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pushEndpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A URL locating the endpoint to which messages should be pushed.
   * For example, a Webhook endpoint might use `https://example.com/push`.
   * </pre>
   *
   * <code>string push_endpoint = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pushEndpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPushEndpointBytes() {
    java.lang.Object ref = pushEndpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pushEndpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 2;

  private static final class AttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.pubsub.v1.PubsubProto
                .internal_static_google_pubsub_v1_PushConfig_AttributesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> attributes_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetAttributes() {
    if (attributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AttributesDefaultEntryHolder.defaultEntry);
    }
    return attributes_;
  }

  public int getAttributesCount() {
    return internalGetAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Endpoint configuration attributes that can be used to control
   * different aspects of the message delivery.
   *
   * The only currently supported attribute is `x-goog-version`, which you can
   * use to change the format of the pushed message. This attribute
   * indicates the version of the data expected by the endpoint. This
   * controls the shape of the pushed message (i.e., its fields and metadata).
   *
   * If not present during the `CreateSubscription` call, it will default to
   * the version of the Pub/Sub API used to make such call. If not present in a
   * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
   * calls will always return a valid version, even if the subscription was
   * created without this attribute.
   *
   * The only supported values for the `x-goog-version` attribute are:
   *
   * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
   * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
   *
   * For example:
   * `attributes { "x-goog-version": "v1" }`
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
    return getAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Endpoint configuration attributes that can be used to control
   * different aspects of the message delivery.
   *
   * The only currently supported attribute is `x-goog-version`, which you can
   * use to change the format of the pushed message. This attribute
   * indicates the version of the data expected by the endpoint. This
   * controls the shape of the pushed message (i.e., its fields and metadata).
   *
   * If not present during the `CreateSubscription` call, it will default to
   * the version of the Pub/Sub API used to make such call. If not present in a
   * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
   * calls will always return a valid version, even if the subscription was
   * created without this attribute.
   *
   * The only supported values for the `x-goog-version` attribute are:
   *
   * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
   * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
   *
   * For example:
   * `attributes { "x-goog-version": "v1" }`
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAttributesMap() {
    return internalGetAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Endpoint configuration attributes that can be used to control
   * different aspects of the message delivery.
   *
   * The only currently supported attribute is `x-goog-version`, which you can
   * use to change the format of the pushed message. This attribute
   * indicates the version of the data expected by the endpoint. This
   * controls the shape of the pushed message (i.e., its fields and metadata).
   *
   * If not present during the `CreateSubscription` call, it will default to
   * the version of the Pub/Sub API used to make such call. If not present in a
   * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
   * calls will always return a valid version, even if the subscription was
   * created without this attribute.
   *
   * The only supported values for the `x-goog-version` attribute are:
   *
   * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
   * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
   *
   * For example:
   * `attributes { "x-goog-version": "v1" }`
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Endpoint configuration attributes that can be used to control
   * different aspects of the message delivery.
   *
   * The only currently supported attribute is `x-goog-version`, which you can
   * use to change the format of the pushed message. This attribute
   * indicates the version of the data expected by the endpoint. This
   * controls the shape of the pushed message (i.e., its fields and metadata).
   *
   * If not present during the `CreateSubscription` call, it will default to
   * the version of the Pub/Sub API used to make such call. If not present in a
   * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
   * calls will always return a valid version, even if the subscription was
   * created without this attribute.
   *
   * The only supported values for the `x-goog-version` attribute are:
   *
   * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
   * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
   *
   * For example:
   * `attributes { "x-goog-version": "v1" }`
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAttributesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int OIDC_TOKEN_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
   * token as an `Authorization` header in the HTTP request for every pushed
   * message.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the oidcToken field is set.
   */
  @java.lang.Override
  public boolean hasOidcToken() {
    return authenticationMethodCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
   * token as an `Authorization` header in the HTTP request for every pushed
   * message.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The oidcToken.
   */
  @java.lang.Override
  public com.google.pubsub.v1.PushConfig.OidcToken getOidcToken() {
    if (authenticationMethodCase_ == 3) {
      return (com.google.pubsub.v1.PushConfig.OidcToken) authenticationMethod_;
    }
    return com.google.pubsub.v1.PushConfig.OidcToken.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
   * token as an `Authorization` header in the HTTP request for every pushed
   * message.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.PushConfig.OidcTokenOrBuilder getOidcTokenOrBuilder() {
    if (authenticationMethodCase_ == 3) {
      return (com.google.pubsub.v1.PushConfig.OidcToken) authenticationMethod_;
    }
    return com.google.pubsub.v1.PushConfig.OidcToken.getDefaultInstance();
  }

  public static final int PUBSUB_WRAPPER_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. When set, the payload to the push endpoint is in the form of
   * the JSON representation of a PubsubMessage
   * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the pubsubWrapper field is set.
   */
  @java.lang.Override
  public boolean hasPubsubWrapper() {
    return wrapperCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. When set, the payload to the push endpoint is in the form of
   * the JSON representation of a PubsubMessage
   * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The pubsubWrapper.
   */
  @java.lang.Override
  public com.google.pubsub.v1.PushConfig.PubsubWrapper getPubsubWrapper() {
    if (wrapperCase_ == 4) {
      return (com.google.pubsub.v1.PushConfig.PubsubWrapper) wrapper_;
    }
    return com.google.pubsub.v1.PushConfig.PubsubWrapper.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. When set, the payload to the push endpoint is in the form of
   * the JSON representation of a PubsubMessage
   * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.PushConfig.PubsubWrapperOrBuilder getPubsubWrapperOrBuilder() {
    if (wrapperCase_ == 4) {
      return (com.google.pubsub.v1.PushConfig.PubsubWrapper) wrapper_;
    }
    return com.google.pubsub.v1.PushConfig.PubsubWrapper.getDefaultInstance();
  }

  public static final int NO_WRAPPER_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. When set, the payload to the push endpoint is not wrapped.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the noWrapper field is set.
   */
  @java.lang.Override
  public boolean hasNoWrapper() {
    return wrapperCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. When set, the payload to the push endpoint is not wrapped.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The noWrapper.
   */
  @java.lang.Override
  public com.google.pubsub.v1.PushConfig.NoWrapper getNoWrapper() {
    if (wrapperCase_ == 5) {
      return (com.google.pubsub.v1.PushConfig.NoWrapper) wrapper_;
    }
    return com.google.pubsub.v1.PushConfig.NoWrapper.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. When set, the payload to the push endpoint is not wrapped.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.PushConfig.NoWrapperOrBuilder getNoWrapperOrBuilder() {
    if (wrapperCase_ == 5) {
      return (com.google.pubsub.v1.PushConfig.NoWrapper) wrapper_;
    }
    return com.google.pubsub.v1.PushConfig.NoWrapper.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pushEndpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pushEndpoint_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, 2);
    if (authenticationMethodCase_ == 3) {
      output.writeMessage(3, (com.google.pubsub.v1.PushConfig.OidcToken) authenticationMethod_);
    }
    if (wrapperCase_ == 4) {
      output.writeMessage(4, (com.google.pubsub.v1.PushConfig.PubsubWrapper) wrapper_);
    }
    if (wrapperCase_ == 5) {
      output.writeMessage(5, (com.google.pubsub.v1.PushConfig.NoWrapper) wrapper_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pushEndpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pushEndpoint_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> attributes__ =
          AttributesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, attributes__);
    }
    if (authenticationMethodCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.pubsub.v1.PushConfig.OidcToken) authenticationMethod_);
    }
    if (wrapperCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.pubsub.v1.PushConfig.PubsubWrapper) wrapper_);
    }
    if (wrapperCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.pubsub.v1.PushConfig.NoWrapper) wrapper_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.PushConfig)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.PushConfig other = (com.google.pubsub.v1.PushConfig) obj;

    if (!getPushEndpoint().equals(other.getPushEndpoint())) return false;
    if (!internalGetAttributes().equals(other.internalGetAttributes())) return false;
    if (!getAuthenticationMethodCase().equals(other.getAuthenticationMethodCase())) return false;
    switch (authenticationMethodCase_) {
      case 3:
        if (!getOidcToken().equals(other.getOidcToken())) return false;
        break;
      case 0:
      default:
    }
    if (!getWrapperCase().equals(other.getWrapperCase())) return false;
    switch (wrapperCase_) {
      case 4:
        if (!getPubsubWrapper().equals(other.getPubsubWrapper())) return false;
        break;
      case 5:
        if (!getNoWrapper().equals(other.getNoWrapper())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PUSH_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getPushEndpoint().hashCode();
    if (!internalGetAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAttributes().hashCode();
    }
    switch (authenticationMethodCase_) {
      case 3:
        hash = (37 * hash) + OIDC_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getOidcToken().hashCode();
        break;
      case 0:
      default:
    }
    switch (wrapperCase_) {
      case 4:
        hash = (37 * hash) + PUBSUB_WRAPPER_FIELD_NUMBER;
        hash = (53 * hash) + getPubsubWrapper().hashCode();
        break;
      case 5:
        hash = (37 * hash) + NO_WRAPPER_FIELD_NUMBER;
        hash = (53 * hash) + getNoWrapper().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.PushConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.PushConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.PushConfig parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.PushConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.PushConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.PushConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.PushConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.PushConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.PushConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.PushConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.PushConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.PushConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.PushConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a push delivery endpoint.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.PushConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.PushConfig)
      com.google.pubsub.v1.PushConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_PushConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_PushConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.PushConfig.class, com.google.pubsub.v1.PushConfig.Builder.class);
    }

    // Construct using com.google.pubsub.v1.PushConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      pushEndpoint_ = "";
      internalGetMutableAttributes().clear();
      if (oidcTokenBuilder_ != null) {
        oidcTokenBuilder_.clear();
      }
      if (pubsubWrapperBuilder_ != null) {
        pubsubWrapperBuilder_.clear();
      }
      if (noWrapperBuilder_ != null) {
        noWrapperBuilder_.clear();
      }
      authenticationMethodCase_ = 0;
      authenticationMethod_ = null;
      wrapperCase_ = 0;
      wrapper_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_PushConfig_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.PushConfig getDefaultInstanceForType() {
      return com.google.pubsub.v1.PushConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.PushConfig build() {
      com.google.pubsub.v1.PushConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.PushConfig buildPartial() {
      com.google.pubsub.v1.PushConfig result = new com.google.pubsub.v1.PushConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.pubsub.v1.PushConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.pushEndpoint_ = pushEndpoint_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.attributes_ = internalGetAttributes();
        result.attributes_.makeImmutable();
      }
    }

    private void buildPartialOneofs(com.google.pubsub.v1.PushConfig result) {
      result.authenticationMethodCase_ = authenticationMethodCase_;
      result.authenticationMethod_ = this.authenticationMethod_;
      if (authenticationMethodCase_ == 3 && oidcTokenBuilder_ != null) {
        result.authenticationMethod_ = oidcTokenBuilder_.build();
      }
      result.wrapperCase_ = wrapperCase_;
      result.wrapper_ = this.wrapper_;
      if (wrapperCase_ == 4 && pubsubWrapperBuilder_ != null) {
        result.wrapper_ = pubsubWrapperBuilder_.build();
      }
      if (wrapperCase_ == 5 && noWrapperBuilder_ != null) {
        result.wrapper_ = noWrapperBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.PushConfig) {
        return mergeFrom((com.google.pubsub.v1.PushConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.PushConfig other) {
      if (other == com.google.pubsub.v1.PushConfig.getDefaultInstance()) return this;
      if (!other.getPushEndpoint().isEmpty()) {
        pushEndpoint_ = other.pushEndpoint_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
      bitField0_ |= 0x00000002;
      switch (other.getAuthenticationMethodCase()) {
        case OIDC_TOKEN:
          {
            mergeOidcToken(other.getOidcToken());
            break;
          }
        case AUTHENTICATIONMETHOD_NOT_SET:
          {
            break;
          }
      }
      switch (other.getWrapperCase()) {
        case PUBSUB_WRAPPER:
          {
            mergePubsubWrapper(other.getPubsubWrapper());
            break;
          }
        case NO_WRAPPER:
          {
            mergeNoWrapper(other.getNoWrapper());
            break;
          }
        case WRAPPER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                pushEndpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> attributes__ =
                    input.readMessage(
                        AttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAttributes()
                    .getMutableMap()
                    .put(attributes__.getKey(), attributes__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getOidcTokenFieldBuilder().getBuilder(), extensionRegistry);
                authenticationMethodCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPubsubWrapperFieldBuilder().getBuilder(), extensionRegistry);
                wrapperCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getNoWrapperFieldBuilder().getBuilder(), extensionRegistry);
                wrapperCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int authenticationMethodCase_ = 0;
    private java.lang.Object authenticationMethod_;

    public AuthenticationMethodCase getAuthenticationMethodCase() {
      return AuthenticationMethodCase.forNumber(authenticationMethodCase_);
    }

    public Builder clearAuthenticationMethod() {
      authenticationMethodCase_ = 0;
      authenticationMethod_ = null;
      onChanged();
      return this;
    }

    private int wrapperCase_ = 0;
    private java.lang.Object wrapper_;

    public WrapperCase getWrapperCase() {
      return WrapperCase.forNumber(wrapperCase_);
    }

    public Builder clearWrapper() {
      wrapperCase_ = 0;
      wrapper_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object pushEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A URL locating the endpoint to which messages should be pushed.
     * For example, a Webhook endpoint might use `https://example.com/push`.
     * </pre>
     *
     * <code>string push_endpoint = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pushEndpoint.
     */
    public java.lang.String getPushEndpoint() {
      java.lang.Object ref = pushEndpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pushEndpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A URL locating the endpoint to which messages should be pushed.
     * For example, a Webhook endpoint might use `https://example.com/push`.
     * </pre>
     *
     * <code>string push_endpoint = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pushEndpoint.
     */
    public com.google.protobuf.ByteString getPushEndpointBytes() {
      java.lang.Object ref = pushEndpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pushEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A URL locating the endpoint to which messages should be pushed.
     * For example, a Webhook endpoint might use `https://example.com/push`.
     * </pre>
     *
     * <code>string push_endpoint = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pushEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setPushEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pushEndpoint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A URL locating the endpoint to which messages should be pushed.
     * For example, a Webhook endpoint might use `https://example.com/push`.
     * </pre>
     *
     * <code>string push_endpoint = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPushEndpoint() {
      pushEndpoint_ = getDefaultInstance().getPushEndpoint();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A URL locating the endpoint to which messages should be pushed.
     * For example, a Webhook endpoint might use `https://example.com/push`.
     * </pre>
     *
     * <code>string push_endpoint = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pushEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setPushEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pushEndpoint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> attributes_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAttributes() {
      if (attributes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AttributesDefaultEntryHolder.defaultEntry);
      }
      return attributes_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAttributes() {
      if (attributes_ == null) {
        attributes_ =
            com.google.protobuf.MapField.newMapField(AttributesDefaultEntryHolder.defaultEntry);
      }
      if (!attributes_.isMutable()) {
        attributes_ = attributes_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return attributes_;
    }

    public int getAttributesCount() {
      return internalGetAttributes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint configuration attributes that can be used to control
     * different aspects of the message delivery.
     *
     * The only currently supported attribute is `x-goog-version`, which you can
     * use to change the format of the pushed message. This attribute
     * indicates the version of the data expected by the endpoint. This
     * controls the shape of the pushed message (i.e., its fields and metadata).
     *
     * If not present during the `CreateSubscription` call, it will default to
     * the version of the Pub/Sub API used to make such call. If not present in a
     * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
     * calls will always return a valid version, even if the subscription was
     * created without this attribute.
     *
     * The only supported values for the `x-goog-version` attribute are:
     *
     * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
     * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
     *
     * For example:
     * `attributes { "x-goog-version": "v1" }`
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributes().getMap().containsKey(key);
    }
    /** Use {@link #getAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
      return getAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint configuration attributes that can be used to control
     * different aspects of the message delivery.
     *
     * The only currently supported attribute is `x-goog-version`, which you can
     * use to change the format of the pushed message. This attribute
     * indicates the version of the data expected by the endpoint. This
     * controls the shape of the pushed message (i.e., its fields and metadata).
     *
     * If not present during the `CreateSubscription` call, it will default to
     * the version of the Pub/Sub API used to make such call. If not present in a
     * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
     * calls will always return a valid version, even if the subscription was
     * created without this attribute.
     *
     * The only supported values for the `x-goog-version` attribute are:
     *
     * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
     * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
     *
     * For example:
     * `attributes { "x-goog-version": "v1" }`
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAttributesMap() {
      return internalGetAttributes().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint configuration attributes that can be used to control
     * different aspects of the message delivery.
     *
     * The only currently supported attribute is `x-goog-version`, which you can
     * use to change the format of the pushed message. This attribute
     * indicates the version of the data expected by the endpoint. This
     * controls the shape of the pushed message (i.e., its fields and metadata).
     *
     * If not present during the `CreateSubscription` call, it will default to
     * the version of the Pub/Sub API used to make such call. If not present in a
     * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
     * calls will always return a valid version, even if the subscription was
     * created without this attribute.
     *
     * The only supported values for the `x-goog-version` attribute are:
     *
     * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
     * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
     *
     * For example:
     * `attributes { "x-goog-version": "v1" }`
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint configuration attributes that can be used to control
     * different aspects of the message delivery.
     *
     * The only currently supported attribute is `x-goog-version`, which you can
     * use to change the format of the pushed message. This attribute
     * indicates the version of the data expected by the endpoint. This
     * controls the shape of the pushed message (i.e., its fields and metadata).
     *
     * If not present during the `CreateSubscription` call, it will default to
     * the version of the Pub/Sub API used to make such call. If not present in a
     * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
     * calls will always return a valid version, even if the subscription was
     * created without this attribute.
     *
     * The only supported values for the `x-goog-version` attribute are:
     *
     * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
     * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
     *
     * For example:
     * `attributes { "x-goog-version": "v1" }`
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAttributesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAttributes() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableAttributes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint configuration attributes that can be used to control
     * different aspects of the message delivery.
     *
     * The only currently supported attribute is `x-goog-version`, which you can
     * use to change the format of the pushed message. This attribute
     * indicates the version of the data expected by the endpoint. This
     * controls the shape of the pushed message (i.e., its fields and metadata).
     *
     * If not present during the `CreateSubscription` call, it will default to
     * the version of the Pub/Sub API used to make such call. If not present in a
     * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
     * calls will always return a valid version, even if the subscription was
     * created without this attribute.
     *
     * The only supported values for the `x-goog-version` attribute are:
     *
     * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
     * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
     *
     * For example:
     * `attributes { "x-goog-version": "v1" }`
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAttributes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAttributes() {
      bitField0_ |= 0x00000002;
      return internalGetMutableAttributes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint configuration attributes that can be used to control
     * different aspects of the message delivery.
     *
     * The only currently supported attribute is `x-goog-version`, which you can
     * use to change the format of the pushed message. This attribute
     * indicates the version of the data expected by the endpoint. This
     * controls the shape of the pushed message (i.e., its fields and metadata).
     *
     * If not present during the `CreateSubscription` call, it will default to
     * the version of the Pub/Sub API used to make such call. If not present in a
     * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
     * calls will always return a valid version, even if the subscription was
     * created without this attribute.
     *
     * The only supported values for the `x-goog-version` attribute are:
     *
     * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
     * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
     *
     * For example:
     * `attributes { "x-goog-version": "v1" }`
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAttributes(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAttributes().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Endpoint configuration attributes that can be used to control
     * different aspects of the message delivery.
     *
     * The only currently supported attribute is `x-goog-version`, which you can
     * use to change the format of the pushed message. This attribute
     * indicates the version of the data expected by the endpoint. This
     * controls the shape of the pushed message (i.e., its fields and metadata).
     *
     * If not present during the `CreateSubscription` call, it will default to
     * the version of the Pub/Sub API used to make such call. If not present in a
     * `ModifyPushConfig` call, its value will not be changed. `GetSubscription`
     * calls will always return a valid version, even if the subscription was
     * created without this attribute.
     *
     * The only supported values for the `x-goog-version` attribute are:
     *
     * * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
     * * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API.
     *
     * For example:
     * `attributes { "x-goog-version": "v1" }`
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAttributes(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAttributes().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PushConfig.OidcToken,
            com.google.pubsub.v1.PushConfig.OidcToken.Builder,
            com.google.pubsub.v1.PushConfig.OidcTokenOrBuilder>
        oidcTokenBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
     * token as an `Authorization` header in the HTTP request for every pushed
     * message.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the oidcToken field is set.
     */
    @java.lang.Override
    public boolean hasOidcToken() {
      return authenticationMethodCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
     * token as an `Authorization` header in the HTTP request for every pushed
     * message.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The oidcToken.
     */
    @java.lang.Override
    public com.google.pubsub.v1.PushConfig.OidcToken getOidcToken() {
      if (oidcTokenBuilder_ == null) {
        if (authenticationMethodCase_ == 3) {
          return (com.google.pubsub.v1.PushConfig.OidcToken) authenticationMethod_;
        }
        return com.google.pubsub.v1.PushConfig.OidcToken.getDefaultInstance();
      } else {
        if (authenticationMethodCase_ == 3) {
          return oidcTokenBuilder_.getMessage();
        }
        return com.google.pubsub.v1.PushConfig.OidcToken.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
     * token as an `Authorization` header in the HTTP request for every pushed
     * message.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOidcToken(com.google.pubsub.v1.PushConfig.OidcToken value) {
      if (oidcTokenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authenticationMethod_ = value;
        onChanged();
      } else {
        oidcTokenBuilder_.setMessage(value);
      }
      authenticationMethodCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
     * token as an `Authorization` header in the HTTP request for every pushed
     * message.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOidcToken(com.google.pubsub.v1.PushConfig.OidcToken.Builder builderForValue) {
      if (oidcTokenBuilder_ == null) {
        authenticationMethod_ = builderForValue.build();
        onChanged();
      } else {
        oidcTokenBuilder_.setMessage(builderForValue.build());
      }
      authenticationMethodCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
     * token as an `Authorization` header in the HTTP request for every pushed
     * message.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeOidcToken(com.google.pubsub.v1.PushConfig.OidcToken value) {
      if (oidcTokenBuilder_ == null) {
        if (authenticationMethodCase_ == 3
            && authenticationMethod_
                != com.google.pubsub.v1.PushConfig.OidcToken.getDefaultInstance()) {
          authenticationMethod_ =
              com.google.pubsub.v1.PushConfig.OidcToken.newBuilder(
                      (com.google.pubsub.v1.PushConfig.OidcToken) authenticationMethod_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authenticationMethod_ = value;
        }
        onChanged();
      } else {
        if (authenticationMethodCase_ == 3) {
          oidcTokenBuilder_.mergeFrom(value);
        } else {
          oidcTokenBuilder_.setMessage(value);
        }
      }
      authenticationMethodCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
     * token as an `Authorization` header in the HTTP request for every pushed
     * message.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOidcToken() {
      if (oidcTokenBuilder_ == null) {
        if (authenticationMethodCase_ == 3) {
          authenticationMethodCase_ = 0;
          authenticationMethod_ = null;
          onChanged();
        }
      } else {
        if (authenticationMethodCase_ == 3) {
          authenticationMethodCase_ = 0;
          authenticationMethod_ = null;
        }
        oidcTokenBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
     * token as an `Authorization` header in the HTTP request for every pushed
     * message.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.PushConfig.OidcToken.Builder getOidcTokenBuilder() {
      return getOidcTokenFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
     * token as an `Authorization` header in the HTTP request for every pushed
     * message.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.PushConfig.OidcTokenOrBuilder getOidcTokenOrBuilder() {
      if ((authenticationMethodCase_ == 3) && (oidcTokenBuilder_ != null)) {
        return oidcTokenBuilder_.getMessageOrBuilder();
      } else {
        if (authenticationMethodCase_ == 3) {
          return (com.google.pubsub.v1.PushConfig.OidcToken) authenticationMethod_;
        }
        return com.google.pubsub.v1.PushConfig.OidcToken.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If specified, Pub/Sub will generate and attach an OIDC JWT
     * token as an `Authorization` header in the HTTP request for every pushed
     * message.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.OidcToken oidc_token = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PushConfig.OidcToken,
            com.google.pubsub.v1.PushConfig.OidcToken.Builder,
            com.google.pubsub.v1.PushConfig.OidcTokenOrBuilder>
        getOidcTokenFieldBuilder() {
      if (oidcTokenBuilder_ == null) {
        if (!(authenticationMethodCase_ == 3)) {
          authenticationMethod_ = com.google.pubsub.v1.PushConfig.OidcToken.getDefaultInstance();
        }
        oidcTokenBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.PushConfig.OidcToken,
                com.google.pubsub.v1.PushConfig.OidcToken.Builder,
                com.google.pubsub.v1.PushConfig.OidcTokenOrBuilder>(
                (com.google.pubsub.v1.PushConfig.OidcToken) authenticationMethod_,
                getParentForChildren(),
                isClean());
        authenticationMethod_ = null;
      }
      authenticationMethodCase_ = 3;
      onChanged();
      return oidcTokenBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PushConfig.PubsubWrapper,
            com.google.pubsub.v1.PushConfig.PubsubWrapper.Builder,
            com.google.pubsub.v1.PushConfig.PubsubWrapperOrBuilder>
        pubsubWrapperBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is in the form of
     * the JSON representation of a PubsubMessage
     * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pubsubWrapper field is set.
     */
    @java.lang.Override
    public boolean hasPubsubWrapper() {
      return wrapperCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is in the form of
     * the JSON representation of a PubsubMessage
     * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pubsubWrapper.
     */
    @java.lang.Override
    public com.google.pubsub.v1.PushConfig.PubsubWrapper getPubsubWrapper() {
      if (pubsubWrapperBuilder_ == null) {
        if (wrapperCase_ == 4) {
          return (com.google.pubsub.v1.PushConfig.PubsubWrapper) wrapper_;
        }
        return com.google.pubsub.v1.PushConfig.PubsubWrapper.getDefaultInstance();
      } else {
        if (wrapperCase_ == 4) {
          return pubsubWrapperBuilder_.getMessage();
        }
        return com.google.pubsub.v1.PushConfig.PubsubWrapper.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is in the form of
     * the JSON representation of a PubsubMessage
     * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPubsubWrapper(com.google.pubsub.v1.PushConfig.PubsubWrapper value) {
      if (pubsubWrapperBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        wrapper_ = value;
        onChanged();
      } else {
        pubsubWrapperBuilder_.setMessage(value);
      }
      wrapperCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is in the form of
     * the JSON representation of a PubsubMessage
     * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPubsubWrapper(
        com.google.pubsub.v1.PushConfig.PubsubWrapper.Builder builderForValue) {
      if (pubsubWrapperBuilder_ == null) {
        wrapper_ = builderForValue.build();
        onChanged();
      } else {
        pubsubWrapperBuilder_.setMessage(builderForValue.build());
      }
      wrapperCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is in the form of
     * the JSON representation of a PubsubMessage
     * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePubsubWrapper(com.google.pubsub.v1.PushConfig.PubsubWrapper value) {
      if (pubsubWrapperBuilder_ == null) {
        if (wrapperCase_ == 4
            && wrapper_ != com.google.pubsub.v1.PushConfig.PubsubWrapper.getDefaultInstance()) {
          wrapper_ =
              com.google.pubsub.v1.PushConfig.PubsubWrapper.newBuilder(
                      (com.google.pubsub.v1.PushConfig.PubsubWrapper) wrapper_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          wrapper_ = value;
        }
        onChanged();
      } else {
        if (wrapperCase_ == 4) {
          pubsubWrapperBuilder_.mergeFrom(value);
        } else {
          pubsubWrapperBuilder_.setMessage(value);
        }
      }
      wrapperCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is in the form of
     * the JSON representation of a PubsubMessage
     * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPubsubWrapper() {
      if (pubsubWrapperBuilder_ == null) {
        if (wrapperCase_ == 4) {
          wrapperCase_ = 0;
          wrapper_ = null;
          onChanged();
        }
      } else {
        if (wrapperCase_ == 4) {
          wrapperCase_ = 0;
          wrapper_ = null;
        }
        pubsubWrapperBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is in the form of
     * the JSON representation of a PubsubMessage
     * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.PushConfig.PubsubWrapper.Builder getPubsubWrapperBuilder() {
      return getPubsubWrapperFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is in the form of
     * the JSON representation of a PubsubMessage
     * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.PushConfig.PubsubWrapperOrBuilder getPubsubWrapperOrBuilder() {
      if ((wrapperCase_ == 4) && (pubsubWrapperBuilder_ != null)) {
        return pubsubWrapperBuilder_.getMessageOrBuilder();
      } else {
        if (wrapperCase_ == 4) {
          return (com.google.pubsub.v1.PushConfig.PubsubWrapper) wrapper_;
        }
        return com.google.pubsub.v1.PushConfig.PubsubWrapper.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is in the form of
     * the JSON representation of a PubsubMessage
     * (https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#pubsubmessage).
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.PubsubWrapper pubsub_wrapper = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PushConfig.PubsubWrapper,
            com.google.pubsub.v1.PushConfig.PubsubWrapper.Builder,
            com.google.pubsub.v1.PushConfig.PubsubWrapperOrBuilder>
        getPubsubWrapperFieldBuilder() {
      if (pubsubWrapperBuilder_ == null) {
        if (!(wrapperCase_ == 4)) {
          wrapper_ = com.google.pubsub.v1.PushConfig.PubsubWrapper.getDefaultInstance();
        }
        pubsubWrapperBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.PushConfig.PubsubWrapper,
                com.google.pubsub.v1.PushConfig.PubsubWrapper.Builder,
                com.google.pubsub.v1.PushConfig.PubsubWrapperOrBuilder>(
                (com.google.pubsub.v1.PushConfig.PubsubWrapper) wrapper_,
                getParentForChildren(),
                isClean());
        wrapper_ = null;
      }
      wrapperCase_ = 4;
      onChanged();
      return pubsubWrapperBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PushConfig.NoWrapper,
            com.google.pubsub.v1.PushConfig.NoWrapper.Builder,
            com.google.pubsub.v1.PushConfig.NoWrapperOrBuilder>
        noWrapperBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is not wrapped.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the noWrapper field is set.
     */
    @java.lang.Override
    public boolean hasNoWrapper() {
      return wrapperCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is not wrapped.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The noWrapper.
     */
    @java.lang.Override
    public com.google.pubsub.v1.PushConfig.NoWrapper getNoWrapper() {
      if (noWrapperBuilder_ == null) {
        if (wrapperCase_ == 5) {
          return (com.google.pubsub.v1.PushConfig.NoWrapper) wrapper_;
        }
        return com.google.pubsub.v1.PushConfig.NoWrapper.getDefaultInstance();
      } else {
        if (wrapperCase_ == 5) {
          return noWrapperBuilder_.getMessage();
        }
        return com.google.pubsub.v1.PushConfig.NoWrapper.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is not wrapped.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNoWrapper(com.google.pubsub.v1.PushConfig.NoWrapper value) {
      if (noWrapperBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        wrapper_ = value;
        onChanged();
      } else {
        noWrapperBuilder_.setMessage(value);
      }
      wrapperCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is not wrapped.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNoWrapper(com.google.pubsub.v1.PushConfig.NoWrapper.Builder builderForValue) {
      if (noWrapperBuilder_ == null) {
        wrapper_ = builderForValue.build();
        onChanged();
      } else {
        noWrapperBuilder_.setMessage(builderForValue.build());
      }
      wrapperCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is not wrapped.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeNoWrapper(com.google.pubsub.v1.PushConfig.NoWrapper value) {
      if (noWrapperBuilder_ == null) {
        if (wrapperCase_ == 5
            && wrapper_ != com.google.pubsub.v1.PushConfig.NoWrapper.getDefaultInstance()) {
          wrapper_ =
              com.google.pubsub.v1.PushConfig.NoWrapper.newBuilder(
                      (com.google.pubsub.v1.PushConfig.NoWrapper) wrapper_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          wrapper_ = value;
        }
        onChanged();
      } else {
        if (wrapperCase_ == 5) {
          noWrapperBuilder_.mergeFrom(value);
        } else {
          noWrapperBuilder_.setMessage(value);
        }
      }
      wrapperCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is not wrapped.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNoWrapper() {
      if (noWrapperBuilder_ == null) {
        if (wrapperCase_ == 5) {
          wrapperCase_ = 0;
          wrapper_ = null;
          onChanged();
        }
      } else {
        if (wrapperCase_ == 5) {
          wrapperCase_ = 0;
          wrapper_ = null;
        }
        noWrapperBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is not wrapped.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.PushConfig.NoWrapper.Builder getNoWrapperBuilder() {
      return getNoWrapperFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is not wrapped.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.PushConfig.NoWrapperOrBuilder getNoWrapperOrBuilder() {
      if ((wrapperCase_ == 5) && (noWrapperBuilder_ != null)) {
        return noWrapperBuilder_.getMessageOrBuilder();
      } else {
        if (wrapperCase_ == 5) {
          return (com.google.pubsub.v1.PushConfig.NoWrapper) wrapper_;
        }
        return com.google.pubsub.v1.PushConfig.NoWrapper.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. When set, the payload to the push endpoint is not wrapped.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.PushConfig.NoWrapper no_wrapper = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PushConfig.NoWrapper,
            com.google.pubsub.v1.PushConfig.NoWrapper.Builder,
            com.google.pubsub.v1.PushConfig.NoWrapperOrBuilder>
        getNoWrapperFieldBuilder() {
      if (noWrapperBuilder_ == null) {
        if (!(wrapperCase_ == 5)) {
          wrapper_ = com.google.pubsub.v1.PushConfig.NoWrapper.getDefaultInstance();
        }
        noWrapperBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.PushConfig.NoWrapper,
                com.google.pubsub.v1.PushConfig.NoWrapper.Builder,
                com.google.pubsub.v1.PushConfig.NoWrapperOrBuilder>(
                (com.google.pubsub.v1.PushConfig.NoWrapper) wrapper_,
                getParentForChildren(),
                isClean());
        wrapper_ = null;
      }
      wrapperCase_ = 5;
      onChanged();
      return noWrapperBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.PushConfig)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.PushConfig)
  private static final com.google.pubsub.v1.PushConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.PushConfig();
  }

  public static com.google.pubsub.v1.PushConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PushConfig> PARSER =
      new com.google.protobuf.AbstractParser<PushConfig>() {
        @java.lang.Override
        public PushConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PushConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PushConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.PushConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
