/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.5
package com.google.pubsub.v1;

public interface StreamingPullRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.pubsub.v1.StreamingPullRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The subscription for which to initialize the new stream. This
   * must be provided in the first request on the stream, and must not be set in
   * subsequent requests from client to server.
   * Format is `projects/{project}/subscriptions/{sub}`.
   * </pre>
   *
   * <code>
   * string subscription = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The subscription.
   */
  java.lang.String getSubscription();
  /**
   *
   *
   * <pre>
   * Required. The subscription for which to initialize the new stream. This
   * must be provided in the first request on the stream, and must not be set in
   * subsequent requests from client to server.
   * Format is `projects/{project}/subscriptions/{sub}`.
   * </pre>
   *
   * <code>
   * string subscription = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for subscription.
   */
  com.google.protobuf.ByteString getSubscriptionBytes();

  /**
   *
   *
   * <pre>
   * Optional. List of acknowledgement IDs for acknowledging previously received
   * messages (received on this stream or a different stream). If an ack ID has
   * expired, the corresponding message may be redelivered later. Acknowledging
   * a message more than once will not result in an error. If the
   * acknowledgement ID is malformed, the stream will be aborted with status
   * `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated string ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the ackIds.
   */
  java.util.List<java.lang.String> getAckIdsList();
  /**
   *
   *
   * <pre>
   * Optional. List of acknowledgement IDs for acknowledging previously received
   * messages (received on this stream or a different stream). If an ack ID has
   * expired, the corresponding message may be redelivered later. Acknowledging
   * a message more than once will not result in an error. If the
   * acknowledgement ID is malformed, the stream will be aborted with status
   * `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated string ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of ackIds.
   */
  int getAckIdsCount();
  /**
   *
   *
   * <pre>
   * Optional. List of acknowledgement IDs for acknowledging previously received
   * messages (received on this stream or a different stream). If an ack ID has
   * expired, the corresponding message may be redelivered later. Acknowledging
   * a message more than once will not result in an error. If the
   * acknowledgement ID is malformed, the stream will be aborted with status
   * `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated string ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The ackIds at the given index.
   */
  java.lang.String getAckIds(int index);
  /**
   *
   *
   * <pre>
   * Optional. List of acknowledgement IDs for acknowledging previously received
   * messages (received on this stream or a different stream). If an ack ID has
   * expired, the corresponding message may be redelivered later. Acknowledging
   * a message more than once will not result in an error. If the
   * acknowledgement ID is malformed, the stream will be aborted with status
   * `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated string ack_ids = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ackIds at the given index.
   */
  com.google.protobuf.ByteString getAckIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. The list of new ack deadlines for the IDs listed in
   * `modify_deadline_ack_ids`. The size of this list must be the same as the
   * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
   * with `INVALID_ARGUMENT`. Each element in this list is applied to the
   * element in the same position in `modify_deadline_ack_ids`. The new ack
   * deadline is with respect to the time this request was sent to the Pub/Sub
   * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
   * will expire 10 seconds after this request is received. If the value is 0,
   * the message is immediately made available for another streaming or
   * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
   * be aborted with status `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated int32 modify_deadline_seconds = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the modifyDeadlineSeconds.
   */
  java.util.List<java.lang.Integer> getModifyDeadlineSecondsList();
  /**
   *
   *
   * <pre>
   * Optional. The list of new ack deadlines for the IDs listed in
   * `modify_deadline_ack_ids`. The size of this list must be the same as the
   * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
   * with `INVALID_ARGUMENT`. Each element in this list is applied to the
   * element in the same position in `modify_deadline_ack_ids`. The new ack
   * deadline is with respect to the time this request was sent to the Pub/Sub
   * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
   * will expire 10 seconds after this request is received. If the value is 0,
   * the message is immediately made available for another streaming or
   * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
   * be aborted with status `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated int32 modify_deadline_seconds = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of modifyDeadlineSeconds.
   */
  int getModifyDeadlineSecondsCount();
  /**
   *
   *
   * <pre>
   * Optional. The list of new ack deadlines for the IDs listed in
   * `modify_deadline_ack_ids`. The size of this list must be the same as the
   * size of `modify_deadline_ack_ids`. If it differs the stream will be aborted
   * with `INVALID_ARGUMENT`. Each element in this list is applied to the
   * element in the same position in `modify_deadline_ack_ids`. The new ack
   * deadline is with respect to the time this request was sent to the Pub/Sub
   * system. Must be &gt;= 0. For example, if the value is 10, the new ack deadline
   * will expire 10 seconds after this request is received. If the value is 0,
   * the message is immediately made available for another streaming or
   * non-streaming pull request. If the value is &lt; 0 (an error), the stream will
   * be aborted with status `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>repeated int32 modify_deadline_seconds = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The modifyDeadlineSeconds at the given index.
   */
  int getModifyDeadlineSeconds(int index);

  /**
   *
   *
   * <pre>
   * Optional. List of acknowledgement IDs whose deadline will be modified based
   * on the corresponding element in `modify_deadline_seconds`. This field can
   * be used to indicate that more time is needed to process a message by the
   * subscriber, or to make the message available for redelivery if the
   * processing was interrupted.
   * </pre>
   *
   * <code>repeated string modify_deadline_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the modifyDeadlineAckIds.
   */
  java.util.List<java.lang.String> getModifyDeadlineAckIdsList();
  /**
   *
   *
   * <pre>
   * Optional. List of acknowledgement IDs whose deadline will be modified based
   * on the corresponding element in `modify_deadline_seconds`. This field can
   * be used to indicate that more time is needed to process a message by the
   * subscriber, or to make the message available for redelivery if the
   * processing was interrupted.
   * </pre>
   *
   * <code>repeated string modify_deadline_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of modifyDeadlineAckIds.
   */
  int getModifyDeadlineAckIdsCount();
  /**
   *
   *
   * <pre>
   * Optional. List of acknowledgement IDs whose deadline will be modified based
   * on the corresponding element in `modify_deadline_seconds`. This field can
   * be used to indicate that more time is needed to process a message by the
   * subscriber, or to make the message available for redelivery if the
   * processing was interrupted.
   * </pre>
   *
   * <code>repeated string modify_deadline_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The modifyDeadlineAckIds at the given index.
   */
  java.lang.String getModifyDeadlineAckIds(int index);
  /**
   *
   *
   * <pre>
   * Optional. List of acknowledgement IDs whose deadline will be modified based
   * on the corresponding element in `modify_deadline_seconds`. This field can
   * be used to indicate that more time is needed to process a message by the
   * subscriber, or to make the message available for redelivery if the
   * processing was interrupted.
   * </pre>
   *
   * <code>repeated string modify_deadline_ack_ids = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the modifyDeadlineAckIds at the given index.
   */
  com.google.protobuf.ByteString getModifyDeadlineAckIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Required. The ack deadline to use for the stream. This must be provided in
   * the first request on the stream, but it can also be updated on subsequent
   * requests from client to server. The minimum deadline you can specify is 10
   * seconds. The maximum deadline you can specify is 600 seconds (10 minutes).
   * </pre>
   *
   * <code>int32 stream_ack_deadline_seconds = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The streamAckDeadlineSeconds.
   */
  int getStreamAckDeadlineSeconds();

  /**
   *
   *
   * <pre>
   * Optional. A unique identifier that is used to distinguish client instances
   * from each other. Only needs to be provided on the initial request. When a
   * stream disconnects and reconnects for the same stream, the client_id should
   * be set to the same value so that state associated with the old stream can
   * be transferred to the new stream. The same client_id should not be used for
   * different client instances.
   * </pre>
   *
   * <code>string client_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The clientId.
   */
  java.lang.String getClientId();
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier that is used to distinguish client instances
   * from each other. Only needs to be provided on the initial request. When a
   * stream disconnects and reconnects for the same stream, the client_id should
   * be set to the same value so that state associated with the old stream can
   * be transferred to the new stream. The same client_id should not be used for
   * different client instances.
   * </pre>
   *
   * <code>string client_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for clientId.
   */
  com.google.protobuf.ByteString getClientIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. Flow control settings for the maximum number of outstanding
   * messages. When there are `max_outstanding_messages` currently sent to the
   * streaming pull client that have not yet been acked or nacked, the server
   * stops sending more messages. The sending of messages resumes once the
   * number of outstanding messages is less than this value. If the value is
   * &lt;= 0, there is no limit to the number of outstanding messages. This
   * property can only be set on the initial StreamingPullRequest. If it is set
   * on a subsequent request, the stream will be aborted with status
   * `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>int64 max_outstanding_messages = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxOutstandingMessages.
   */
  long getMaxOutstandingMessages();

  /**
   *
   *
   * <pre>
   * Optional. Flow control settings for the maximum number of outstanding
   * bytes. When there are `max_outstanding_bytes` or more worth of messages
   * currently sent to the streaming pull client that have not yet been acked or
   * nacked, the server will stop sending more messages. The sending of messages
   * resumes once the number of outstanding bytes is less than this value. If
   * the value is &lt;= 0, there is no limit to the number of outstanding bytes.
   * This property can only be set on the initial StreamingPullRequest. If it is
   * set on a subsequent request, the stream will be aborted with status
   * `INVALID_ARGUMENT`.
   * </pre>
   *
   * <code>int64 max_outstanding_bytes = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxOutstandingBytes.
   */
  long getMaxOutstandingBytes();
}
