/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.4
package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * Settings for an ingestion data source on a topic.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings}
 */
public final class IngestionDataSourceSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings)
    IngestionDataSourceSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IngestionDataSourceSettings.newBuilder() to construct.
  private IngestionDataSourceSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IngestionDataSourceSettings() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IngestionDataSourceSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_IngestionDataSourceSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_IngestionDataSourceSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.IngestionDataSourceSettings.class,
            com.google.pubsub.v1.IngestionDataSourceSettings.Builder.class);
  }

  public interface AwsKinesisOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State getState();

    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The streamArn.
     */
    java.lang.String getStreamArn();
    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for streamArn.
     */
    com.google.protobuf.ByteString getStreamArnBytes();

    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The consumerArn.
     */
    java.lang.String getConsumerArn();
    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for consumerArn.
     */
    com.google.protobuf.ByteString getConsumerArnBytes();

    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The awsRoleArn.
     */
    java.lang.String getAwsRoleArn();
    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for awsRoleArn.
     */
    com.google.protobuf.ByteString getAwsRoleArnBytes();

    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcpServiceAccount.
     */
    java.lang.String getGcpServiceAccount();
    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    com.google.protobuf.ByteString getGcpServiceAccountBytes();
  }
  /**
   *
   *
   * <pre>
   * Ingestion settings for Amazon Kinesis Data Streams.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis}
   */
  public static final class AwsKinesis extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
      AwsKinesisOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AwsKinesis.newBuilder() to construct.
    private AwsKinesis(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AwsKinesis() {
      state_ = 0;
      streamArn_ = "";
      consumerArn_ = "";
      awsRoleArn_ = "";
      gcpServiceAccount_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AwsKinesis();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Possible states for ingestion from Amazon Kinesis Data Streams.
     * </pre>
     *
     * Protobuf enum {@code google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      ACTIVE(1),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Kinesis.
       * This can happen if:
       *   - The provided `aws_role_arn` does not exist or does not have the
       *     appropriate permissions attached.
       *   - The provided `aws_role_arn` is not set up properly for Identity
       *     Federation using `gcp_service_account`.
       *   - The Pub/Sub SA is not granted the
       *     `iam.serviceAccounts.getOpenIdToken` permission on
       *     `gcp_service_account`.
       * </pre>
       *
       * <code>KINESIS_PERMISSION_DENIED = 2;</code>
       */
      KINESIS_PERMISSION_DENIED(2),
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic. This can
       * happen if the Pub/Sub SA has not been granted the [appropriate publish
       * permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      PUBLISH_PERMISSION_DENIED(3),
      /**
       *
       *
       * <pre>
       * The Kinesis stream does not exist.
       * </pre>
       *
       * <code>STREAM_NOT_FOUND = 4;</code>
       */
      STREAM_NOT_FOUND(4),
      /**
       *
       *
       * <pre>
       * The Kinesis consumer does not exist.
       * </pre>
       *
       * <code>CONSUMER_NOT_FOUND = 5;</code>
       */
      CONSUMER_NOT_FOUND(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Ingestion is active.
       * </pre>
       *
       * <code>ACTIVE = 1;</code>
       */
      public static final int ACTIVE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Permission denied encountered while consuming data from Kinesis.
       * This can happen if:
       *   - The provided `aws_role_arn` does not exist or does not have the
       *     appropriate permissions attached.
       *   - The provided `aws_role_arn` is not set up properly for Identity
       *     Federation using `gcp_service_account`.
       *   - The Pub/Sub SA is not granted the
       *     `iam.serviceAccounts.getOpenIdToken` permission on
       *     `gcp_service_account`.
       * </pre>
       *
       * <code>KINESIS_PERMISSION_DENIED = 2;</code>
       */
      public static final int KINESIS_PERMISSION_DENIED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Permission denied encountered while publishing to the topic. This can
       * happen if the Pub/Sub SA has not been granted the [appropriate publish
       * permissions](https://cloud.google.com/pubsub/docs/access-control#pubsub.publisher)
       * </pre>
       *
       * <code>PUBLISH_PERMISSION_DENIED = 3;</code>
       */
      public static final int PUBLISH_PERMISSION_DENIED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The Kinesis stream does not exist.
       * </pre>
       *
       * <code>STREAM_NOT_FOUND = 4;</code>
       */
      public static final int STREAM_NOT_FOUND_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The Kinesis consumer does not exist.
       * </pre>
       *
       * <code>CONSUMER_NOT_FOUND = 5;</code>
       */
      public static final int CONSUMER_NOT_FOUND_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return ACTIVE;
          case 2:
            return KINESIS_PERMISSION_DENIED;
          case 3:
            return PUBLISH_PERMISSION_DENIED;
          case 4:
            return STREAM_NOT_FOUND;
          case 5:
            return CONSUMER_NOT_FOUND;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State)
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field that indicates the state of the Kinesis
     * ingestion source.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State getState() {
      com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State result =
          com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.forNumber(state_);
      return result == null
          ? com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.UNRECOGNIZED
          : result;
    }

    public static final int STREAM_ARN_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object streamArn_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The streamArn.
     */
    @java.lang.Override
    public java.lang.String getStreamArn() {
      java.lang.Object ref = streamArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        streamArn_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Kinesis stream ARN to ingest data from.
     * </pre>
     *
     * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for streamArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStreamArnBytes() {
      java.lang.Object ref = streamArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        streamArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONSUMER_ARN_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object consumerArn_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The consumerArn.
     */
    @java.lang.Override
    public java.lang.String getConsumerArn() {
      java.lang.Object ref = consumerArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        consumerArn_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
     * Fan-Out mode. The consumer must be already created and ready to be used.
     * </pre>
     *
     * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for consumerArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConsumerArnBytes() {
      java.lang.Object ref = consumerArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        consumerArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AWS_ROLE_ARN_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object awsRoleArn_ = "";
    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The awsRoleArn.
     */
    @java.lang.Override
    public java.lang.String getAwsRoleArn() {
      java.lang.Object ref = awsRoleArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        awsRoleArn_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. AWS role ARN to be used for Federated Identity authentication
     * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
     * required permissions that need to be attached to it.
     * </pre>
     *
     * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for awsRoleArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAwsRoleArnBytes() {
      java.lang.Object ref = awsRoleArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        awsRoleArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GCP_SERVICE_ACCOUNT_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcpServiceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcpServiceAccount.
     */
    @java.lang.Override
    public java.lang.String getGcpServiceAccount() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcpServiceAccount_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The GCP service account to be used for Federated Identity
     * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
     * the provided role). The `aws_role_arn` must be set up with
     * `accounts.google.com:sub` equals to this service account number.
     * </pre>
     *
     * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcpServiceAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
      java.lang.Object ref = gcpServiceAccount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcpServiceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(streamArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, streamArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(consumerArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, consumerArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(awsRoleArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, awsRoleArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, gcpServiceAccount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(streamArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, streamArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(consumerArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, consumerArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(awsRoleArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, awsRoleArn_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcpServiceAccount_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, gcpServiceAccount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)) {
        return super.equals(obj);
      }
      com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis other =
          (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) obj;

      if (state_ != other.state_) return false;
      if (!getStreamArn().equals(other.getStreamArn())) return false;
      if (!getConsumerArn().equals(other.getConsumerArn())) return false;
      if (!getAwsRoleArn().equals(other.getAwsRoleArn())) return false;
      if (!getGcpServiceAccount().equals(other.getGcpServiceAccount())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + STREAM_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getStreamArn().hashCode();
      hash = (37 * hash) + CONSUMER_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerArn().hashCode();
      hash = (37 * hash) + AWS_ROLE_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getAwsRoleArn().hashCode();
      hash = (37 * hash) + GCP_SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getGcpServiceAccount().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Ingestion settings for Amazon Kinesis Data Streams.
     * </pre>
     *
     * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.class,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder.class);
      }

      // Construct using com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        streamArn_ = "";
        consumerArn_ = "";
        awsRoleArn_ = "";
        gcpServiceAccount_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.pubsub.v1.PubsubProto
            .internal_static_google_pubsub_v1_IngestionDataSourceSettings_AwsKinesis_descriptor;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
          getDefaultInstanceForType() {
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis build() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis buildPartial() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis result =
            new com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.streamArn_ = streamArn_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.consumerArn_ = consumerArn_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.awsRoleArn_ = awsRoleArn_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.gcpServiceAccount_ = gcpServiceAccount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) {
          return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis other) {
        if (other
            == com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getStreamArn().isEmpty()) {
          streamArn_ = other.streamArn_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getConsumerArn().isEmpty()) {
          consumerArn_ = other.consumerArn_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getAwsRoleArn().isEmpty()) {
          awsRoleArn_ = other.awsRoleArn_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getGcpServiceAccount().isEmpty()) {
          gcpServiceAccount_ = other.gcpServiceAccount_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  streamArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  consumerArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  awsRoleArn_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  gcpServiceAccount_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State getState() {
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State result =
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.forNumber(state_);
        return result == null
            ? com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. An output-only field that indicates the state of the Kinesis
       * ingestion source.
       * </pre>
       *
       * <code>
       * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object streamArn_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The streamArn.
       */
      public java.lang.String getStreamArn() {
        java.lang.Object ref = streamArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          streamArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for streamArn.
       */
      public com.google.protobuf.ByteString getStreamArnBytes() {
        java.lang.Object ref = streamArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          streamArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The streamArn to set.
       * @return This builder for chaining.
       */
      public Builder setStreamArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamArn_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStreamArn() {
        streamArn_ = getDefaultInstance().getStreamArn();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis stream ARN to ingest data from.
       * </pre>
       *
       * <code>string stream_arn = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for streamArn to set.
       * @return This builder for chaining.
       */
      public Builder setStreamArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        streamArn_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object consumerArn_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The consumerArn.
       */
      public java.lang.String getConsumerArn() {
        java.lang.Object ref = consumerArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          consumerArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for consumerArn.
       */
      public com.google.protobuf.ByteString getConsumerArnBytes() {
        java.lang.Object ref = consumerArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          consumerArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The consumerArn to set.
       * @return This builder for chaining.
       */
      public Builder setConsumerArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        consumerArn_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConsumerArn() {
        consumerArn_ = getDefaultInstance().getConsumerArn();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Kinesis consumer ARN to used for ingestion in Enhanced
       * Fan-Out mode. The consumer must be already created and ready to be used.
       * </pre>
       *
       * <code>string consumer_arn = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for consumerArn to set.
       * @return This builder for chaining.
       */
      public Builder setConsumerArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        consumerArn_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object awsRoleArn_ = "";
      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The awsRoleArn.
       */
      public java.lang.String getAwsRoleArn() {
        java.lang.Object ref = awsRoleArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          awsRoleArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for awsRoleArn.
       */
      public com.google.protobuf.ByteString getAwsRoleArnBytes() {
        java.lang.Object ref = awsRoleArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          awsRoleArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The awsRoleArn to set.
       * @return This builder for chaining.
       */
      public Builder setAwsRoleArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        awsRoleArn_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAwsRoleArn() {
        awsRoleArn_ = getDefaultInstance().getAwsRoleArn();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. AWS role ARN to be used for Federated Identity authentication
       * with Kinesis. Check the Pub/Sub docs for how to set up this role and the
       * required permissions that need to be attached to it.
       * </pre>
       *
       * <code>string aws_role_arn = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for awsRoleArn to set.
       * @return This builder for chaining.
       */
      public Builder setAwsRoleArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        awsRoleArn_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object gcpServiceAccount_ = "";
      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The gcpServiceAccount.
       */
      public java.lang.String getGcpServiceAccount() {
        java.lang.Object ref = gcpServiceAccount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcpServiceAccount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for gcpServiceAccount.
       */
      public com.google.protobuf.ByteString getGcpServiceAccountBytes() {
        java.lang.Object ref = gcpServiceAccount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcpServiceAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcpServiceAccount() {
        gcpServiceAccount_ = getDefaultInstance().getGcpServiceAccount();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The GCP service account to be used for Federated Identity
       * authentication with Kinesis (via a `AssumeRoleWithWebIdentity` call for
       * the provided role). The `aws_role_arn` must be set up with
       * `accounts.google.com:sub` equals to this service account number.
       * </pre>
       *
       * <code>string gcp_service_account = 5 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for gcpServiceAccount to set.
       * @return This builder for chaining.
       */
      public Builder setGcpServiceAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcpServiceAccount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
    }

    // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis)
    private static final com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis();
    }

    public static com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AwsKinesis> PARSER =
        new com.google.protobuf.AbstractParser<AwsKinesis>() {
          @java.lang.Override
          public AwsKinesis parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AwsKinesis> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AwsKinesis> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AWS_KINESIS(1),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return AWS_KINESIS;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int AWS_KINESIS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Optional. Amazon Kinesis Data Streams.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the awsKinesis field is set.
   */
  @java.lang.Override
  public boolean hasAwsKinesis() {
    return sourceCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Optional. Amazon Kinesis Data Streams.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The awsKinesis.
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getAwsKinesis() {
    if (sourceCase_ == 1) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Amazon Kinesis Data Streams.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder
      getAwsKinesisOrBuilder() {
    if (sourceCase_ == 1) {
      return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
    }
    return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceCase_ == 1) {
      output.writeMessage(1, (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.IngestionDataSourceSettings)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.IngestionDataSourceSettings other =
        (com.google.pubsub.v1.IngestionDataSourceSettings) obj;

    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 1:
        if (!getAwsKinesis().equals(other.getAwsKinesis())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (sourceCase_) {
      case 1:
        hash = (37 * hash) + AWS_KINESIS_FIELD_NUMBER;
        hash = (53 * hash) + getAwsKinesis().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.IngestionDataSourceSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Settings for an ingestion data source on a topic.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.IngestionDataSourceSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.IngestionDataSourceSettings)
      com.google.pubsub.v1.IngestionDataSourceSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.IngestionDataSourceSettings.class,
              com.google.pubsub.v1.IngestionDataSourceSettings.Builder.class);
    }

    // Construct using com.google.pubsub.v1.IngestionDataSourceSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (awsKinesisBuilder_ != null) {
        awsKinesisBuilder_.clear();
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_IngestionDataSourceSettings_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings getDefaultInstanceForType() {
      return com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings build() {
      com.google.pubsub.v1.IngestionDataSourceSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings buildPartial() {
      com.google.pubsub.v1.IngestionDataSourceSettings result =
          new com.google.pubsub.v1.IngestionDataSourceSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.pubsub.v1.IngestionDataSourceSettings result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.pubsub.v1.IngestionDataSourceSettings result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 1 && awsKinesisBuilder_ != null) {
        result.source_ = awsKinesisBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.IngestionDataSourceSettings) {
        return mergeFrom((com.google.pubsub.v1.IngestionDataSourceSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.IngestionDataSourceSettings other) {
      if (other == com.google.pubsub.v1.IngestionDataSourceSettings.getDefaultInstance())
        return this;
      switch (other.getSourceCase()) {
        case AWS_KINESIS:
          {
            mergeAwsKinesis(other.getAwsKinesis());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAwsKinesisFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 1;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder>
        awsKinesisBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the awsKinesis field is set.
     */
    @java.lang.Override
    public boolean hasAwsKinesis() {
      return sourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The awsKinesis.
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis getAwsKinesis() {
      if (awsKinesisBuilder_ == null) {
        if (sourceCase_ == 1) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      } else {
        if (sourceCase_ == 1) {
          return awsKinesisBuilder_.getMessage();
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAwsKinesis(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis value) {
      if (awsKinesisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        awsKinesisBuilder_.setMessage(value);
      }
      sourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAwsKinesis(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder builderForValue) {
      if (awsKinesisBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        awsKinesisBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAwsKinesis(
        com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis value) {
      if (awsKinesisBuilder_ == null) {
        if (sourceCase_ == 1
            && source_
                != com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis
                    .getDefaultInstance()) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.newBuilder(
                      (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 1) {
          awsKinesisBuilder_.mergeFrom(value);
        } else {
          awsKinesisBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAwsKinesis() {
      if (awsKinesisBuilder_ == null) {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 1) {
          sourceCase_ = 0;
          source_ = null;
        }
        awsKinesisBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder
        getAwsKinesisBuilder() {
      return getAwsKinesisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder
        getAwsKinesisOrBuilder() {
      if ((sourceCase_ == 1) && (awsKinesisBuilder_ != null)) {
        return awsKinesisBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 1) {
          return (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_;
        }
        return com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Amazon Kinesis Data Streams.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis aws_kinesis = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder,
            com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder>
        getAwsKinesisFieldBuilder() {
      if (awsKinesisBuilder_ == null) {
        if (!(sourceCase_ == 1)) {
          source_ =
              com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.getDefaultInstance();
        }
        awsKinesisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis.Builder,
                com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesisOrBuilder>(
                (com.google.pubsub.v1.IngestionDataSourceSettings.AwsKinesis) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 1;
      onChanged();
      return awsKinesisBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.IngestionDataSourceSettings)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.IngestionDataSourceSettings)
  private static final com.google.pubsub.v1.IngestionDataSourceSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.IngestionDataSourceSettings();
  }

  public static com.google.pubsub.v1.IngestionDataSourceSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IngestionDataSourceSettings> PARSER =
      new com.google.protobuf.AbstractParser<IngestionDataSourceSettings>() {
        @java.lang.Override
        public IngestionDataSourceSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IngestionDataSourceSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IngestionDataSourceSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.IngestionDataSourceSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
