/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.pubsub.v1.SubscriptionName;
import java.util.ArrayList;
import java.util.List;

public class UntypedSubscriptionName
extends SubscriptionName {
    private final String rawValue;

    private UntypedSubscriptionName(String rawValue) {
        this.rawValue = (String)Preconditions.checkNotNull((Object)rawValue);
    }

    public static UntypedSubscriptionName from(ResourceName resourceName) {
        return new UntypedSubscriptionName(resourceName.toString());
    }

    public static UntypedSubscriptionName parse(String formattedString) {
        return new UntypedSubscriptionName(formattedString);
    }

    public static List<UntypedSubscriptionName> parseList(List<String> formattedStrings) {
        ArrayList<UntypedSubscriptionName> list = new ArrayList<UntypedSubscriptionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UntypedSubscriptionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UntypedSubscriptionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UntypedSubscriptionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return true;
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("UntypedSubscriptionName.getType() not supported");
    }

    public String toString() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UntypedSubscriptionName) {
            UntypedSubscriptionName that = (UntypedSubscriptionName)o;
            return this.rawValue.equals(that.rawValue);
        }
        return false;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }
}

