/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectSubscriptionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/subscriptions/{subscription}");
    private final String project;
    private final String subscription;

    public String getProject() {
        return this.project;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectSubscriptionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.subscription = (String)Preconditions.checkNotNull((Object)builder.getSubscription());
    }

    public static ProjectSubscriptionName of(String project, String subscription) {
        return ProjectSubscriptionName.newBuilder().setProject(project).setSubscription(subscription).build();
    }

    public static String format(String project, String subscription) {
        return ProjectSubscriptionName.newBuilder().setProject(project).setSubscription(subscription).build().toString();
    }

    public static ProjectSubscriptionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectSubscriptionName.parse: formattedString not in valid format");
        return ProjectSubscriptionName.of((String)matchMap.get("project"), (String)matchMap.get("subscription"));
    }

    public static List<ProjectSubscriptionName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectSubscriptionName> list = new ArrayList<ProjectSubscriptionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectSubscriptionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectSubscriptionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectSubscriptionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("ProjectSubscriptionName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "subscription", this.subscription});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectSubscriptionName) {
            ProjectSubscriptionName that = (ProjectSubscriptionName)o;
            return this.project.equals(that.project) && this.subscription.equals(that.subscription);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.subscription.hashCode();
    }

    public static class Builder {
        private String project;
        private String subscription;

        public String getProject() {
            return this.project;
        }

        public String getSubscription() {
            return this.subscription;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSubscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectSubscriptionName projectSubscriptionName) {
            this.project = projectSubscriptionName.project;
            this.subscription = projectSubscriptionName.subscription;
        }

        public ProjectSubscriptionName build() {
            return new ProjectSubscriptionName(this);
        }
    }
}

